/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.related;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.RelatedGame;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.repository.RepositoryGame;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.related.RelatedGames;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class RelatedGamesImpl
implements RelatedGames {
    private static final int NAME_MATCH_ONE_WORD_GAME_SCORE = 5;
    private static final int NAME_MATCH_ONE_IN_MANY_WORDS_SCORE = 3;
    private static final int NAME_MATCH_TWO_OR_MORE_IN_MANY_WORDS_SCORE = 5;
    private static final int GENRE_MATCH_SCORE = 4;
    private static final int COMPANY_MATCH_SCORE = 2;
    private static final int SAME_CLUSTER_MATCH_SCORE = 7;
    private static final int MAX_SIZE_RESULTS = 15;
    private static final Set<String> excludedStrings = new HashSet<String>();
    private static final Map<Integer, Set<Integer>> idToCluster;
    private final ExtraDataGetter extraDataGetter;
    private final Map<String, RepositoryGame> repositoryInfoMap;

    @Inject
    RelatedGamesImpl(ExtraDataGetter extraDataGetter, @Assisted Map<String, RepositoryGame> repositoryInfoMap) {
        this.extraDataGetter = extraDataGetter;
        this.repositoryInfoMap = repositoryInfoMap;
    }

    @Override
    public List<RelatedGame> findRelated(Game game) throws IOException {
        Set<String> gameNameParts;
        String companyOfSelectedGame;
        Map<String, ExtraData> extraDataMap = null;
        try {
            extraDataMap = this.extraDataGetter.getExtraData();
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw ioe;
        }
        HashSet<SimilarGame> similarGames = new HashSet<SimilarGame>();
        RepositoryGame repositoryGame = this.repositoryInfoMap.get(game.getSha1Code());
        if (repositoryGame == null) {
            companyOfSelectedGame = "";
            gameNameParts = this.getNormalizedStrings(game.getName());
        } else {
            companyOfSelectedGame = repositoryGame.getCompany();
            gameNameParts = this.getNormalizedStrings(repositoryGame.getTitle());
        }
        Set<Integer> clusterForGivenGame = idToCluster.get(game.getMsxGenID());
        for (Map.Entry<String, RepositoryGame> entry : this.repositoryInfoMap.entrySet()) {
            SimilarGame similarGame;
            if (!"MSX".equals(entry.getValue().getSystem())) continue;
            String companyOfRepositoryGame = entry.getValue().getCompany();
            String repositoryTitle = entry.getValue().getTitle();
            int score = 0;
            String sha1CodeOfRepositoryGame = entry.getKey();
            ExtraData extraData = extraDataMap.get(sha1CodeOfRepositoryGame);
            if (extraData == null || extraData.getMSXGenerationsID() == game.getMsxGenID()) continue;
            score += this.getNameScore(repositoryTitle, gameNameParts);
            score += this.getGenreScore(extraData, game);
            score += this.getCompanyScore(companyOfRepositoryGame, companyOfSelectedGame);
            if ((score += this.getClusterScore(clusterForGivenGame, extraData.getMSXGenerationsID())) <= 0 || similarGames.contains(similarGame = new SimilarGame(new RelatedGame(repositoryTitle, entry.getValue().getCompany(), entry.getValue().getYear(), extraData.getMSXGenerationsID()), score))) continue;
            similarGames.add(similarGame);
        }
        return similarGames.stream().sorted(Comparator.comparingInt(SimilarGame::getScore).reversed()).map(g -> ((SimilarGame)g).relatedGame).limit(15L).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private int getNameScore(String repositoryTitle, Set<String> gameNameParts) {
        Set<String> repositoryTitleParts = this.getNormalizedStrings(repositoryTitle);
        int score = 0;
        int matches = 0;
        for (String part : gameNameParts) {
            if (!repositoryTitleParts.contains(part)) continue;
            if (repositoryTitleParts.size() == 1 || gameNameParts.size() == 1) {
                score += 5;
                continue;
            }
            score += ++matches == 1 ? 3 : 5;
        }
        return score;
    }

    private int getGenreScore(ExtraData extraData, Game game) {
        int score = 0;
        if (extraData != null) {
            Genre selectedGameGenre1 = game.getGenre1();
            Genre selectedGameGenre2 = game.getGenre2();
            Genre genre1OfRepositoryGame = Genre.fromValue(extraData.getGenre1());
            Genre genre2OfRepositoryGame = Genre.fromValue(extraData.getGenre2());
            if (!selectedGameGenre1.equals(Genre.UNKNOWN) && (selectedGameGenre1.equals(genre1OfRepositoryGame) || selectedGameGenre1.equals(genre2OfRepositoryGame)) || !selectedGameGenre2.equals(Genre.UNKNOWN) && (selectedGameGenre2.equals(genre1OfRepositoryGame) || selectedGameGenre2.equals(genre2OfRepositoryGame))) {
                score = 4;
            }
        }
        return score;
    }

    private int getCompanyScore(String companyOfRepositoryGame, String companyOfSelectedGame) {
        if (!companyOfRepositoryGame.isEmpty() && companyOfRepositoryGame.equals(companyOfSelectedGame)) {
            return 2;
        }
        return 0;
    }

    private int getClusterScore(Set<Integer> clusterForGivenGame, int extraDataGenMSXId) {
        if (clusterForGivenGame != null && clusterForGivenGame.contains(extraDataGenMSXId)) {
            return 7;
        }
        return 0;
    }

    private Set<String> getNormalizedStrings(String string) {
        String[] parts = string.split(" ");
        return Stream.of(parts).map(String::toLowerCase).map(s -> s.replace(",", "")).filter(s -> !excludedStrings.contains(s)).filter(s -> !Utils.isNumber(s) || Utils.getNumber(s) >= 5).collect(Collectors.toSet());
    }

    static {
        excludedStrings.add("-");
        excludedStrings.add("i");
        excludedStrings.add("ii");
        excludedStrings.add("the");
        excludedStrings.add("of");
        excludedStrings.add("and");
        excludedStrings.add("in");
        excludedStrings.add("on");
        excludedStrings.add("at");
        excludedStrings.add("to");
        excludedStrings.add("version");
        excludedStrings.add("de");
        excludedStrings.add("el");
        excludedStrings.add("los");
        excludedStrings.add("en");
        idToCluster = new HashMap<Integer, Set<Integer>>();
        List<Set> clusters = Arrays.asList(Stream.of(742, 932, 1254, 941, 1188).collect(Collectors.toSet()), Stream.of(855, 916, 946).collect(Collectors.toSet()), Stream.of(1238, 3607).collect(Collectors.toSet()), Stream.of(684, 412).collect(Collectors.toSet()), Stream.of(810, 4221).collect(Collectors.toSet()));
        clusters.stream().forEach(cluster -> idToCluster.putAll(cluster.stream().collect(Collectors.toMap(Function.identity(), c -> cluster))));
    }

    private class SimilarGame {
        private final RelatedGame relatedGame;
        private final int score;

        SimilarGame(RelatedGame relatedGame, int score) {
            this.relatedGame = relatedGame;
            this.score = score;
        }

        int getScore() {
            return this.score;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof SimilarGame)) {
                return false;
            }
            return this.relatedGame.equals(((SimilarGame)other).relatedGame);
        }

        public int hashCode() {
            return this.relatedGame.hashCode();
        }
    }
}

