/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.starter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import info.msxlaunchers.openmsx.common.OSUtils;
import info.msxlaunchers.openmsx.launcher.starter.LinuxBSDStarterArguments;
import info.msxlaunchers.openmsx.launcher.starter.MacStarterArguments;
import info.msxlaunchers.openmsx.launcher.starter.StarterPlatformArguments;
import info.msxlaunchers.openmsx.launcher.starter.WindowsStarterArguments;
import info.msxlaunchers.platform.ArgumentsBuilderProvider;

final class PlatformArgumentsProvider
implements Provider<StarterPlatformArguments> {
    private final ArgumentsBuilderProvider argumentsBuilderProvider;

    @Inject
    PlatformArgumentsProvider(ArgumentsBuilderProvider argumentsBuilderProvider) {
        this.argumentsBuilderProvider = argumentsBuilderProvider;
    }

    public StarterPlatformArguments get() {
        if (OSUtils.isWindows()) {
            return new WindowsStarterArguments(this.argumentsBuilderProvider.get());
        }
        if (OSUtils.isMac()) {
            return new MacStarterArguments(this.argumentsBuilderProvider.get());
        }
        if (OSUtils.isLinux() || OSUtils.isBSD()) {
            return new LinuxBSDStarterArguments(this.argumentsBuilderProvider.get());
        }
        throw new IllegalArgumentException("Unsupported Operating System");
    }
}

