/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.importer.DatabaseImporterFactory;
import info.msxlaunchers.openmsx.launcher.ui.presenter.BlueMSXLauncherDatabasesImporterActionDecider;
import info.msxlaunchers.openmsx.launcher.ui.presenter.BlueMSXLauncherDatabasesImporterPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.BlueMSXLauncherDatabaseImporterView;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import info.msxlaunchers.openmsx.machine.MachineLister;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class BlueMSXLauncherDatabasesImporterPresenterImpl
implements BlueMSXLauncherDatabasesImporterPresenter {
    private final MainPresenter mainPresenter;
    private final MachineLister machineLister;
    private final BlueMSXLauncherDatabaseImporterView view;
    private final DatabaseImporterFactory databaseImporterFactory;
    private final String DATABASE_EXTENSION = ".db";
    private Language currentLanguage = null;
    private boolean currentRightToLeft = false;

    @Inject
    BlueMSXLauncherDatabasesImporterPresenterImpl(MainPresenter mainPresenter, MachineLister machineLister, BlueMSXLauncherDatabaseImporterView view, DatabaseImporterFactory databaseImporterFactory) throws IOException {
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.machineLister = Objects.requireNonNull(machineLister);
        this.view = Objects.requireNonNull(view);
        this.databaseImporterFactory = Objects.requireNonNull(databaseImporterFactory);
    }

    @Override
    public void onRequestImportBlueMSXLauncherDatabasesScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        this.currentLanguage = currentLanguage;
        this.currentRightToLeft = currentRightToLeft;
        try {
            this.view.displayScreen(currentLanguage, currentRightToLeft, this.machineLister.get());
        }
        catch (InvalidMachinesDirectoryException imde) {
            throw new LauncherException(LauncherExceptionCode.ERR_INVALID_MACHINES_DIRECTORY);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public int onRequestImportBlueMSXLauncherDatabasesAction(String path, String[] databaseNames, String machine) throws LauncherException {
        File[] databases = new File[databaseNames.length];
        for (int ix = 0; ix < databases.length; ++ix) {
            databases[ix] = new File(path, databaseNames[ix] + ".db");
        }
        Set<String> importedDatabases = null;
        try {
            importedDatabases = this.databaseImporterFactory.create(machine).importDatabases(databases, new BlueMSXLauncherDatabasesImporterActionDecider(this.view, this.currentLanguage, this.currentRightToLeft));
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        this.mainPresenter.onAcceptImportBlueMSXLauncherDatabasesAction(importedDatabases);
        return importedDatabases.size();
    }

    @Override
    public Set<String> onGetDatabasesInDirectory(File directory) {
        File[] files;
        HashSet<String> databases = new HashSet<String>();
        for (File file : files = directory.listFiles()) {
            String filename;
            if (!file.isFile() || !(filename = file.getName()).endsWith(".db")) continue;
            databases.add(filename.substring(0, filename.lastIndexOf(".db")));
        }
        return databases;
    }
}

