/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.LauncherPersistence;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseBackupsPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DatabaseManagerPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.view.DatabaseBackupsView;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class DatabaseBackupsPresenterImpl
implements DatabaseBackupsPresenter {
    private final LauncherPersistence launcherPersistence;
    private final DatabaseBackupsView view;
    private final DatabaseManagerPresenter databaseManagerPresenter;
    private final String database;
    private final Set<DatabaseBackup> backups;
    private final Map<Timestamp, DatabaseBackup> timestampToBackup;

    @Inject
    DatabaseBackupsPresenterImpl(DatabaseBackupsView view, LauncherPersistence launcherPersistence, @Assisted DatabaseManagerPresenter databaseManagerPresenter, @Assisted String database, @Assisted Set<DatabaseBackup> backups) {
        this.databaseManagerPresenter = Objects.requireNonNull(databaseManagerPresenter);
        this.launcherPersistence = Objects.requireNonNull(launcherPersistence);
        this.view = Objects.requireNonNull(view);
        this.database = Objects.requireNonNull(database);
        this.backups = Objects.requireNonNull(backups);
        this.timestampToBackup = backups.stream().collect(Collectors.toMap(DatabaseBackup::getTimestamp, p -> p));
    }

    @Override
    public void onRequestDatabaseBackupsScreen(Language currentLanguage, boolean currentRightToLeft) {
        this.view.displayScreen(this, currentLanguage, currentRightToLeft, this.backups);
    }

    @Override
    public void onRequestDeleteBackup(Timestamp timestamp) throws LauncherException {
        try {
            this.launcherPersistence.getGamePersister().deleteBackup(this.timestampToBackup.get(timestamp));
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.BACKUP_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_BACKUP_NOT_FOUND, timestamp.toString());
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestRestoreBackup(Timestamp timestamp) throws LauncherException {
        try {
            this.launcherPersistence.getGamePersister().restoreBackup(this.timestampToBackup.get(timestamp));
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.BACKUP_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_BACKUP_NOT_FOUND, timestamp.toString());
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void updateDatabaseAndBackupsView(Timestamp timestamp) {
        this.databaseManagerPresenter.updateDatabaseAndBackupsView(this.timestampToBackup.get(timestamp).getDatabase());
    }

    @Override
    public void updateDatabaseAndBackupsView(DatabaseBackup databaseBackup) {
        this.timestampToBackup.put(databaseBackup.getTimestamp(), databaseBackup);
        this.databaseManagerPresenter.updateDatabaseAndBackupsView(this.database);
    }

    @Override
    public void updateDatabaseInfoView() {
        this.databaseManagerPresenter.updateDatabaseInfoView();
    }

    @Override
    public void viewRestoredDatabase(Timestamp timestamp) throws LauncherException {
        this.databaseManagerPresenter.viewRestoredDatabase(this.timestampToBackup.get(timestamp).getDatabase());
    }

    @Override
    public DatabaseBackup onRequestBackupDatabase() throws LauncherException {
        try {
            return this.launcherPersistence.getGamePersister().backupDatabase(this.database);
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_MAX_BACKUPS_REACHED)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_MAX_BACKUPS_REACHED);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }
}

