/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.game.scan.Scanner;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.ui.presenter.DraggedAndDroppedGamesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.AddDraggedAndDroppedGamesView;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import info.msxlaunchers.openmsx.machine.MachineLister;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

final class DraggedAndDroppedGamesPresenterImpl
implements DraggedAndDroppedGamesPresenter {
    private final MainPresenter mainPresenter;
    private final AddDraggedAndDroppedGamesView view;
    private final String currentDatabase;
    private final File[] files;
    private final MachineLister machineLister;
    private final Scanner scanner;
    private File[] filteredFiles;

    @Inject
    DraggedAndDroppedGamesPresenterImpl(MainPresenter mainPresenter, AddDraggedAndDroppedGamesView view, @Assisted String currentDatabase, @Assisted File[] files, MachineLister machineLister, Scanner scanner) {
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.view = Objects.requireNonNull(view);
        this.currentDatabase = Objects.requireNonNull(currentDatabase);
        this.files = Objects.requireNonNull(files);
        this.machineLister = Objects.requireNonNull(machineLister);
        this.scanner = Objects.requireNonNull(scanner);
    }

    @Override
    public void onRequestAddDraggedAndDroppedGamesScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        try {
            this.filteredFiles = (File[])Arrays.asList(this.files).stream().filter(file -> this.isDirectoryOrPotentialMSXFile((File)file)).toArray(File[]::new);
            if (this.filteredFiles.length > 0) {
                this.view.displayScreen(this, this.currentDatabase, currentLanguage, currentRightToLeft, this.filteredFiles, this.machineLister.get());
            }
        }
        catch (InvalidMachinesDirectoryException imde) {
            throw new LauncherException(LauncherExceptionCode.ERR_INVALID_MACHINES_DIRECTORY);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public int onRequestAddDraggedAndDroppedGamesAddAction(boolean getNameFromOpenMSXDatabase, boolean backupDatabase, String machine) throws LauncherException {
        int totalFound = 0;
        String[] filePaths = (String[])Arrays.asList(this.filteredFiles).stream().map(file -> file.getAbsolutePath()).toArray(String[]::new);
        try {
            totalFound = this.scanner.scan(filePaths, true, this.currentDatabase, false, true, machine, true, true, true, true, getNameFromOpenMSXDatabase, backupDatabase);
        }
        catch (GamePersistenceException gpe) {
            if (!gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_NULL_NAME)) {
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NULL_NAME)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NULL_NAME);
                }
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_MAX_BACKUPS_REACHED)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_MAX_BACKUPS_REACHED, this.currentDatabase);
                }
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_ALREADY_EXISTS, this.currentDatabase);
                }
                if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                    throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, this.currentDatabase);
                }
            }
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        return totalFound;
    }

    @Override
    public void onRequestInterruptFillDatabaseProcess() {
        this.scanner.interrupt();
    }

    @Override
    public void onUpdateViewedDatabase(String database) throws LauncherException {
        this.mainPresenter.onViewUpdatedDatabase(database);
    }

    private boolean isDirectoryOrPotentialMSXFile(File file) {
        return file.isDirectory() || FileTypeUtils.isROM(file) || FileTypeUtils.isDisk(file) || FileTypeUtils.isTape(file) || FileTypeUtils.isHarddisk(file) || FileTypeUtils.isLaserdisc(file) || FileTypeUtils.isZIP(file);
    }
}

