/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterFactory;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterPersister;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterSetAlreadyExistsException;
import info.msxlaunchers.openmsx.launcher.persistence.filter.FilterSetNotFoundException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.FilterEditingPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.FilterEditingView;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class FilterEditingPresenterImpl
implements FilterEditingPresenter {
    private final MainPresenter mainPresenter;
    private final FilterEditingView view;
    private final FilterPersister filterPersister;
    private final Set<Filter> filterItemsSet;
    private boolean editMode = false;
    private boolean changedFilter = false;

    @Inject
    FilterEditingPresenterImpl(MainPresenter mainPresenter, FilterEditingView view, FilterPersister filterPersister) {
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.view = Objects.requireNonNull(view);
        this.filterPersister = Objects.requireNonNull(filterPersister);
        this.filterItemsSet = new HashSet<Filter>();
    }

    @Override
    public void onRequestAddFilterScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        this.editMode = false;
        this.view.displayAddFilterScreen(currentLanguage, currentRightToLeft);
    }

    @Override
    public void onRequestEditFilterScreen(Language currentLanguage, boolean currentRightToLeft, String filterName, Set<Filter> filterItems) throws LauncherException {
        this.editMode = true;
        this.filterItemsSet.clear();
        this.filterItemsSet.addAll(filterItems);
        List<String> filterMonikerStrings = FilterFactory.getFilterMonikers(filterItems);
        this.view.displayEditFilterScreen(currentLanguage, currentRightToLeft, filterName, filterMonikerStrings);
    }

    @Override
    public boolean onAddToFilterListAndApply(FilterType type, String value1, String value2, FilterParameter parameter) throws LauncherException {
        this.changedFilter = true;
        boolean added = this.filterItemsSet.add(FilterFactory.createFilter(type, value1, value2, parameter));
        if (added) {
            this.mainPresenter.onApplyFilter(this.filterItemsSet);
        }
        return added;
    }

    @Override
    public void onRemoveFromFilterList(FilterType type, String value1, String value2, FilterParameter parameter) throws LauncherException {
        this.changedFilter = true;
        this.filterItemsSet.remove(FilterFactory.createFilter(type, value1, value2, parameter));
        this.mainPresenter.onApplyFilter(this.filterItemsSet);
    }

    @Override
    public void onRequestSaveFilterAction(String filterName) throws LauncherException {
        try {
            this.filterPersister.saveFilter(filterName, this.filterItemsSet);
            this.mainPresenter.onRequestUpdateFilterName(filterName);
        }
        catch (FilterSetAlreadyExistsException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_FILTER_ALREADY_EXISTS, filterName);
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestUpdateFilterAction(String oldFilterName, String newFilterName) throws LauncherException {
        if (!oldFilterName.equals(newFilterName)) {
            try {
                this.filterPersister.getFilter(newFilterName);
                throw new LauncherException(LauncherExceptionCode.ERR_FILTER_ALREADY_EXISTS, newFilterName);
            }
            catch (FilterSetNotFoundException filterSetNotFoundException) {
                // empty catch block
            }
        }
        try {
            this.filterPersister.deleteFilter(oldFilterName);
            this.filterPersister.saveFilter(newFilterName, this.filterItemsSet);
        }
        catch (FilterSetAlreadyExistsException filterSetAlreadyExistsException) {
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        this.mainPresenter.onRequestUpdateFilterName(newFilterName);
    }

    @Override
    public void onRequestClose() {
        if (this.editMode && this.changedFilter) {
            this.mainPresenter.onRequestSetFilterNameUntitled();
        }
    }
}

