/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractionException;
import info.msxlaunchers.openmsx.launcher.extractor.Extractor;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractorData;
import info.msxlaunchers.openmsx.launcher.extractor.ExtractorExceptionIssue;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LHAExtractorActionDecider;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LHAExtractorPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.view.LHAExtractorView;

class LHAExtractorPresenterImpl
implements LHAExtractorPresenter {
    private final LHAExtractorView view;
    private final Extractor extractor;
    private Language currentLanguage = null;
    private boolean currentRightToLeft = false;

    @Inject
    public LHAExtractorPresenterImpl(LHAExtractorView view, Extractor extractor) {
        this.view = view;
        this.extractor = extractor;
    }

    @Override
    public void onRequestLHAExtractorScreen(Language currentLanguage, boolean currentRightToLeft) {
        this.currentLanguage = currentLanguage;
        this.currentRightToLeft = currentRightToLeft;
        this.view.displayScreen(currentLanguage, currentRightToLeft);
    }

    @Override
    public ExtractorData onRequestLHAExtractAction(String fileToUncompress, String targetDirectory, boolean extractOnlyMSXImages) throws LauncherException {
        try {
            LHAExtractorActionDecider actionDecider = new LHAExtractorActionDecider(this.view, this.currentLanguage, this.currentRightToLeft);
            return this.extractor.extract(fileToUncompress, targetDirectory, extractOnlyMSXImages, actionDecider);
        }
        catch (ExtractionException de) {
            if (de.getIssue().equals((Object)ExtractorExceptionIssue.COMPRESSED_FILE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_COMPRESSED_FILE_NOT_FOUND);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }
}

