/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import info.msxlaunchers.openmsx.common.Nullable;
import info.msxlaunchers.openmsx.extension.ExtensionLister;
import info.msxlaunchers.openmsx.launcher.builder.GameBuilder;
import info.msxlaunchers.openmsx.launcher.data.extra.ExtraData;
import info.msxlaunchers.openmsx.launcher.data.game.Game;
import info.msxlaunchers.openmsx.launcher.data.game.constants.FDDMode;
import info.msxlaunchers.openmsx.launcher.data.game.constants.InputDevice;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.extra.ExtraDataGetter;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceException;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersistenceExceptionIssue;
import info.msxlaunchers.openmsx.launcher.persistence.game.GamePersister;
import info.msxlaunchers.openmsx.launcher.starter.EmulatorStarter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.ProfileEditingPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.ProfileEditingView;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import info.msxlaunchers.openmsx.machine.MachineLister;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

final class ProfileEditingPresenterImpl
implements ProfileEditingPresenter {
    private final ProfileEditingView view;
    private final MainPresenter mainPresenter;
    private final GamePersister gamePersister;
    private final EmulatorStarter emulatorStarter;
    private final MachineLister machineLister;
    private final ExtensionLister extensionLister;
    private final GameBuilder gameBuilder;
    private final ExtraDataGetter extraDataGetter;
    private final Settings settings;
    private final String currentDatabase;
    private final Game currentSelectedGame;

    @Inject
    ProfileEditingPresenterImpl(ProfileEditingView view, MainPresenter mainPresenter, GamePersister gamePersister, EmulatorStarter emulatorStarter, MachineLister machineLister, ExtensionLister extensionLister, GameBuilder gameBuilder, ExtraDataGetter extraDataGetter, @Assisted Settings settings, @Assisted String currentDatabase, @Nullable @Assisted Game currentSelectedGame) throws IOException {
        this.view = Objects.requireNonNull(view);
        this.mainPresenter = Objects.requireNonNull(mainPresenter);
        this.gamePersister = Objects.requireNonNull(gamePersister);
        this.emulatorStarter = Objects.requireNonNull(emulatorStarter);
        this.machineLister = Objects.requireNonNull(machineLister);
        this.extensionLister = Objects.requireNonNull(extensionLister);
        this.gameBuilder = Objects.requireNonNull(gameBuilder);
        this.extraDataGetter = Objects.requireNonNull(extraDataGetter);
        this.settings = Objects.requireNonNull(settings);
        this.currentDatabase = Objects.requireNonNull(currentDatabase);
        this.currentSelectedGame = currentSelectedGame;
    }

    @Override
    public void onRequestAddGameScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        try {
            this.view.displayAddGameScreen(this, currentLanguage, this.machineLister.get(), this.extensionLister.get(), currentRightToLeft);
        }
        catch (InvalidMachinesDirectoryException imde) {
            throw new LauncherException(LauncherExceptionCode.ERR_INVALID_MACHINES_DIRECTORY);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestEditGameScreen(Language currentLanguage, boolean currentRightToLeft) throws LauncherException {
        try {
            this.view.displayEditGameScreen(this, currentLanguage, this.machineLister.get(), this.extensionLister.get(), Language.isRightToLeft(currentLanguage), this.currentSelectedGame.getName(), this.currentSelectedGame.getInfo(), this.currentSelectedGame.getMachine(), this.currentSelectedGame.getRomA(), this.currentSelectedGame.getRomB(), this.currentSelectedGame.getExtensionRom(), this.currentSelectedGame.getDiskA(), this.currentSelectedGame.getDiskB(), this.currentSelectedGame.getTape(), this.currentSelectedGame.getHarddisk(), this.currentSelectedGame.getLaserdisc(), this.currentSelectedGame.getTclScript(), this.currentSelectedGame.getFDDMode().getValue(), this.currentSelectedGame.isTclScriptOverride(), this.currentSelectedGame.getInputDevice().getValue(), this.currentSelectedGame.isConnectGFX9000());
        }
        catch (InvalidMachinesDirectoryException imde) {
            throw new LauncherException(LauncherExceptionCode.ERR_INVALID_MACHINES_DIRECTORY);
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestAddGameSaveAction(String name, String info, String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, int fddModeCode, boolean scriptOverride, int inputDeviceCode, boolean connectGFX9000) throws LauncherException {
        Map<String, ExtraData> extraDataMap = null;
        try {
            extraDataMap = this.extraDataGetter.getExtraData();
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        Game game = null;
        try {
            game = this.getGameObject(name, info, machine, romA, romB, extensionRom, diskA, diskB, tape, harddisk, laserdisc, script, fddModeCode, scriptOverride, inputDeviceCode, connectGFX9000, extraDataMap);
        }
        catch (IllegalArgumentException iae) {
            throw new LauncherException(LauncherExceptionCode.ERR_EMPTY_GAME_FIELDS);
        }
        if (game == null) {
            throw new LauncherException(LauncherExceptionCode.ERR_EMPTY_GAME_FIELDS);
        }
        try {
            this.gamePersister.saveGame(game, this.currentDatabase);
            this.mainPresenter.onAcceptAddGameSaveAction(game);
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_NULL_NAME)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_WITH_NULL_NAME);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_MISSING_MEDIA)) {
                throw new LauncherException(LauncherExceptionCode.ERR_EMPTY_GAME_FIELDS);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_ALREADY_EXISTS)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_ALREADY_EXISTS, name);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, this.currentDatabase);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    @Override
    public void onRequestLaunchAction(String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, int fddModeCode, boolean scriptOverride, int inputDeviceCode, boolean connectGFX9000) throws LauncherException {
        Game game = null;
        try {
            game = Game.machine(machine).romA(romA).romB(romB).extensionRom(extensionRom).diskA(diskA).diskB(diskB).tape(tape).harddisk(harddisk).laserdisc(laserdisc).tclScript(script).fddMode(FDDMode.fromValue(fddModeCode)).tclScriptOverride(scriptOverride).inputDevice(InputDevice.fromValue(inputDeviceCode)).connectGFX9000(connectGFX9000).build();
        }
        catch (IllegalArgumentException iae) {
            throw new LauncherException(LauncherExceptionCode.ERR_EMPTY_GAME_FIELDS);
        }
        try {
            this.emulatorStarter.start(this.settings, game);
        }
        catch (IOException ioe) {
            LauncherLogger.logException(this, ioe);
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_START_OPENMSX);
        }
    }

    @Override
    public void onRequestEditGameSaveAction(String oldName, String newName, String info, String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, int fddModeCode, boolean scriptOverride, int inputDeviceCode, boolean connectGFX9000) throws LauncherException {
        Map<String, ExtraData> extraDataMap = null;
        try {
            extraDataMap = this.extraDataGetter.getExtraData();
        }
        catch (IOException ioe) {
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
        Game newGame = null;
        try {
            newGame = this.getGameObject(newName, info, machine, romA, romB, extensionRom, diskA, diskB, tape, harddisk, laserdisc, script, fddModeCode, scriptOverride, inputDeviceCode, connectGFX9000, extraDataMap);
        }
        catch (IllegalArgumentException iae) {
            throw new LauncherException(LauncherExceptionCode.ERR_EMPTY_GAME_FIELDS);
        }
        try {
            this.gamePersister.updateGame(this.currentSelectedGame, newGame, this.currentDatabase);
            this.mainPresenter.onAcceptEditGameSaveAction(oldName, newGame);
        }
        catch (GamePersistenceException gpe) {
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_NULL_NAME)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_WITH_NULL_NAME);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_WITH_MISSING_MEDIA)) {
                throw new LauncherException(LauncherExceptionCode.ERR_EMPTY_GAME_FIELDS);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_ALREADY_EXISTS)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_ALREADY_EXISTS, newName);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.GAME_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_NOT_FOUND, oldName);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_ALREADY_EXISTS)) {
                throw new LauncherException(LauncherExceptionCode.ERR_GAME_ALREADY_EXISTS, this.currentDatabase);
            }
            if (gpe.getIssue().equals((Object)GamePersistenceExceptionIssue.DATABASE_NOT_FOUND)) {
                throw new LauncherException(LauncherExceptionCode.ERR_DATABASE_NOT_FOUND, this.currentDatabase);
            }
            throw new LauncherException(LauncherExceptionCode.ERR_IO);
        }
    }

    private Game getGameObject(String name, String info, String machine, String romA, String romB, String extensionRom, String diskA, String diskB, String tape, String harddisk, String laserdisc, String script, int fddModeCode, boolean scriptOverride, int inputDeviceCode, boolean connectGFX9000, Map<String, ExtraData> extraDataMap) {
        return this.gameBuilder.createGameObjectForDataEnteredByUser(name, info, machine, romA, romB, extensionRom, diskA, diskB, tape, harddisk, laserdisc, script, FDDMode.fromValue(fddModeCode), scriptOverride, InputDevice.fromValue(inputDeviceCode), connectGFX9000, extraDataMap);
    }
}

