/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import info.msxlaunchers.openmsx.launcher.data.feed.FeedMessage;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.GameLabel;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.MainView;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.PlatformViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.CreateEmptyDatabaseWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.HelpWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MoveGamesWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

@Singleton
class MainSwingView
implements MainView {
    private final MainPresenter mainPresenter;
    private final MainWindow mainWindow;

    @Inject
    MainSwingView(MainPresenter mainPresenter, PlatformViewProperties platformViewProperties) {
        this.mainPresenter = mainPresenter;
        this.mainWindow = new MainWindow(mainPresenter, platformViewProperties);
    }

    @Override
    public void displayMain(Language language, Set<GameLabel> games, Set<String> databases, String defaultDatabase, boolean rightToLeft, boolean showUpdateAllDatabases, boolean enableFeedButton) {
        SwingUtilities.invokeLater(new MainWindowStarter(language, games, databases, defaultDatabase, rightToLeft, showUpdateAllDatabases, enableFeedButton));
    }

    @Override
    public void refreshLanguage(Language language) {
        this.mainWindow.refreshLanguage(language);
    }

    @Override
    public void flipOrientationLeftToRight() {
        this.mainWindow.flipOrientationLeftToRight();
    }

    @Override
    public void flipOrientationRightToLeft() {
        this.mainWindow.flipOrientationRightToLeft();
    }

    @Override
    public void fillGameList(String currentDatabase, Set<GameLabel> games, String selectedGame) {
        this.mainWindow.fillGameList(currentDatabase, games, selectedGame);
        this.mainWindow.updateGameCount(games.size());
    }

    @Override
    public void updateGameCount(int total) {
        this.mainWindow.updateGameCount(total);
    }

    @Override
    public void displayAbout(Language language, boolean rightToLeft, String extraDataVersion, String screenshotsVersion) {
        HelpWindow helpWindow = new HelpWindow(language, rightToLeft, extraDataVersion, screenshotsVersion, this.mainWindow);
        helpWindow.display();
    }

    @Override
    public void showGameScreenshots(String screenshot1, String screenshot2) {
        this.mainWindow.showGameScreenshot(screenshot1, screenshot2);
    }

    @Override
    public void enableButtons(boolean launchFlag, boolean removeFlag, boolean addFlag, boolean editFlag, boolean infoFlag) {
        this.mainWindow.enableButtons(launchFlag, removeFlag, addFlag, editFlag, infoFlag);
    }

    @Override
    public void enableSoundIndicators(boolean psgFlag, boolean sccFlag, boolean scciFlag, boolean pcmFlag, boolean msxMusicFlag, boolean msxAudioFlag, boolean moonsoundFlag, boolean midiFlag) {
        this.mainWindow.enableSoundIndicators(psgFlag, sccFlag, scciFlag, pcmFlag, msxMusicFlag, msxAudioFlag, moonsoundFlag, midiFlag);
    }

    @Override
    public void enableGenerationIndicators(boolean msxFlag, boolean msx2Flag, boolean msx2pFlag, boolean turboRFlag) {
        this.mainWindow.enableGenerationIndicators(msxFlag, msx2Flag, msx2pFlag, turboRFlag);
    }

    @Override
    public Set<String> displayAndGetMoveGames(Language language, Set<String> gameNames, String oldDatabase, Set<String> targetDatabases, boolean rightToLeft) {
        MoveGamesWindow moveGamesWindow = new MoveGamesWindow(this.mainPresenter, language, rightToLeft, this.mainWindow, gameNames, oldDatabase, targetDatabases);
        return moveGamesWindow.displayAndGetMovedGames();
    }

    @Override
    public int displayAndGetActionDecider(String gameName, Language language, boolean rightToLeft) {
        Map<String, String> messages = LanguageDisplayFactory.getDisplayMessages(MainWindow.class, language);
        return MessageBoxUtil.showYesNoAllMessageBox(this.mainWindow, "<html>\"" + gameName + "\" " + messages.get("MOVE_GAME_CONFLICT_MESSAGE") + "</html>", messages, rightToLeft);
    }

    @Override
    public void removeDatabase(String database) {
        this.mainWindow.removeDatabase(database);
    }

    @Override
    public void renameDatabase(String oldDatabase, String newDatabase) {
        this.mainWindow.renameDatabase(oldDatabase, newDatabase);
    }

    @Override
    public void displayCreateEmptyDatabase(Language language, boolean rightToLeft) {
        CreateEmptyDatabaseWindow createEmptyDatabaseWindow = new CreateEmptyDatabaseWindow(this.mainPresenter, language, rightToLeft, this.mainWindow);
        createEmptyDatabaseWindow.displayAndGetNewDatabaseName();
    }

    @Override
    public void showFavoritesMenu(Set<DatabaseItem> favorites) {
        this.mainWindow.showFavoritesMenu(favorites);
    }

    @Override
    public void showDatabasesList(Set<String> databases) {
        this.mainWindow.showDatabasesList(databases);
    }

    @Override
    public void highlightGame(String gameName) {
        this.mainWindow.higlightGame(gameName);
    }

    @Override
    public void showFiltersMenu(Set<String> filterNames, boolean isFilterSelected, boolean isEditCurrentUntitledFilter) {
        this.mainWindow.showFiltersMenu(filterNames, isFilterSelected, isEditCurrentUntitledFilter);
    }

    @Override
    public void updateFilterNameLabel(String filtersName) {
        this.mainWindow.updateFilterNameLabel(filtersName);
    }

    @Override
    public void setFilterNameLabelUntitled() {
        this.mainWindow.setFilterNameLabelUntitled();
    }

    @Override
    public void displayFilterDetails(List<String> filterDescriptions) {
        this.mainWindow.setFiltersToolTip(filterDescriptions);
    }

    @Override
    public void enableFeedAccess(boolean flag) {
        this.mainWindow.enableFeedButton(flag);
    }

    @Override
    public void indicateNewFeedMessages(boolean flag) {
        this.mainWindow.indicateNewNews(flag);
    }

    @Override
    public void showFeedMessagesList(List<FeedMessage> feedMessages) {
        this.mainWindow.showFeedMenu(feedMessages);
    }

    @Override
    public void showFeedProcessingMessage() {
        this.mainWindow.showFeedProcessingMessage();
    }

    private class MainWindowStarter
    implements Runnable {
        private final Language language;
        private final Set<GameLabel> games;
        private final Set<String> databases;
        private final String defaultDatabase;
        private final boolean rightToLeft;
        private final boolean showUpdateAllDatabases;
        private final boolean enableFeedAccess;

        MainWindowStarter(Language language, Set<GameLabel> games, Set<String> databases, String defaultDatabase, boolean rightToLeft, boolean showUpdateAllDatabases, boolean enableFeedAccess) {
            this.language = language;
            this.games = games;
            this.databases = databases;
            this.defaultDatabase = defaultDatabase;
            this.rightToLeft = rightToLeft;
            this.showUpdateAllDatabases = showUpdateAllDatabases;
            this.enableFeedAccess = enableFeedAccess;
        }

        @Override
        public void run() {
            MainSwingView.this.mainWindow.display(this.language, this.games, this.databases, this.defaultDatabase, this.rightToLeft, this.showUpdateAllDatabases, this.enableFeedAccess);
        }
    }
}

