/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ActivityViewerWindow
extends JDialog
implements ActionListener {
    private final Map<String, List<String[]>> logData;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final Map<String, String> messages;
    private static final int GAME_COL_WIDTH = 300;
    private static final int DATABASE_COL_WIDTH = 220;
    private static final int TIME_COL_WIDTH = 420;
    private static final int COUNT_COL_WIDTH = 60;
    private JButton okButton;

    public ActivityViewerWindow(Map<String, List<String[]>> logData, Language language, boolean rightToLeft) {
        this.logData = logData;
        this.rightToLeft = rightToLeft;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("ACTIVITY_VIEWER"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel tablesPane = new JPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tablesPane.add(tabbedPane);
        JPanel launchHistoryPanel = new JPanel();
        List<String[]> launchHistoryData = this.logData.get("ALL_PLAY_HISTORY");
        Object[] launchHistoryColumnNames = new Object[]{this.messages.get("TIME"), this.messages.get("GAME"), this.messages.get("DATABASE")};
        Object[][] launchHistoryRowData = (Object[][])launchHistoryData.toArray((T[])new String[0][]);
        JTable launchHistoryTable = new JTable(launchHistoryRowData, launchHistoryColumnNames);
        launchHistoryTable.setRowSelectionAllowed(false);
        launchHistoryTable.setPreferredScrollableViewportSize(new Dimension(450, 180));
        launchHistoryTable.getColumnModel().getColumn(0).setPreferredWidth(420);
        launchHistoryTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        launchHistoryTable.getColumnModel().getColumn(2).setPreferredWidth(220);
        JScrollPane launchHistoryScrollPane = new JScrollPane(launchHistoryTable);
        launchHistoryScrollPane.setVerticalScrollBarPolicy(22);
        launchHistoryPanel.add(launchHistoryScrollPane);
        tabbedPane.addTab(this.messages.get("HISTORY"), launchHistoryPanel);
        JPanel mostPlayedPanel = new JPanel();
        List<String[]> mostPlayedData = this.logData.get("MOST_PLAYED");
        Object[] mostPlayedColumnNames = new Object[]{this.messages.get("GAME"), this.messages.get("DATABASE"), this.messages.get("COUNT")};
        Object[][] mostPlayedRowData = (Object[][])mostPlayedData.toArray((T[])new String[0][]);
        JTable mostPlayedTable = new JTable(mostPlayedRowData, mostPlayedColumnNames);
        mostPlayedTable.setRowSelectionAllowed(false);
        mostPlayedTable.setPreferredScrollableViewportSize(new Dimension(450, 180));
        mostPlayedTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        mostPlayedTable.getColumnModel().getColumn(1).setPreferredWidth(220);
        mostPlayedTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        JScrollPane mostPlayedScrollPane = new JScrollPane(mostPlayedTable);
        mostPlayedScrollPane.setVerticalScrollBarPolicy(22);
        mostPlayedPanel.add(mostPlayedScrollPane);
        tabbedPane.addTab(this.messages.get("MOST_PLAYED"), mostPlayedPanel);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.okButton);
        contentPane.add(tablesPane);
        contentPane.add(buttonsPane);
        if (this.rightToLeft) {
            tabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
            tableRenderer.setHorizontalAlignment(4);
            launchHistoryTable.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            launchHistoryTable.getColumnModel().getColumn(0).setCellRenderer(tableRenderer);
            launchHistoryTable.getColumnModel().getColumn(1).setCellRenderer(tableRenderer);
            launchHistoryTable.getColumnModel().getColumn(2).setCellRenderer(tableRenderer);
            ((DefaultTableCellRenderer)launchHistoryTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(4);
            mostPlayedTable.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            mostPlayedTable.getColumnModel().getColumn(0).setCellRenderer(tableRenderer);
            mostPlayedTable.getColumnModel().getColumn(1).setCellRenderer(tableRenderer);
            mostPlayedTable.getColumnModel().getColumn(2).setCellRenderer(tableRenderer);
            ((DefaultTableCellRenderer)mostPlayedTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(4);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.dispose();
        }
    }
}

