/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.EnumWithDisplayName;
import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterDescriptor;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Genre;
import info.msxlaunchers.openmsx.launcher.data.game.constants.MSXGeneration;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Medium;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Sound;
import info.msxlaunchers.openmsx.launcher.data.game.constants.VideoSource;
import info.msxlaunchers.openmsx.launcher.data.repository.constants.Company;
import info.msxlaunchers.openmsx.launcher.data.repository.constants.Country;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.FilterEditingPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FilterItemObject;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FilterUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTableButtonColumn;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class AddEditFilterWindow
extends JDialog
implements ActionListener {
    private final FilterEditingPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component mainWindow;
    private final List<String> filterItemsToEdit;
    private final String filterName;
    private final boolean editMode;
    private final boolean editSavedFilterMode;
    private final AddEditFilterWindow thisWindow = this;
    private JPanel filterItemsPanel;
    private JTable table;
    private TableModel tableModel;
    private JCheckBox saveAsCheckBox;
    private JTextField filterNameTextField;
    private JButton saveButton;
    private JButton closeButton;
    private List<FilterItemObject> filterItemObjectList = new ArrayList<FilterItemObject>();

    public AddEditFilterWindow(FilterEditingPresenter presenter, Language language, boolean rightToLeft, String filterName, List<String> filterItemsToEdit) {
        this.presenter = presenter;
        this.rightToLeft = rightToLeft;
        this.filterItemsToEdit = filterItemsToEdit;
        this.filterName = filterName;
        this.editMode = filterItemsToEdit != null;
        this.editSavedFilterMode = this.editMode && filterName != null;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
    }

    public void display() {
        this.setDefaultCloseOperation(0);
        if (this.editSavedFilterMode) {
            this.setTitle(this.messages.get("EDIT_FILTER") + " - " + this.filterName);
        } else if (this.editMode) {
            this.setTitle(this.messages.get("EDIT_FILTER"));
        } else {
            this.setTitle(this.messages.get("ADD_FILTER"));
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddEditFilterWindow.this.presenter.onRequestClose();
                AddEditFilterWindow.this.dispose();
            }
        });
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)contentPanel, "Center");
        JComboBox<ComboBoxWithDisplayNameItem> filterTypesComboBox = this.getComboBoxWithDisplayValuesLocalizedExternally(FilterType.class, false);
        filterTypesComboBox.setMaximumRowCount(FilterType.values().length);
        filterTypesComboBox.addActionListener(event -> this.showCorrespondingSelector(FilterType.valueOf(((ComboBoxWithDisplayNameItem)filterTypesComboBox.getSelectedItem()).value)));
        this.filterItemsPanel = new JPanel();
        this.tableModel = new TableModel();
        this.table = new JTable(this.tableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(450, 82));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(320);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(10);
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AddEditFilterWindow.this.removeRowFromTable(Integer.parseInt(e.getActionCommand()));
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)AddEditFilterWindow.this.thisWindow, le, (Map<String, String>)AddEditFilterWindow.this.messages, AddEditFilterWindow.this.rightToLeft);
                }
            }
        };
        new JTableButtonColumn(this.table, deleteAction, 2, Icons.DELETE_SMALL.getImageIcon(), this.messages.get("DELETE"));
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setVerticalScrollBarPolicy(22);
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new FlowLayout(1, 5, 5));
        this.saveButton = new JButton(this.messages.get("SAVE"));
        this.saveButton.addActionListener(this);
        this.saveButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.saveButton);
        this.closeButton = new JButton(this.messages.get("CLOSE"));
        this.closeButton.addActionListener(this);
        this.closeButton.setPreferredSize(MainWindow.BUTTON_DIMENSION);
        buttonsPane.add(this.closeButton);
        JPanel filterSelectorPanel = new JPanel();
        filterSelectorPanel.setLayout(new FlowLayout(3));
        filterSelectorPanel.add(filterTypesComboBox);
        filterSelectorPanel.add(this.filterItemsPanel);
        JPanel saveAsPanel = new JPanel();
        this.filterNameTextField = new JTextField(25);
        saveAsPanel.setLayout(new FlowLayout(3));
        if (!this.editSavedFilterMode) {
            this.saveAsCheckBox = new JCheckBox(this.messages.get("SAVE_AS"));
            this.saveAsCheckBox.addActionListener(this);
            this.filterNameTextField = new JTextField(25);
            this.filterNameTextField.setEnabled(false);
            saveAsPanel.add(this.saveAsCheckBox);
            saveAsPanel.add(this.filterNameTextField);
            this.saveButton.setEnabled(false);
        } else {
            JLabel nameLabel = new JLabel(this.messages.get("NAME"));
            saveAsPanel.add(nameLabel);
            this.filterNameTextField.setText(this.filterName);
            saveAsPanel.add(this.filterNameTextField);
        }
        GroupLayout glContentPanel = new GroupLayout(contentPanel);
        glContentPanel.setHorizontalGroup(glContentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glContentPanel.createSequentialGroup().addComponent(filterSelectorPanel)).addGroup(glContentPanel.createSequentialGroup().addComponent(scrollPane, -2, -2, -2)).addGroup(glContentPanel.createSequentialGroup().addComponent(saveAsPanel)).addGroup(glContentPanel.createSequentialGroup().addComponent(buttonsPane)));
        glContentPanel.setVerticalGroup(glContentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(glContentPanel.createSequentialGroup().addGroup(glContentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(filterSelectorPanel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(glContentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(saveAsPanel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(buttonsPane)));
        contentPanel.setLayout(glContentPanel);
        this.filterItemsPanel.setLayout(new CardLayout(0, 0));
        this.filterItemsPanel.add(new CompaniesLayer().getLayer(), FilterType.COMPANY.toString());
        this.filterItemsPanel.add(new YearsLayer().getLayer(), FilterType.YEAR.toString());
        this.filterItemsPanel.add(new CountriesLayer().getLayer(), FilterType.COUNTRY.toString());
        this.filterItemsPanel.add(new MediaLayer().getLayer(), FilterType.MEDIUM.toString());
        this.filterItemsPanel.add(new GenerationsLayer().getLayer(), FilterType.GENERATION.toString());
        this.filterItemsPanel.add(new GenresLayer().getLayer(), FilterType.GENRE.toString());
        this.filterItemsPanel.add(new SizesLayer().getLayer(), FilterType.SIZE.toString());
        this.filterItemsPanel.add(new SoundChipsLayer().getLayer(), FilterType.SOUND.toString());
        this.filterItemsPanel.add(new VideoSourcesLayer().getLayer(), FilterType.VIDEO_SOURCE.toString());
        if (this.filterItemsToEdit != null) {
            for (String filterItem : this.filterItemsToEdit) {
                this.addRowToTable(filterItem);
            }
        }
        if (this.rightToLeft) {
            filterSelectorPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.table.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(4);
            DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
            tableRenderer.setHorizontalAlignment(4);
            for (int index = 0; index < this.table.getColumnCount() - 1; ++index) {
                this.table.getColumnModel().getColumn(index).setCellRenderer(tableRenderer);
            }
            if (!this.editSavedFilterMode) {
                this.saveAsCheckBox.setHorizontalTextPosition(10);
            }
            saveAsPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            DefaultListCellRenderer comboBoxRenderer = new DefaultListCellRenderer();
            comboBoxRenderer.setHorizontalAlignment(4);
            filterTypesComboBox.setRenderer(comboBoxRenderer);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.saveButton) {
            String text = this.filterNameTextField.getText().trim();
            if (text.isEmpty()) {
                this.filterNameTextField.setBorder(BorderFactory.createLineBorder(Color.red, 1));
                return;
            }
            try {
                if (this.editSavedFilterMode) {
                    this.presenter.onRequestUpdateFilterAction(this.filterName, text);
                } else {
                    this.presenter.onRequestSaveFilterAction(this.filterNameTextField.getText());
                }
                this.dispose();
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.rightToLeft);
            }
        } else if (source == this.closeButton) {
            this.presenter.onRequestClose();
            this.dispose();
        } else if (source == this.saveAsCheckBox) {
            this.filterNameTextField.setEnabled(this.saveAsCheckBox.isSelected());
            this.saveButton.setEnabled(this.saveAsCheckBox.isSelected());
        }
    }

    private void showCorrespondingSelector(FilterType filterType) {
        CardLayout cl = (CardLayout)this.filterItemsPanel.getLayout();
        cl.show(this.filterItemsPanel, filterType.toString());
    }

    private <E extends Enum<E>> JComboBox<ComboBoxWithDisplayNameItem> getComboBoxWithDisplayValuesLocalizedExternally(Class<E> enumClass, boolean sort) {
        ComboBoxWithDisplayNameItem[] comboBoxItems = new ComboBoxWithDisplayNameItem[((Enum[])enumClass.getEnumConstants()).length];
        int index = 0;
        for (Enum enumVal : (Enum[])enumClass.getEnumConstants()) {
            comboBoxItems[index++] = new ComboBoxWithDisplayNameItem(this.messages.get(enumVal.toString()), enumVal.toString());
        }
        if (sort) {
            Arrays.sort(comboBoxItems, (c1, c2) -> ((ComboBoxWithDisplayNameItem)c1).label.compareToIgnoreCase(((ComboBoxWithDisplayNameItem)c2).label));
        }
        JComboBox<ComboBoxWithDisplayNameItem> comboBox = new JComboBox<ComboBoxWithDisplayNameItem>(comboBoxItems);
        if (this.rightToLeft) {
            DefaultListCellRenderer renderer = new DefaultListCellRenderer();
            renderer.setHorizontalAlignment(4);
            comboBox.setRenderer(renderer);
        }
        return comboBox;
    }

    private <E extends Enum<E>> JComboBox<ComboBoxWithDisplayNameItem> getComboBoxWithDisplayValuesLocalizedInternally(Class<E> enumClass, boolean sort) {
        ComboBoxWithDisplayNameItem[] comboBoxItems = new ComboBoxWithDisplayNameItem[((Enum[])enumClass.getEnumConstants()).length];
        int index = 0;
        for (Enum enumVal : (Enum[])enumClass.getEnumConstants()) {
            comboBoxItems[index++] = new ComboBoxWithDisplayNameItem(((EnumWithDisplayName)((Object)enumVal)).getDisplayName(), enumVal.toString());
        }
        if (sort) {
            Arrays.sort(comboBoxItems, (c1, c2) -> ((ComboBoxWithDisplayNameItem)c1).label.compareToIgnoreCase(((ComboBoxWithDisplayNameItem)c2).label));
        }
        return new JComboBox<ComboBoxWithDisplayNameItem>(comboBoxItems);
    }

    private void addRowToTable(String filter) {
        FilterItemObject filterItemObject = FilterUtils.getFilterItemObject(filter);
        this.tableModel.addRow(new Object[]{this.messages.get(filterItemObject.type.toString()), FilterUtils.getFilterDescriptor(filterItemObject.type, filterItemObject.value1, filterItemObject.value2, filterItemObject.parameter, this.messages)});
        this.filterItemObjectList.add(filterItemObject);
    }

    private void addRowToTableAndApply(FilterType type, String value1, String value2, FilterParameter parameter) throws LauncherException {
        if (this.presenter.onAddToFilterListAndApply(type, value1, value2, parameter)) {
            this.tableModel.addRow(new Object[]{this.messages.get(type.toString()), FilterUtils.getFilterDescriptor(type, value1, value2, parameter, this.messages)});
            this.filterItemObjectList.add(new FilterItemObject(type, value1, value2, parameter));
        }
    }

    private void removeRowFromTable(int index) throws LauncherException {
        FilterItemObject filterItemObject = this.filterItemObjectList.get(index);
        this.presenter.onRemoveFromFilterList(filterItemObject.type, filterItemObject.value1, filterItemObject.value2, filterItemObject.parameter);
        this.tableModel.removeRow(index);
        this.filterItemObjectList.remove(index);
    }

    private class TableModel
    extends DefaultTableModel {
        private final String[] columnNames;

        private TableModel() {
            this.columnNames = new String[]{(String)AddEditFilterWindow.this.messages.get("TYPE"), (String)AddEditFilterWindow.this.messages.get("VALUE"), ""};
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == this.columnNames.length - 1;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }

    private static class ComboBoxWithDisplayNameItem {
        private final String label;
        private final String value;

        ComboBoxWithDisplayNameItem(String label, String value) {
            this.label = label;
            this.value = value;
        }

        ComboBoxWithDisplayNameItem(String label, int value) {
            this(label, Utils.getString(value));
        }

        public String toString() {
            return this.label;
        }
    }

    @FilterDescriptor(type=FilterType.VIDEO_SOURCE)
    private class VideoSourcesLayer
    extends AbstractLayer {
        private final VideoSourcesLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> videoSourcesComboBox;

        private VideoSourcesLayer() {
            this.instance = this;
            this.videoSourcesComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedInternally(VideoSource.class, false);
        }

        @Override
        public Component getLayer() {
            JPanel videoSourcesPanel = this.getFilterLayerPanel();
            videoSourcesPanel.add(this.videoSourcesComboBox);
            this.addButton(this.instance, videoSourcesPanel);
            return videoSourcesPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.videoSourcesComboBox.getSelectedItem()).value;
        }
    }

    @FilterDescriptor(type=FilterType.YEAR)
    private class YearsLayer
    extends AbstractLayer {
        private final YearsLayer instance;
        private final JComboBox<String> yearsComboBox;
        private final JComboBox<ComboBoxWithDisplayNameItem> parametersComboBox;
        private final JComboBox<String> secondYearsComboBox;
        private static final int FIRST_YEAR = 1982;
        private static final int LAST_YEAR = 2018;

        YearsLayer() {
            this.instance = this;
            this.yearsComboBox = new JComboBox<String>(this.getYears());
            this.parametersComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedExternally(FilterParameter.class, false);
            this.secondYearsComboBox = new JComboBox<String>(this.getYears());
            this.secondYearsComboBox.setEnabled(false);
        }

        @Override
        public Component getLayer() {
            JPanel sizesPanel = this.getFilterLayerPanel();
            sizesPanel.add(this.yearsComboBox);
            sizesPanel.add(this.parametersComboBox);
            sizesPanel.add(this.secondYearsComboBox);
            this.addButton(this.instance, sizesPanel);
            this.parametersComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String parameter = ((ComboBoxWithDisplayNameItem)YearsLayer.this.parametersComboBox.getSelectedItem()).value;
                    if (parameter.equals(FilterParameter.BETWEEN_INCLUSIVE.toString())) {
                        YearsLayer.this.secondYearsComboBox.setEnabled(true);
                    } else {
                        YearsLayer.this.secondYearsComboBox.setEnabled(false);
                    }
                }
            });
            return sizesPanel;
        }

        private String[] getYears() {
            String[] years = new String[37];
            int count = 0;
            for (int year = 1982; year <= 2018; ++year) {
                years[count++] = String.valueOf(year);
            }
            return years;
        }

        @Override
        public String getValue1() {
            return this.yearsComboBox.getSelectedItem().toString();
        }

        @Override
        public String getValue2() {
            return this.secondYearsComboBox.getSelectedItem().toString();
        }

        @Override
        public FilterParameter getParameter() {
            return FilterParameter.valueOf(((ComboBoxWithDisplayNameItem)this.parametersComboBox.getSelectedItem()).value);
        }
    }

    @FilterDescriptor(type=FilterType.SOUND)
    private class SoundChipsLayer
    extends AbstractLayer {
        private final SoundChipsLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> soundChipsComboBox;

        private SoundChipsLayer() {
            this.instance = this;
            this.soundChipsComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedInternally(Sound.class, false);
        }

        @Override
        public Component getLayer() {
            JPanel soundChipsPanel = this.getFilterLayerPanel();
            soundChipsPanel.add(this.soundChipsComboBox);
            this.addButton(this.instance, soundChipsPanel);
            return soundChipsPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.soundChipsComboBox.getSelectedItem()).value;
        }
    }

    @FilterDescriptor(type=FilterType.SIZE)
    private class SizesLayer
    extends AbstractLayer {
        private final SizesLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> sizesComboBox;
        private final JComboBox<ComboBoxWithDisplayNameItem> parametersComboBox;
        private final JComboBox<ComboBoxWithDisplayNameItem> secondSizesComboBox;
        private static final String KB = " KB";

        SizesLayer() {
            this.instance = this;
            this.sizesComboBox = new JComboBox<ComboBoxWithDisplayNameItem>(this.getSizesModel());
            this.parametersComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedExternally(FilterParameter.class, false);
            this.secondSizesComboBox = new JComboBox<ComboBoxWithDisplayNameItem>(this.getSizesModel());
            this.secondSizesComboBox.setEnabled(false);
        }

        @Override
        public Component getLayer() {
            JPanel sizesPanel = this.getFilterLayerPanel();
            sizesPanel.add(this.sizesComboBox);
            sizesPanel.add(this.parametersComboBox);
            sizesPanel.add(this.secondSizesComboBox);
            this.addButton(this.instance, sizesPanel);
            this.parametersComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String parameter = ((ComboBoxWithDisplayNameItem)SizesLayer.this.parametersComboBox.getSelectedItem()).value;
                    if (parameter.equals(FilterParameter.BETWEEN_INCLUSIVE.toString())) {
                        SizesLayer.this.secondSizesComboBox.setEnabled(true);
                    } else {
                        SizesLayer.this.secondSizesComboBox.setEnabled(false);
                    }
                }
            });
            return sizesPanel;
        }

        private ComboBoxWithDisplayNameItem[] getSizesModel() {
            int[] sizes = new int[]{16, 32, 128, 256, 360, 512, 720, 1024};
            ComboBoxWithDisplayNameItem[] comboBoxItems = new ComboBoxWithDisplayNameItem[sizes.length];
            for (int index = 0; index < sizes.length; ++index) {
                comboBoxItems[index] = new ComboBoxWithDisplayNameItem(sizes[index] + KB, sizes[index] * 1024);
            }
            return comboBoxItems;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.sizesComboBox.getSelectedItem()).value;
        }

        @Override
        public String getValue2() {
            return ((ComboBoxWithDisplayNameItem)this.secondSizesComboBox.getSelectedItem()).value;
        }

        @Override
        public FilterParameter getParameter() {
            return FilterParameter.valueOf(((ComboBoxWithDisplayNameItem)this.parametersComboBox.getSelectedItem()).value);
        }
    }

    @FilterDescriptor(type=FilterType.MEDIUM)
    private class MediaLayer
    extends AbstractLayer {
        private final MediaLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> mediaComboBox;

        private MediaLayer() {
            this.instance = this;
            this.mediaComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedExternally(Medium.class, false);
        }

        @Override
        public Component getLayer() {
            JPanel mediaPanel = this.getFilterLayerPanel();
            mediaPanel.add(this.mediaComboBox);
            this.addButton(this.instance, mediaPanel);
            return mediaPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.mediaComboBox.getSelectedItem()).value;
        }
    }

    @FilterDescriptor(type=FilterType.GENRE)
    private class GenresLayer
    extends AbstractLayer {
        private final GenresLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> genresComboBox;

        private GenresLayer() {
            this.instance = this;
            this.genresComboBox = new JComboBox();
        }

        @Override
        public Component getLayer() {
            JPanel genresPanel = this.getFilterLayerPanel();
            Genre[] genres = Genre.values();
            Arrays.sort(genres, (g1, g2) -> g1.getDisplayName().compareTo(g2.getDisplayName()));
            for (int index = 1; index < genres.length; ++index) {
                this.genresComboBox.addItem(new ComboBoxWithDisplayNameItem(genres[index].getDisplayName(), genres[index].toString()));
            }
            genresPanel.add(this.genresComboBox);
            this.addButton(this.instance, genresPanel);
            return genresPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.genresComboBox.getSelectedItem()).value;
        }
    }

    @FilterDescriptor(type=FilterType.GENERATION)
    private class GenerationsLayer
    extends AbstractLayer {
        private final GenerationsLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> generationsComboBox;

        private GenerationsLayer() {
            this.instance = this;
            this.generationsComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedInternally(MSXGeneration.class, false);
        }

        @Override
        public Component getLayer() {
            JPanel generationsPanel = this.getFilterLayerPanel();
            generationsPanel.add(this.generationsComboBox);
            this.addButton(this.instance, generationsPanel);
            return generationsPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.generationsComboBox.getSelectedItem()).value;
        }
    }

    @FilterDescriptor(type=FilterType.COUNTRY)
    private class CountriesLayer
    extends AbstractLayer {
        private final CountriesLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> countriesComboBox;

        private CountriesLayer() {
            this.instance = this;
            this.countriesComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedExternally(Country.class, true);
        }

        @Override
        public Component getLayer() {
            JPanel countriesPanel = this.getFilterLayerPanel();
            countriesPanel.add(this.countriesComboBox);
            this.addButton(this.instance, countriesPanel);
            return countriesPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.countriesComboBox.getSelectedItem()).value;
        }
    }

    @FilterDescriptor(type=FilterType.COMPANY)
    private class CompaniesLayer
    extends AbstractLayer {
        private final CompaniesLayer instance;
        private final JComboBox<ComboBoxWithDisplayNameItem> companiesComboBox;

        private CompaniesLayer() {
            this.instance = this;
            this.companiesComboBox = AddEditFilterWindow.this.getComboBoxWithDisplayValuesLocalizedInternally(Company.class, true);
        }

        @Override
        public Component getLayer() {
            JPanel companiesPanel = this.getFilterLayerPanel();
            companiesPanel.add(this.companiesComboBox);
            this.addButton(this.instance, companiesPanel);
            return companiesPanel;
        }

        @Override
        public String getValue1() {
            return ((ComboBoxWithDisplayNameItem)this.companiesComboBox.getSelectedItem()).label;
        }
    }

    private abstract class AbstractLayer
    implements Layer {
        private AbstractLayer() {
        }

        @Override
        public final FilterType getType() {
            return this.getClass().getAnnotation(FilterDescriptor.class).type();
        }

        @Override
        public String getValue2() {
            return null;
        }

        @Override
        public FilterParameter getParameter() {
            return null;
        }

        protected void addButton(final Layer instance, JPanel panel) {
            JButton addButton = this.getAddButton();
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AbstractLayer.this.addFilterItem(instance);
                    }
                    catch (LauncherException le) {
                        MessageBoxUtil.showErrorMessageBox((Component)AddEditFilterWindow.this.thisWindow, le, (Map<String, String>)AddEditFilterWindow.this.messages, AddEditFilterWindow.this.rightToLeft);
                    }
                }
            });
            panel.add(addButton);
        }

        protected JPanel getFilterLayerPanel() {
            JPanel panel = new JPanel(new FlowLayout(3, 0, 0));
            if (AddEditFilterWindow.this.rightToLeft) {
                panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            return panel;
        }

        private JButton getAddButton() {
            JButton addButton = new JButton(Icons.ADD_SMALL.getImageIcon());
            addButton.setPreferredSize(new Dimension(24, 24));
            return addButton;
        }

        private void addFilterItem(Layer layer) throws LauncherException {
            AddEditFilterWindow.this.addRowToTableAndApply(layer.getType(), layer.getValue1(), layer.getValue2(), layer.getParameter());
            AddEditFilterWindow.this.table.changeSelection(AddEditFilterWindow.this.table.getRowCount() - 1, 0, false, false);
        }
    }

    private static interface Layer {
        public Component getLayer();

        public FilterType getType();

        public String getValue1();

        public String getValue2();

        public FilterParameter getParameter();
    }
}

