/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class HelpWindow
extends JDialog
implements ActionListener {
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final String extraDataVersion;
    private final String screenshotsVersion;
    private final Component mainWindow;
    private JButton okButton;

    public HelpWindow(Language language, boolean rightToLeft, String extraDataVersion, String screenshotsVersion, Component parent) {
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.extraDataVersion = extraDataVersion;
        this.screenshotsVersion = screenshotsVersion;
        this.mainWindow = parent;
    }

    public void display() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.messages.get("ABOUT"));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        if (this.rightToLeft) {
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        JPanel contentPanel = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)contentPanel, "Center");
        this.okButton = new JButton(this.messages.get("OK"));
        this.okButton.addActionListener(this);
        JLabel versionLabel = new JLabel("openMSX Launcher 1.14");
        JLabel developerLabel = new JLabel("Sam Elsharif 2013-2020");
        JLabel launcherIcon = new JLabel(Icons.APPLICATION_64.getImageIcon());
        JTextArea aboutMessageTextField = new JTextArea("");
        if (!Utils.isEmpty(this.extraDataVersion)) {
            aboutMessageTextField.append(this.getComponentVersionLabel(this.messages.get("EXTRA_DATA"), this.extraDataVersion));
            aboutMessageTextField.append("\n");
        }
        if (!Utils.isEmpty(this.screenshotsVersion)) {
            aboutMessageTextField.append(this.getComponentVersionLabel(this.messages.get("SCREENSHOTS"), this.screenshotsVersion));
            aboutMessageTextField.append("\n");
        }
        if (!Utils.isEmpty(this.extraDataVersion) || !Utils.isEmpty(this.screenshotsVersion)) {
            aboutMessageTextField.append("\n");
        }
        aboutMessageTextField.append("http://msxlaunchers.info/");
        aboutMessageTextField.append("\n\n");
        aboutMessageTextField.append("JRE Version " + System.getProperty("java.version"));
        aboutMessageTextField.append("\n\n");
        aboutMessageTextField.append(this.messages.get("MESSAGE"));
        aboutMessageTextField.append("\n\n");
        aboutMessageTextField.append(this.messages.get("CREDITS"));
        aboutMessageTextField.append("\n");
        aboutMessageTextField.append(" Afsaneh Tajvidi - Persian translation and graphics\n");
        aboutMessageTextField.append(" Eric Chen - Chinese translation\n");
        aboutMessageTextField.append(" Giuseve - Beta testing and suggestions\n");
        aboutMessageTextField.append(" rderooy - Suggesting and testing the disable-FDD feature\n");
        aboutMessageTextField.append("\n");
        aboutMessageTextField.append(this.messages.get("TRANSLATION_SOURCES"));
        aboutMessageTextField.append("\n");
        aboutMessageTextField.append(" Microsoft Language Portal\n");
        aboutMessageTextField.append(" Google Translate\n");
        aboutMessageTextField.append(" blueMSX Launcher\n");
        aboutMessageTextField.append("\n");
        aboutMessageTextField.append(this.messages.get("ICONS"));
        aboutMessageTextField.append("\n");
        aboutMessageTextField.append(" http://www.iconfinder.com/\n");
        aboutMessageTextField.append(" http://www.iconarchive.com/\n");
        aboutMessageTextField.setCaretPosition(0);
        aboutMessageTextField.setWrapStyleWord(true);
        aboutMessageTextField.setBorder(BorderFactory.createEmptyBorder());
        aboutMessageTextField.setBackground(SystemColor.control);
        aboutMessageTextField.setLineWrap(true);
        aboutMessageTextField.setEditable(false);
        aboutMessageTextField.setBorder(new EmptyBorder(0, 3, 0, 3));
        JScrollPane aboutMessageScrollPane = new JScrollPane(aboutMessageTextField);
        GroupLayout gl_contentPanel = new GroupLayout(contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGap(10).addComponent(launcherIcon, -2, 64, -2).addGap(10).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(versionLabel).addComponent(developerLabel)).addGap(100).addComponent(this.okButton, -2, 92, -2)).addGroup(gl_contentPanel.createSequentialGroup().addGap(10).addComponent(aboutMessageScrollPane, -2, 410, -2).addGap(10)));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGap(15).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGap(1).addComponent(launcherIcon, -2, 64, -2)).addGroup(gl_contentPanel.createSequentialGroup().addGap(13).addComponent(versionLabel).addGap(15).addComponent(developerLabel)).addComponent(this.okButton)).addGap(15).addComponent(aboutMessageScrollPane, -2, 72, -2)));
        contentPanel.setLayout(gl_contentPanel);
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.dispose();
        }
    }

    private String getComponentVersionLabel(String component, String version) {
        if (this.rightToLeft) {
            return version + " " + component;
        }
        return component + " " + version;
    }
}

