/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.OSUtils;
import info.msxlaunchers.openmsx.launcher.data.feed.FeedMessage;
import info.msxlaunchers.openmsx.launcher.data.filter.Filter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterFactory;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterParameter;
import info.msxlaunchers.openmsx.launcher.data.filter.FilterType;
import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.data.game.constants.MSXGeneration;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Medium;
import info.msxlaunchers.openmsx.launcher.data.game.constants.Sound;
import info.msxlaunchers.openmsx.launcher.data.repository.constants.Company;
import info.msxlaunchers.openmsx.launcher.data.repository.constants.Country;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.GameLabel;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.PlatformViewProperties;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.FilterUtils;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.AbstractActionButton;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.HyperLink;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JCompositeLabel;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JLabelTransitionedEnabledDisabledImage;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JLabelTransitionedNewImage;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JListWithImagesAndActions;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JMenuItemWithIcon;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JSearchTextField;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.SearchFieldHandler;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.iharder.dnd.FileDrop;

public class MainWindow
extends JFrame
implements ActionListener,
WindowFocusListener,
SearchFieldHandler {
    private final MainPresenter presenter;
    private Set<String> databases;
    private String currentDatabase;
    private boolean showUpdateAllDatabases;
    private JPanel contentPane;
    private JMenuBar topMenuBar;
    private JMenu optionsMenu;
    private JMenuItem optionsSettings;
    private JMenu actionsMenu;
    private JMenuItem actionsCreateEmptyDatabase;
    private JMenuItem actionsFillDatabase;
    private JMenuItem actionsChangeMachine;
    private JMenuItem actionsUpdateAllDatabase;
    private JMenuItem actionsImportBlueMSXLauncherDatabases;
    private JMenu toolsMenu;
    private JMenuItem databaseManager;
    private JMenuItem activityViewer;
    private JMenuItem patcher;
    private JMenuItem lhaExtractor;
    private JMenu helpMenu;
    private JMenuItem helpAbout;
    private JMenuItem helpFile;
    private JMenuItem helpCheckForUpdates;
    private JListWithImagesAndActions gameList;
    private JComponent databaseSelectButton;
    private JCompositeLabel databaseLabel;
    private JCompositeLabel totalLabel;
    private JComponent filtersSelectButton;
    private JCompositeLabel filtersLabel;
    private JButton favoritesButton;
    private JButton searchButton;
    private JButton feedButton;
    private JButton launchButton;
    private JButton removeButton;
    private JButton addButton;
    private JButton editButton;
    private JPopupMenu contextMenu;
    private JMenuItem moveMenuItem;
    private JMenuItem locateFileMenuItem;
    private JMenuItem addFavoriteMenuItem;
    private JMenuItem findRelatedMenuItem;
    private JMenuItem infoMenuItem;
    private JMenuItem propertiesMenuItem;
    private Map<String, String> messages;
    private JLabel screenshot1Label;
    private JLabel screenshot2Label;
    private JPopupMenu favoritesContextMenu;
    private JPopupMenu filtersContextMenu;
    private JMenu quickFilterMenuItemList;
    private JMenu companyQuickFilterMenuItemList;
    private JMenu yearQuickFilterMenuItemList;
    private JMenu countryQuickFilterMenuItemList;
    private JMenu mediumQuickFilterMenuItemList;
    private JMenu generationQuickFilterMenuItemList;
    private JMenu soundQuickFilterMenuItemList;
    private JMenuItem newFilterMenuItem;
    private JMenuItem editCurrentUntitledFilterMenuItem;
    private JMenuItem resetFilterMenuItem;
    private JLabel soundIndicatorPSG;
    private JLabel soundIndicatorSCC;
    private JLabel soundIndicatorSCCI;
    private JLabel soundIndicatorPCM;
    private JLabel soundIndicatorMSXMusic;
    private JLabel soundIndicatorMSXAudio;
    private JLabel soundIndicatorMoonsound;
    private JLabel soundIndicatorMidi;
    private JLabel generationIndicatorMSX;
    private JLabel generationIndicatorMSX2;
    private JLabel generationIndicatorMSX2P;
    private JLabel generationIndicatorTurboR;
    private ComponentOrientation orientation = null;
    private int popupMenuOrientation = 0;
    private Insets favoritesMenuInsets = null;
    private String removeConfirmationMessage = null;
    private String updateAllDatabasesConfirmationMessage = null;
    private Map<Medium, ImageIcon> mediaIconsMap = new HashMap<Medium, ImageIcon>();
    public static final Dimension BUTTON_DIMENSION = new Dimension(109, 28);
    private static final Font gameFont = new Font(null, 0, 14);
    private static final Font databaseFont = new Font(null, 0, 9);
    private static final Color databaseColor = new Color(100, 100, 100);
    private static final Insets favoritesMenuMarginLeftToRight = new Insets(-2, 0, 22, 250);
    private static final Insets favoritesMenuMarginRightToLeft = new Insets(-2, -12, 22, 260);
    private static final Dimension favoritesLabelSize = new Dimension(300, 18);
    private static final Dimension favoriteMenuItemSizeOnMac = new Dimension(363, 40);
    private static final Color DEFAULT_BUTTON_BG_COLOR = UIManager.getLookAndFeelDefaults().getColor("Button.background");
    private static final Insets POPUP_MENU_ITEM_BUTTON_INSETS = new Insets(-1, 0, -1, -13);
    private static final Dimension POPUP_MENU_ITEM_BUTTON_DIMENSION = new Dimension(18, 18);
    public static final Color POPUP_MENU_ITEM_BUTTON_HOVER_BG_COLOR = new Color(140, 140, 220);
    private static final String SPACES = "                                ";
    private static final int SEARCH_TEXT_FIELD_COLUMNS = 25;
    private static final Dimension NEWS_DATE_DIMENSION = new Dimension(42, 10);
    private static final Color NEWS_SITE_BACKGROUND_COLOR = new Color(50, 200, 50);
    private static final LayoutManager NEWS_PANEL_LAYOUT_MANAGER = new FlowLayout(0, 5, 1);
    private final MainWindow ref = this;

    public MainWindow(MainPresenter presenter, PlatformViewProperties platformViewProperties) {
        this.presenter = presenter;
        platformViewProperties.setDisplayProperties(this);
        this.mediaIconsMap.put(Medium.ROM, Icons.MEDIA_ROM.getImageIcon());
        this.mediaIconsMap.put(Medium.DISK, Icons.MEDIA_DISK.getImageIcon());
        this.mediaIconsMap.put(Medium.TAPE, Icons.MEDIA_TAPE.getImageIcon());
        this.mediaIconsMap.put(Medium.HARDDISK, Icons.MEDIA_HARDDISK.getImageIcon());
        this.mediaIconsMap.put(Medium.LASERDISC, Icons.MEDIA_LASERDISC.getImageIcon());
        this.mediaIconsMap.put(Medium.SCRIPT, Icons.MEDIA_SCRIPT.getImageIcon());
        new GlobalSwingContext(this);
        new FileDrop((Component)this, this::addDraggedGames);
    }

    public void display(Language language, Set<GameLabel> games, Set<String> databases, String currentDatabase, boolean rightToLeft, boolean showUpdateAllDatabases, boolean enableFeedButton) {
        this.databases = databases;
        this.currentDatabase = currentDatabase;
        this.showUpdateAllDatabases = showUpdateAllDatabases;
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        this.contentPane = new JPanelWithBackground();
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.setTitle("openMSX Launcher");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowCloseAdapter());
        this.setResizable(false);
        this.drawScreen();
        this.setupGameListContextMenu();
        this.setupFiltersMenu();
        if (rightToLeft) {
            this.orientation = ComponentOrientation.RIGHT_TO_LEFT;
            this.popupMenuOrientation = 0;
            this.favoritesMenuInsets = favoritesMenuMarginRightToLeft;
        } else {
            this.orientation = ComponentOrientation.LEFT_TO_RIGHT;
            this.popupMenuOrientation = 2;
            this.favoritesMenuInsets = favoritesMenuMarginLeftToRight;
        }
        this.flipOrientation();
        this.refreshLanguage(language);
        this.fillGameList(currentDatabase, games, null);
        this.updateGameCount(games.size());
        this.addWindowFocusListener(this);
        this.enableSoundIndicators(false, false, false, false, false, false, false, false);
        this.enableGenerationIndicators(false, false, false, false);
        this.enableFeedButton(enableFeedButton);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void drawMenu() {
        this.topMenuBar = new JMenuBar();
        this.setJMenuBar(this.topMenuBar);
        this.optionsMenu = new JMenu();
        this.topMenuBar.add(this.optionsMenu);
        this.optionsSettings = new JMenuItemWithIcon();
        this.optionsSettings.setIcon(Icons.SETTINGS.getImageIcon());
        this.optionsSettings.addActionListener(event -> this.presenter.onRequestSettingsScreen());
        this.optionsMenu.add(this.optionsSettings);
        this.actionsMenu = new JMenu();
        this.topMenuBar.add(this.actionsMenu);
        this.actionsCreateEmptyDatabase = new JMenuItemWithIcon();
        this.actionsCreateEmptyDatabase.addActionListener(event -> this.presenter.onRequestCreateEmptyDatabaseScreen());
        this.actionsMenu.add(this.actionsCreateEmptyDatabase);
        this.actionsFillDatabase = new JMenuItemWithIcon();
        this.actionsFillDatabase.setIcon(Icons.FILL_DB.getImageIcon());
        this.actionsFillDatabase.addActionListener(event -> this.onRequestFillDatabaseScreen());
        this.actionsMenu.add(this.actionsFillDatabase);
        this.actionsChangeMachine = new JMenuItemWithIcon();
        this.actionsChangeMachine.addActionListener(event -> this.onRequestChangeMachineScreen());
        this.actionsMenu.add(this.actionsChangeMachine);
        this.actionsUpdateAllDatabase = new JMenuItemWithIcon();
        if (this.showUpdateAllDatabases) {
            this.actionsUpdateAllDatabase.addActionListener(event -> this.onRequestUpdateAllDatabases());
            this.actionsMenu.add(this.actionsUpdateAllDatabase);
        }
        this.actionsImportBlueMSXLauncherDatabases = new JMenuItemWithIcon();
        if (OSUtils.isWindows()) {
            this.actionsImportBlueMSXLauncherDatabases.addActionListener(event -> this.onRequestImportBlueMSXLauncherDatabasesScreen());
            this.actionsMenu.addSeparator();
            this.actionsMenu.add(this.actionsImportBlueMSXLauncherDatabases);
        }
        this.toolsMenu = new JMenu();
        this.topMenuBar.add(this.toolsMenu);
        this.databaseManager = new JMenuItemWithIcon();
        this.databaseManager.addActionListener(event -> this.onRequestDatabaseManagerScreen());
        this.toolsMenu.add(this.databaseManager);
        this.activityViewer = new JMenuItemWithIcon();
        this.activityViewer.addActionListener(event -> this.onRequestActivityViewerScreen());
        this.toolsMenu.add(this.activityViewer);
        this.toolsMenu.addSeparator();
        this.patcher = new JMenuItemWithIcon();
        this.patcher.setIcon(Icons.PATCH.getImageIcon());
        this.patcher.addActionListener(event -> this.onRequestPatcherScreen());
        this.toolsMenu.add(this.patcher);
        this.lhaExtractor = new JMenuItem();
        this.lhaExtractor.addActionListener(event -> this.onRequestLHAExtractorScreen());
        this.toolsMenu.add(this.lhaExtractor);
        this.helpMenu = new JMenu();
        this.topMenuBar.add(this.helpMenu);
        this.helpFile = new JMenuItemWithIcon();
        this.helpFile.setIcon(Icons.HELP.getImageIcon());
        this.helpFile.addActionListener(event -> this.onRequestHelpFile());
        this.helpMenu.add(this.helpFile);
        this.helpCheckForUpdates = new JMenuItemWithIcon();
        this.helpCheckForUpdates.addActionListener(event -> this.onRequestUpdatesChecker());
        this.helpMenu.add(this.helpCheckForUpdates);
        this.helpMenu.addSeparator();
        this.helpAbout = new JMenuItemWithIcon();
        if (!OSUtils.isMac()) {
            this.helpAbout.addActionListener(event -> this.presenter.onRequestAboutScreen());
            this.helpMenu.add(this.helpAbout);
        }
    }

    public void removeDatabase(String database) {
        if (database.equals(this.currentDatabase)) {
            this.currentDatabase = null;
            this.databaseLabel.setValue(null);
            this.gameList.clear();
            this.updateGameCount(0);
            this.filtersSelectButton.setEnabled(false);
            this.applyFilter(null);
            this.updateFilterNameLabel(null);
        }
        this.databaseSelectButton.setEnabled(!this.databases.isEmpty());
    }

    public void renameDatabase(String oldDatabase, String newDatabase) {
        if (oldDatabase.equals(this.currentDatabase)) {
            this.databaseLabel.setValue(newDatabase);
            this.currentDatabase = newDatabase;
        }
    }

    private void drawScreen() {
        this.databaseSelectButton = new ExpandMenuButton(this);
        this.databaseLabel = new JCompositeLabel(172, 131, false);
        this.totalLabel = new JCompositeLabel(50, 37, true);
        this.databaseSelectButton.setEnabled(!this.databases.isEmpty());
        this.gameList = new JListWithImagesAndActions(new DefaultListModel<Object>());
        ToolTipManager.sharedInstance().unregisterComponent(this.gameList);
        this.gameList.registerKeyboardAction(event -> this.moveSelectedGames(), this.getCtrlXKeyStroke(), 0);
        this.gameList.registerKeyboardAction(event -> this.showPropertiesOfSelectedGame(), this.getCtrlF1KeyStroke(), 0);
        this.gameList.registerKeyboardAction(event -> this.locateMainFileOfSelectedGame(), this.getCtrlShiftFKeyStroke(), 0);
        this.gameList.registerKeyboardAction(event -> this.editGame(), this.getCtrlEKeyStroke(), 0);
        this.gameList.registerKeyboardAction(event -> this.addSelectedGameToFavorites(), this.getCtrlDKeyStroke(), 0);
        this.gameList.registerKeyboardAction(event -> this.viewGameInfo(), this.getF1KeyStroke(), 0);
        this.gameList.registerKeyboardAction(event -> this.processShowSearchScreenRequest(), this.getCtrlFKeyStroke(), 2);
        this.gameList.registerKeyboardAction(event -> this.processShowDatabasesMenuRequest(), this.getCtrlQKeyStroke(), 2);
        this.gameList.registerKeyboardAction(event -> this.processShowFavoritesMenuRequest(), this.getCtrlIKeyStroke(), 2);
        this.gameList.registerKeyboardAction(event -> this.processShowFiltersMenuRequest(), this.getCtrlLKeyStroke(), 2);
        this.gameList.registerKeyboardAction(event -> this.applyFilter(null), this.getCtrlRKeyStroke(), 2);
        this.gameList.registerKeyboardAction(event -> this.findRelated(), this.getCtrlShiftRKeyStroke(), 0);
        JScrollPane gameListScrollBar = new JScrollPane(this.gameList);
        this.filtersLabel = new JCompositeLabel(118, 90, false);
        this.filtersSelectButton = new ExpandMenuButton(this);
        JPanel launchButtonPanel = new JPanel();
        launchButtonPanel.setLayout(new GridLayout(1, 0, 0, 0));
        JPanel removeButtonPanel = new JPanel();
        removeButtonPanel.setLayout(new GridLayout(1, 0, 0, 0));
        JPanel addButtonPanel = new JPanel();
        addButtonPanel.setLayout(new GridLayout(1, 0, 0, 0));
        JPanel editButtonPanel = new JPanel();
        editButtonPanel.setLayout(new GridLayout(1, 0, 0, 0));
        this.screenshot1Label = new JLabelTransitionedNewImage(Icons.NO_SCREENSHOT.getImageIcon());
        this.screenshot2Label = new JLabelTransitionedNewImage(Icons.NO_SCREENSHOT.getImageIcon());
        this.favoritesButton = new JButton();
        this.favoritesButton.setIcon(Icons.FAVORITE.getImageIcon());
        this.favoritesButton.addActionListener(this);
        this.favoritesButton.setFocusable(false);
        this.searchButton = new JButton();
        this.searchButton.setIcon(Icons.SEARCH.getImageIcon());
        this.searchButton.addActionListener(this);
        this.searchButton.setFocusable(false);
        this.feedButton = new JButton();
        this.feedButton.setIcon(Icons.FEED.getImageIcon());
        this.feedButton.addActionListener(this);
        this.feedButton.setFocusable(false);
        Color indicatorsPanelBackground = new Color(187, 187, 187);
        JPanel soundIndicatorsPanel = new JPanel(new FlowLayout(0, 2, 1));
        soundIndicatorsPanel.setBackground(indicatorsPanelBackground);
        this.soundIndicatorPSG = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_PSG.getImageIcon());
        this.soundIndicatorSCC = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_SCC.getImageIcon());
        this.soundIndicatorSCCI = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_SCC_I.getImageIcon());
        this.soundIndicatorPCM = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_PCM.getImageIcon());
        this.soundIndicatorMSXMusic = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_MSX_MUSIC.getImageIcon());
        this.soundIndicatorMSXAudio = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_MSX_AUDIO.getImageIcon());
        this.soundIndicatorMoonsound = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_MOONSOUND.getImageIcon());
        this.soundIndicatorMidi = new JLabelTransitionedEnabledDisabledImage(Icons.SOUND_MIDI.getImageIcon());
        soundIndicatorsPanel.add(this.soundIndicatorPSG);
        soundIndicatorsPanel.add(this.soundIndicatorSCC);
        soundIndicatorsPanel.add(this.soundIndicatorSCCI);
        soundIndicatorsPanel.add(this.soundIndicatorPCM);
        soundIndicatorsPanel.add(this.soundIndicatorMSXMusic);
        soundIndicatorsPanel.add(this.soundIndicatorMSXAudio);
        soundIndicatorsPanel.add(this.soundIndicatorMoonsound);
        soundIndicatorsPanel.add(this.soundIndicatorMidi);
        JPanel generationIndicatorsPanel = new JPanel(new FlowLayout(0, 2, 1));
        generationIndicatorsPanel.setBackground(indicatorsPanelBackground);
        this.generationIndicatorMSX = new JLabelTransitionedEnabledDisabledImage(Icons.GENERATION_MSX.getImageIcon());
        this.generationIndicatorMSX2 = new JLabelTransitionedEnabledDisabledImage(Icons.GENERATION_MSX2.getImageIcon());
        this.generationIndicatorMSX2P = new JLabelTransitionedEnabledDisabledImage(Icons.GENERATION_MSX2P.getImageIcon());
        this.generationIndicatorTurboR = new JLabelTransitionedEnabledDisabledImage(Icons.GENERATION_TURBO_R.getImageIcon());
        generationIndicatorsPanel.add(this.generationIndicatorMSX);
        generationIndicatorsPanel.add(this.generationIndicatorMSX2);
        generationIndicatorsPanel.add(this.generationIndicatorMSX2P);
        generationIndicatorsPanel.add(this.generationIndicatorTurboR);
        GroupLayout groupLayout = new GroupLayout(this.contentPane);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(gameListScrollBar, -2, 370, -2).addGroup(groupLayout.createSequentialGroup().addGap(2).addComponent(false, this.databaseSelectButton, -2, 9, -2).addComponent(false, this.databaseLabel, -2, this.databaseLabel.getComponentWidth(), -2).addGap(4).addComponent(false, this.totalLabel, -2, this.totalLabel.getComponentWidth(), -2).addGap(4).addComponent(false, this.filtersSelectButton, -2, 9, -2).addComponent(false, this.filtersLabel, -2, this.filtersLabel.getComponentWidth(), -2)).addGroup(groupLayout.createSequentialGroup().addGap(2).addComponent(soundIndicatorsPanel, -2, -2, -2).addGap(28).addComponent(generationIndicatorsPanel, -2, -2, -2))).addGap(7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(groupLayout.createSequentialGroup().addComponent(this.favoritesButton, -2, 26, -2).addComponent(this.searchButton, -2, 26, -2).addComponent(this.feedButton, -2, 26, -2)).addComponent(launchButtonPanel, -2, 60, -2).addComponent(removeButtonPanel, -2, 60, -2).addComponent(addButtonPanel, -2, 60, -2).addComponent(editButtonPanel, -2, 60, -2)).addGap(13).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.screenshot1Label, -2, 272, -2).addComponent(this.screenshot2Label, -2, 272, -2)).addGap(20)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseSelectButton, -2, 38, -2).addComponent(this.databaseLabel, -2, 38, -2).addComponent(this.totalLabel, -2, 38, -2).addComponent(this.filtersSelectButton, -2, 38, -2).addComponent(this.filtersLabel, -2, 38, -2)).addGap(4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(soundIndicatorsPanel, -2, -2, -2).addComponent(generationIndicatorsPanel, -2, -2, -2)).addGap(2).addComponent(gameListScrollBar, -2, 474, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(35).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.favoritesButton, -2, 26, -2).addComponent(this.searchButton, -2, 26, -2).addComponent(this.feedButton, -2, 26, -2)).addGap(115).addComponent(launchButtonPanel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(removeButtonPanel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(addButtonPanel, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(editButtonPanel, -2, 30, -2)).addGroup(groupLayout.createSequentialGroup().addGap(18).addComponent(this.screenshot1Label, -2, 240, -2).addGap(16).addComponent(this.screenshot2Label, -2, 240, -2)))).addGap(20)));
        this.editButton = this.getIconButton(editButtonPanel, Icons.EDIT.getImageIcon());
        this.addButton = this.getIconButton(addButtonPanel, Icons.ADD.getImageIcon());
        this.removeButton = this.getIconButton(removeButtonPanel, Icons.REMOVE.getImageIcon());
        this.launchButton = this.getIconButton(launchButtonPanel, Icons.LAUNCH.getImageIcon());
        this.contentPane.setLayout(groupLayout);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MainWindow.this.gameList.getSelectedIndex() < 0) {
                    MainWindow.this.presenter.resetAll();
                } else if (!listSelectionEvent.getValueIsAdjusting()) {
                    MainWindow.this.presenter.onSelectGames(MainWindow.this.getSelectedGames());
                }
            }
        };
        this.gameList.addListSelectionListener(listSelectionListener);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("doubleClickCommand") || e.getActionCommand().equals("enterKeyCommand")) {
                    MainWindow.this.presenter.onSelectGames(MainWindow.this.getSelectedGames());
                    MainWindow.this.launchGame();
                } else if (e.getActionCommand().equals("deleteKeyCommand")) {
                    MainWindow.this.promptForRemovingSelection();
                } else if (e.getActionCommand().equals("insertKeyCommand")) {
                    MainWindow.this.addGame();
                }
            }
        };
        this.gameList.addActionListener(actionListener);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (SwingUtilities.isRightMouseButton(me)) {
                    int mouseSelectionIndex = MainWindow.this.gameList.locationToIndex(me.getPoint());
                    if (!MainWindow.isInSelection(MainWindow.this.gameList.getSelectedIndices(), mouseSelectionIndex)) {
                        MainWindow.this.gameList.setSelectedIndex(mouseSelectionIndex);
                    }
                    MainWindow.this.moveMenuItem.setEnabled(MainWindow.this.databases.size() > 1);
                    MainWindow.this.locateFileMenuItem.setEnabled(MainWindow.this.gameList.getSelectedIndices().length == 1);
                    MainWindow.this.addFavoriteMenuItem.setEnabled(MainWindow.this.gameList.getSelectedIndices().length == 1);
                    MainWindow.this.findRelatedMenuItem.setEnabled(MainWindow.this.gameList.getSelectedIndices().length == 1);
                    MainWindow.this.propertiesMenuItem.setEnabled(MainWindow.this.gameList.getSelectedIndices().length == 1);
                    MainWindow.this.contextMenu.show(MainWindow.this.gameList, me.getX(), me.getY());
                }
            }
        };
        this.gameList.addMouseListener(mouseAdapter);
    }

    public void flipOrientationLeftToRight() {
        this.orientation = ComponentOrientation.LEFT_TO_RIGHT;
        this.popupMenuOrientation = 2;
        this.favoritesMenuInsets = favoritesMenuMarginLeftToRight;
        this.flipOrientation();
    }

    public void flipOrientationRightToLeft() {
        this.orientation = ComponentOrientation.RIGHT_TO_LEFT;
        this.popupMenuOrientation = 0;
        this.favoritesMenuInsets = favoritesMenuMarginRightToLeft;
        this.flipOrientation();
    }

    public void refreshLanguage(Language language) {
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.optionsMenu.setText(this.messages.get("OPTIONS"));
        this.optionsMenu.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("OPTIONS_MNEMONIC")).getKeyCode());
        this.optionsSettings.setText(this.messages.get("SETTINGS") + "...");
        this.optionsSettings.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("SETTINGS_MNEMONIC")).getKeyCode());
        this.actionsMenu.setText(this.messages.get("ACTIONS"));
        this.actionsMenu.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("ACTIONS_MNEMONIC")).getKeyCode());
        this.actionsCreateEmptyDatabase.setText(this.messages.get("CREATE_EMPTY_DATABASE") + "...");
        this.actionsCreateEmptyDatabase.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("CREATE_EMPTY_DATABASE_MNEMONIC")).getKeyCode());
        this.actionsFillDatabase.setText(this.messages.get("FILL_DATABASE") + "...");
        this.actionsFillDatabase.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("FILL_DATABASE_MNEMONIC")).getKeyCode());
        this.actionsChangeMachine.setText(this.messages.get("CHANGE_MACHINE") + "...");
        this.actionsChangeMachine.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("CHANGE_MACHINE_MNEMONIC")).getKeyCode());
        this.actionsUpdateAllDatabase.setText(this.messages.get("UPDATE_ALL_DATABASES"));
        this.actionsUpdateAllDatabase.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("UPDATE_ALL_DATABASES_MNEMONIC")).getKeyCode());
        this.actionsImportBlueMSXLauncherDatabases.setText(this.messages.get("IMPORT_BLUEMSXLAUNCHER_DATABASES"));
        this.actionsImportBlueMSXLauncherDatabases.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("IMPORT_BLUEMSXLAUNCHER_DATABASES_MNEMONIC")).getKeyCode());
        this.toolsMenu.setText(this.messages.get("TOOLS"));
        this.toolsMenu.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("TOOLS_MNEMONIC")).getKeyCode());
        this.databaseManager.setText(this.messages.get("DATABASE_MANAGER"));
        this.databaseManager.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("DATABASE_MANAGER_MNEMONIC")).getKeyCode());
        this.activityViewer.setText(this.messages.get("ACTIVITY_VIEWER"));
        this.activityViewer.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("ACTIVITY_VIEWER_MNEMONIC")).getKeyCode());
        this.patcher.setText(this.messages.get("PATCH_CENTER") + "...");
        this.patcher.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("PATCH_CENTER_MNEMONIC")).getKeyCode());
        this.lhaExtractor.setText(this.messages.get("LHA_EXTRACTOR") + "...");
        this.lhaExtractor.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("LHA_EXTRACTOR_MNEMONIC")).getKeyCode());
        this.helpMenu.setText(this.messages.get("HELP"));
        this.helpMenu.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("HELP_MNEMONIC")).getKeyCode());
        this.helpFile.setText(this.messages.get("HELP"));
        this.helpFile.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("HELP_MNEMONIC")).getKeyCode());
        this.helpCheckForUpdates.setText(this.messages.get("CHECK_FOR_UPDATES") + "...");
        this.helpCheckForUpdates.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("CHECK_FOR_UPDATES_MNEMONIC")).getKeyCode());
        this.helpAbout.setText(this.messages.get("ABOUT"));
        this.helpAbout.setMnemonic(KeyStroke.getKeyStroke(this.messages.get("ABOUT_MNEMONIC")).getKeyCode());
        this.databaseLabel.setTitle(this.messages.get("DATABASE"));
        this.totalLabel.setTitle(this.messages.get("COUNT"));
        this.favoritesButton.setToolTipText(this.messages.get("FAVORITES"));
        this.searchButton.setToolTipText(this.messages.get("SEARCH"));
        this.feedButton.setToolTipText(this.messages.get("FEED"));
        this.filtersLabel.setTitle(this.messages.get("FILTERS"));
        this.launchButton.setToolTipText(this.messages.get("LAUNCH"));
        this.removeButton.setToolTipText(this.messages.get("REMOVE"));
        this.addButton.setToolTipText(this.messages.get("ADD"));
        this.editButton.setToolTipText(this.messages.get("EDIT"));
        this.moveMenuItem.setText(this.messages.get("MOVE") + "...");
        this.locateFileMenuItem.setText(this.messages.get("LOCATE_FILE"));
        this.addFavoriteMenuItem.setText(this.messages.get("ADD_FAVORITE"));
        this.findRelatedMenuItem.setText(this.messages.get("FIND_RELATED"));
        this.infoMenuItem.setText(this.messages.get("INFO"));
        this.propertiesMenuItem.setText(this.messages.get("PROPERTIES"));
        this.quickFilterMenuItemList.setText(this.messages.get("QUICK_FILTER"));
        this.companyQuickFilterMenuItemList.setText(this.messages.get("COMPANY"));
        this.yearQuickFilterMenuItemList.setText(this.messages.get("YEAR"));
        this.countryQuickFilterMenuItemList.setText(this.messages.get("COUNTRY"));
        this.mediumQuickFilterMenuItemList.setText(this.messages.get("MEDIUM"));
        this.generationQuickFilterMenuItemList.setText(this.messages.get("GENERATION"));
        this.soundQuickFilterMenuItemList.setText(this.messages.get("SOUND"));
        this.newFilterMenuItem.setText(this.messages.get("NEW") + "...");
        this.editCurrentUntitledFilterMenuItem.setText(this.messages.get("EDIT_UNTITLED_FILTER") + "...");
        this.resetFilterMenuItem.setText(this.messages.get("RESET"));
        this.removeConfirmationMessage = this.messages.get("REMOVE_CONFIRMATION_MESSAGE");
        this.updateAllDatabasesConfirmationMessage = this.messages.get("UPDATE_ALL_DATABASES_CONFIRMATION_MESSAGE");
        this.completeQuickFilterMenu();
    }

    public void fillGameList(String currentDatabase, Set<GameLabel> games, String selectedGame) {
        this.currentDatabase = currentDatabase;
        this.databaseLabel.setValue(currentDatabase);
        this.filtersSelectButton.setEnabled(currentDatabase != null);
        this.gameList.clear();
        for (GameLabel gameLabel : games) {
            this.gameList.addElement(gameLabel.getName(), gameLabel.getCommany(), gameLabel.getYear(), gameLabel.getSize(), this.mediaIconsMap.get((Object)gameLabel.getMedium()));
        }
        if (selectedGame != null) {
            this.gameList.setSelectedValue(selectedGame);
        } else {
            this.enableButtons(false, false, currentDatabase != null, false, false);
        }
        this.databaseSelectButton.setEnabled(!this.databases.isEmpty());
    }

    public void updateGameCount(int total) {
        this.totalLabel.setValue(String.valueOf(total));
    }

    public void showGameScreenshot(String screenshot1, String screenshot2) {
        if (screenshot1 == null) {
            this.screenshot1Label.setIcon(Icons.NO_SCREENSHOT.getImageIcon());
            this.screenshot2Label.setIcon(Icons.NO_SCREENSHOT.getImageIcon());
        } else {
            this.screenshot1Label.setIcon(new ImageIcon(screenshot1));
            if (screenshot2 == null) {
                this.screenshot2Label.setIcon(Icons.NO_SCREENSHOT.getImageIcon());
            } else {
                this.screenshot2Label.setIcon(new ImageIcon(screenshot2));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.launchButton) {
            this.launchGame();
        } else if (source == this.addButton) {
            this.addGame();
        } else if (source == this.editButton) {
            this.editGame();
        } else if (source == this.removeButton) {
            this.promptForRemovingSelection();
        } else if (source == this.moveMenuItem) {
            this.moveSelectedGames();
        } else if (source == this.locateFileMenuItem) {
            this.locateMainFileOfSelectedGame();
        } else if (source == this.addFavoriteMenuItem) {
            this.addSelectedGameToFavorites();
        } else if (source == this.findRelatedMenuItem) {
            this.findRelated();
        } else if (source == this.infoMenuItem) {
            this.viewGameInfo();
        } else if (source == this.propertiesMenuItem) {
            this.showPropertiesOfSelectedGame();
        } else if (source == this.favoritesButton) {
            this.processShowFavoritesMenuRequest();
        } else if (source == this.searchButton) {
            this.processShowSearchScreenRequest();
        } else if (source == this.feedButton) {
            this.processShowNewsListRequest();
            this.indicateNewNews(false);
        } else if (source == this.filtersSelectButton) {
            this.processShowFiltersMenuRequest();
        } else if (source == this.databaseSelectButton) {
            this.processShowDatabasesMenuRequest();
        } else if (source == this.newFilterMenuItem) {
            this.applyFilter(null);
            this.addFilter();
        } else if (source == this.editCurrentUntitledFilterMenuItem) {
            try {
                this.presenter.onRequestEditFilterScreen(null);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        } else if (source == this.resetFilterMenuItem) {
            this.applyFilter(null);
        } else if (source instanceof JMenuItem) {
            Action action = ((JMenuItem)source).getAction();
            if (action instanceof FilterMenuItemName) {
                this.applyFilter(((PopupMenuItemName)action).getPopupMenuItemName());
            } else if (action instanceof FavoriteMenuItemName) {
                this.selectGame(((FavoriteMenuItemName)action).favorite);
            } else if (action instanceof DatabaseMenuItemName) {
                this.onSelectDatabase(((PopupMenuItemName)action).getPopupMenuItemName());
            } else if (action instanceof QuickFilterMenuItemName) {
                this.applyQuickFilter(((QuickFilterMenuItemName)action).filter);
            }
            this.gameList.requestFocusInWindow();
        } else if (source instanceof JButton) {
            Action action = ((JButton)source).getAction();
            if (action instanceof FilterMenuItemDelete) {
                this.filtersContextMenu.setVisible(false);
                this.promptForDeletingFilter(((PopupMenuItemDelete)action).getPopupMenuItemName());
            } else if (action instanceof FilterMenuItemEdit) {
                this.filtersContextMenu.setVisible(false);
                try {
                    String filterName = ((PopupMenuItemEdit)action).getPopupMenuItemName();
                    this.applyFilter(filterName);
                    this.presenter.onRequestEditFilterScreen(filterName);
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
                }
            } else if (action instanceof FavoriteMenuItemDelete) {
                this.favoritesContextMenu.setVisible(false);
                try {
                    this.presenter.onRequestDeleteFavoriteAction(((FavoriteMenuItemDelete)action).favorite);
                    this.gameList.requestFocusInWindow();
                }
                catch (LauncherException le) {
                    MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
                }
            }
        }
    }

    public void showDatabasesList(Set<String> databases) {
        JPopupMenu databasesContextMenu = new JPopupMenu();
        databasesContextMenu.setComponentOrientation(this.orientation);
        for (String database : databases) {
            JMenuItem databaseMenuItem = new JMenuItem();
            databaseMenuItem.setComponentOrientation(this.orientation);
            databaseMenuItem.setAction(new DatabaseMenuItemName(database));
            databaseMenuItem.addActionListener(this);
            databasesContextMenu.add(databaseMenuItem);
        }
        this.showButtonMenu(this.databaseSelectButton, databasesContextMenu, 0);
    }

    public void showFavoritesMenu(Set<DatabaseItem> favorites) {
        this.favoritesContextMenu = new JPopupMenu();
        this.favoritesContextMenu.setBorder(new EmptyBorder(0, 0, 0, 0));
        for (DatabaseItem favorite : favorites) {
            JMenuItem favoriteMenuItem = new JMenuItem();
            favoriteMenuItem.setAction(new FavoriteMenuItemName(favorite));
            favoriteMenuItem.addActionListener(this);
            favoriteMenuItem.setMargin(this.favoritesMenuInsets);
            favoriteMenuItem.setLayout(new FlowLayout(0, 0, 0));
            JPanel menuItemPanel = new JPanel();
            menuItemPanel.setComponentOrientation(this.orientation);
            menuItemPanel.setOpaque(false);
            JPanel labelsPanel = new JPanel();
            labelsPanel.setOpaque(false);
            labelsPanel.setLayout(new BoxLayout(labelsPanel, 1));
            JLabel gameName = new JLabel(favorite.getGameName());
            gameName.setFont(gameFont);
            gameName.setPreferredSize(favoritesLabelSize);
            labelsPanel.add(gameName);
            JLabel databaseName = new JLabel("- " + favorite.getDatabase());
            databaseName.setFont(databaseFont);
            databaseName.setForeground(databaseColor);
            databaseName.setPreferredSize(favoritesLabelSize);
            labelsPanel.add(databaseName);
            menuItemPanel.add(labelsPanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setOpaque(false);
            JButton deleteButton = new JButton();
            buttonPanel.add(deleteButton);
            deleteButton.setAction(new FavoriteMenuItemDelete(favorite));
            deleteButton.addActionListener(this);
            deleteButton.setToolTipText(this.messages.get("DELETE"));
            menuItemPanel.add(buttonPanel);
            if (OSUtils.isMac()) {
                favoriteMenuItem.setPreferredSize(favoriteMenuItemSizeOnMac);
            }
            favoriteMenuItem.add(menuItemPanel);
            this.favoritesContextMenu.add(favoriteMenuItem);
        }
        this.showButtonMenu(this.favoritesButton, this.favoritesContextMenu, 2);
    }

    public void higlightGame(String gameName) {
        this.gameList.setSelectedValue(gameName);
    }

    public void showFiltersMenu(Set<String> filterNames, boolean isFilterSelected, boolean isEditCurrentUntitledFilter) {
        this.filtersContextMenu = new JPopupMenu();
        this.filtersContextMenu.setComponentOrientation(this.orientation);
        for (String filterName : filterNames) {
            JMenuItem filterMenuItem = new JMenuItem();
            filterMenuItem.setComponentOrientation(this.orientation);
            filterMenuItem.setAction(new FilterMenuItemName(filterName));
            filterMenuItem.addActionListener(this);
            filterMenuItem.setMargin(POPUP_MENU_ITEM_BUTTON_INSETS);
            filterMenuItem.setLayout(new FlowLayout(this.popupMenuOrientation, 0, 0));
            JButton editButton = new JButton();
            editButton.setContentAreaFilled(false);
            editButton.setPreferredSize(POPUP_MENU_ITEM_BUTTON_DIMENSION);
            editButton.setAction(new FilterMenuItemEdit(filterName));
            editButton.addActionListener(this);
            editButton.setToolTipText(this.messages.get("EDIT"));
            MainWindow.addFilterButtonHoverBehavior(editButton);
            filterMenuItem.add(editButton);
            JButton deleteButton = new JButton();
            deleteButton.setContentAreaFilled(false);
            deleteButton.setPreferredSize(POPUP_MENU_ITEM_BUTTON_DIMENSION);
            deleteButton.setAction(new FilterMenuItemDelete(filterName));
            deleteButton.addActionListener(this);
            deleteButton.setToolTipText(this.messages.get("DELETE"));
            MainWindow.addFilterButtonHoverBehavior(deleteButton);
            filterMenuItem.add(deleteButton);
            this.filtersContextMenu.add(filterMenuItem);
        }
        if (!filterNames.isEmpty()) {
            this.filtersContextMenu.addSeparator();
        }
        if (isFilterSelected || isEditCurrentUntitledFilter) {
            this.filtersContextMenu.add(this.resetFilterMenuItem);
            this.filtersContextMenu.addSeparator();
        }
        if (isEditCurrentUntitledFilter) {
            this.filtersContextMenu.add(this.editCurrentUntitledFilterMenuItem);
        }
        this.filtersContextMenu.add(this.quickFilterMenuItemList);
        this.quickFilterMenuItemList.add(this.companyQuickFilterMenuItemList);
        this.quickFilterMenuItemList.add(this.yearQuickFilterMenuItemList);
        this.quickFilterMenuItemList.add(this.countryQuickFilterMenuItemList);
        this.quickFilterMenuItemList.add(this.mediumQuickFilterMenuItemList);
        this.quickFilterMenuItemList.add(this.generationQuickFilterMenuItemList);
        this.quickFilterMenuItemList.add(this.soundQuickFilterMenuItemList);
        this.filtersContextMenu.add(this.newFilterMenuItem);
        this.showButtonMenu(this.filtersSelectButton, this.filtersContextMenu, 0);
    }

    public void updateFilterNameLabel(String filterName) {
        this.filtersLabel.setValue(filterName);
    }

    public void setFilterNameLabelUntitled() {
        this.filtersLabel.setValue("(" + this.messages.get("UNTITLED_FILTER") + ")");
    }

    public void setFiltersToolTip(List<String> filterMonikers) {
        String descriptions;
        if (!filterMonikers.isEmpty()) {
            List<String> filterDescriptions = FilterUtils.getFiltersStringRepresentation(filterMonikers, this.messages);
            StringBuilder builder = new StringBuilder("<html>");
            builder.append(filterDescriptions.stream().collect(Collectors.joining("<br>")));
            descriptions = builder.append("</html>").toString();
        } else {
            descriptions = null;
        }
        this.filtersLabel.setToolTipText(descriptions);
    }

    @Override
    public Set<DatabaseItem> getSearchMatches(String searchString) {
        return this.presenter.onRequestSearchMatches(searchString);
    }

    @Override
    public void handleSearchSelection(DatabaseItem searchSelection) {
        this.selectGame(searchSelection);
    }

    @Override
    public void windowGainedFocus(WindowEvent arg0) {
        this.gameList.requestFocusInWindow();
    }

    @Override
    public void windowLostFocus(WindowEvent arg0) {
    }

    public void enableButtons(boolean launchFlag, boolean removeFlag, boolean addFlag, boolean editFlag, boolean infoFlag) {
        this.launchButton.setEnabled(launchFlag);
        this.removeButton.setEnabled(removeFlag);
        this.addButton.setEnabled(addFlag);
        this.editButton.setEnabled(editFlag);
        this.infoMenuItem.setEnabled(infoFlag);
    }

    public void enableSoundIndicators(boolean psgFlag, boolean sccFlag, boolean scciFlag, boolean pcmFlag, boolean msxMusicFlag, boolean msxAudioFlag, boolean moonsoundFlag, boolean midiFlag) {
        this.soundIndicatorPSG.setEnabled(psgFlag);
        this.soundIndicatorSCC.setEnabled(sccFlag);
        this.soundIndicatorSCCI.setEnabled(scciFlag);
        this.soundIndicatorPCM.setEnabled(pcmFlag);
        this.soundIndicatorMSXMusic.setEnabled(msxMusicFlag);
        this.soundIndicatorMSXAudio.setEnabled(msxAudioFlag);
        this.soundIndicatorMoonsound.setEnabled(moonsoundFlag);
        this.soundIndicatorMidi.setEnabled(midiFlag);
    }

    public void enableGenerationIndicators(boolean msxFlag, boolean msx2Flag, boolean msx2pFlag, boolean turboRFlag) {
        this.generationIndicatorMSX.setEnabled(msxFlag);
        this.generationIndicatorMSX2.setEnabled(msx2Flag);
        this.generationIndicatorMSX2P.setEnabled(msx2pFlag);
        this.generationIndicatorTurboR.setEnabled(turboRFlag);
    }

    public void enableFeedButton(boolean enable) {
        this.feedButton.setEnabled(enable);
    }

    public void indicateNewNews(boolean enable) {
        if (enable) {
            this.feedButton.setIcon(Icons.FEED_NEW.getImageIcon());
        } else {
            this.feedButton.setIcon(Icons.FEED.getImageIcon());
        }
    }

    public void showFeedMenu(List<FeedMessage> feedMessages) {
        JPopupMenu feedMessagesContextMenu = new JPopupMenu();
        feedMessagesContextMenu.setComponentOrientation(this.orientation);
        for (int index = 0; index < feedMessages.size(); ++index) {
            JPanel newsPanel = new JPanel();
            newsPanel.setLayout(NEWS_PANEL_LAYOUT_MANAGER);
            FeedMessage feedMessage = feedMessages.get(index);
            JLabel date = new JLabel(feedMessage.getPubDateDisplayName());
            date.setPreferredSize(NEWS_DATE_DIMENSION);
            newsPanel.add(date);
            newsPanel.add(HyperLink.label(feedMessage.getTitle()).address(feedMessage.getLink()).build());
            JPanel sitePanel = new JPanel();
            sitePanel.setBackground(NEWS_SITE_BACKGROUND_COLOR);
            sitePanel.setLayout(new FlowLayout(0, 5, 2));
            sitePanel.add(HyperLink.label(feedMessage.getFeedSiteName()).address(feedMessage.getFeedSiteUrl()).linkColor(Color.white).noUnderline().bold().size(10).build());
            newsPanel.add(sitePanel);
            feedMessagesContextMenu.add(newsPanel);
        }
        this.showButtonMenu(this.feedButton, feedMessagesContextMenu, 2);
    }

    public void showFeedProcessingMessage() {
        JPopupMenu feedMessagesProcessingContextMenu = new JPopupMenu();
        feedMessagesProcessingContextMenu.setComponentOrientation(this.orientation);
        JPanel messagePanel = new JPanel();
        JLabel message = new JLabel(this.messages.get("FEED_PROCESSING_MESSAGE"));
        messagePanel.add(message);
        feedMessagesProcessingContextMenu.add(messagePanel);
        this.showButtonMenu(this.feedButton, feedMessagesProcessingContextMenu, 2);
    }

    private void completeQuickFilterMenu() {
        Filter filter;
        this.companyQuickFilterMenuItemList.removeAll();
        List<Company> companies = Arrays.asList(Company.values());
        Collections.sort(companies, (c1, c2) -> c1.getDisplayName().compareToIgnoreCase(c2.getDisplayName()));
        for (Company company : companies) {
            JMenuItem companyQuickFilterMenuItem = new JMenuItem();
            Filter filter2 = FilterFactory.createFilter(FilterType.COMPANY, company.getDisplayName(), null, null);
            companyQuickFilterMenuItem.addActionListener(this);
            companyQuickFilterMenuItem.setAction(new QuickFilterMenuItemName(filter2));
            companyQuickFilterMenuItem.setText(company.getDisplayName());
            this.companyQuickFilterMenuItemList.add(companyQuickFilterMenuItem);
        }
        this.yearQuickFilterMenuItemList.removeAll();
        for (int year = 1982; year <= 1994; ++year) {
            JMenuItem yearQuickFilterMenuItem = new JMenuItem();
            Filter filter3 = FilterFactory.createFilter(FilterType.YEAR, year + "", null, FilterParameter.EQUAL);
            yearQuickFilterMenuItem.addActionListener(this);
            yearQuickFilterMenuItem.setAction(new QuickFilterMenuItemName(filter3));
            yearQuickFilterMenuItem.setText(year + "");
            this.yearQuickFilterMenuItemList.add(yearQuickFilterMenuItem);
        }
        this.countryQuickFilterMenuItemList.removeAll();
        List countries = Arrays.asList(Country.values()).stream().map(Object::toString).collect(Collectors.toList());
        Collections.sort(countries, (c1, c2) -> this.messages.get(c1).compareToIgnoreCase(this.messages.get(c2)));
        for (String country : countries) {
            JMenuItem countryQuickFilterMenuItem = new JMenuItem();
            countryQuickFilterMenuItem.setComponentOrientation(this.orientation);
            Filter filter2 = FilterFactory.createFilter(FilterType.COUNTRY, country, null, null);
            countryQuickFilterMenuItem.addActionListener(this);
            countryQuickFilterMenuItem.setAction(new QuickFilterMenuItemName(filter2));
            countryQuickFilterMenuItem.setText(this.messages.get(country));
            this.countryQuickFilterMenuItemList.add(countryQuickFilterMenuItem);
        }
        this.mediumQuickFilterMenuItemList.removeAll();
        for (Medium medium : Medium.values()) {
            JMenuItem mediumQuickFilterMenuItem = new JMenuItem();
            mediumQuickFilterMenuItem.setComponentOrientation(this.orientation);
            filter = FilterFactory.createFilter(FilterType.MEDIUM, medium.toString(), null, null);
            mediumQuickFilterMenuItem.addActionListener(this);
            mediumQuickFilterMenuItem.setAction(new QuickFilterMenuItemName(filter));
            mediumQuickFilterMenuItem.setText(this.messages.get(medium.toString()));
            this.mediumQuickFilterMenuItemList.add(mediumQuickFilterMenuItem);
        }
        this.generationQuickFilterMenuItemList.removeAll();
        for (Enum enum_ : MSXGeneration.values()) {
            JMenuItem generationQuickFilterMenuItem = new JMenuItem();
            filter = FilterFactory.createFilter(FilterType.GENERATION, enum_.toString(), null, null);
            generationQuickFilterMenuItem.addActionListener(this);
            generationQuickFilterMenuItem.setAction(new QuickFilterMenuItemName(filter));
            generationQuickFilterMenuItem.setText(((MSXGeneration)enum_).getDisplayName());
            this.generationQuickFilterMenuItemList.add(generationQuickFilterMenuItem);
        }
        this.soundQuickFilterMenuItemList.removeAll();
        for (Enum enum_ : Sound.values()) {
            JMenuItem soundQuickFilterMenuItem = new JMenuItem();
            filter = FilterFactory.createFilter(FilterType.SOUND, enum_.toString(), null, null);
            soundQuickFilterMenuItem.addActionListener(this);
            soundQuickFilterMenuItem.setAction(new QuickFilterMenuItemName(filter));
            soundQuickFilterMenuItem.setText(((Sound)enum_).getDisplayName());
            this.soundQuickFilterMenuItemList.add(soundQuickFilterMenuItem);
        }
    }

    private void showButtonMenu(JComponent button, JPopupMenu menu, int xOffset) {
        int x = this.orientation == ComponentOrientation.RIGHT_TO_LEFT ? button.getWidth() - menu.getPreferredSize().width - xOffset : xOffset;
        menu.show(button, x, button.getHeight() - 1);
    }

    private void onRequestFillDatabaseScreen() {
        try {
            this.presenter.onRequestFillDatabaseScreen();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onRequestChangeMachineScreen() {
        try {
            this.presenter.onRequestMachineUpdateScreen();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onRequestUpdateAllDatabases() {
        try {
            if (MessageBoxUtil.showYesNoMessageBox((Component)this.ref, this.updateAllDatabasesConfirmationMessage, this.messages, this.orientation) == 0) {
                int numberUpdatedProfiles = this.presenter.onRequestUpdateAllDatabases();
                this.presenter.onViewUpdatedDatabase(this.currentDatabase);
                MessageBoxUtil.showInformationMessageBox((Component)this.ref, this.messages.get("TOTAL_UPDATED_PROFILES") + ": " + numberUpdatedProfiles, this.messages, this.orientation);
            }
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onRequestImportBlueMSXLauncherDatabasesScreen() {
        try {
            this.presenter.onRequestImportBlueMSXLauncherDatabasesScreen();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onRequestDatabaseManagerScreen() {
        try {
            this.presenter.onRequestDatabaseManagerScreen();
            if (this.currentDatabase == null) {
                this.addButton.setEnabled(false);
                this.filtersSelectButton.setEnabled(false);
            }
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onRequestActivityViewerScreen() {
        this.presenter.onRequestActivityViewerScreen();
    }

    private void onRequestPatcherScreen() {
        this.presenter.onRequestPatcherScreen();
    }

    private void onRequestLHAExtractorScreen() {
        this.presenter.onRequestLHAExtractorScreen();
    }

    private void onRequestHelpFile() {
        try {
            this.presenter.onRequestHelpFile();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onRequestUpdatesChecker() {
        try {
            this.presenter.onRequestUpdatesChecker();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this.ref, le, this.messages, this.orientation);
        }
    }

    private void onSelectDatabase(String database) {
        try {
            this.presenter.onSelectDatabase(database);
        }
        catch (LauncherException le) {
            this.databaseLabel.setValue(this.currentDatabase);
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
        this.currentDatabase = database;
    }

    private JButton getIconButton(JPanel buttonPanel, ImageIcon icon) {
        JButton button = new JButton();
        button.addActionListener(this);
        button.setIcon(icon);
        buttonPanel.setOpaque(false);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        buttonPanel.setBackground(new Color(0, 0, 0, 0));
        buttonPanel.add(button);
        return button;
    }

    private void launchGame() {
        try {
            this.presenter.onLaunchGame(this.getSelectedGame());
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private void addGame() {
        try {
            this.presenter.onRequestAddGameScreen();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private void editGame() {
        String selectedGame = this.getSelectedGame();
        if (selectedGame != null) {
            try {
                this.presenter.onRequestEditGameScreen(this.getSelectedGame());
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void promptForRemovingSelection() {
        if (MessageBoxUtil.showYesNoMessageBox((Component)this.ref, this.removeConfirmationMessage, this.messages, this.orientation) == 0) {
            try {
                this.presenter.onRequestRemoveGamesAction(this.getSelectedGames());
                int[] selections = this.gameList.getSelectedIndices();
                for (int index = selections.length - 1; index >= 0; --index) {
                    this.gameList.remove(selections[index]);
                }
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void viewGameInfo() {
        String selectedGame = this.getSelectedGame();
        if (selectedGame != null) {
            try {
                this.presenter.onRequestGameInfo(selectedGame);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void moveSelectedGames() {
        Set<String> games = this.getSelectedGames();
        if (games != null) {
            Set<String> movedGames = this.presenter.onRequestMoveGamesScreen(games, this.currentDatabase);
            int gamesTotal = this.gameList.getListSize();
            for (int index = gamesTotal - 1; index > -1; --index) {
                if (!movedGames.contains(this.gameList.getElementAt(index))) continue;
                this.gameList.remove(index);
            }
        }
    }

    private void locateMainFileOfSelectedGame() {
        String selectedGame = this.getSelectedGame();
        if (selectedGame != null) {
            try {
                this.presenter.onRequestLocateFile(selectedGame);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void addSelectedGameToFavorites() {
        String selectedGame = this.getSelectedGame();
        if (selectedGame != null) {
            try {
                this.presenter.onRequestAddFavorite(selectedGame, this.currentDatabase);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void findRelated() {
        String selectedGame = this.getSelectedGame();
        if (selectedGame != null) {
            try {
                this.presenter.onRequestFindRelated(selectedGame);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void showPropertiesOfSelectedGame() {
        String selectedGame = this.getSelectedGame();
        if (selectedGame != null) {
            this.presenter.onRequestShowProperties(selectedGame);
        }
    }

    private void processShowFavoritesMenuRequest() {
        this.presenter.onRequestListOfFavorites();
    }

    private void processShowFiltersMenuRequest() {
        if (this.currentDatabase != null) {
            this.presenter.onRequestListOfSavedFilters();
        }
    }

    private void processShowDatabasesMenuRequest() {
        this.presenter.onRequestDatabasesList();
    }

    private void addFilter() {
        try {
            this.presenter.onRequestAddFilterScreen();
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private void processShowSearchScreenRequest() {
        JPopupMenu searchContextMenu = new JPopupMenu();
        searchContextMenu.setComponentOrientation(this.orientation);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new FlowLayout(1, 4, 0));
        boolean gradientResultHighlight = !OSUtils.isMac();
        JSearchTextField searchField = new JSearchTextField(25, searchContextMenu, this, gradientResultHighlight);
        searchPanel.add(searchField);
        searchContextMenu.add(searchPanel);
        int x = this.orientation == ComponentOrientation.RIGHT_TO_LEFT ? this.searchButton.getWidth() - searchContextMenu.getPreferredSize().width - 2 : 2;
        searchContextMenu.show(this.searchButton, x, this.searchButton.getHeight() - 1);
    }

    private void processShowNewsListRequest() {
        this.presenter.onRequestNewsList();
    }

    private static void addFilterButtonHoverBehavior(final JButton button) {
        button.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = (ButtonModel)e.getSource();
                if (model.isRollover()) {
                    button.setBackground(POPUP_MENU_ITEM_BUTTON_HOVER_BG_COLOR);
                    button.setBorder(BorderFactory.createEtchedBorder());
                } else {
                    button.setBackground(DEFAULT_BUTTON_BG_COLOR);
                    button.setBorder(null);
                }
            }
        });
    }

    private static boolean isInSelection(int[] selections, int mouseSelection) {
        for (int ix = 0; ix < selections.length; ++ix) {
            if (selections[ix] != mouseSelection) continue;
            return true;
        }
        return false;
    }

    private void promptForDeletingFilter(String filterName) {
        if (MessageBoxUtil.showYesNoMessageBox((Component)this.ref, this.removeConfirmationMessage, this.messages, this.orientation) == 0) {
            try {
                this.presenter.onRequestDeleteFilterAction(filterName);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void flipOrientation() {
        this.drawMenu();
        this.topMenuBar.setComponentOrientation(this.orientation);
        this.optionsMenu.applyComponentOrientation(this.orientation);
        this.actionsMenu.applyComponentOrientation(this.orientation);
        this.toolsMenu.applyComponentOrientation(this.orientation);
        this.helpMenu.applyComponentOrientation(this.orientation);
        this.contentPane.setComponentOrientation(this.orientation);
        this.contentPane.applyComponentOrientation(this.orientation);
        this.quickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.companyQuickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.yearQuickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.countryQuickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.mediumQuickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.generationQuickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.soundQuickFilterMenuItemList.setComponentOrientation(this.orientation);
        this.newFilterMenuItem.setComponentOrientation(this.orientation);
        this.editCurrentUntitledFilterMenuItem.setComponentOrientation(this.orientation);
        this.resetFilterMenuItem.setComponentOrientation(this.orientation);
        this.moveMenuItem.setComponentOrientation(this.orientation);
        this.locateFileMenuItem.setComponentOrientation(this.orientation);
        this.addFavoriteMenuItem.setComponentOrientation(this.orientation);
        this.findRelatedMenuItem.setComponentOrientation(this.orientation);
        this.infoMenuItem.setComponentOrientation(this.orientation);
        this.propertiesMenuItem.setComponentOrientation(this.orientation);
        this.databaseLabel.setComponentOrientation(this.orientation);
        this.totalLabel.setComponentOrientation(this.orientation);
        this.filtersLabel.setComponentOrientation(this.orientation);
        this.gameList.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
    }

    private String getSelectedGame() {
        String gameName = null;
        Set<String> selectedGames = this.getSelectedGames();
        if (selectedGames != null && selectedGames.size() == 1) {
            gameName = selectedGames.iterator().next();
        }
        return gameName;
    }

    private Set<String> getSelectedGames() {
        HashSet<String> gameNames = null;
        int[] selections = this.gameList.getSelectedIndices();
        if (selections != null && selections.length > 0) {
            gameNames = new HashSet<String>(Arrays.asList(this.gameList.getSelectedItems()));
        }
        return gameNames;
    }

    private void setupGameListContextMenu() {
        this.contextMenu = new JPopupMenu();
        this.moveMenuItem = new JMenuItemWithIcon();
        this.moveMenuItem.addActionListener(this);
        this.moveMenuItem.setAccelerator(this.getCtrlXKeyStroke());
        this.contextMenu.add(this.moveMenuItem);
        this.locateFileMenuItem = new JMenuItemWithIcon();
        this.locateFileMenuItem.setAccelerator(this.getCtrlShiftFKeyStroke());
        this.locateFileMenuItem.addActionListener(this);
        this.contextMenu.add(this.locateFileMenuItem);
        this.addFavoriteMenuItem = new JMenuItemWithIcon();
        this.addFavoriteMenuItem.setAccelerator(this.getCtrlDKeyStroke());
        this.addFavoriteMenuItem.setIcon(Icons.FAVORITE.getImageIcon());
        this.addFavoriteMenuItem.addActionListener(this);
        this.contextMenu.add(this.addFavoriteMenuItem);
        this.findRelatedMenuItem = new JMenuItemWithIcon();
        this.findRelatedMenuItem.setAccelerator(this.getCtrlShiftRKeyStroke());
        this.findRelatedMenuItem.addActionListener(this);
        this.contextMenu.add(this.findRelatedMenuItem);
        this.contextMenu.addSeparator();
        this.infoMenuItem = new JMenuItemWithIcon();
        this.infoMenuItem.addActionListener(this);
        this.infoMenuItem.setAccelerator(this.getF1KeyStroke());
        this.contextMenu.add(this.infoMenuItem);
        this.propertiesMenuItem = new JMenuItemWithIcon();
        this.propertiesMenuItem.addActionListener(this);
        this.propertiesMenuItem.setAccelerator(this.getCtrlF1KeyStroke());
        this.contextMenu.add(this.propertiesMenuItem);
    }

    private void setupFiltersMenu() {
        this.quickFilterMenuItemList = new JMenu();
        this.companyQuickFilterMenuItemList = new JMenu();
        this.yearQuickFilterMenuItemList = new JMenu();
        this.countryQuickFilterMenuItemList = new JMenu();
        this.mediumQuickFilterMenuItemList = new JMenu();
        this.generationQuickFilterMenuItemList = new JMenu();
        this.soundQuickFilterMenuItemList = new JMenu();
        this.newFilterMenuItem = new JMenuItem();
        this.newFilterMenuItem.addActionListener(this);
        this.editCurrentUntitledFilterMenuItem = new JMenuItem();
        this.editCurrentUntitledFilterMenuItem.addActionListener(this);
        this.resetFilterMenuItem = new JMenuItem();
        this.resetFilterMenuItem.addActionListener(this);
    }

    private void selectGame(DatabaseItem databaseItem) {
        try {
            this.presenter.onSelectDatabaseItem(databaseItem);
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private void applyFilter(String filterName) {
        try {
            this.presenter.onSelectFilter(filterName);
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private void applyQuickFilter(Filter filter) {
        try {
            this.presenter.onSelectQuickFilter(filter);
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private KeyStroke getCtrlXKeyStroke() {
        return KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlEKeyStroke() {
        return KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlF1KeyStroke() {
        return KeyStroke.getKeyStroke(112, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlShiftFKeyStroke() {
        return KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
    }

    private KeyStroke getCtrlDKeyStroke() {
        return KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getF1KeyStroke() {
        return KeyStroke.getKeyStroke("F1");
    }

    private KeyStroke getCtrlFKeyStroke() {
        return KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlQKeyStroke() {
        return KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlIKeyStroke() {
        return KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlLKeyStroke() {
        return KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlRKeyStroke() {
        return KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private KeyStroke getCtrlShiftRKeyStroke() {
        return KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
    }

    private void addDraggedGames(File[] files) {
        try {
            this.presenter.onRequestAddDraggedAndDroppedGamesScreen(files);
        }
        catch (LauncherException le) {
            MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
        }
    }

    private static class ExpandMenuButton
    extends AbstractActionButton {
        private static final Color arrowColor = new Color(235, 235, 235);

        ExpandMenuButton(ActionListener listener) {
            super(listener, new Color(187, 187, 187), new Color(207, 207, 207), new Color(157, 157, 157));
        }

        @Override
        protected void drawButton(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int halfWidth = width / 2;
            int startOfArrowHeight = height / 2 - halfWidth;
            g.fillRect(0, 0, width, height);
            g.setColor(arrowColor);
            for (int ix = 0; ix <= halfWidth; ++ix) {
                g.drawLine(ix, startOfArrowHeight + ix, width - ix - 1, startOfArrowHeight + ix);
            }
        }
    }

    private class JPanelWithBackground
    extends JPanel {
        private JPanelWithBackground() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(Icons.BACKGROUND.getImage(), 0, 0, null);
        }
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        private WindowCloseAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            MainWindow.this.presenter.onRequestExit();
        }
    }

    private class FavoriteMenuItemDelete
    extends PopupMenuItemDelete {
        private final DatabaseItem favorite;

        FavoriteMenuItemDelete(DatabaseItem favorite) {
            super("");
            this.favorite = favorite;
        }
    }

    private class QuickFilterMenuItemName
    extends PopupMenuItemName {
        private final Filter filter;

        QuickFilterMenuItemName(Filter filter) {
            super("");
            this.filter = filter;
        }
    }

    private class DatabaseMenuItemName
    extends PopupMenuItemName {
        DatabaseMenuItemName(String databaseName) {
            super(databaseName);
        }
    }

    private class FavoriteMenuItemName
    extends PopupMenuItemName {
        private final DatabaseItem favorite;

        FavoriteMenuItemName(DatabaseItem favorite) {
            super("");
            this.favorite = favorite;
        }
    }

    private class FilterMenuItemEdit
    extends PopupMenuItemEdit {
        FilterMenuItemEdit(String filterName) {
            super(filterName);
        }
    }

    private class FilterMenuItemDelete
    extends PopupMenuItemDelete {
        FilterMenuItemDelete(String filterName) {
            super(filterName);
        }
    }

    private class FilterMenuItemName
    extends PopupMenuItemName {
        FilterMenuItemName(String filterName) {
            super(filterName);
        }
    }

    private abstract class PopupMenuItemEdit
    extends PopupMenuAction {
        PopupMenuItemEdit(String popupMenuItemName) {
            super(popupMenuItemName);
            this.putValue("SmallIcon", Icons.EDIT_SMALL.getImageIcon());
        }
    }

    private abstract class PopupMenuItemDelete
    extends PopupMenuAction {
        PopupMenuItemDelete(String popupMenuItemName) {
            super(popupMenuItemName);
            this.putValue("SmallIcon", Icons.DELETE_SMALL.getImageIcon());
        }
    }

    private abstract class PopupMenuItemName
    extends PopupMenuAction {
        PopupMenuItemName(String popupMenuItemName) {
            super(popupMenuItemName);
            this.putValue("Name", popupMenuItemName);
            if (MainWindow.this.orientation == ComponentOrientation.LEFT_TO_RIGHT) {
                this.putValue("Name", popupMenuItemName + MainWindow.SPACES);
            } else {
                this.putValue("Name", MainWindow.SPACES + popupMenuItemName);
            }
        }
    }

    private abstract class PopupMenuAction
    extends AbstractAction {
        private final String popupMenuItemName;

        PopupMenuAction(String popupMenuItemName) {
            this.popupMenuItemName = popupMenuItemName;
        }

        public String getPopupMenuItemName() {
            return this.popupMenuItemName;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

