/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.Utils;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputComboBoxSelector;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.UserInputWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MoveGamesWindow {
    private final MainPresenter presenter;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final Component parent;
    private final Set<String> gameNames;
    private final String oldDatabase;
    private final Set<String> targetDatabases;
    Set<String> movedGameNames = null;

    public MoveGamesWindow(MainPresenter presenter, Language language, boolean rightToLeft, Component parent, Set<String> gameNames, String oldDatabase, Set<String> targetDatabases) {
        this.presenter = presenter;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.parent = parent;
        this.gameNames = gameNames;
        this.oldDatabase = oldDatabase;
        this.targetDatabases = targetDatabases;
    }

    public Set<String> displayAndGetMovedGames() {
        UserInputWindow<String> userInputWindow = new UserInputWindow<String>(this.parent, this.messages, this.rightToLeft, this.messages.get("MOVE_GAMES"), this.messages.get("MOVE_MESSAGE"), new UserInputComboBoxSelector(Utils.getSortedCaseInsensitiveArray(this.targetDatabases)));
        String userInput = userInputWindow.displayAndGetUserInput();
        this.movedGameNames = new HashSet<String>();
        if (userInput != null) {
            try {
                this.movedGameNames = this.presenter.onRequestMoveGamesAction(this.gameNames, this.oldDatabase, userInput);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox(this.parent, le, this.messages, this.rightToLeft);
            }
        }
        return this.movedGameNames;
    }
}

