/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.data.game.RelatedGame;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.RelatedGamesPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.GlobalSwingContext;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.AbstractActionButton;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.HyperLink;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.JTextFieldBorderless;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.MessageBoxUtil;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.language.LanguageDisplayFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class RelatedGamesWindow
extends JDialog
implements ActionListener {
    private final RelatedGamesPresenter presenter;
    private final String gameName;
    private final List<RelatedGame> relatedGames;
    private final Map<String, String> messages;
    private final boolean rightToLeft;
    private final JFrame mainWindow;
    private final ImageIcon noScreenshot;
    private JComponent closeButton;
    private ComponentOrientation orientation = null;
    private static final Dimension CLOSE_BUTTON_SIZE = new Dimension(20, 19);
    private static final Font NAME_FONT = new Font(null, 0, 17);
    private static final Font INFO_FONT = new Font(null, 0, 11);
    private static final int SCROLL_PANE_WIDTH = 560;
    private static final int SCROLL_PANE_UNIT_HEIGHT = 104;
    private static final int SCREENSHOT_WIDTH = 102;
    private static final int SCREENSHOT_HEIGHT = 90;
    private static final FlowLayout DATA_LAYOUT = new FlowLayout(3, 0, 1);
    private static final Color MSX_GENERATION_BACKGROUND_COLOR = new Color(90, 90, 220);
    private static final Color ALTERNATE_BG_COLOR = new Color(212, 214, 223);

    public RelatedGamesWindow(RelatedGamesPresenter presenter, String gameName, List<RelatedGame> relatedGames, Language language, boolean rightToLeft) {
        this.presenter = presenter;
        this.gameName = gameName;
        this.relatedGames = relatedGames;
        this.messages = LanguageDisplayFactory.getDisplayMessages(this.getClass(), language);
        this.rightToLeft = rightToLeft;
        this.mainWindow = GlobalSwingContext.getIntance().getMainWindow();
        this.noScreenshot = this.getScaledImage(Icons.NO_SCREENSHOT.getImageIcon());
        this.closeButton = new CloseButton(this);
    }

    public void displayScreen() {
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setUndecorated(true);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel titlePanel = new JPanel();
        JPanel closeButtonPanel = new JPanel();
        titlePanel.add(new JLabel("<html>" + this.messages.get("RELATED_TO") + ": <b>" + this.gameName + "</b></html>"));
        this.closeButton.setPreferredSize(CLOSE_BUTTON_SIZE);
        closeButtonPanel.add(titlePanel);
        closeButtonPanel.add(this.closeButton);
        if (this.rightToLeft) {
            this.orientation = ComponentOrientation.RIGHT_TO_LEFT;
            titlePanel.setLayout(new FlowLayout(0));
            closeButtonPanel.setLayout(new FlowLayout(2));
            topPanel.add((Component)titlePanel, "East");
            topPanel.add((Component)closeButtonPanel, "West");
        } else {
            this.orientation = ComponentOrientation.LEFT_TO_RIGHT;
            titlePanel.setLayout(new FlowLayout(2));
            closeButtonPanel.setLayout(new FlowLayout(0));
            topPanel.add((Component)titlePanel, "West");
            topPanel.add((Component)closeButtonPanel, "East");
        }
        contentPane.add((Component)topPanel, "North");
        JPanel table = new JPanel();
        table.setLayout(new BoxLayout(table, 1));
        if (!this.relatedGames.isEmpty()) {
            boolean alternateColor = false;
            for (RelatedGame relatedGame : this.relatedGames) {
                alternateColor = !alternateColor;
                JPanel rowPanel = new JPanel();
                rowPanel.setLayout(new FlowLayout(3));
                this.setAlternateBackgrounfColor(rowPanel, alternateColor);
                JLabel screenshotLabel = new JLabel(this.getScreenshot(relatedGame.getMSXGenId()));
                rowPanel.add(screenshotLabel);
                JPanel namePanel = new JPanel(DATA_LAYOUT);
                this.setAlternateBackgrounfColor(namePanel, alternateColor);
                JTextFieldBorderless nameLabel = new JTextFieldBorderless(relatedGame.getGameName());
                nameLabel.setFont(NAME_FONT);
                namePanel.add(nameLabel);
                JPanel infoPanel = new JPanel(DATA_LAYOUT);
                this.setAlternateBackgrounfColor(infoPanel, alternateColor);
                JLabel infoLabel = new JLabel(relatedGame.getCompany() + " " + relatedGame.getYear());
                infoLabel.setFont(INFO_FONT);
                infoPanel.add(infoLabel);
                JPanel dataPanel = new JPanel();
                dataPanel.setLayout(new BoxLayout(dataPanel, 1));
                dataPanel.add(namePanel);
                dataPanel.add(infoPanel);
                JPanel iconsPanel = new JPanel(DATA_LAYOUT);
                this.setAlternateBackgrounfColor(iconsPanel, alternateColor);
                if (this.presenter.isGenerationMSXIdValid(relatedGame)) {
                    JPanel msxGenerationPanel = new JPanel();
                    msxGenerationPanel.setBackground(MSX_GENERATION_BACKGROUND_COLOR);
                    msxGenerationPanel.setLayout(new FlowLayout(0, 5, 2));
                    msxGenerationPanel.add(HyperLink.address(this.presenter.getGenerationMSXURL(relatedGame)).label("Generation-MSX").linkColor(Color.WHITE).noUnderline().bold().size(10).build());
                    iconsPanel.add(msxGenerationPanel);
                    iconsPanel.add(Box.createHorizontalStrut(5));
                }
                iconsPanel.add(HyperLink.address(this.presenter.getYouTubeURL(relatedGame.getGameName())).icon(Icons.YOUTUBE.getImageIcon()).tooltip(this.messages.get("SEARCH_ON_YOUTUBE")).build());
                if (relatedGame.getDatabaseItem().isPresent()) {
                    JButtonIconWithAction<DatabaseItem> launcherButton = new JButtonIconWithAction<DatabaseItem>(Icons.APPLICATION_16.getImageIcon(), relatedGame.getDatabaseItem().get());
                    launcherButton.setToolTipText(this.messages.get("LOCATE_IN_LAUNCHER"));
                    launcherButton.addActionListener(this);
                    iconsPanel.add(Box.createHorizontalStrut(5));
                    iconsPanel.add(launcherButton);
                }
                dataPanel.add(iconsPanel);
                rowPanel.add(dataPanel);
                table.add(rowPanel);
            }
            JScrollPane scrollPane = new JScrollPane(table);
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            scrollPane.setPreferredSize(new Dimension(560, Math.min(5, this.relatedGames.size()) * 104));
            contentPane.add((Component)scrollPane, "South");
        } else {
            JPanel noResultsPanel = new JPanel(new FlowLayout(1, 10, 10));
            JLabel noResultsLabel = new JLabel(this.messages.get("NO_RESULTS"));
            noResultsPanel.add(noResultsLabel);
            contentPane.add((Component)noResultsPanel, "South");
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.greyoutBackground();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.reenableBackground();
        } else if (e.getSource() instanceof JButtonIconWithAction) {
            this.reenableBackground();
            DatabaseItem databaseItem = (DatabaseItem)((JButtonIconWithAction)e.getSource()).actionType;
            try {
                this.presenter.onRequestHighlightGameInLauncher(databaseItem);
            }
            catch (LauncherException le) {
                MessageBoxUtil.showErrorMessageBox((Component)this, le, this.messages, this.orientation);
            }
        }
    }

    private void setAlternateBackgrounfColor(JPanel panel, boolean alternateColor) {
        if (alternateColor) {
            panel.setBackground(ALTERNATE_BG_COLOR);
        }
    }

    private ImageIcon getScreenshot(int msxGenId) {
        Path path = this.presenter.getScreenshotPath(msxGenId);
        if (path.toFile().exists()) {
            return this.getScaledImage(new ImageIcon(path.toString()));
        }
        return this.noScreenshot;
    }

    private ImageIcon getScaledImage(ImageIcon imageIcon) {
        BufferedImage bufferedImage = new BufferedImage(102, 90, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(imageIcon.getImage(), 0, 0, 102, 90, null);
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    private void greyoutBackground() {
        JPanel glass = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(new Color(0, 0, 0, 80));
                g.fillRect(0, 0, RelatedGamesWindow.this.mainWindow.getWidth(), RelatedGamesWindow.this.mainWindow.getHeight());
            }
        };
        glass.setOpaque(false);
        this.mainWindow.setGlassPane(glass);
        glass.setVisible(true);
    }

    private void reenableBackground() {
        this.mainWindow.getGlassPane().setVisible(false);
        this.dispose();
    }

    private static class CloseButton
    extends AbstractActionButton {
        private static final Color CLOSE_COLOR = new Color(235, 235, 235);
        private static final Color NORMAL_BUTTON_BG_COLOR = UIManager.getLookAndFeelDefaults().getColor("Panel.background");
        private static final Color HOVER_BUTTON_BG_COLOR = new Color(207, 37, 37);
        private static final Color PRESSED_BUTTON_BG_COLOR = new Color(157, 157, 157);
        private static final int X_LENGTH = 12;

        CloseButton(ActionListener listener) {
            super(listener, NORMAL_BUTTON_BG_COLOR, HOVER_BUTTON_BG_COLOR, PRESSED_BUTTON_BG_COLOR);
        }

        @Override
        protected void drawButton(Graphics g) {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(CLOSE_COLOR);
            if (this.inside) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawLine(3, 3, 15, 15);
            g.drawLine(15, 3, 3, 15);
            g.drawLine(4, 3, 16, 15);
            g.drawLine(16, 3, 4, 15);
        }
    }

    private class JButtonIconWithAction<T>
    extends JButton {
        final T actionType;

        public JButtonIconWithAction(Icon icon, T actionType) {
            super(icon);
            this.actionType = actionType;
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(16, 16));
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent me) {
                }

                @Override
                public void mousePressed(MouseEvent me) {
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    JButtonIconWithAction.this.setCursor(Cursor.getPredefinedCursor(0));
                }

                @Override
                public void mouseEntered(MouseEvent me) {
                    JButtonIconWithAction.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                }
            });
        }
    }
}

