/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing;

import info.msxlaunchers.openmsx.common.FileTypeUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class WindowUtils {
    public static final Dimension iconButtonDimension = new Dimension(35, 26);
    private static final String ELLIPSES = "...";

    public static void browseFile(JDialog window, JTextField field) {
        WindowUtils.browseFile(window, field, null, null, false);
    }

    public static void browseFile(JDialog window, JTextField field, String filterDescription, Set<String> extensions, boolean includeZipFiles) {
        JFileChooser fileChooser = new JFileChooser();
        Set<String> extensionsEffectiveValue = extensions;
        if (filterDescription != null) {
            if (includeZipFiles) {
                extensionsEffectiveValue = new HashSet<String>(extensions);
                extensionsEffectiveValue.addAll(FileTypeUtils.getZIPExtensions());
            }
            fileChooser.addChoosableFileFilter(new FileFilterImpl(filterDescription, extensionsEffectiveValue));
        }
        if (fileChooser.showOpenDialog(window) == 0) {
            field.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static void browseForDirectory(JDialog window, JTextField field) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(window) == 0) {
            field.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    public static String truncateStringAndDisplayEllipsis(String string, FontMetrics fontMetrics, int availableWidth) {
        String stringToDisplay = null;
        if (string == null || fontMetrics == null) {
            stringToDisplay = "";
        } else if (fontMetrics.stringWidth(string) > availableWidth) {
            int index = string.length() - 1;
            stringToDisplay = string.substring(0, index) + ELLIPSES;
            while (fontMetrics.stringWidth(stringToDisplay) >= availableWidth) {
                stringToDisplay = string.substring(0, --index) + ELLIPSES;
            }
        } else {
            stringToDisplay = string;
        }
        return stringToDisplay;
    }

    private static class FileFilterImpl
    extends FileFilter {
        private final String description;
        private final Set<String> extensions;

        FileFilterImpl(String description, Set<String> extensions) {
            this.description = description;
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            boolean accept;
            if (file.isDirectory()) {
                accept = true;
            } else {
                String filename = file.getPath();
                String extension = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
                accept = this.extensions.contains(extension);
            }
            return accept;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

