/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.common.ExternalLinksUtils;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class HyperLink
extends JLabel {
    private static final Color DEFAULT_LINK_COLOR = new Color(0, 0, 153);
    private static final Cursor HAND_CURSOR = new Cursor(12);
    private Map attributes = this.getFont().getAttributes();
    private final boolean noUnderline;

    public static HyperLinkParam label(String label) {
        return new HyperLinkParam().label(label);
    }

    public static HyperLinkParam address(String address) {
        return new HyperLinkParam().address(address);
    }

    public static HyperLinkParam linkColor(Color linkColor) {
        return new HyperLinkParam().linkColor(linkColor);
    }

    public static HyperLinkParam noUnderline() {
        return new HyperLinkParam().noUnderline();
    }

    public static HyperLinkParam bold() {
        return new HyperLinkParam().noUnderline();
    }

    public static HyperLinkParam size(int size) {
        return new HyperLinkParam().size(size);
    }

    public static HyperLinkParam icon(ImageIcon icon) {
        return new HyperLinkParam().icon(icon);
    }

    public static HyperLinkParam tooltip(String tooltip) {
        return new HyperLinkParam().tooltip(tooltip);
    }

    private HyperLink(final HyperLinkParam param) {
        super(param.label);
        this.setCursor(HAND_CURSOR);
        if (param.bold) {
            this.attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            this.setFont(this.getFont().deriveFont(this.attributes));
        }
        if (param.linkColor == null) {
            this.setForeground(DEFAULT_LINK_COLOR);
        } else {
            this.setForeground(param.linkColor);
        }
        this.noUnderline = param.noUnderline;
        if (param.size > 0) {
            this.attributes.put(TextAttribute.SIZE, param.size);
            this.setFont(this.getFont().deriveFont(this.attributes));
        }
        if (param.icon != null) {
            this.setIcon(param.icon);
        }
        this.setToolTipText(param.tooltip);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (!HyperLink.this.noUnderline) {
                    HyperLink.this.attributes.put(TextAttribute.UNDERLINE, -1);
                    HyperLink.this.setFont(HyperLink.this.getFont().deriveFont(HyperLink.this.attributes));
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                if (!HyperLink.this.noUnderline) {
                    HyperLink.this.attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    HyperLink.this.setFont(HyperLink.this.getFont().deriveFont(HyperLink.this.attributes));
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    ExternalLinksUtils.startBrowser(param.address);
                }
                catch (IOException ioe) {
                    LauncherLogger.logException(this, ioe);
                }
            }
        });
    }

    public static class HyperLinkParam {
        private String label;
        private String address;
        private Color linkColor;
        private boolean noUnderline;
        private boolean bold;
        private int size;
        private ImageIcon icon;
        private String tooltip;

        public HyperLinkParam label(String label) {
            this.label = label;
            return this;
        }

        public HyperLinkParam address(String address) {
            this.address = address;
            return this;
        }

        public HyperLinkParam linkColor(Color linkColor) {
            this.linkColor = linkColor;
            return this;
        }

        public HyperLinkParam noUnderline() {
            this.noUnderline = true;
            return this;
        }

        public HyperLinkParam bold() {
            this.bold = true;
            return this;
        }

        public HyperLinkParam size(int size) {
            this.size = size;
            return this;
        }

        public HyperLinkParam icon(ImageIcon icon) {
            this.icon = icon;
            return this;
        }

        public HyperLinkParam tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public HyperLink build() {
            return new HyperLink(this);
        }
    }
}

