/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.data.game.DatabaseItem;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.component.SearchFieldHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Painter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JSearchTextField
extends JTextField {
    private static final int TYPING_DELAY = 150;
    private final SearchFieldHandler searchFieldHandler;
    private final JPopupMenu parentMenu;
    private final boolean gradientResultHighlight;
    private final JWindow matchesPopup;
    private final JPanel matchesPanel;
    private final ActionListener timerListener = new TimerListener();
    private final Timer fieldUpdateTimer = new Timer(150, this.timerListener);
    private static final int MATCHES_MENU_ITEM_HEIGHT = 39;
    private static final String ENTER_MAP_KEY = "Enter-key";
    private static final String DOWN_MAP_KEY = "Down-key";
    private static final String UP_MAP_KEY = "Up-key";
    private static final int UNSELECTED_INDEX = -1;
    private int currentMatchSelectionIndex = -1;
    private int currentMatchSelectionMaximum = 0;
    private JMatchPanel[] matchesLabels;
    private static final Border LABEL_MARGIN = BorderFactory.createEmptyBorder(5, 7, 7, 7);
    private static final Border LABEL_LINE = BorderFactory.createMatteBorder(0, 1, 0, 1, Color.gray);
    private static final Border LABEL_COMPOUND_BORDER = BorderFactory.createCompoundBorder(LABEL_LINE, LABEL_MARGIN);
    private static final Font gameFont = new Font(null, 0, 14);
    private static final Font databaseFont = new Font(null, 0, 9);
    private static final Color databaseColor = new Color(100, 100, 100);
    private static final Painter<JComponent> LABEL_BACKGROUND_PAINTER = (Painter)UIManager.get("MenuItem[MouseOver].backgroundPainter");

    public JSearchTextField(int columns, JPopupMenu parentMenu, SearchFieldHandler searchFieldHandler, boolean gradientResultHighlight) {
        super(columns);
        this.parentMenu = parentMenu;
        this.searchFieldHandler = searchFieldHandler;
        this.gradientResultHighlight = gradientResultHighlight;
        this.matchesPopup = new JWindow();
        this.matchesPanel = new JPanel();
        this.matchesPanel.setLayout(new GridLayout(0, 1));
        this.matchesPopup.getContentPane().add(this.matchesPanel);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                JSearchTextField.this.fieldUpdateTimer.restart();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                JSearchTextField.this.fieldUpdateTimer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JSearchTextField.this.fieldUpdateTimer.restart();
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), ENTER_MAP_KEY);
        this.getActionMap().put(ENTER_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (JSearchTextField.this.currentMatchSelectionIndex > -1) {
                    JSearchTextField.this.processMatchSelection(JSearchTextField.this.matchesLabels[JSearchTextField.this.currentMatchSelectionIndex].getSelectedItem());
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0, false), DOWN_MAP_KEY);
        this.getActionMap().put(DOWN_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (JSearchTextField.this.currentMatchSelectionMaximum > 0) {
                    if (JSearchTextField.this.currentMatchSelectionIndex != -1) {
                        JSearchTextField.this.matchesLabels[JSearchTextField.this.currentMatchSelectionIndex].unhighlight();
                    }
                    JSearchTextField.this.currentMatchSelectionIndex++;
                    if (JSearchTextField.this.currentMatchSelectionIndex == JSearchTextField.this.currentMatchSelectionMaximum) {
                        JSearchTextField.this.currentMatchSelectionIndex = 0;
                    }
                    JSearchTextField.this.matchesLabels[JSearchTextField.this.currentMatchSelectionIndex].highlight();
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0, false), UP_MAP_KEY);
        this.getActionMap().put(UP_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (JSearchTextField.this.currentMatchSelectionMaximum > 0) {
                    if (JSearchTextField.this.currentMatchSelectionIndex != -1) {
                        JSearchTextField.this.matchesLabels[JSearchTextField.this.currentMatchSelectionIndex].unhighlight();
                    }
                    JSearchTextField.this.currentMatchSelectionIndex--;
                    if (JSearchTextField.this.currentMatchSelectionIndex < 0) {
                        JSearchTextField.this.currentMatchSelectionIndex = JSearchTextField.this.currentMatchSelectionMaximum - 1;
                    }
                    JSearchTextField.this.matchesLabels[JSearchTextField.this.currentMatchSelectionIndex].highlight();
                }
            }
        });
        parentMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(() -> JSearchTextField.this.requestFocusInWindow());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JSearchTextField.this.matchesPopup.setVisible(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JSearchTextField.this.matchesPopup.setVisible(false);
            }
        });
    }

    private void processMatchSelection(DatabaseItem selection) {
        this.searchFieldHandler.handleSearchSelection(selection);
        this.parentMenu.setVisible(false);
    }

    static /* synthetic */ JMatchPanel[] access$302(JSearchTextField x0, JMatchPanel[] x1) {
        x0.matchesLabels = x1;
        return x1;
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Set<DatabaseItem> matches = JSearchTextField.this.searchFieldHandler.getSearchMatches(JSearchTextField.this.getText());
            this.showMatches(matches);
            ((Timer)evt.getSource()).stop();
        }

        private void showMatches(Set<DatabaseItem> matches) {
            if (matches.isEmpty()) {
                JSearchTextField.this.matchesPopup.setVisible(false);
            } else {
                JSearchTextField.this.matchesPopup.setSize(JSearchTextField.this.parentMenu.getWidth(), matches.size() * 39);
                JSearchTextField.this.matchesPopup.setLocation(((JSearchTextField)JSearchTextField.this).parentMenu.getLocationOnScreen().x, ((JSearchTextField)JSearchTextField.this).parentMenu.getLocationOnScreen().y + JSearchTextField.this.parentMenu.getHeight() - 1);
                JSearchTextField.this.matchesPanel.removeAll();
                int index = 0;
                JSearchTextField.access$302(JSearchTextField.this, new JMatchPanel[matches.size()]);
                for (DatabaseItem match : matches) {
                    ((JSearchTextField)JSearchTextField.this).matchesLabels[index] = new JMatchPanel(match, index);
                    JSearchTextField.this.matchesPanel.add(JSearchTextField.this.matchesLabels[index++]);
                }
                JSearchTextField.this.matchesPopup.setAlwaysOnTop(true);
                JSearchTextField.this.matchesPopup.setVisible(true);
            }
            JSearchTextField.this.currentMatchSelectionIndex = -1;
            JSearchTextField.this.currentMatchSelectionMaximum = matches.size();
        }
    }

    private class JMatchPanel
    extends JPanel
    implements MouseListener {
        private final int indexInMatchesList;
        private boolean mouseInsideLabel;
        private final DatabaseItem databaseItem;

        JMatchPanel(DatabaseItem databaseItem, int indexInMatchesList) {
            this.databaseItem = databaseItem;
            this.indexInMatchesList = indexInMatchesList;
            this.setLayout(new BoxLayout(this, 1));
            this.addGameLabel();
            this.addDatabaseLabel();
            this.setOpaque(!JSearchTextField.this.gradientResultHighlight);
            this.setBackground(UIManager.getColor("MenuItem.background"));
            this.addMouseListener(this);
            this.setBorder(LABEL_COMPOUND_BORDER);
            this.mouseInsideLabel = false;
        }

        public DatabaseItem getSelectedItem() {
            return this.databaseItem;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (JSearchTextField.this.gradientResultHighlight && this.mouseInsideLabel) {
                Painter painter = LABEL_BACKGROUND_PAINTER;
                painter.paint((Graphics2D)g, this, this.getWidth() + 1, this.getHeight());
            }
            super.paintComponent(g);
        }

        private void addGameLabel() {
            JLabel gameName = new JLabel(this.databaseItem.getGameName());
            gameName.setFont(gameFont);
            this.add(gameName);
        }

        private void addDatabaseLabel() {
            JLabel databaseName = new JLabel("- " + this.databaseItem.getDatabase());
            databaseName.setFont(databaseFont);
            databaseName.setForeground(databaseColor);
            this.add(databaseName);
        }

        private void highlight() {
            this.mouseInsideLabel = true;
            if (JSearchTextField.this.gradientResultHighlight) {
                this.repaint();
            } else {
                this.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
            }
            JSearchTextField.this.currentMatchSelectionIndex = this.indexInMatchesList;
        }

        private void unhighlight() {
            this.mouseInsideLabel = false;
            this.setBackground(UIManager.getColor("MenuItem.background"));
            this.setForeground(UIManager.getColor("MenuItem.foreground"));
            if (JSearchTextField.this.gradientResultHighlight) {
                this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JSearchTextField.this.processMatchSelection(((JMatchPanel)e.getSource()).getSelectedItem());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (JSearchTextField.this.currentMatchSelectionIndex != -1) {
                JSearchTextField.this.matchesLabels[JSearchTextField.this.currentMatchSelectionIndex].unhighlight();
            }
            this.highlight();
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

