/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import info.msxlaunchers.openmsx.launcher.ui.view.swing.MainWindow;
import info.msxlaunchers.openmsx.launcher.ui.view.swing.images.Icons;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MessageWindow
extends JDialog
implements ActionListener {
    private final Component mainWindow;
    private final String windowTitle;
    private final String message;
    private final int mode;
    private final String[] buttonLabels;
    private final boolean rightToLeft;
    private JButton[] buttons;
    private int result;
    public static final int ERROR = 0;
    public static final int INFORMATION = 1;
    public static final int WARNING = 2;
    public static final int QUESTION = 3;

    public MessageWindow(Component parent, String title, String message, int mode, String[] buttonLabels, ComponentOrientation orientation) {
        this(parent, title, message, mode, buttonLabels, orientation == ComponentOrientation.RIGHT_TO_LEFT);
    }

    public MessageWindow(Component parent, String title, String message, int mode, String[] buttonLabels, boolean rightToLeft) {
        this.mainWindow = parent;
        this.windowTitle = title;
        this.message = message;
        this.mode = mode;
        this.buttonLabels = buttonLabels;
        this.rightToLeft = rightToLeft;
        this.buttons = new JButton[buttonLabels.length];
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                MessageWindow.this.result = -1;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MessageWindow.this.result = -1;
            }
        });
    }

    public int displayAndGetResult() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.windowTitle);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel messagePane = new JPanel();
        if (this.rightToLeft) {
            messagePane.setLayout(new FlowLayout(2, 15, 10));
        } else {
            messagePane.setLayout(new FlowLayout(0, 15, 10));
        }
        contentPane.add(messagePane);
        JLabel messageLabel = new JLabel(this.message, this.getIconFromMode(this.mode), 11);
        if (this.rightToLeft) {
            messageLabel.setHorizontalAlignment(4);
            messageLabel.setHorizontalTextPosition(2);
        } else {
            messageLabel.setHorizontalAlignment(2);
            messageLabel.setHorizontalTextPosition(4);
        }
        messagePane.add(messageLabel);
        JPanel buttonsPane = new JPanel();
        contentPane.add(buttonsPane);
        for (int counter = 0; counter < this.buttons.length; ++counter) {
            this.buttons[counter] = new JButton(this.buttonLabels[counter]);
            this.buttons[counter].addActionListener(this);
            this.buttons[counter].setPreferredSize(MainWindow.BUTTON_DIMENSION);
            buttonsPane.add(this.buttons[counter]);
        }
        if (this.rightToLeft) {
            buttonsPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        this.pack();
        this.setLocationRelativeTo(this.mainWindow);
        this.setVisible(true);
        return this.result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        for (int counter = 0; counter < this.buttons.length; ++counter) {
            if (source != this.buttons[counter]) continue;
            this.result = counter;
            this.dispose();
            break;
        }
    }

    private ImageIcon getIconFromMode(int mode) {
        ImageIcon icon = null;
        switch (mode) {
            case 0: {
                icon = Icons.ERROR.getImageIcon();
                break;
            }
            case 1: {
                icon = Icons.INFORMATION.getImageIcon();
                break;
            }
            case 2: {
                icon = null;
                break;
            }
            case 3: {
                icon = Icons.QUESTION.getImageIcon();
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode " + mode + " is incorrent");
            }
        }
        return icon;
    }
}

