/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.updater;

import info.msxlaunchers.openmsx.launcher.updater.AbstractLauncherUpdater;
import info.msxlaunchers.openmsx.launcher.updater.FileUpdateFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

final class LinuxBSDLauncherUpdater
extends AbstractLauncherUpdater {
    private final String EXE_FILENAME = "openmsx-launcher.run";
    private final String EXE_FILENAME_UPDATE = "openmsx-launcher.run_starter_update";

    LinuxBSDLauncherUpdater() {
    }

    @Override
    public void startInstallation(String jarFilesDirectory, String executableDirectory, String helpFileDirectory, File zipFile) throws FileUpdateFailedException, IOException {
        this.unzipUpdateFile(jarFilesDirectory, zipFile);
        this.installNewJarFiles(jarFilesDirectory);
        this.installNewStartScript(jarFilesDirectory, executableDirectory);
        this.installNewHelpFile(jarFilesDirectory, helpFileDirectory);
    }

    private void installNewStartScript(String jarFilesDirectory, String executableDirectory) throws FileUpdateFailedException {
        File[] files = new File(jarFilesDirectory).listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().equals("openmsx-launcher.run_starter_update")) continue;
                Path currentExecutable = Paths.get(executableDirectory, "openmsx-launcher.run");
                Path newExecutable = Paths.get(jarFilesDirectory, "openmsx-launcher.run_starter_update");
                try {
                    Set<PosixFilePermission> permissions = Arrays.asList(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE).stream().collect(Collectors.toSet());
                    Files.setPosixFilePermissions(newExecutable, permissions);
                    Files.move(newExecutable, currentExecutable, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ioe) {
                    throw new FileUpdateFailedException();
                }
                return;
            }
        }
    }
}

