/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.vnc;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.free.j64.net.etc.Utils;

public final class ConnectHost
extends JDialog {
    private static final Preferences prefs = Preferences.userNodeForPackage(ConnectHost.class);
    private String host;
    private int port;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public ConnectHost(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Utils.initWindow(this, this.getRootPane(), this.jButton1);
        this.initForm();
        this.setVisible(true);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private void initForm() {
        this.host = prefs.node("Connection").get("host", "localhost");
        this.jTextField1.setText(this.host);
        this.port = prefs.node("Connection").getInt("port", -1);
        this.jTextField2.setText(String.valueOf(this.port));
        this.jTextField1.requestFocusInWindow();
    }

    private void validateForm() {
        this.host = this.jTextField1.getText().trim().toLowerCase();
        this.port = Utils.validateInt(this.jTextField2.getText(), 10, 0, 65536);
        if (this.port != -1 && !this.host.isEmpty()) {
            prefs.node("Connection").put("host", this.host);
            prefs.node("Connection").putInt("port", this.port);
        } else {
            System.err.format("Host must not be empty and port must be between 0 - 65535%n", new Object[0]);
        }
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("OK")) {
            this.validateForm();
        }
        this.setVisible(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jTextField2 = new JTextField();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Connect to host");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.jLabel1.setDisplayedMnemonic('H');
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setLabelFor(this.jTextField1);
        this.jLabel1.setText("Hostname");
        this.jTextField1.setFont(new Font("Dialog", 1, 16));
        this.jTextField1.setToolTipText("Enter hostname or IP address");
        this.jButton1.setMnemonic('O');
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectHost.this.actionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("Dialog", 1, 14));
        this.jButton2.setMnemonic('C');
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectHost.this.actionPerformed(evt);
            }
        });
        this.jTextField2.setFont(new Font("Dialog", 1, 16));
        this.jLabel2.setDisplayedMnemonic('P');
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setLabelFor(this.jTextField2);
        this.jLabel2.setText("Port");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTextField1).addGap(43, 43, 43)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, 75, -2)))).addContainerGap(187, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addGap(60, 60, 60)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap()));
        layout.linkSize(1, this.jButton1, this.jButton2);
        this.pack();
    }
}

