/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.vnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public final class Utils {
    private Utils() {
    }

    public static SimpleAttributeSet getAttributes(Color color, int size) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.CharacterConstants.Foreground, color);
        attr.addAttribute(StyleConstants.FontSize, size);
        return attr;
    }

    public static void initWindow(Window win, JRootPane rp, JButton btn) {
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        win.setLocation((sz.width - win.getWidth()) / 2, (sz.height - win.getHeight()) / 2);
        rp.setDefaultButton(btn);
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
    }

    public static List<String> split(String str, String pattern) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : str.split(pattern)) {
            if (s.isEmpty()) continue;
            t.add(s);
        }
        return t;
    }

    public static int validateInt(String num, int radix, int low, int high) {
        String s = num.trim();
        try {
            int n = s.startsWith("$") ? Integer.parseInt(s.substring(1), 16) : Integer.parseInt(s, radix);
            if (n >= low && n < high) {
                return n;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return -1;
    }
}

