/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.app;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.free.j64.app.C64;
import org.free.j64.cpu.CPU;
import org.free.j64.etc.Utils;
import org.free.j64.gui.Admin;
import org.free.j64.gui.Dump;
import org.free.j64.gui.FileList;
import org.free.j64.gui.Patch;
import org.free.j64.io.Audio;
import org.free.j64.io.Keyboard;
import org.free.j64.io.Loader;
import org.free.j64.io.Screen;
import org.free.j64.net.Net;
import org.free.j64.net.chat.Client;
import org.free.j64.net.type.Key;

public final class Desktop
extends JFrame {
    public static final String debugFile = String.format("c64-debug-%s.log", Utils.localDate);
    public static final String DEBUG_BORDER = "==================================================";
    public static final Preferences appPrefs = Preferences.userNodeForPackage(Desktop.class);
    private static final String updateAbout = String.format("%s%n%s%n", String.format("10 ? CHR$(147): ? \"JAC 64 V%s (UNOFFICIAL) UPDATE\"", "1.3.0rc1"), "20 ? \"2011-13 OSMANPUB@GMAIL.COM\"\nrun");
    private static final Font menuFont = new Font("Dialog", 1, 13);
    private static final FileFilter openProgram = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return Utils.isAcceptProgram(f);
        }

        @Override
        public String getDescription() {
            return "C64 files (d64|prg|t64)";
        }
    };
    private static final FileFilter savePicture = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return Utils.isAcceptPicture(f);
        }

        @Override
        public String getDescription() {
            return "Picture files (bmp|gif|jpg)";
        }
    };
    private static String progDir = appPrefs.node("File").get("FileDir", System.getProperties().getProperty("user.dir", ""));
    private static boolean saveDump;
    private boolean fullScreen;
    private boolean inGame;
    private int colorSet;
    private JSlider jSlider1;
    private Admin adminForm;
    private Client chatForm;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBoxMenuItem jCheckBoxMenuItem2;
    private JFileChooser jFileChooser1;
    private JMenu jMenu1;
    private JMenu jMenu10;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenu jMenu7;
    private JMenu jMenu8;
    private JMenu jMenu9;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem14;
    private JMenuItem jMenuItem15;
    private JMenuItem jMenuItem16;
    private JMenuItem jMenuItem17;
    private JMenuItem jMenuItem18;
    private JMenuItem jMenuItem19;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem20;
    private JMenuItem jMenuItem21;
    private JMenuItem jMenuItem22;
    private JMenuItem jMenuItem23;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JRadioButtonMenuItem jRadioButtonMenuItem1;
    private JRadioButtonMenuItem jRadioButtonMenuItem2;
    private JRadioButtonMenuItem jRadioButtonMenuItem3;
    private JRadioButtonMenuItem jRadioButtonMenuItem4;
    private JRadioButtonMenuItem jRadioButtonMenuItem5;
    private JRadioButtonMenuItem jRadioButtonMenuItem6;
    private JRadioButtonMenuItem jRadioButtonMenuItem7;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Desktop();
            }
        });
    }

    Desktop() {
        this.initComponents();
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                C64.C64.init();
                return null;
            }

            @Override
            protected void done() {
                Desktop.this.initScreen();
                Desktop.this.loadPrefs();
            }
        }.execute();
        this.configureQuickLoad();
        if (!progDir.isEmpty()) {
            this.buildProgramMenu(progDir);
        }
        this.loadWindowPrefs();
    }

    public static String getProgDir() {
        return progDir;
    }

    public static void setProgDir(String progDir) {
        Desktop.progDir = progDir;
    }

    public static boolean saveDump() {
        return saveDump;
    }

    private void keyPressed(int key, KeyEvent e) {
        switch (key) {
            case 67: {
                if (e.isControlDown()) {
                    this.setColorSet(this.colorSet != 3 ? this.colorSet + 1 : 0);
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 68: {
                if (this.jMenuItem19.isEnabled()) {
                    if (e.isControlDown()) {
                        this.debug();
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 70: {
                if (this.jCheckBoxMenuItem2.isEnabled()) {
                    if (e.isControlDown()) {
                        this.jCheckBoxMenuItem2.setSelected(!this.jCheckBoxMenuItem2.isSelected());
                        saveDump = this.jCheckBoxMenuItem2.isSelected();
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 74: {
                if (e.isControlDown()) {
                    if (this.jRadioButtonMenuItem5.isEnabled()) {
                        this.setJoyStick(2);
                        break;
                    }
                    if (this.jRadioButtonMenuItem6.isEnabled()) {
                        this.setJoyStick(0);
                        break;
                    }
                    if (!this.jRadioButtonMenuItem7.isEnabled()) break;
                    this.setJoyStick(1);
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 77: {
                if (this.jMenuItem18.isEnabled()) {
                    if (e.isControlDown()) {
                        new Dump((Frame)this, false);
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 79: {
                if (this.jMenuItem1.isEnabled()) {
                    if (e.isControlDown()) {
                        this.openFile();
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 80: {
                if (this.jMenuItem20.isEnabled()) {
                    if (e.isControlDown()) {
                        new Patch((Frame)this, false);
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 81: {
                if (e.isControlDown()) {
                    this.quitDesktop();
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 83: {
                if (this.jMenuItem21.isEnabled()) {
                    if (e.isControlDown()) {
                        this.screenDump();
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 86: {
                if (this.jMenu9.isEnabled()) {
                    if (e.isControlDown()) {
                        this.pasteText();
                        break;
                    }
                    C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                    break;
                }
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
                break;
            }
            case 119: {
                if (!this.jMenuItem15.isEnabled()) break;
                Screen.SCREEN.restoreKey(true);
                break;
            }
            case 19: {
                this.pause();
                break;
            }
            default: {
                C64.C64.addKey(new Key(key), C64.C64.getJoyStick(false));
            }
        }
    }

    private void keyReleased(int key) {
        switch (key) {
            case 113: {
                this.toggleSound();
                break;
            }
            case 116: {
                if (!this.jMenu9.isEnabled()) break;
                this.text("run~", true);
                break;
            }
            case 117: {
                if (!this.jMenu9.isEnabled()) break;
                this.text("list~", true);
                break;
            }
            case 118: {
                if (!this.jMenu9.isEnabled()) break;
                C64.C64.simulateBreak(50);
                break;
            }
            case 119: {
                if (!this.jMenuItem15.isEnabled()) break;
                Screen.SCREEN.restoreKey(false);
                break;
            }
            case 120: {
                if (!this.jMenuItem5.isEnabled()) break;
                this.reset(true);
                break;
            }
            case 121: {
                if (!this.jMenuItem6.isEnabled()) break;
                this.reset(false);
                break;
            }
            case 122: {
                this.setFullScreen(!this.fullScreen);
                break;
            }
            case 123: {
                if (!this.jMenuItem10.isEnabled()) break;
                this.throttleCPU();
                break;
            }
            case 154: {
                this.screenCapture();
                break;
            }
            default: {
                C64.C64.addKey(new Key(~key), C64.C64.getJoyStick(false));
            }
        }
    }

    private void actionLoad(ActionEvent e) {
        String cmd = e.getActionCommand();
        Preferences p = appPrefs.node("QuickLoad");
        if (cmd.startsWith("Clear All")) {
            this.eraseAllQuickLoad(p);
            return;
        }
        C64.C64.texting = false;
        String key = e.getActionCommand();
        String value = p.get(key, "");
        if (!value.isEmpty()) {
            this.autoLoad(value);
        } else {
            this.menuLoad(key);
        }
    }

    private void autoLoad(String value) {
        if (value.startsWith("@")) {
            this.text(Utils.getText(value.substring(1)), true);
        } else {
            String[] file = value.split(":");
            if (file != null) {
                C64.C64.buildProgramList(file[0]);
                this.run(file[1]);
            }
        }
    }

    private void menuLoad(String key) {
        String[] file;
        if (key.contains(":")) {
            String[] file2 = key.split(":");
            if (file2 != null) {
                this.load(file2[0], file2[1]);
            }
        } else if (key.contains("@") && (file = key.split("@")) != null) {
            this.loadListing(file[0], file[1]);
        }
    }

    private void load(String path, String name) {
        C64.C64.buildProgramList(path);
        FileList f = new FileList((Frame)this, true, Loader.LOADER.getList());
        String selected = f.getFile();
        if (!selected.isEmpty()) {
            this.run(selected);
            appPrefs.node("QuickLoad").put(name, path + ":" + selected);
            this.configureQuickLoad();
        }
    }

    private void loadListing(String program, String file) {
        this.text(Utils.getText(program), true);
        Preferences p = appPrefs.node("QuickLoad");
        if (p.get(file, "").isEmpty()) {
            p.put(file, "@" + program);
            this.configureQuickLoad();
        }
    }

    private void openFile() {
        this.openProgram();
        if (this.jFileChooser1.showOpenDialog(this) == 0) {
            String path = this.jFileChooser1.getSelectedFile().toString();
            String name = this.jFileChooser1.getSelectedFile().getName();
            C64.C64.texting = false;
            this.buildProgramMenu(path);
            if (!Utils.getExtension(path).equals("txt")) {
                this.load(path, name);
            } else {
                this.loadListing(path, name);
            }
            progDir = path;
        }
        this.jFileChooser1.setVisible(false);
    }

    private void run(String program) {
        this.enableMenus(false);
        this.inGame = true;
        Loader.LOADER.load(program);
        this.text("run~", false);
        C64.C64.throttleCPUTime(60000);
    }

    private void text(final String msg, final boolean enable) {
        if (msg.isEmpty()) {
            return;
        }
        this.enableTextMenus(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                C64.C64.text(msg);
                return null;
            }

            @Override
            protected void done() {
                Desktop.this.enableTextMenus(enable);
            }
        }.execute();
    }

    private void text(final List<String> msg, final boolean enable) {
        if (msg.isEmpty()) {
            return;
        }
        this.enableTextMenus(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                C64.C64.text(msg);
                return null;
            }

            @Override
            protected void done() {
                Desktop.this.enableTextMenus(enable);
            }
        }.execute();
    }

    private void configureSlider() {
        this.jSlider1 = new JSlider();
        this.jSlider1.setAutoscrolls(true);
        this.jSlider1.setFont(new Font("SansSerif", 1, 13));
        this.jSlider1.setMajorTickSpacing(10);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setMaximum(10);
        this.jSlider1.setMinimum(0);
        this.jSlider1.setOrientation(1);
        this.jSlider1.setValue(5);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, new JLabel("Slow"));
        labelTable.put(5, new JLabel("Normal"));
        labelTable.put(10, new JLabel("Fast"));
        this.jSlider1.setLabelTable(labelTable);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Desktop.this.actionStateChanged(e);
            }
        });
        this.getContentPane().add((Component)this.jSlider1, "East");
        if (Audio.AUDIO.hasSound()) {
            this.jSlider1.setVisible(false);
        }
    }

    private void configureQuickLoad() {
        this.jMenu8.removeAll();
        try {
            for (String s : appPrefs.node("QuickLoad").keys()) {
                this.addProgMenuItem(this.jMenu8, s, s);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        this.jMenu8.add(new JSeparator());
        this.addProgMenuItem(this.jMenu8, "Clear All", "Clear All");
    }

    private void initScreen() {
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)Screen.Canvas.CANVAS.getPanel(), "Center");
        this.configureSlider();
        if (C64.C64.isServer()) {
            this.jMenuItem14.setText("Server Off");
            this.jMenuItem22.setEnabled(true);
        }
        this.setTitle("JaC64");
        this.setVisible(true);
    }

    private void openProgram() {
        this.jFileChooser1.setDialogTitle("Open C64 File");
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setFileFilter(openProgram);
        this.jFileChooser1.removeChoosableFileFilter(savePicture);
        this.jFileChooser1.setCurrentDirectory(new File(progDir));
        Utils.showChooser(this.jFileChooser1);
    }

    private void savePicture() {
        this.jFileChooser1.setDialogTitle("Save Screenshot");
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setFileFilter(savePicture);
        this.jFileChooser1.removeChoosableFileFilter(openProgram);
        this.jFileChooser1.setCurrentDirectory(new File(progDir));
        Utils.showChooser(this.jFileChooser1);
    }

    private void eraseAllQuickLoad(Preferences p) {
        this.jMenu8.removeAll();
        try {
            p.clear();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void addProgMenu(JMenu[] progMenus, String file, String path) {
        char c = file.toUpperCase().charAt(0);
        int i = 0;
        if (Character.isLetter(c)) {
            i = Character.toUpperCase(c) - 65;
        } else if (Character.isDigit(c)) {
            i = progMenus.length - 1;
        }
        if (progMenus[i] == null) {
            JMenu m = new JMenu();
            if (i != progMenus.length - 1) {
                m.setMnemonic(c);
                m.setText(Character.toString(c));
            } else {
                m.setMnemonic('0');
                m.setText("0 - 9");
            }
            m.setFont(menuFont);
            progMenus[i] = m;
            this.jMenu7.add(m);
        }
        if (!Utils.getExtension(file).equals("txt")) {
            this.addProgMenuItem(progMenus[i], file, path + ":" + file);
        } else {
            this.addProgMenuItem(progMenus[i], file, path + "@" + file);
        }
    }

    private void addProgMenuItem(JMenu jm, String file, String command) {
        JMenuItem m = new JMenuItem(Utils.getFileName(file));
        m.setFont(menuFont);
        m.setActionCommand(command);
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionLoad(evt);
            }
        });
        jm.add(m);
    }

    private void buildProgramMenu(final String path) {
        this.jMenu7.setEnabled(false);
        new SwingWorker<Void, Void>(){
            List<File> dir;

            @Override
            protected Void doInBackground() {
                this.dir = Utils.getFileList(path);
                return null;
            }

            @Override
            protected void done() {
                if (this.dir.isEmpty()) {
                    return;
                }
                Desktop.this.jMenu7.removeAll();
                JMenu[] progMenus = new JMenu[27];
                for (File f : this.dir) {
                    if (!f.isFile()) continue;
                    Desktop.this.addProgMenu(progMenus, f.getName(), f.getPath());
                }
                Desktop.this.jMenu7.setEnabled(true);
            }
        }.execute();
    }

    private void enableMenus(boolean m) {
        this.jMenuItem1.setEnabled(m);
        this.jMenuItem4.setEnabled(m);
        this.jMenu7.setEnabled(m);
        this.jMenu8.setEnabled(m);
        this.jMenu9.setEnabled(m);
    }

    private void enableTextMenus(boolean m) {
        this.jMenuItem4.setEnabled(m);
        this.jMenu9.setEnabled(m);
    }

    private void debug() {
        CPU.CPU.toggleDebug();
        if (CPU.CPU.isDebug()) {
            this.setTitle("JaC64: DEBUG MODE");
        } else {
            this.setTitle("JaC64");
        }
    }

    private void loadPrefs() {
        Preferences p = appPrefs.node("Menus");
        this.setColorSet(p.getInt("ColorSet", 0));
        this.setJoyStick(p.getInt("Joystick", 1));
    }

    private void loadWindowPrefs() {
        Preferences p = appPrefs.node("Window");
        int w = p.getInt("Width", -1);
        int h = p.getInt("Height", -1);
        if (w != -1 && h != -1) {
            this.setSize(w, h);
        } else {
            this.setSize(800, 600);
        }
        int x = p.getInt("X", -1);
        int y = p.getInt("Y", -1);
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        } else {
            Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((sz.width - this.getWidth()) / 2, (sz.height - this.getHeight()) / 2);
        }
        int s = p.getInt("ExtendedState", -1);
        if (s != -1) {
            this.setExtendedState(s);
        } else {
            this.setExtendedState(6);
        }
    }

    private void savePrefs() {
        Preferences p = appPrefs.node("Window");
        p.putInt("Width", this.getWidth());
        p.putInt("Height", this.getHeight());
        p.putInt("X", this.getX());
        p.putInt("Y", this.getY());
        p.putInt("ExtendedState", this.getExtendedState());
        p = appPrefs.node("File");
        p.put("FileDir", progDir);
        p = appPrefs.node("Menus");
        p.putInt("ColorSet", this.colorSet);
        p.putInt("Joystick", Keyboard.KEYBOARD.getJoyStick() == Keyboard.JoyStick.ONE ? 1 : 2);
    }

    private void pasteText() {
        String txt = Utils.getClipboardContents();
        if (txt.isEmpty()) {
            return;
        }
        this.text(Arrays.asList(txt.split("\n")), true);
    }

    private void pause() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                C64.C64.pause();
                return null;
            }

            @Override
            protected void done() {
                if (Desktop.this.jMenuItem12.getText().equalsIgnoreCase("pause")) {
                    this.enablePauseMenus(false);
                    Desktop.this.jMenuItem12.setText("Resume");
                    Desktop.this.jMenuItem12.setMnemonic('e');
                } else {
                    this.enablePauseMenus(true);
                    Desktop.this.jMenuItem12.setText("Pause");
                    Desktop.this.jMenuItem12.setMnemonic('P');
                }
            }

            private void enablePauseMenus(boolean enable) {
                if (!Desktop.this.inGame) {
                    Desktop.this.enableMenus(enable);
                }
                Desktop.this.jMenu2.setEnabled(enable);
                Desktop.this.jMenu5.setEnabled(enable);
                Desktop.this.jMenuItem5.setEnabled(enable);
                Desktop.this.jMenuItem6.setEnabled(enable);
                Desktop.this.jMenuItem10.setEnabled(enable);
                Desktop.this.jMenuItem15.setEnabled(enable);
                Desktop.this.jMenuItem16.setEnabled(enable);
                Desktop.this.jMenuItem18.setEnabled(enable);
                Desktop.this.jMenuItem19.setEnabled(enable);
                Desktop.this.jMenuItem20.setEnabled(enable);
                Desktop.this.jMenuItem21.setEnabled(enable);
            }
        }.execute();
    }

    private void quitDesktop() {
        this.setVisible(false);
        if (this.adminForm != null) {
            this.adminForm.quit();
        }
        if (this.chatForm != null) {
            this.chatForm.quit();
        }
        this.savePrefs();
        try {
            C64.C64.stop();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.exit(0);
    }

    private void reset(final boolean soft) {
        this.enableMenus(false);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                C64.C64.reset(soft);
                return null;
            }

            @Override
            protected void done() {
                Desktop.this.enableMenus(true);
                Desktop.this.inGame = false;
            }
        }.execute();
    }

    private void screenCapture() {
        final boolean oldScreen = this.fullScreen;
        if (!this.fullScreen) {
            this.setFullScreen(true);
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                if (!oldScreen) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                try {
                    BufferedImage capture = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
                    Desktop.this.savePicture();
                    if (Desktop.this.jFileChooser1.showSaveDialog(Desktop.this) == 0) {
                        String path = Desktop.this.jFileChooser1.getSelectedFile().toString();
                        String name = Desktop.this.jFileChooser1.getSelectedFile().getName();
                        try {
                            ImageIO.write((RenderedImage)capture, Utils.getExtension(name), new File(path));
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        progDir = path;
                    }
                    Desktop.this.jFileChooser1.setVisible(false);
                }
                catch (AWTException ex) {
                    Logger.getLogger(Desktop.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            protected void done() {
                if (!oldScreen) {
                    Desktop.this.setFullScreen(false);
                }
            }
        }.execute();
    }

    private void screenDump() {
        if (this.jCheckBoxMenuItem2.isSelected()) {
            String localTime = new SimpleDateFormat("yy-MM-dd hh:mm:ss", Locale.ENGLISH).format(new Date());
            String header = String.format("%s%nSCREEN DUMP %s%n%s%n", DEBUG_BORDER, localTime, DEBUG_BORDER);
            Utils.appendTextFile(debugFile, String.format("%s%s", header, Screen.Renderer.RENDERER.dump()));
            System.out.format("%s file updated: action screen dump%n", debugFile);
        } else {
            System.out.println(Screen.Renderer.RENDERER.dump());
        }
    }

    private void setColorSet(int i) {
        Screen.SCREEN.setColorSet(i);
        this.colorSet = i;
        switch (this.colorSet) {
            default: {
                this.jRadioButtonMenuItem1.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonMenuItem2.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonMenuItem3.setSelected(true);
                break;
            }
            case 3: {
                this.jRadioButtonMenuItem4.setSelected(true);
            }
        }
    }

    private void setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
        GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(fullScreen ? this : null);
    }

    private void setJoyStick(int js) {
        switch (js) {
            case 1: {
                C64.C64.twoPlayer = false;
                Keyboard.KEYBOARD.setJoyStick(Keyboard.JoyStick.ONE);
                this.jRadioButtonMenuItem5.setSelected(true);
                break;
            }
            case 2: {
                C64.C64.twoPlayer = false;
                Keyboard.KEYBOARD.setJoyStick(Keyboard.JoyStick.TWO);
                this.jRadioButtonMenuItem6.setSelected(true);
                break;
            }
            default: {
                C64.C64.twoPlayer = true;
                this.jRadioButtonMenuItem7.setSelected(true);
            }
        }
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this, "JaC64 version: 1.3.0rc1\nJaC64 is a Java-based C64 emulator by Joakim Eriksson\nThe SID emulation uses the resid Java port by Ken Hindel\n\nFor more information see: http://www.jathis.com/", "JaC64 - The Java C64 Emulator", 1);
    }

    private void showUpdate() {
        this.text(Arrays.asList(updateAbout.split("\n")), true);
    }

    private void startAdmin() {
        this.adminForm = new Admin(new Admin.Callback(){

            @Override
            public void enableMenus() {
                Desktop.this.jMenuItem23.setEnabled(true);
                Desktop.this.adminForm = null;
            }
        });
        this.jMenuItem23.setEnabled(false);
    }

    private void startChat() {
        this.chatForm = new Client(Net.ServerSession.SS.getChatSession(), new Client.Callback(){

            @Override
            public void enableMenus() {
                Desktop.this.jMenuItem22.setEnabled(true);
                Desktop.this.chatForm = null;
            }
        });
        this.jMenuItem22.setEnabled(false);
    }

    private void toggleServer() {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                if (!C64.C64.isServer()) {
                    C64.C64.startServer();
                } else {
                    C64.C64.stopServer();
                }
                return null;
            }

            @Override
            protected void done() {
                if (C64.C64.isServer()) {
                    Desktop.this.jMenuItem14.setText("Server Off");
                    Desktop.this.jMenuItem22.setEnabled(true);
                } else {
                    Desktop.this.jMenuItem14.setText("Server On");
                    Desktop.this.jMenuItem22.setEnabled(false);
                }
            }
        }.execute();
    }

    private void toggleSound() {
        boolean soundOn = !Audio.AUDIO.isSound();
        Audio.AUDIO.setSound(soundOn);
        if (soundOn) {
            this.jMenuItem16.setText("Sound Off");
        } else {
            this.jMenuItem16.setText("Sound On");
        }
    }

    private void throttleCPU() {
        if (this.jSlider1.isVisible()) {
            this.jSlider1.setValue(this.jSlider1.getMaximum());
        } else {
            C64.C64.throttleCPU();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jFileChooser1 = new JFileChooser();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu8 = new JMenu();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem13 = new JMenuItem();
        this.jMenuItem17 = new JMenuItem();
        this.jMenuItem16 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem12 = new JMenuItem();
        this.jMenuItem15 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem11 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenu4 = new JMenu();
        this.jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem3 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem4 = new JRadioButtonMenuItem();
        this.jMenu6 = new JMenu();
        this.jRadioButtonMenuItem5 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem6 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem7 = new JRadioButtonMenuItem();
        this.jMenu7 = new JMenu();
        this.jMenu9 = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem3 = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem19 = new JMenuItem();
        this.jMenuItem18 = new JMenuItem();
        this.jMenuItem20 = new JMenuItem();
        this.jMenuItem21 = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
        this.jMenu10 = new JMenu();
        this.jMenuItem14 = new JMenuItem();
        this.jMenuItem22 = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItem23 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jFileChooser1.setDialogTitle("Open File");
        this.jFileChooser1.setFont(new Font("Dialog", 0, 14));
        this.jFileChooser1.setName("fileChooser");
        this.jFileChooser1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("JaC64 - A Java C64 Emulator");
        this.setBackground(Color.black);
        this.setBounds(new Rectangle(400, 300, 800, 600));
        this.setForeground(Color.black);
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(640, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Desktop.this.windowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Desktop.this.keyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                Desktop.this.keyReleased(evt);
            }
        });
        this.jMenu1.setMnemonic('C');
        this.jMenu1.setText("C64");
        this.jMenu1.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem1.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem1.setMnemonic('O');
        this.jMenuItem1.setText("Open");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu8.setMnemonic('Q');
        this.jMenu8.setText("Quick Load");
        this.jMenu8.setFont(new Font("Dialog", 1, 13));
        this.jMenu1.add(this.jMenu8);
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.jMenuItem13.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem13.setMnemonic('F');
        this.jMenuItem13.setText("Full Screen");
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem13);
        this.jMenuItem17.setAccelerator(KeyStroke.getKeyStroke(154, 0));
        this.jMenuItem17.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem17.setMnemonic('i');
        this.jMenuItem17.setText("Print Screen");
        this.jMenuItem17.setToolTipText("");
        this.jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem17);
        this.jMenuItem16.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.jMenuItem16.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem16.setMnemonic('S');
        this.jMenuItem16.setLabel("Sound Off");
        this.jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem16);
        this.jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.jMenuItem10.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem10.setMnemonic('T');
        this.jMenuItem10.setText("Throttle CPU");
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem10);
        this.jMenu1.add(this.jSeparator2);
        this.jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(19, 0));
        this.jMenuItem12.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem12.setMnemonic('P');
        this.jMenuItem12.setText("Pause");
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem12);
        this.jMenuItem15.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.jMenuItem15.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem15.setMnemonic('s');
        this.jMenuItem15.setText("Restore");
        this.jMenu1.add(this.jMenuItem15);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        this.jMenuItem5.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem5.setMnemonic('R');
        this.jMenuItem5.setText("Reset");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(121, 0));
        this.jMenuItem6.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem6.setMnemonic('H');
        this.jMenuItem6.setText("Hard Reset");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenu1.add(this.jSeparator4);
        this.jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem11.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem11.setMnemonic('Q');
        this.jMenuItem11.setText("Quit");
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem11);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setMnemonic('S');
        this.jMenu2.setText("Settings");
        this.jMenu2.setFont(new Font("Dialog", 1, 13));
        this.jMenu4.setMnemonic('C');
        this.jMenu4.setText("Color");
        this.jMenu4.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem1.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.buttonGroup1.add(this.jRadioButtonMenuItem1);
        this.jRadioButtonMenuItem1.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem1.setSelected(true);
        this.jRadioButtonMenuItem1.setText("Original");
        this.jRadioButtonMenuItem1.setActionCommand("Color Original");
        this.jRadioButtonMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItem1);
        this.jRadioButtonMenuItem2.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.buttonGroup1.add(this.jRadioButtonMenuItem2);
        this.jRadioButtonMenuItem2.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem2.setText("Darker");
        this.jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItem2);
        this.jRadioButtonMenuItem3.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.buttonGroup1.add(this.jRadioButtonMenuItem3);
        this.jRadioButtonMenuItem3.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem3.setText("Softer");
        this.jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItem3);
        this.jRadioButtonMenuItem4.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.buttonGroup1.add(this.jRadioButtonMenuItem4);
        this.jRadioButtonMenuItem4.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem4.setText("WinVICE");
        this.jRadioButtonMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItem4);
        this.jMenu2.add(this.jMenu4);
        this.jMenu6.setMnemonic('J');
        this.jMenu6.setText("Joystick");
        this.jMenu6.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem5.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.buttonGroup2.add(this.jRadioButtonMenuItem5);
        this.jRadioButtonMenuItem5.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem5.setSelected(true);
        this.jRadioButtonMenuItem5.setText("One");
        this.jRadioButtonMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jRadioButtonMenuItem5);
        this.jRadioButtonMenuItem6.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.buttonGroup2.add(this.jRadioButtonMenuItem6);
        this.jRadioButtonMenuItem6.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem6.setText("Two");
        this.jRadioButtonMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jRadioButtonMenuItem6);
        this.jRadioButtonMenuItem7.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.buttonGroup2.add(this.jRadioButtonMenuItem7);
        this.jRadioButtonMenuItem7.setFont(new Font("Dialog", 1, 13));
        this.jRadioButtonMenuItem7.setMnemonic('2');
        this.jRadioButtonMenuItem7.setText("2 Player");
        this.jRadioButtonMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jRadioButtonMenuItem7);
        this.jMenu2.add(this.jMenu6);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu7.setMnemonic('P');
        this.jMenu7.setText("Programs");
        this.jMenu7.setFont(new Font("Dialog", 1, 13));
        this.jMenuBar1.add(this.jMenu7);
        this.jMenu9.setMnemonic('o');
        this.jMenu9.setText("Commands");
        this.jMenu9.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.jMenuItem8.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem8.setMnemonic('R');
        this.jMenuItem8.setText("Run");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem8);
        this.jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jMenuItem7.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem7.setMnemonic('L');
        this.jMenuItem7.setText("List");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem7);
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.jMenuItem9.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem9.setMnemonic('B');
        this.jMenuItem9.setText("Break");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem9);
        this.jMenu9.add(this.jSeparator3);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem3.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem3.setMnemonic('P');
        this.jMenuItem3.setText("Paste");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu9.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu9);
        this.jMenu5.setMnemonic('D');
        this.jMenu5.setText("Debug");
        this.jMenuItem19.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.jMenuItem19.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem19.setMnemonic('D');
        this.jMenuItem19.setText("Debug Off");
        this.jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem19);
        this.jMenuItem18.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jMenuItem18.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem18.setMnemonic('M');
        this.jMenuItem18.setText("Dump Memory");
        this.jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem18);
        this.jMenuItem20.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.jMenuItem20.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem20.setMnemonic('P');
        this.jMenuItem20.setText("Patch Memory");
        this.jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem20);
        this.jMenuItem21.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem21.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem21.setMnemonic('V');
        this.jMenuItem21.setText("VIC/SID Dump");
        this.jMenuItem21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem21);
        this.jMenu5.add(this.jSeparator5);
        this.jCheckBoxMenuItem2.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jCheckBoxMenuItem2.setFont(new Font("Dialog", 1, 13));
        this.jCheckBoxMenuItem2.setMnemonic('F');
        this.jCheckBoxMenuItem2.setText("Save to File");
        this.jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jCheckBoxMenuItem2);
        this.jMenuBar1.add(this.jMenu5);
        this.jMenu10.setMnemonic('N');
        this.jMenu10.setText("Network");
        this.jMenu10.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem14.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem14.setMnemonic('S');
        this.jMenuItem14.setText("Server on");
        this.jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jMenuItem14);
        this.jMenuItem22.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.jMenuItem22.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem22.setMnemonic('C');
        this.jMenuItem22.setText("Chat");
        this.jMenuItem22.setEnabled(false);
        this.jMenuItem22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jMenuItem22);
        this.jMenu10.add(this.jSeparator6);
        this.jMenuItem23.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuItem23.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem23.setMnemonic('A');
        this.jMenuItem23.setText("Admin");
        this.jMenuItem23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu10.add(this.jMenuItem23);
        this.jMenuBar1.add(this.jMenu10);
        this.jMenu3.setMnemonic('H');
        this.jMenu3.setText("Help");
        this.jMenu3.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem2.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem2.setMnemonic('A');
        this.jMenuItem2.setText("About");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenuItem4.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem4.setMnemonic('U');
        this.jMenuItem4.setText("Update");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.actionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 529, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 330, Short.MAX_VALUE));
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("Open")) {
            this.openFile();
        } else if (cmd.startsWith("Full")) {
            this.setFullScreen(!this.fullScreen);
        } else if (cmd.startsWith("Print")) {
            this.screenCapture();
        } else if (cmd.startsWith("Sound")) {
            this.toggleSound();
        } else if (cmd.startsWith("Throttle CPU")) {
            this.throttleCPU();
        } else if (cmd.startsWith("Pause") || cmd.startsWith("Resume")) {
            this.pause();
        } else if (cmd.startsWith("Reset")) {
            this.reset(true);
        } else if (cmd.startsWith("Hard")) {
            this.reset(false);
        } else if (cmd.startsWith("Quit")) {
            this.quitDesktop();
        } else if (cmd.startsWith("Color Original")) {
            this.setColorSet(0);
        } else if (cmd.startsWith("Darker")) {
            this.setColorSet(1);
        } else if (cmd.startsWith("Softer")) {
            this.setColorSet(2);
        } else if (cmd.startsWith("WinVICE")) {
            this.setColorSet(3);
        } else if (cmd.startsWith("One")) {
            this.setJoyStick(1);
        } else if (cmd.startsWith("Two")) {
            this.setJoyStick(2);
        } else if (cmd.startsWith("2 Player")) {
            this.setJoyStick(0);
        } else if (cmd.startsWith("Run")) {
            this.text("run~", true);
        } else if (cmd.startsWith("Break")) {
            C64.C64.simulateBreak(50);
        } else if (cmd.startsWith("List")) {
            this.text("list~", true);
        } else if (cmd.startsWith("Paste")) {
            this.pasteText();
        } else if (cmd.startsWith("Debug")) {
            this.debug();
        } else if (cmd.startsWith("Dump")) {
            new Dump((Frame)this, false);
        } else if (cmd.startsWith("Patch")) {
            new Patch((Frame)this, false);
        } else if (cmd.startsWith("VIC")) {
            this.screenDump();
        } else if (cmd.startsWith("Save")) {
            saveDump = this.jCheckBoxMenuItem2.isSelected();
        } else if (cmd.startsWith("Server")) {
            this.toggleServer();
        } else if (cmd.startsWith("Chat")) {
            this.startChat();
        } else if (cmd.startsWith("Admin")) {
            this.startAdmin();
        } else if (cmd.startsWith("About")) {
            this.showAbout();
        } else if (cmd.startsWith("Update")) {
            this.showUpdate();
        }
    }

    private void actionStateChanged(ChangeEvent e) {
        JSlider sl;
        if (e.getSource().equals(this.jSlider1) && !(sl = (JSlider)e.getSource()).getValueIsAdjusting()) {
            C64.C64.throttleCPU(sl.getValue(), sl.getMaximum());
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.quitDesktop();
    }

    private void keyPressed(KeyEvent evt) {
        if (evt.getSource().equals(this)) {
            this.keyPressed(evt.getKeyCode(), evt);
        }
    }

    private void keyReleased(KeyEvent evt) {
        if (evt.getSource().equals(this)) {
            this.keyReleased(evt.getKeyCode());
        }
    }
}

