/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.cpu;

import java.util.HashMap;
import java.util.Map;

final class Ops {
    static final int NMI_DELAY = 2;
    static final int IRQ_DELAY = 2;
    static final int NMI_INT = 1;
    static final int IRQ_INT = 2;
    static final String[] INS_STR = new String[]{"BRK", "ORA", "TRP", "SLO", "NOP", "ASL", "PHP", "ANC", "BPL", "CLC", "JSR", "AND", "RLA", "BIT", "ROL", "PLP", "BMI", "SEC", "RTI", "EOR", "SRE", "LSR", "PHA", "ASR", "JMP", "BVC", "CLI", "RTS", "ADC", "RRA", "ROR", "PLA", "ARR", "BVS", "SEI", "SAX", "STA", "STY", "STX", "DEY", "TXA", "ANE", "BCC", "SHA", "TYA", "TXS", "SHS", "SHY", "SHX", "LDY", "LDA", "LDX", "LAX", "TAX", "LXA", "TAY", "BCS", "CLV", "TSX", "LAS", "CPY", "CMP", "DCP", "DEC", "INY", "DEX", "SBX", "BNE", "CLD", "CPX", "SBC", "ISB", "INC", "INX", "BEQ", "SED", "X-LOAD_FILE", "X-SLEEP"};
    static final String[] ADR_STR_PRE = new String[]{" ", " #", " Z ", " ", " Z ", " Z ", " ", " ", " ", " (", " (", " ACC", " ("};
    static final String[] ADR_STR_POST = new String[]{"", "", "", "", ",X", ",Y", ",X", ",Y", "", ",X)", "),Y", "", ")"};
    static final int[] ADR_LEN = new int[]{1, 2, 2, 3, 2, 2, 3, 3, 2, 2, 2, 1, 3};
    private static final Op[] OP_SET = new Op[]{Op.BRK, Op.ORA, Op.TRP, Op.SLO, Op.NOP, Op.ORA, Op.ASL, Op.SLO, Op.PHP, Op.ORA, Op.ASL, Op.ANC, Op.NOP, Op.ORA, Op.ASL, Op.SLO, Op.BPL, Op.ORA, Op.TRP, Op.SLO, Op.NOP, Op.ORA, Op.ASL, Op.SLO, Op.CLC, Op.ORA, Op.NOP, Op.SLO, Op.NOP, Op.ORA, Op.ASL, Op.SLO, Op.JSR, Op.AND, Op.TRP, Op.RLA, Op.BIT, Op.AND, Op.ROL, Op.RLA, Op.PLP, Op.AND, Op.ROL, Op.ANC, Op.BIT, Op.AND, Op.ROL, Op.RLA, Op.BMI, Op.AND, Op.TRP, Op.RLA, Op.NOP, Op.AND, Op.ROL, Op.RLA, Op.SEC, Op.AND, Op.NOP, Op.RLA, Op.NOP, Op.AND, Op.ROL, Op.RLA, Op.RTI, Op.EOR, Op.TRP, Op.SRE, Op.NOP, Op.EOR, Op.LSR, Op.SRE, Op.PHA, Op.EOR, Op.LSR, Op.ASR, Op.JMP, Op.EOR, Op.LSR, Op.SRE, Op.BVC, Op.EOR, Op.TRP, Op.SRE, Op.NOP, Op.EOR, Op.LSR, Op.SRE, Op.CLI, Op.EOR, Op.NOP, Op.SRE, Op.NOP, Op.EOR, Op.LSR, Op.SRE, Op.RTS, Op.ADC, Op.TRP, Op.RRA, Op.NOP, Op.ADC, Op.ROR, Op.RRA, Op.PLA, Op.ADC, Op.ROR, Op.ARR, Op.JMP, Op.ADC, Op.ROR, Op.RRA, Op.BVS, Op.ADC, Op.TRP, Op.RRA, Op.NOP, Op.ADC, Op.ROR, Op.RRA, Op.SEI, Op.ADC, Op.NOP, Op.RRA, Op.NOP, Op.ADC, Op.ROR, Op.RRA, Op.NOP, Op.STA, Op.NOP, Op.SAX, Op.STY, Op.STA, Op.STX, Op.SAX, Op.DEY, Op.NOP, Op.TXA, Op.ANE, Op.STY, Op.STA, Op.STX, Op.SAX, Op.BCC, Op.STA, Op.TRP, Op.SHA, Op.STY, Op.STA, Op.STX, Op.SAX, Op.TYA, Op.STA, Op.TXS, Op.SHS, Op.SHY, Op.STA, Op.SHX, Op.SHA, Op.LDY, Op.LDA, Op.LDX, Op.LAX, Op.LDY, Op.LDA, Op.LDX, Op.LAX, Op.TAY, Op.LDA, Op.TAX, Op.LXA, Op.LDY, Op.LDA, Op.LDX, Op.LAX, Op.BCS, Op.LDA, Op.TRP, Op.LAX, Op.LDY, Op.LDA, Op.LDX, Op.LAX, Op.CLV, Op.LDA, Op.TSX, Op.LAS, Op.LDY, Op.LDA, Op.LDX, Op.LAX, Op.CPY, Op.CMP, Op.NOP, Op.DCP, Op.CPY, Op.CMP, Op.DEC, Op.DCP, Op.INY, Op.CMP, Op.DEX, Op.SBX, Op.CPY, Op.CMP, Op.DEC, Op.DCP, Op.BNE, Op.CMP, Op.TRP, Op.DCP, Op.NOP, Op.CMP, Op.DEC, Op.DCP, Op.CLD, Op.CMP, Op.NOP, Op.DCP, Op.NOP, Op.CMP, Op.DEC, Op.DCP, Op.CPX, Op.SBC, Op.NOP, Op.ISB, Op.CPX, Op.SBC, Op.INC, Op.ISB, Op.INX, Op.SBC, Op.NOP, Op.SBC, Op.CPX, Op.SBC, Op.INC, Op.ISB, Op.BEQ, Op.SBC, Op.TRP, Op.ISB, Op.NOP, Op.SBC, Op.INC, Op.ISB, Op.SED, Op.SBC, Op.NOP, Op.ISB, Op.NOP, Op.SBC, Op.INC, Op.ISB, Op.LOAD_FILE, Op.SLEEP};
    static final int[] INSTRUCTION_SET = new int[OP_SET.length];
    private static final Op[] READ_INS = new Op[]{Op.LDA, Op.LDX, Op.LDY, Op.EOR, Op.AND, Op.ORA, Op.ADC, Op.SBC, Op.CMP, Op.CPX, Op.CPY, Op.BIT, Op.LAX, Op.LAS, Op.NOP};
    private static final Op[] WRITE_INS = new Op[]{Op.STA, Op.STX, Op.STY, Op.SAX, Op.SHA, Op.SHX, Op.SHY, Op.SHS};
    private static final Op[] RMW_INS = new Op[]{Op.ASL, Op.LSR, Op.ROL, Op.ROR, Op.INC, Op.DEC, Op.SLO, Op.SRE, Op.RLA, Op.RRA, Op.ISB, Op.DCP};
    private static final Map<Op, Integer> codes = new HashMap<Op, Integer>();
    private static final Map<Integer, Op> rcodes = new HashMap<Integer, Op>();

    private Ops() {
    }

    static Op getOp(int code) {
        return rcodes.get(code);
    }

    static int lookup(String s) {
        int n = INS_STR.length;
        for (int i = 0; i < n; ++i) {
            if (!INS_STR[i].equalsIgnoreCase(s)) continue;
            return i;
        }
        return -1;
    }

    static int lookup(int instr, int addrMode) {
        int n = INSTRUCTION_SET.length;
        for (int i = 0; i < n; ++i) {
            int op = INSTRUCTION_SET[i];
            int address = op & Op.ADDRESSING_MASK.code;
            if ((op &= Op.OP_MASK.code) != instr || address != addrMode) continue;
            return i;
        }
        return -1;
    }

    static String modeString(int mode) {
        switch (Ops.getOp(mode)) {
            case ABSOLUTE: {
                return "absolute";
            }
            case ABSOLUTE_X: {
                return "absolute,x";
            }
            case ABSOLUTE_Y: {
                return "absolute,y";
            }
            case ACCUMULATOR: {
                return "accumulator";
            }
            case BRK: {
                return "implied";
            }
            case IMMEDIATE: {
                return "immediate";
            }
            case INDIRECT: {
                return "indirect";
            }
            case INDIRECT_X: {
                return "indirect,x";
            }
            case INDIRECT_Y: {
                return "indirect,y";
            }
            case RELATIVE: {
                return "relative";
            }
            case ZERO: {
                return "zero";
            }
            case ZERO_X: {
                return "zero,x";
            }
            case ZERO_Y: {
                return "zero,y";
            }
        }
        return "";
    }

    private static Op getAddrMode(int pos, int m) {
        switch (m) {
            case 0: 
            case 2: {
                if (pos > 4) {
                    return Op.IMMEDIATE;
                }
                return Op.BRK;
            }
            case 1: 
            case 3: {
                return Op.INDIRECT_X;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return Op.ZERO;
            }
            case 9: 
            case 11: {
                return Op.IMMEDIATE;
            }
            case 10: {
                if (pos < 4) {
                    return Op.ACCUMULATOR;
                }
                return Op.BRK;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                if (m == 12 && pos == 3) {
                    return Op.INDIRECT;
                }
                return Op.ABSOLUTE;
            }
            case 16: {
                return Op.RELATIVE;
            }
            case 17: 
            case 19: {
                return Op.INDIRECT_Y;
            }
            case 20: 
            case 21: {
                return Op.ZERO_X;
            }
            case 22: 
            case 23: {
                if (pos == 4 || pos == 5) {
                    return Op.ZERO_Y;
                }
                return Op.ZERO_X;
            }
            case 25: 
            case 27: {
                return Op.ABSOLUTE_Y;
            }
            case 28: 
            case 29: {
                return Op.ABSOLUTE_X;
            }
            case 30: 
            case 31: {
                if (pos == 4 || pos == 5) {
                    return Op.ABSOLUTE_Y;
                }
                return Op.ABSOLUTE_X;
            }
        }
        return Op.BRK;
    }

    private static Op getOpMode(Op i) {
        for (Op j : READ_INS) {
            if (j != i) continue;
            return Op.READ;
        }
        for (Op j : WRITE_INS) {
            if (j != i) continue;
            return Op.WRITE;
        }
        for (Op j : RMW_INS) {
            if (j != i) continue;
            return Op.RMW;
        }
        return Op.BRK;
    }

    static {
        for (Op o : Op.values()) {
            codes.put(o, o.code);
            rcodes.put(o.code, o);
        }
        int n = OP_SET.length;
        for (int i = 0; i < n; ++i) {
            int mode = i & 0x1F;
            int pos = i >> 5;
            if (i >= 256) continue;
            int c = OP_SET[i].code;
            c |= codes.get((Object)Ops.getAddrMode(pos, mode)).intValue();
            Ops.INSTRUCTION_SET[i] = c |= codes.get((Object)Ops.getOpMode(OP_SET[i])).intValue();
        }
    }

    static enum Op {
        BRK(0),
        ORA(1),
        TRP(2),
        SLO(3),
        NOP(4),
        ASL(5),
        PHP(6),
        ANC(7),
        BPL(8),
        CLC(9),
        JSR(10),
        AND(11),
        RLA(12),
        BIT(13),
        ROL(14),
        PLP(15),
        BMI(16),
        SEC(17),
        RTI(18),
        EOR(19),
        SRE(20),
        LSR(21),
        PHA(22),
        ASR(23),
        JMP(24),
        BVC(25),
        CLI(26),
        RTS(27),
        ADC(28),
        RRA(29),
        ROR(30),
        PLA(31),
        ARR(32),
        BVS(33),
        SEI(34),
        SAX(35),
        STA(36),
        STY(37),
        STX(38),
        DEY(39),
        TXA(40),
        ANE(41),
        BCC(42),
        SHA(43),
        TYA(44),
        TXS(45),
        SHS(46),
        SHY(47),
        SHX(48),
        LDY(49),
        LDA(50),
        LDX(51),
        LAX(52),
        TAX(53),
        LXA(54),
        TAY(55),
        BCS(56),
        CLV(57),
        TSX(58),
        LAS(59),
        CPY(60),
        CMP(61),
        DCP(62),
        DEC(63),
        INY(64),
        DEX(65),
        SBX(66),
        BNE(67),
        CLD(68),
        CPX(69),
        SBC(70),
        ISB(71),
        INC(72),
        INX(73),
        BEQ(74),
        SED(75),
        LOAD_FILE(76),
        SLEEP(77),
        ADDRESSING_MASK(3840),
        OP_MASK(255),
        IMMEDIATE(256),
        ZERO(512),
        ABSOLUTE(768),
        ZERO_X(1024),
        ZERO_Y(1280),
        ABSOLUTE_X(1536),
        ABSOLUTE_Y(1792),
        RELATIVE(2048),
        INDIRECT_X(2304),
        INDIRECT_Y(2560),
        ACCUMULATOR(2816),
        INDIRECT(3072),
        READ(4096),
        WRITE(8192),
        RMW(12288);

        private final int code;

        private Op(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

