/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.io;

import org.free.j64.cpu.CPU;
import org.free.j64.io.ExtChip;
import org.free.j64.io.TimeEvent;

final class CIA {
    private static final int PRA = 0;
    private static final int PRB = 1;
    private static final int DDRA = 2;
    private static final int DDRB = 3;
    private static final int TIMALO = 4;
    private static final int TIMAHI = 5;
    private static final int TIMBLO = 6;
    private static final int TIMBHI = 7;
    private static final int TODTEN = 8;
    private static final int TODSEC = 9;
    private static final int TODMIN = 10;
    private static final int TODHRS = 11;
    private static final int ICR = 13;
    private static final int CRA = 14;
    private static final int CRB = 15;
    private static final int CIA_TIMER_IRQ = 2;
    private static final int CIA_TIMER_NMI = 2;
    private final CIATimer timerA;
    private final CIATimer timerB;
    private final ExtChip chips;
    private final TimeEvent todEvent = new TimeEvent(0L){

        @Override
        public void execute(long cycle) {
            this.time = 100000L;
            int tmp = (CIA.this.tod10sec & 0xF) + 1;
            CIA.this.tod10sec = tmp % 10;
            if (tmp > 9) {
                this.wrapTime();
            }
            CPU.CPU.addEvent(this);
        }

        private void wrapTime() {
            int tmp = (CIA.this.todsec & 0x7F) + 1;
            if ((tmp & 0xF) > 9) {
                tmp += 6;
            }
            if (tmp > 59) {
                tmp = 0;
            }
            CIA.this.todsec = tmp;
            if (tmp == 0) {
                tmp = (CIA.this.todmin & 0x7F) + 1;
                if ((tmp & 0xF) > 9) {
                    tmp += 6;
                }
                if (tmp > 59) {
                    tmp = 0;
                }
                CIA.this.todmin = tmp;
                if (tmp == 0) {
                    tmp = (CIA.this.todhour & 0x1F) + 1;
                    if ((tmp & 0xF) > 9) {
                        tmp += 6;
                    }
                    if (tmp > 11) {
                        tmp = 0;
                    }
                    CIA.this.todhour = tmp;
                }
            }
        }
    };
    int pra = 0;
    int prb = 0;
    int ddra = 0;
    int ddrb = 0;
    private int tod10sec = 0;
    private int todsec = 0;
    private int todmin = 0;
    private int todhour = 0;
    private final int offset;
    private int ciaicrRead;
    private int ciaie = 0;

    CIA(int offset, ExtChip chips) {
        this.offset = offset;
        this.chips = chips;
        this.timerA = new CIATimer(1, null);
        this.timerB = new CIATimer(2, this.timerA);
        this.timerA.otherTimer = this.timerB;
        this.todEvent.setTime(CPU.CPU.getCycles() + 10000L);
        CPU.CPU.addEvent(this.todEvent);
    }

    void reset() {
        this.todhour = 0;
        this.todmin = 0;
        this.todsec = 0;
        this.tod10sec = 0;
        this.ciaie = 0;
        this.ciaicrRead = 0;
        this.timerA.reset();
        this.timerB.reset();
        this.updateInterrupts();
    }

    int performRead(int address, long cycles) {
        switch (address -= this.offset) {
            case 2: {
                return this.ddra;
            }
            case 3: {
                return this.ddrb;
            }
            case 0: {
                return (this.pra | ~this.ddra) & 0xFF;
            }
            case 1: {
                int data = (this.prb | ~this.ddrb) & 0xFF;
                if ((this.timerA.cr & 2) > 0) {
                    data &= 0xBF;
                    data = (this.timerA.cr & 4) > 0 ? (data |= this.timerA.flipflop ? 64 : 0) : (data |= this.timerA.underflow ? 64 : 0);
                }
                if ((this.timerB.cr & 2) > 0) {
                    data &= 0x7F;
                    data = (this.timerB.cr & 4) > 0 ? (data |= this.timerB.flipflop ? 128 : 0) : (data |= this.timerB.underflow ? 128 : 0);
                }
                return data;
            }
            case 4: {
                return this.timerA.getTimer(cycles) & 0xFF;
            }
            case 5: {
                return this.timerA.getTimer(cycles) >> 8;
            }
            case 6: 
            case 7: {
                return this.timerB.getTimer(cycles) & 0xFF;
            }
            case 8: {
                return this.tod10sec;
            }
            case 9: {
                return this.todsec;
            }
            case 10: {
                return this.todmin;
            }
            case 11: {
                return this.todhour;
            }
            case 14: {
                return this.timerA.cr;
            }
            case 15: {
                return this.timerB.cr;
            }
            case 13: {
                int val = this.ciaicrRead;
                this.ciaicrRead = 0;
                this.updateInterrupts();
                return val;
            }
        }
        return 255;
    }

    void performWrite(int address, int data, long cycles) {
        switch (address -= this.offset) {
            case 2: {
                this.ddra = data;
                break;
            }
            case 3: {
                this.ddrb = data;
                break;
            }
            case 0: {
                this.pra = data;
                break;
            }
            case 1: {
                this.prb = data;
                break;
            }
            case 4: {
                this.timerA.latch = this.timerA.latch & 0xFF00 | data;
                break;
            }
            case 5: {
                this.timerA.latch = this.timerA.latch & 0xFF | data << 8;
                if (this.timerA.state != State.STOP) break;
                this.timerA.timer = this.timerA.latch;
                break;
            }
            case 6: {
                this.timerB.latch = this.timerB.latch & 0xFF00 | data;
                break;
            }
            case 7: {
                this.timerB.latch = this.timerB.latch & 0xFF | data << 8;
                if (this.timerB.state != State.STOP) break;
                this.timerB.timer = this.timerB.latch;
                break;
            }
            case 8: {
                this.tod10sec = data;
                break;
            }
            case 9: {
                this.todsec = data;
                break;
            }
            case 10: {
                this.todmin = data;
                break;
            }
            case 11: {
                this.todhour = data;
                break;
            }
            case 13: {
                boolean val;
                boolean bl = val = (data & 0x80) != 0;
                this.ciaie = val ? (this.ciaie |= data & 0x7F) : (this.ciaie &= ~data);
                this.updateInterrupts();
                break;
            }
            case 14: {
                this.timerA.writeCR(cycles, data);
                break;
            }
            case 15: {
                this.timerB.writeCR(cycles, data);
                this.timerB.countUnderflow = (data & 0x60) == 64;
                break;
            }
        }
    }

    String printStatus() {
        StringBuilder s = new StringBuilder();
        s.append("\n--------------------------\n");
        s.append(this.ciaID()).append(": status");
        s.append("\nTimer A state: ").append((Object)this.timerA.state);
        s.append("\nTimer A next trigger: ").append(this.timerA.nextZero);
        s.append("\nCIA CRA: ").append(String.format("%02x", this.timerA.cr)).append(" => ").append((this.timerA.cr & 8) == 0 ? "cont" : "one-shot");
        s.append("\nTimer A Latch: ").append(this.timerA.latch);
        s.append("\nTimer B state: ").append((Object)this.timerB.state);
        s.append("\nTimer B next trigger: ").append(this.timerB.nextZero);
        s.append("\nCIA CRB: ").append(String.format("%02x", this.timerA.cr)).append(" => ").append((this.timerB.cr & 8) == 0 ? "cont" : "one-shot");
        s.append("\nTimer B Latch: ").append(this.timerB.latch);
        s.append("\n--------------------------\n");
        return s.toString();
    }

    private String ciaID() {
        return this.offset == 68608 ? "CIA 1" : "CIA 2";
    }

    private void updateInterrupts() {
        if ((this.ciaie & this.ciaicrRead & 0x1F) != 0) {
            this.ciaicrRead |= 0x80;
            if (this.offset == 68608) {
                this.chips.setIRQ(2);
            } else {
                this.chips.setNMI(2);
            }
        } else if (this.offset == 68608) {
            this.chips.clearIRQ(2);
        } else {
            this.chips.clearNMI(2);
        }
    }

    private final class CIATimer {
        private final TimeEvent updateEvent = new TimeEvent(0L){

            @Override
            public void execute(long cycles) {
                this.doUpdate(cycles);
                if (CIATimer.this.state != State.STOP) {
                    this.time = CIATimer.this.nextUpdate;
                    CPU.CPU.addEvent(this);
                }
            }

            private void delayedWrite(long cycles) {
                CIATimer.this.nextUpdate = cycles + 1L;
                switch (CIATimer.this.state) {
                    case STOP: 
                    case LOAD_STOP: {
                        if ((CIATimer.this.writeCR & 1) > 0) {
                            if ((CIATimer.this.writeCR & 0x10) > 0) {
                                CIATimer.this.state = State.LOAD_WAIT_COUNT;
                                break;
                            }
                            this.loadTimer(cycles);
                            CIATimer.this.state = State.WAIT;
                            break;
                        }
                        if ((CIATimer.this.writeCR & 0x10) <= 0) break;
                        CIATimer.this.state = State.LOAD_STOP;
                        break;
                    }
                    case COUNT: {
                        if ((CIATimer.this.writeCR & 1) > 0) {
                            if ((CIATimer.this.writeCR & 0x10) <= 0) break;
                            CIATimer.this.state = State.LOAD_WAIT_COUNT;
                            break;
                        }
                        if ((CIATimer.this.writeCR & 0x10) > 0) {
                            CIATimer.this.state = State.LOAD_STOP;
                            break;
                        }
                        CIATimer.this.state = State.COUNT_STOP;
                        break;
                    }
                    case LOAD_COUNT: 
                    case WAIT: {
                        if ((CIATimer.this.writeCR & 1) > 0) {
                            if ((CIATimer.this.writeCR & 8) > 0) {
                                CIATimer.this.writeCR &= 254;
                                CIATimer.this.state = State.STOP;
                                break;
                            }
                            if ((CIATimer.this.writeCR & 0x10) <= 0) break;
                            CIATimer.this.state = State.LOAD_WAIT_COUNT;
                            break;
                        }
                        CIATimer.this.state = State.COUNT_STOP;
                        break;
                    }
                }
                CIATimer.this.cr = CIATimer.this.writeCR & 0xEF;
            }

            private void doUpdate(long cycles) {
                if (CIATimer.this.nextUpdate == 0L) {
                    CIATimer.this.nextUpdate = (CIATimer.this.nextZero = cycles);
                }
                if (cycles == CIATimer.this.nextUpdate) {
                    this.update(cycles);
                } else {
                    while (cycles >= CIATimer.this.nextUpdate) {
                        this.update(CIATimer.this.nextUpdate);
                    }
                }
            }

            private void update(long cycles) {
                CIATimer.this.underflow = false;
                CIATimer.this.nextUpdate = cycles + 1L;
                if (CIATimer.this.interruptNext) {
                    CIA.this.ciaicrRead |= CIATimer.this.iflag;
                    CIATimer.this.interruptNext = false;
                    CIA.this.updateInterrupts();
                }
                CIATimer.this.getTimer(cycles);
                switch (CIATimer.this.state) {
                    case STOP: {
                        break;
                    }
                    case WAIT: {
                        CIATimer.this.state = State.COUNT;
                        break;
                    }
                    case LOAD_STOP: {
                        this.loadTimer(cycles);
                        CIATimer.this.state = State.STOP;
                        break;
                    }
                    case LOAD_COUNT: {
                        this.loadTimer(cycles);
                        CIATimer.this.state = State.COUNT;
                        break;
                    }
                    case LOAD_WAIT_COUNT: {
                        if (CIATimer.this.nextZero == cycles + 1L) {
                            CIATimer.this.triggerInterrupt(cycles);
                        }
                        CIATimer.this.state = State.WAIT;
                        this.loadTimer(cycles);
                        break;
                    }
                    case COUNT_STOP: {
                        if (!CIATimer.this.countUnderflow) {
                            CIATimer.this.timer = (int)(cycles - CIATimer.this.nextZero);
                            if (CIATimer.this.timer < 0) {
                                CIATimer.this.timer = 0;
                            }
                        }
                        CIATimer.this.state = State.STOP;
                        break;
                    }
                    case COUNT: {
                        if (CIATimer.this.countUnderflow) {
                            if (CIATimer.this.otherTimer.underflow) {
                                CIATimer.this.timer--;
                            }
                            if (CIATimer.this.timer > 0) break;
                            CIATimer.this.triggerInterrupt(cycles);
                            break;
                        }
                        if (cycles >= CIATimer.this.nextZero && CIATimer.this.state != State.STOP) {
                            CIATimer.this.state = State.LOAD_COUNT;
                            CIATimer.this.triggerInterrupt(cycles);
                            break;
                        }
                        CIATimer.this.nextUpdate = CIATimer.this.nextZero;
                        break;
                    }
                }
                if (CIATimer.this.writeCR != -1) {
                    this.delayedWrite(cycles);
                    CIATimer.this.writeCR = -1;
                }
            }

            private void loadTimer(long cycles) {
                CIATimer.this.timer = CIATimer.this.latch;
                CIATimer.this.nextZero = cycles + (long)CIATimer.this.latch;
            }
        };
        private CIATimer otherTimer;
        private State state = State.STOP;
        private int latch = 0;
        private int timer = 0;
        private int writeCR = -1;
        private int cr = 0;
        private final int iflag;
        private long nextUpdate = 0L;
        private long nextZero = 0L;
        private boolean interruptNext = false;
        private boolean underflow = false;
        private boolean flipflop = false;
        private boolean countUnderflow = false;

        CIATimer(int flag, CIATimer other) {
            this.otherTimer = other;
            this.iflag = flag;
        }

        private int getTimer(long cycles) {
            if (this.state != State.COUNT) {
                return this.timer;
            }
            int t = (int)(this.nextZero - cycles);
            if (t < 0) {
                t = 0;
            }
            this.timer = t;
            return t;
        }

        private void reset() {
            this.timer = 65535;
            this.latch = 65535;
            this.flipflop = false;
            this.countUnderflow = false;
            this.state = State.STOP;
            this.nextUpdate = 0L;
            this.nextZero = 0L;
            this.writeCR = -1;
            CPU.CPU.removeEvent(this.updateEvent);
        }

        private void triggerInterrupt(long cycles) {
            this.underflow = true;
            this.interruptNext = true;
            boolean bl = this.flipflop = !this.flipflop;
            if ((this.cr & 8) != 0) {
                this.cr &= 0xFE;
                this.writeCR &= 0xFE;
                this.state = State.LOAD_STOP;
            } else {
                this.state = State.LOAD_COUNT;
            }
        }

        private void writeCR(long cycles, int data) {
            this.writeCR = data;
            if (this.nextUpdate > cycles + 1L || !this.updateEvent.isScheduled()) {
                this.nextUpdate = cycles + 1L;
                this.updateEvent.setTime(this.nextUpdate);
                CPU.CPU.addEvent(this.updateEvent);
            }
        }
    }

    private static enum State {
        STOP,
        WAIT,
        LOAD_STOP,
        LOAD_COUNT,
        LOAD_WAIT_COUNT,
        COUNT,
        COUNT_STOP;

    }
}

