/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.io;

import org.free.j64.cpu.CPU;

public abstract class ExtChip {
    public abstract void clock(long var1);

    public abstract int performRead(int var1, long var2);

    public abstract void performWrite(int var1, int var2, long var3);

    public abstract void reset();

    public abstract void stop();

    void setIRQ(int irq) {
        InterruptManager.IM.setIRQ(irq);
    }

    void clearIRQ(int irq) {
        InterruptManager.IM.clearIRQ(irq);
    }

    void setNMI(int nmi) {
        InterruptManager.IM.setNMI(nmi);
    }

    void clearNMI(int nmi) {
        InterruptManager.IM.clearNMI(nmi);
    }

    void resetInterrupts() {
        InterruptManager.IM.reset();
    }

    private static enum InterruptManager {
        IM;

        private int nmiFlags;
        private int irqFlags;
        private int oldIrqFlags;
        private int oldNmiFlags;

        private void reset() {
            this.oldNmiFlags = 0;
            this.oldIrqFlags = 0;
            this.irqFlags = 0;
            this.nmiFlags = 0;
            CPU.CPU.setIRQLow(false);
            CPU.CPU.setNMILow(false);
        }

        private boolean setIRQ(int irq) {
            boolean val = (this.irqFlags & irq) == 0;
            this.irqFlags |= irq;
            if (this.irqFlags != this.oldIrqFlags) {
                CPU.CPU.setIRQLow(this.irqFlags != 0);
                this.oldIrqFlags = this.irqFlags;
            }
            return val;
        }

        private void clearIRQ(int irq) {
            this.irqFlags &= ~irq;
            if (this.irqFlags != this.oldIrqFlags) {
                CPU.CPU.setIRQLow(this.irqFlags != 0);
                this.oldIrqFlags = this.irqFlags;
            }
        }

        private boolean setNMI(int nmi) {
            boolean val = (this.nmiFlags & nmi) == 0;
            this.nmiFlags |= nmi;
            if (this.nmiFlags != this.oldNmiFlags) {
                CPU.CPU.setNMILow(this.nmiFlags != 0);
                this.oldNmiFlags = this.nmiFlags;
            }
            return val;
        }

        private void clearNMI(int nmi) {
            this.nmiFlags &= ~nmi;
            if (this.nmiFlags != this.oldNmiFlags) {
                CPU.CPU.setNMILow(this.nmiFlags != 0);
                this.oldNmiFlags = this.nmiFlags;
            }
        }
    }
}

