/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.io;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.free.j64.app.C64;
import org.free.j64.io.CIA;
import org.free.j64.net.type.Key;

public enum Keyboard {
    KEYBOARD;

    private static final int IO_OFFSET;
    private static final int AUTO_SHIFT = 1024;
    private static final int STICK_UPDOWN = 3;
    private static final int STICK_LEFTRIGHT = 12;
    private static final int STICK_UP = 1;
    private static final int STICK_DOWN = 2;
    private static final int STICK_LEFT = 4;
    private static final int STICK_RIGHT = 8;
    private static final int STICK_FIRE = 16;
    private static final int STICK_UPLEFT = 5;
    private static final int STICK_UPRIGHT = 9;
    private static final int STICK_DOWNLEFT = 6;
    private static final int STICK_DOWNRIGHT = 10;
    private static final int USER_UP = 0;
    private static final int USER_DOWN = 1;
    private static final int USER_LEFT = 2;
    private static final int USER_RIGHT = 3;
    private static final int USER_FIRE = 4;
    private static final int USER_UPLEFT = 5;
    private static final int USER_UPRIGHT = 6;
    private static final int USER_DOWNLEFT = 7;
    private static final int USER_DOWNRIGHT = 8;
    private static final int[][] keytableDef;
    private final int[][] keyTable = new int[1024][3];
    private KB keyboard;
    private final Queue<Object[]> EDQ = new LinkedBlockingQueue<Object[]>();
    private final Queue<Key> keyBuffer = new LinkedBlockingQueue<Key>();
    private Future<?> dispatchTask;
    private Future<?> keysTask;
    private CIA cia;

    public void addKey(Key key) {
        this.keyBuffer.offer(key);
    }

    public boolean isReady() {
        return this.keyboard.ready;
    }

    public JoyStick getJoyStick() {
        return this.keyboard.getJoyStick();
    }

    public void reset() {
        this.EDQ.offer(new Object[]{"reset"});
    }

    public void setButtonval(int bv) {
        this.EDQ.offer(new Object[]{"setButtonval", bv});
    }

    public void setJoyStick(JoyStick js) {
        this.EDQ.offer(new Object[]{"setJoyStick", js});
    }

    public void stop() {
        this.keysTask.cancel(true);
        this.dispatchTask.cancel(true);
    }

    void init(CIA c) {
        this.cia = c;
        for (int[] i : this.keyTable) {
            i[0] = -1;
        }
        for (int[] i : keytableDef) {
            int k = i[0];
            this.keyTable[k][0] = i[1];
            this.keyTable[k][1] = i[2];
            this.keyTable[k][2] = i[3];
        }
        this.dispatch();
        this.EDQ.offer(new Object[]{"reset"});
        this.start();
    }

    int readDC00(int pc) {
        return this.keyboard.readDC00(pc);
    }

    int readDC01(int pc) {
        return this.keyboard.readDC01(pc);
    }

    private void dispatch() {
        int id = C64.C64.getTaskId();
        this.keyboard = new KB(id);
        this.dispatchTask = C64.C64.addTask(id, this.keyboard);
    }

    private void start() {
        final int id = C64.C64.getTaskId();
        this.keysTask = C64.C64.addTask(id, new Callable<Void>(){

            @Override
            public Void call() {
                int lastPress = -1;
                while (!Thread.currentThread().isInterrupted()) {
                    Key key = (Key)Keyboard.this.keyBuffer.poll();
                    if (key == null) continue;
                    switch (key.joy) {
                        case ONE: 
                        case TWO: {
                            Keyboard.this.EDQ.offer(new Object[]{"setJoyStick", key.joy});
                            break;
                        }
                    }
                    int keyCode = key.key.getData();
                    if (key.key.getState() == Key.State.PRESSED) {
                        if (keyCode != lastPress && lastPress != -1 && C64.C64.isKeyJam()) {
                            Keyboard.this.EDQ.offer(new Object[]{"keyReleased", lastPress});
                        }
                        Keyboard.this.EDQ.offer(new Object[]{"keyPressed", keyCode});
                        lastPress = keyCode;
                    } else {
                        Keyboard.this.EDQ.offer(new Object[]{"keyReleased", keyCode});
                        lastPress = -1;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(C64.C64.getAudioDelay());
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                C64.C64.removeTask(id);
                return null;
            }
        });
    }

    static {
        IO_OFFSET = 12288;
        keytableDef = new int[][]{{65, 1, 2, 0}, {66, 3, 4, 0}, {67, 2, 4, 0}, {68, 2, 2, 0}, {69, 1, 6, 0}, {70, 2, 5, 0}, {71, 3, 2, 0}, {72, 3, 5, 0}, {73, 4, 1, 0}, {74, 4, 2, 0}, {75, 4, 5, 0}, {76, 5, 2, 0}, {77, 4, 4, 0}, {78, 4, 7, 0}, {79, 4, 6, 0}, {80, 5, 1, 0}, {81, 7, 6, 0}, {82, 2, 1, 0}, {83, 1, 5, 0}, {84, 2, 6, 0}, {85, 3, 6, 0}, {86, 3, 7, 0}, {87, 1, 1, 0}, {88, 2, 7, 0}, {89, 3, 1, 0}, {90, 1, 4, 0}, {48, 4, 3, 0}, {49, 7, 0, 0}, {50, 7, 3, 0}, {51, 1, 0, 0}, {52, 1, 3, 0}, {53, 2, 0, 0}, {54, 2, 3, 0}, {55, 3, 0, 0}, {56, 3, 3, 0}, {57, 4, 0, 0}, {10, 0, 1, 0}, {10, 0, 1, 0}, {32, 7, 4, 0}, {44, 5, 7, 0}, {46, 5, 4, 0}, {92, 6, 5, 0}, {59, 5, 5, 0}, {45, 5, 0, 0}, {61, 5, 3, 0}, {96, 7, 1, 0}, {39, 6, 2, 0}, {109, 5, 3, 0}, {91, 5, 6, 0}, {93, 6, 1, 0}, {27, 7, 1, 0}, {47, 6, 7, 0}, {111, 6, 7, 0}, {63, 6, 7, 1024}, {127, 0, 0, 0}, {8, 0, 0, 0}, {16, 1, 7, 0}, {20, 6, 4, 0}, {19, 7, 7, 0}, {27, 7, 7, 0}, {13, 0, 1, 0}, {17, 7, 5, 2}, {10, 0, 1, 0}, {40, 0, 7, 0}, {38, 0, 7, 1024}, {39, 0, 2, 0}, {37, 0, 2, 1024}, {112, 0, 4, 0}, {114, 0, 5, 0}, {116, 0, 6, 0}, {118, 0, 3, 0}, {36, 6, 3, 0}, {35, 6, 6, 0}, {155, 6, 0, 0}, {9, 7, 2, 0}};
    }

    private final class KB
    implements Callable<Void> {
        private final Map<Integer, Integer> keyRow = new HashMap<Integer, Integer>();
        private final Map<Integer, Integer> keyCol = new HashMap<Integer, Integer>();
        private int bval;
        private int joystick = 255;
        private int joy1 = 255;
        private int joy2 = 255;
        private int reads;
        private int stick = 12288 + 56320;
        private boolean lastUp;
        private boolean lastLeft;
        private boolean ready;
        private final int taskId;

        public KB(int taskId) {
            this.taskId = taskId;
        }

        @Override
        public Void call() {
            while (!Thread.currentThread().isInterrupted()) {
                if (!Keyboard.this.EDQ.isEmpty()) {
                    this.dispatch((Object[])Keyboard.this.EDQ.poll());
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(C64.C64.getAudioDelay());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            C64.C64.removeTask(this.taskId);
            return null;
        }

        private void dispatch(Object[] m) {
            switch ((String)m[0]) {
                case "keyPressed": {
                    this.keyPressed((Integer)m[1]);
                    break;
                }
                case "keyReleased": {
                    this.keyReleased((Integer)m[1]);
                    break;
                }
                case "reset": {
                    this.reset();
                    break;
                }
                case "setButtonval": {
                    this.setButtonval((Integer)m[1]);
                    break;
                }
                case "setJoyStick": {
                    this.setJoyStick((JoyStick)((Object)m[1]));
                    break;
                }
            }
        }

        private JoyStick getJoyStick() {
            return this.stick == IO_OFFSET + 56321 ? JoyStick.ONE : JoyStick.TWO;
        }

        private int getNormalStick(int key) {
            switch (key) {
                case 38: 
                case 104: 
                case 224: {
                    return 0;
                }
                case 40: 
                case 98: 
                case 101: 
                case 225: {
                    return 1;
                }
                case 37: 
                case 100: 
                case 226: {
                    return 2;
                }
                case 39: 
                case 102: 
                case 227: {
                    return 3;
                }
                case 10: 
                case 17: 
                case 32: {
                    return 4;
                }
                case 103: 
                case 155: {
                    return 5;
                }
                case 33: 
                case 105: {
                    return 6;
                }
                case 97: 
                case 127: {
                    return 7;
                }
                case 34: 
                case 99: {
                    return 8;
                }
            }
            return -1;
        }

        private void keyPressed(int key) {
            switch (this.getNormalStick(key)) {
                case 0: {
                    this.joystick &= 0xFE;
                    this.lastUp = true;
                    break;
                }
                case 1: {
                    this.joystick &= 0xFD;
                    this.lastUp = false;
                    break;
                }
                case 2: {
                    this.joystick &= 0xFB;
                    this.lastLeft = true;
                    break;
                }
                case 3: {
                    this.joystick &= 0xF7;
                    this.lastLeft = false;
                    break;
                }
                case 4: {
                    this.joystick &= 0xEF;
                    break;
                }
                case 5: {
                    this.joystick &= 0xFA;
                    this.lastUp = true;
                    this.lastLeft = true;
                    break;
                }
                case 6: {
                    this.joystick &= 0xF6;
                    this.lastUp = true;
                    this.lastLeft = false;
                    break;
                }
                case 7: {
                    this.joystick &= 0xF9;
                    this.lastUp = false;
                    this.lastLeft = true;
                    break;
                }
                case 8: {
                    this.joystick &= 0xF5;
                    this.lastUp = false;
                    this.lastLeft = false;
                    break;
                }
            }
            int mapRow = Keyboard.this.keyTable[key][0];
            int mapCol = Keyboard.this.keyTable[key][1];
            if (mapRow != -1 && mapCol != -1) {
                this.keyRow.put(mapRow, this.keyRow.get(mapRow) & 255 - (1 << Keyboard.this.keyTable[key][1]));
                this.keyCol.put(mapCol, this.keyCol.get(mapCol) & 255 - (1 << Keyboard.this.keyTable[key][0]));
            }
            this.updateKeyboard();
        }

        private void keyReleased(int key) {
            switch (this.getNormalStick(key)) {
                case 0: {
                    this.joystick |= 1;
                    break;
                }
                case 1: {
                    this.joystick |= 2;
                    break;
                }
                case 2: {
                    this.joystick |= 4;
                    break;
                }
                case 3: {
                    this.joystick |= 8;
                    break;
                }
                case 4: {
                    this.joystick |= 0x10;
                    break;
                }
                case 5: {
                    this.joystick |= 5;
                    break;
                }
                case 6: {
                    this.joystick |= 9;
                    break;
                }
                case 7: {
                    this.joystick |= 6;
                    break;
                }
                case 8: {
                    this.joystick |= 0xA;
                    break;
                }
            }
            int mapRow = Keyboard.this.keyTable[key][0];
            int mapCol = Keyboard.this.keyTable[key][1];
            if (mapRow != -1 && mapCol != -1) {
                this.keyRow.put(mapRow, this.keyRow.get(mapRow) | 1 << Keyboard.this.keyTable[key][1]);
                this.keyCol.put(mapCol, this.keyCol.get(mapCol) | 1 << Keyboard.this.keyTable[key][0]);
            }
            this.updateKeyboard();
        }

        private int readDC00(int pc) {
            int val = 255;
            int mask = (((Keyboard)Keyboard.this).cia.prb | ~((Keyboard)Keyboard.this).cia.ddrb) & (pc < 65536 ? this.joy1 : 255);
            int m = 1;
            for (int i = 0; i < 8; ++i) {
                if ((mask & m) == 0) {
                    val &= this.keyCol.get(i).intValue();
                }
                m <<= 1;
            }
            return val & (((Keyboard)Keyboard.this).cia.pra | ~((Keyboard)Keyboard.this).cia.ddra) & (pc < 65536 ? this.joy2 : 255);
        }

        private int readDC01(int pc) {
            int val = 255;
            int mask = (((Keyboard)Keyboard.this).cia.pra | ~((Keyboard)Keyboard.this).cia.ddra) & (pc < 65536 ? this.joy2 & this.bval : 255);
            int m = 1;
            for (int i = 0; i < 8; ++i) {
                if ((mask & m) == 0) {
                    val &= this.keyRow.get(i).intValue();
                }
                m <<= 1;
            }
            return val & (((Keyboard)Keyboard.this).cia.prb | ~((Keyboard)Keyboard.this).cia.ddrb) & (pc < 65536 ? this.joy1 & this.bval : 255);
        }

        private void reset() {
            this.joystick = 255;
            this.reads = 0;
            this.ready = false;
            for (int i = 0; i < 8; ++i) {
                this.keyRow.put(i, 255);
                this.keyCol.put(i, 255);
            }
        }

        private void setJoyStick(JoyStick js) {
            this.stick = IO_OFFSET + 56320;
            if (js == JoyStick.ONE) {
                ++this.stick;
            }
        }

        private void setButtonval(int bv) {
            this.bval = bv;
        }

        private void updateKeyboard() {
            int jst = this.joystick & this.bval;
            if ((jst & 3) == 0) {
                jst = (jst | 3) & 255 - (this.lastUp ? 1 : 2);
            }
            if ((jst & 0xC) == 0) {
                jst = (jst | 0xC) & 255 - (this.lastLeft ? 4 : 8);
            }
            this.joy2 = this.stick == 56320 + IO_OFFSET ? 255 : jst;
            int n = this.joy1 = this.stick == 56320 + IO_OFFSET ? jst : 255;
            if (!this.ready && this.reads++ > 20) {
                this.ready = true;
                this.reads = 0;
            }
        }
    }

    public static final class Key {
        private final org.free.j64.net.type.Key key;
        private final JoyStick joy;

        public Key(org.free.j64.net.type.Key key, JoyStick joystick) {
            this.key = key;
            this.joy = joystick;
        }

        public String toString() {
            return "Key{key=" + this.key + ", joy=" + (Object)((Object)this.joy) + '}';
        }
    }

    public static enum JoyStick {
        ONE,
        TWO,
        NONE;

    }
}

