/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.net.codec;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.free.j64.net.codec.Codecs;
import org.free.j64.net.type.Audio;
import org.free.j64.net.type.Chat;
import org.free.j64.net.type.Key;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

final class Encoder
extends OneToOneEncoder {
    static final String IMG_TYPE = "png";

    Encoder() {
    }

    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof Audio) {
            return Codecs.ac.encode((Audio)msg);
        }
        if (msg instanceof BufferedImage) {
            return this.encodeImage((BufferedImage)msg);
        }
        if (msg instanceof Chat) {
            return Codecs.cc.encode((Chat)msg);
        }
        if (msg instanceof Key) {
            return Codecs.kc.encode((Key)msg);
        }
        if (msg instanceof String) {
            return Codecs.sc.encode((String)msg);
        }
        return null;
    }

    private ChannelBuffer encodeImage(BufferedImage msg) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)msg, IMG_TYPE, os);
        byte[] data = new byte[os.size()];
        System.arraycopy(os.toByteArray(), 0, data, 0, os.size());
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        buf.writeByte(73);
        buf.writeInt(data.length);
        buf.writeBytes(data);
        return buf;
    }
}

