/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.sound;

import org.free.j64.cpu.CPU;
import org.free.j64.io.Audio;
import org.free.j64.io.ExtChip;
import org.free.j64.io.TimeEvent;
import org.free.j64.sound.SID;

public enum RESID {
    RESID;

    private static final ExtChip Sid;

    public ExtChip getSid() {
        return Sid;
    }

    static {
        Sid = new ExtChip(){
            private static final int SAMPLE_RATE = 44000;
            private static final int BUFFER_SIZE = 256;
            private static final int CPUFrq = 985248;
            private static final int clocksPerSample = 22;
            private final byte[] buffer = new byte[512];
            private final TimeEvent sampleEvent = new TimeEvent(0L){

                @Override
                public void execute(long cycles) {
                    nextSample += 22L;
                    nextRest += clocksPerSampleRest;
                    if (nextRest > 1000) {
                        nextRest -= 1000;
                        nextSample++;
                    }
                    while (lastCycles++ < cycles) {
                        SID.SID.clock();
                    }
                    int sample = SID.SID.output();
                    (this).buffer[(this).pos++] = (byte)(sample & 0xFF);
                    (this).buffer[(this).pos++] = (byte)(sample >> 8);
                    if (pos == buffer.length) {
                        this.writeSamples();
                    }
                    this.time = nextSample;
                    if (!removeSample) {
                        CPU.CPU.addEvent(this);
                    }
                }

                private void writeSamples() {
                    Audio.AUDIO.play(buffer);
                    pos = 0;
                }
            };
            private int clocksPerSampleRest = 0;
            private int nextRest = 0;
            private int pos = 0;
            private long nextSample = 0L;
            private long lastCycles = CPU.CPU.getCycles();
            private boolean removeSample = false;
            {
                this.nextSample = CPU.CPU.getCycles();
                SID.SID.set_sampling_parameters(985248.0, SID.sampling_method.SAMPLE_FAST, 44000.0, -1.0, 0.97);
                this.clocksPerSampleRest = 22392;
                this.clocksPerSampleRest -= 22000;
                this.sampleEvent.setTime(CPU.CPU.getCycles() + 5L);
                CPU.CPU.addEvent(this.sampleEvent);
            }

            @Override
            public void clock(long cycles) {
            }

            @Override
            public int performRead(int address, long cycles) {
                return SID.SID.read(address - 12288 - 54272);
            }

            @Override
            public void performWrite(int address, int data, long cycles) {
                SID.SID.write(address - 12288 - 54272, data);
            }

            @Override
            public void reset() {
                this.nextSample = CPU.CPU.getCycles() + 10L;
                this.lastCycles = CPU.CPU.getCycles();
                this.sampleEvent.setTime(this.nextSample);
                CPU.CPU.addEvent(this.sampleEvent);
                SID.SID.reset();
            }

            @Override
            public void stop() {
                this.removeSample = true;
            }
        };
    }
}

