/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.cpu;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.free.j64.cpu.CPU;
import org.free.j64.cpu.Ops;
import org.free.j64.etc.Utils;
import org.free.j64.io.Screen;

public final class Assembler {
    private static final int REF_WORD = 0;
    private static final int REF_BYTE = 1;
    private static final int REF_BYTE_LO = 2;
    private static final int REF_BYTE_HI = 3;
    private static final int REF_RELATIVE = 4;
    private static final int[] REF_SIZE = new int[]{2, 1, 1, 1, 1};
    private final Map<String, Integer> labels = new HashMap<String, Integer>();
    private final List<Ref> references = new ArrayList<Ref>();
    private List<String> tokens = new ArrayList<String>();
    private Mode mode = Mode.CODE;
    private String workingDir;
    private String currentLine;
    private int lineNo;
    private int pos = 0;
    private int lastPos = 0;

    public static void fillMemory(int from, int to, int value) {
        for (int i = from; i < to; ++i) {
            CPU.CPU.memory.set(i, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int loadBinary(String file, int from) {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int data;
            int pos = from;
            while ((data = ((InputStream)in).read()) != -1) {
                CPU.CPU.memory.set(pos++, data);
            }
            System.out.println("Loaded binary file from: $" + String.format("%04x", from) + " size: $" + String.format("%04x", pos - from));
            int n = pos;
            return n;
        }
        catch (IOException ex) {
            Logger.getLogger(Assembler.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public static void loadScript(String file) {
        List<String> tok = Utils.getTokens(file);
        int n = tok.size();
        for (int i = 0; i < n; ++i) {
            int j;
            String t = tok.get(i);
            if (t.equalsIgnoreCase("fill")) {
                if (!Assembler.parseFill(tok, i)) continue;
                i += 4;
                continue;
            }
            if (!t.equalsIgnoreCase("patch") || (j = Assembler.parsePatch(tok, i)) == -1) continue;
            i = j;
        }
    }

    public static void saveBinary(String file, int from, int to) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            for (int i = from; i < to; ++i) {
                ((OutputStream)out).write(CPU.CPU.memory.get(i));
            }
            ((OutputStream)out).flush();
            System.out.println("Saved binary file to " + file + " from location: $" + String.format("%04x", from) + " size: $" + String.format("%04x", to - from));
        }
        catch (IOException ex) {
            Logger.getLogger(Assembler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int assemble(List<String> src, int from) {
        this.reset(from);
        for (String line : src) {
            this.currentLine = line.trim();
            if (!this.assembleLine(this.currentLine)) break;
            ++this.lineNo;
        }
        this.resolveRefs();
        return this.pos;
    }

    private boolean assembleLine(String line) {
        if (line.toLowerCase().contains(".end")) {
            this.dumpSummary();
            return false;
        }
        if (this.ignoreComment(line)) {
            return true;
        }
        this.tokens = Utils.split(line, "\\s");
        if (this.tokens.isEmpty()) {
            return true;
        }
        String label = this.getLabel();
        String op = this.getOp();
        String operand = this.getOperand();
        if (!label.isEmpty() && this.addLabel(label, op, operand)) {
            return true;
        }
        char c = op.charAt(0);
        if (c == '.') {
            this.processLabel(op, operand);
        } else if (op.equals("*=")) {
            this.setPos(this.resolve(operand, this.pos));
        } else {
            if (op.startsWith(";")) {
                return true;
            }
            this.processOp(op, operand, c);
        }
        this.dumpLine(line);
        this.lastPos = this.pos;
        return true;
    }

    private boolean addLabel(String label, String op, String operand) {
        int lpos;
        if (label.startsWith(";")) {
            return true;
        }
        boolean added = false;
        if (op == null || op.startsWith(";")) {
            added = true;
        }
        if (label.equals("*")) {
            if (op.equals("=")) {
                this.setPos(Assembler.parseInt(operand));
            }
            return true;
        }
        if (op.equals("=") || op.equals(".equ")) {
            lpos = Assembler.parseInt(operand);
            added = true;
        } else {
            if (op.equals(".org")) {
                this.setPos(Assembler.parseInt(operand));
                added = true;
            }
            lpos = this.pos;
        }
        this.labels.put(label, lpos);
        return added;
    }

    private static boolean byteSize(String s) {
        int x = Assembler.parseInt(s);
        return x != -1 && x < 256;
    }

    private void dumpLine(String source) {
        System.out.print("Assembled line " + this.lineNo + ": " + source + " => ");
        for (int i = this.lastPos; i < this.pos; ++i) {
            if (i > this.lastPos) {
                System.out.print(", ");
            }
            System.out.print(String.format("%02x", CPU.CPU.memory.get(i)));
        }
        System.out.println();
    }

    private void dumpSummary() {
        System.out.println("*** Assembly file ended (.end) ");
        System.out.println("-------------------------------");
        System.out.println("Total code size: " + this.lineNo + " lines");
        System.out.println("Ending position: " + String.format("%04x", this.pos));
        System.out.println("-------------------------------");
    }

    private void error(String s) {
        throw new IllegalArgumentException(s + " at line " + this.lineNo);
    }

    private int getLabelAddress(String label) {
        Integer lpos = this.labels.get(label);
        if (lpos != null) {
            return lpos;
        }
        return -1;
    }

    private String getLabel() {
        String label = this.tokens.get(0).trim();
        if (this.tokens.size() == 2) {
            if (!Character.isLetter(label.charAt(0))) {
                label = "";
            } else if (Ops.lookup(label) != -1) {
                label = "";
            }
        }
        return label;
    }

    private String getOp() {
        String op = "";
        if (this.tokens.size() > 2) {
            op = this.tokens.get(1).trim();
        } else if (!this.tokens.isEmpty()) {
            op = this.tokens.get(0).trim();
        }
        return op;
    }

    private String getOperand() {
        String operand = "";
        if (this.tokens.size() > 2) {
            operand = this.tokens.get(2).trim();
        } else if (this.tokens.size() == 2) {
            operand = this.tokens.get(1).trim();
        }
        return operand;
    }

    private static int handleStringConstant(int pos, String operand) {
        int num = 0;
        switch (operand.charAt(0)) {
            case '\"': {
                int n = operand.length();
                for (int i = 1; i < n; ++i) {
                    char c = operand.charAt(i);
                    if (c == '\"') continue;
                    CPU.CPU.memory.set(pos++, c);
                    ++num;
                }
                break;
            }
            case '\'': {
                boolean stuffed = false;
                for (char o : operand.toCharArray()) {
                    if (o != '\'' || stuffed) {
                        CPU.CPU.memory.set(pos++, o);
                        ++num;
                        stuffed = false;
                        continue;
                    }
                    stuffed = true;
                }
                break;
            }
        }
        return num;
    }

    private boolean ignoreComment(String line) {
        if (this.mode == Mode.COMMENT) {
            if (line.endsWith("*/")) {
                this.mode = Mode.CODE;
            }
            return true;
        }
        if (line.startsWith("/*")) {
            this.mode = Mode.COMMENT;
            return true;
        }
        return false;
    }

    private static int parseInt(String s) {
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        switch (s.charAt(0)) {
            case '%': {
                return Integer.parseInt(s.substring(1), 2);
            }
            case '@': {
                return Integer.parseInt(s.substring(1), 8);
            }
            case '$': {
                return Integer.parseInt(s.substring(1), 16);
            }
        }
        return Integer.parseInt(s);
    }

    private static boolean parseFill(List<String> tok, int i) {
        try {
            String type = tok.get(i + 1);
            int radix = 10;
            if (type.equalsIgnoreCase("hex")) {
                radix = 16;
            }
            if (Assembler.scriptFill(tok, i, radix)) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int parsePatch(List<String> tok, int i) {
        try {
            String type = tok.get(i + 1);
            int radix = 10;
            if (type.equalsIgnoreCase("hex")) {
                radix = 16;
            }
            return Assembler.scriptPatch(tok, i, radix);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
    }

    private void processLabel(String op, String operand) {
        switch (op) {
            case ".align": {
                int al = Assembler.parseInt(operand);
                this.setPos(this.pos - (this.pos & al - 1) + al);
                break;
            }
            case ".binary": {
                Assembler.loadBinary(operand, this.pos);
                break;
            }
            case ".byte": {
                this.pos += this.setValue(1, this.pos, operand, true);
                break;
            }
            case ".org": {
                this.setPos(Assembler.parseInt(operand));
                break;
            }
            case ".wdir": {
                this.setWorkingDir(operand);
                break;
            }
            case ".word": {
                this.pos += this.setValue(0, this.pos, operand, true);
                break;
            }
            default: {
                this.error("unhandled operation '" + op + "'");
            }
        }
    }

    private void processOp(String op, String operand, char c) {
        int opI = Ops.lookup(op);
        if (opI == -1) {
            opI = Ops.lookup(operand);
        }
        switch (Ops.getOp(opI)) {
            case BNE: 
            case BEQ: 
            case BCC: 
            case BCS: 
            case BVC: 
            case BPL: 
            case BMI: {
                this.setBranch(Ops.lookup(opI, Ops.Op.RELATIVE.getCode()), operand);
                break;
            }
            case PLA: 
            case PLP: 
            case PHA: 
            case PHP: 
            case TAY: 
            case TAX: 
            case TYA: 
            case TXA: 
            case TXS: 
            case TSX: 
            case RTS: 
            case RTI: 
            case SEI: 
            case CLI: 
            case CLC: 
            case CLD: 
            case CLV: 
            case SEC: 
            case SED: 
            case INX: 
            case INY: 
            case DEX: 
            case DEY: 
            case BRK: 
            case NOP: {
                CPU.CPU.memory.set(this.pos++, Ops.lookup(opI, 0));
                break;
            }
            case JMP: 
            case LDA: 
            case STA: 
            case LDX: 
            case STX: 
            case LDY: 
            case STY: 
            case EOR: 
            case ORA: 
            case AND: 
            case INC: 
            case DEC: 
            case CMP: 
            case CPY: 
            case CPX: 
            case ROL: 
            case ROR: 
            case LSR: 
            case ASL: 
            case ADC: 
            case SBC: 
            case BIT: {
                this.setOperation(opI, operand, op);
                break;
            }
            case JSR: {
                this.writeOp(opI, 0, this.pos++);
                this.pos += this.setValue(0, this.pos, operand);
                break;
            }
            default: {
                this.error("Unhandled OP: '" + op + "' at " + String.format("%04x", this.pos));
            }
        }
    }

    private void reset(int start) {
        this.labels.clear();
        this.references.clear();
        this.setPos(start);
        this.mode = Mode.CODE;
    }

    private void resolveRefs() {
        for (Ref r : this.references) {
            Assembler.setValue(r.value[0], r.value[1], this.resolve(r.name, r.value[1]));
        }
    }

    private int resolve(String name, int pos) {
        char c = name.charAt(0);
        if (c == '<') {
            return this.resolve(name.substring(1), pos) & 0xFF;
        }
        if (c == '>') {
            return this.resolve(name.substring(1), pos) >> 8;
        }
        int n = name.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (name.charAt(i)) {
                case '+': 
                case '-': 
                case '/': {
                    return this.resolve(name.substring(0, i), pos) + this.resolve(name.substring(i + 1), pos);
                }
                case '*': {
                    if (i == 0) {
                        if (n != 1) continue block4;
                        return pos - 1;
                    }
                    return this.resolve(name.substring(0, i), pos) * this.resolve(name.substring(i + 1), pos);
                }
            }
        }
        int address = this.getLabelAddress(name);
        if (address == -1) {
            int val = Assembler.parseInt(name);
            if (val == -1) {
                this.error("### Could not find label " + name);
            }
            return val;
        }
        return address;
    }

    private static boolean scriptFill(List<String> tok, int i, int radix) {
        try {
            int from = Utils.validateInt(tok.get(i + 2), radix, 0, 65536);
            int to = Utils.validateInt(tok.get(i + 3), radix, 0, 65536);
            int value = Utils.validateInt(tok.get(i + 4), radix, 0, 256);
            if (from != -1 && to != -1 && from <= to && value != -1) {
                Assembler.fillMemory(from, to, value);
                System.out.println(Screen.SCREEN.dumpMemory(from, to - from));
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int scriptPatch(List<String> tok, int i, int radix) {
        int from = Utils.validateInt(tok.get(i + 2), radix, 0, 65536);
        if (from == -1) {
            return -1;
        }
        int to = from - 1;
        int sz = tok.size();
        int j = i + 3;
        try {
            String token = tok.get(j);
            while (j < sz && !token.equalsIgnoreCase("/patch")) {
                int val = Utils.validateInt(token, radix, 0, 256);
                if (val != -1) {
                    CPU.CPU.memory.set(++to, val);
                }
                token = tok.get(++j);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (to >= from) {
            System.out.println(Screen.SCREEN.dumpMemory(from, to + 1 - from));
        }
        return j;
    }

    private void setBranch(int op, String line) {
        CPU.CPU.memory.set(this.pos++, op);
        this.setValue(4, this.pos++, line);
    }

    private void setOperation(int opI, String operand, String op) {
        char c = operand.charAt(0);
        if (c == '#') {
            this.writeOp(opI, Ops.Op.IMMEDIATE.getCode(), this.pos++);
            this.pos += this.setValue(1, this.pos, operand.substring(1));
        } else if (c == '(') {
            String oplow = operand.toLowerCase();
            int addrMode = Ops.Op.INDIRECT.getCode();
            int size = 0;
            if (oplow.endsWith(")")) {
                operand = operand.substring(1, operand.length() - 1);
            } else if (oplow.endsWith(",x)")) {
                addrMode = Ops.Op.INDIRECT_X.getCode();
                size = 1;
                operand = operand.substring(1, operand.length() - 3);
            } else if (oplow.endsWith("),y")) {
                addrMode = Ops.Op.INDIRECT_Y.getCode();
                size = 1;
                operand = operand.substring(1, operand.length() - 3);
            } else {
                this.error("Illegal syntax on indirection op " + op);
            }
            this.writeOp(opI, addrMode, this.pos++);
            this.pos += this.setValue(size, this.pos, operand);
        } else {
            String oplow = operand.toLowerCase();
            int addrMode = Ops.Op.ABSOLUTE.getCode();
            int addrModeZ = Ops.Op.ZERO.getCode();
            int size = 0;
            if (oplow.endsWith(",x")) {
                operand = operand.substring(0, operand.length() - 2);
                addrMode = Ops.Op.ABSOLUTE_X.getCode();
                addrModeZ = Ops.Op.ZERO_X.getCode();
            } else if (oplow.endsWith(",y")) {
                operand = operand.substring(0, operand.length() - 2);
                addrMode = Ops.Op.ABSOLUTE_Y.getCode();
                addrModeZ = Ops.Op.ZERO_Y.getCode();
            }
            if (Assembler.byteSize(operand)) {
                size = 1;
                addrMode = addrModeZ;
            }
            this.writeOp(opI, addrMode, this.pos++);
            this.pos += this.setValue(size, this.pos, operand);
        }
    }

    private void setPos(int start) {
        this.pos = this.lastPos = start;
    }

    private int setValue(int type, int pos, String value) {
        return this.setValue(type, pos, value, false);
    }

    private int setValue(int type, int pos, String value, boolean allowArrays) {
        int val;
        if (allowArrays) {
            char c = value.charAt(0);
            if (c == '\'' || c == '\"') {
                return Assembler.handleStringConstant(pos, this.currentLine.substring(this.currentLine.indexOf(c)));
            }
            if (this.tokens.size() > 3) {
                return this.setValueArray(type, pos, this.tokens, 2);
            }
            if (value.indexOf(44) > 0) {
                return this.setValueArray(type, pos, Arrays.asList(value.split(",")), 0);
            }
        }
        if ((val = Assembler.parseInt(value)) != -1) {
            Assembler.setValue(type, pos, val);
        } else {
            this.references.add(new Ref(value.toLowerCase().trim(), type, pos));
        }
        return REF_SIZE[type];
    }

    private int setValueArray(int type, int pos, List<String> tokens, int start) {
        int len = 0;
        for (String s : tokens) {
            String t = s.trim();
            if (t.startsWith(";")) {
                return len;
            }
            if (t.indexOf(44) >= 0) {
                len += this.setValueArray(type, pos + len, Arrays.asList(t.split(",")), 0);
                continue;
            }
            len += this.setValue(type, pos + len, t, false);
        }
        return len;
    }

    private static void setValue(int type, int pos, int value) {
        switch (type) {
            case 3: {
                Assembler.setByteValue(pos, value >> 8);
                break;
            }
            case 1: 
            case 2: {
                Assembler.setByteValue(pos, value & 0xFF);
                break;
            }
            case 4: {
                Assembler.setRelativeValue(pos, value);
                break;
            }
            case 0: {
                Assembler.setWordValue(pos, value);
                break;
            }
        }
    }

    private static void setWordValue(int pos, int val) {
        CPU.CPU.memory.set(pos, val & 0xFF);
        CPU.CPU.memory.set(pos + 1, val >> 8 & 0xFF);
    }

    private static void setByteValue(int pos, int val) {
        CPU.CPU.memory.set(pos, val & 0xFF);
    }

    private static void setRelativeValue(int pos, int val) {
        CPU.CPU.memory.set(pos, val - pos - 1 & 0xFF);
    }

    private void setWorkingDir(String dir) {
        this.workingDir = dir;
        if (!this.workingDir.endsWith("/")) {
            this.workingDir = this.workingDir + "/";
        }
    }

    private void writeOp(int opI, int mode, int pos) {
        int opR = Ops.lookup(opI, mode);
        if (opR == -1) {
            this.error(Ops.modeString(mode) + " mode not available for " + Ops.INS_STR[opI]);
        }
        CPU.CPU.memory.set(pos, opR);
    }

    private static final class Ref {
        final String name;
        final int[] value;

        Ref(String name, int type, int pos) {
            this.name = name;
            this.value = new int[]{type, pos};
        }
    }

    private static enum Mode {
        CODE,
        COMMENT;

    }
}

