/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.etc;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.free.j64.etc.Utils;
import org.free.j64.net.Net;

public enum Config {
    CONFIG;

    private final Map<String, Object> config = new HashMap<String, Object>();
    private final Map<String, Net.User> users = new HashMap<String, Net.User>();
    private final String[] TAGS = new String[]{"server", "auto", "port", "users", "user", "address", "name", "max"};
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private final XMLEvent dtdLF = this.eventFactory.createDTD("\n");
    private final XMLEvent dtdTab = this.eventFactory.createDTD("\t");

    private Config() {
        this.config.put("serverAuto", false);
        this.config.put("serverMax", 0);
        this.config.put("serverPort", 6464);
        this.config.put("users", this.users);
        Net.ServerSession.SS.setUsers(this.users);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void read(InputStream is) {
        try {
            XMLEventReader er = XMLInputFactory.newInstance().createXMLEventReader(is);
            Net.User user = null;
            while (er.hasNext()) {
                EndElement endElement;
                XMLEvent event = er.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    if (startElement.getName().getLocalPart().equals(this.TAGS[4])) {
                        user = new Net.User();
                        continue;
                    }
                    String field = this.getValue(event, er, this.TAGS[1]);
                    if (!field.isEmpty() && field.equalsIgnoreCase("true")) {
                        this.config.put("serverAuto", true);
                        continue;
                    }
                    field = this.getValue(event, er, this.TAGS[2]);
                    if (!field.isEmpty()) {
                        this.config.put("serverPort", Integer.parseInt(field));
                        continue;
                    }
                    field = this.getValue(event, er, this.TAGS[7]);
                    if (!field.isEmpty()) {
                        int max = Integer.parseInt(field);
                        this.config.put("serverMax", max);
                        Net.ServerSession.SS.setMaxCon(max);
                        continue;
                    }
                    field = this.getValue(event, er, this.TAGS[5]);
                    if (!field.isEmpty()) {
                        user.setAddress(field);
                        continue;
                    }
                    field = this.getValue(event, er, this.TAGS[6]);
                    if (!field.isEmpty()) {
                        user.setName(field);
                        continue;
                    }
                }
                if (!event.isEndElement() || !(endElement = event.asEndElement()).getName().getLocalPart().equals(this.TAGS[4])) continue;
                this.users.put(user.getAddress(), user);
            }
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void read(String file) {
        try (FileInputStream is = new FileInputStream(file);){
            this.read(is);
        }
        catch (IOException ex) {
            this.read(Utils.getResourceStream(Config.class, "/META-INF/" + file));
            try {
                this.write(file);
            }
            catch (Exception ex1) {
                Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    public void write(OutputStream os) throws Exception {
        XMLEventWriter ew = XMLOutputFactory.newInstance().createXMLEventWriter(os);
        ew.add(this.eventFactory.createStartDocument());
        this.writeEvent(ew, this.dtdLF, 2);
        ew.add(this.eventFactory.createStartElement("", "", "config"));
        this.writeEvent(ew, this.dtdLF, 1);
        this.writeEvent(ew, this.dtdTab, 1);
        ew.add(this.eventFactory.createStartElement("", "", this.TAGS[0]));
        this.writeEvent(ew, this.dtdLF, 1);
        this.writeEvent(ew, this.dtdTab, 1);
        this.createNode(ew, "auto", String.valueOf(this.config.get("serverAuto")));
        this.writeEvent(ew, this.dtdTab, 1);
        this.createNode(ew, "max", String.valueOf(this.config.get("serverMax")));
        this.writeEvent(ew, this.dtdTab, 1);
        this.createNode(ew, "port", String.valueOf(this.config.get("serverPort")));
        this.writeEvent(ew, this.dtdTab, 1);
        ew.add(this.eventFactory.createEndElement("", "", this.TAGS[0]));
        this.writeEvent(ew, this.dtdLF, 2);
        this.writeEvent(ew, this.dtdTab, 1);
        ew.add(this.eventFactory.createStartElement("", "", this.TAGS[3]));
        this.writeEvent(ew, this.dtdLF, 1);
        for (Net.User u : this.users.values()) {
            this.writeEvent(ew, this.dtdTab, 2);
            ew.add(this.eventFactory.createStartElement("", "", this.TAGS[4]));
            this.writeEvent(ew, this.dtdLF, 1);
            this.writeEvent(ew, this.dtdTab, 2);
            this.createNode(ew, "address", u.getAddress());
            this.writeEvent(ew, this.dtdTab, 2);
            this.createNode(ew, "name", u.getName());
            this.writeEvent(ew, this.dtdTab, 2);
            ew.add(this.eventFactory.createEndElement("", "", this.TAGS[4]));
            this.writeEvent(ew, this.dtdLF, 1);
        }
        this.writeEvent(ew, this.dtdTab, 1);
        ew.add(this.eventFactory.createEndElement("", "", this.TAGS[3]));
        this.writeEvent(ew, this.dtdLF, 1);
        ew.add(this.eventFactory.createEndElement("", "", "config"));
        this.writeEvent(ew, this.dtdLF, 1);
        ew.add(this.eventFactory.createEndDocument());
        ew.close();
    }

    public void write(String file) throws Exception {
        try (FileOutputStream os = new FileOutputStream(file);){
            this.write(os);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createNode(XMLEventWriter ew, String name, String value) throws XMLStreamException {
        this.writeEvent(ew, this.dtdTab, 1);
        ew.add(this.eventFactory.createStartElement("", "", name));
        ew.add(this.eventFactory.createCharacters(value));
        ew.add(this.eventFactory.createEndElement("", "", name));
        this.writeEvent(ew, this.dtdLF, 1);
    }

    private String getValue(XMLEvent event, XMLEventReader eventReader, String field) throws XMLStreamException {
        if (event.asStartElement().getName().getLocalPart().equals(field)) {
            event = eventReader.nextEvent();
            return event.asCharacters().getData();
        }
        return "";
    }

    private void writeEvent(XMLEventWriter ew, XMLEvent ev, int n) throws XMLStreamException {
        for (int i = 0; i < n; ++i) {
            ew.add(ev);
        }
    }
}

