/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.etc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.free.j64.io.Screen;

public final class Utils {
    public static final String txt = "txt";
    public static final String localDate = new SimpleDateFormat("yy-MM-dd", Locale.ENGLISH).format(new Date());
    public static final String a65 = "a65";
    public static final String bin = "bin";
    public static final String d64 = "d64";
    public static final String prg = "prg";
    public static final String p00 = "p00";
    public static final String t64 = "t64";
    public static final String bmp = "bmp";
    public static final String gif = "gif";
    public static final String jpg = "jpg";
    private static final int DEFAULT_IMAGE_TYPE = 1;

    private Utils() {
    }

    public static void appendTextFile(String file, String data) {
        if (data.isEmpty()) {
            return;
        }
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file, true));){
            out.write(data);
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void appendTextFile(String file, List<String> data) {
        if (data.isEmpty()) {
            return;
        }
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file, true));){
            for (String s : data) {
                out.write(s);
            }
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void closeObject(Closeable cs, String msg) {
        try {
            if (!msg.isEmpty()) {
                System.err.println(msg);
            }
            cs.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static BufferedImage createImage(Image image) {
        return Utils.createImage(image, 1);
    }

    public static BufferedImage createImage(Image img, int type) {
        BufferedImage bimg = new BufferedImage(img.getWidth(null), img.getHeight(null), type);
        bimg.createGraphics().drawImage(img, null, null);
        return bimg;
    }

    public static void dumpMemory(int from, int to, boolean save, String file) {
        String localTime = new SimpleDateFormat("yy-MM-dd hh:mm:ss", Locale.ENGLISH).format(new Date());
        String header = String.format("%s%nMEMORY DUMP %s%n%s%n", "==================================================", localTime, "==================================================");
        String msg = String.format("%s%s", header, Screen.SCREEN.dumpMemory(from, to - from));
        Utils.dumpMsg(msg, save, file);
    }

    public static void dumpMsg(String msg, boolean save, String file) {
        if (msg.isEmpty()) {
            return;
        }
        if (save) {
            Utils.appendTextFile(file, msg);
            System.out.format("%s updated%n", file);
        } else {
            System.out.println(msg);
        }
    }

    public static SimpleAttributeSet getAttributes(Color color, int size) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.Foreground, color);
        attr.addAttribute(StyleConstants.FontSize, size);
        return attr;
    }

    public static String getExtension(String s) {
        String ext = "";
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    public static String getFileName(String fullPathName, String fileSeparator) {
        int namePos = fullPathName.lastIndexOf(fileSeparator);
        if (namePos != -1 && namePos < fullPathName.length() - 1) {
            return fullPathName.substring(namePos + 1);
        }
        return fullPathName;
    }

    public static String getFileName(String file) {
        int i = file.lastIndexOf(46);
        if (i != -1) {
            return file.substring(0, i);
        }
        return file;
    }

    public static List<File> getFileList(String file) {
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return Utils.isAcceptProgram(f);
            }
        };
        File[] dir = new File(new File(file).getParent()).listFiles(ff);
        if (dir == null) {
            return Collections.emptyList();
        }
        Arrays.sort(dir, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return Collections.unmodifiableList(Arrays.asList(dir));
    }

    public static InputStream getResourceStream(Class<?> c, String r) {
        try {
            return c.getResource(r).openConnection().getInputStream();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getText(String file) {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String s;
            ArrayList<String> data = new ArrayList<String>();
            while ((s = in.readLine()) != null) {
                data.add(s);
            }
            ArrayList<String> arrayList = data;
            return arrayList;
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getTokens(String file) {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String s;
            ArrayList<String> data = new ArrayList<String>();
            while ((s = in.readLine()) != null) {
                data.addAll(Utils.split(s, "\\s"));
            }
            ArrayList<String> arrayList = data;
            return arrayList;
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
    }

    public static String getHex(int num) {
        if (num >= 0 && num < 256) {
            return String.format("$%02x", num).toUpperCase();
        }
        if (num < 65536) {
            return String.format("$%04x", num).toUpperCase();
        }
        return "";
    }

    public static int getInt(String num) {
        String s = num.trim();
        try {
            if (s.startsWith("$")) {
                return Integer.parseInt(s.substring(1), 16);
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static void initWindow(final Window win, JRootPane rp, JButton btn) {
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        win.setLocation((sz.width - win.getWidth()) / 2, (sz.height - win.getHeight()) / 2);
        rp.setDefaultButton(btn);
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        rp.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "WindowClosing");
        rp.getActionMap().put("WindowClosing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                win.setVisible(false);
            }
        });
    }

    public static boolean isAcceptAssembly(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(file.getName());
        return !extension.isEmpty() && (extension.equals(a65) || extension.equals(bin) || extension.equals(txt));
    }

    public static boolean isAcceptBinary(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(file.getName());
        return !extension.isEmpty() && (extension.equals(a65) || extension.equals(bin));
    }

    public static boolean isAcceptProgram(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(file.getName());
        return !extension.isEmpty() && (extension.equals(d64) || extension.equals(t64) || extension.equals(prg) || extension.equals(p00) || extension.equals(txt));
    }

    public static boolean isAcceptPicture(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String extension = Utils.getExtension(file.getName());
        return !extension.isEmpty() && (extension.equals(bmp) || extension.equals(gif) || extension.equals(jpg));
    }

    public static void setText(JTextField lower, JTextField upper) {
        String s = lower.getText();
        int val = Utils.getInt(s) + 1;
        if (s.startsWith("$")) {
            upper.setText(Utils.getHex(val));
        } else {
            upper.setText(String.valueOf(val));
        }
    }

    public static void showChooser(JFileChooser fc) {
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        fc.setLocation((sz.width - fc.getWidth()) / 2, (sz.height - fc.getHeight()) / 2);
        fc.setVisible(true);
    }

    public static List<String> split(String str, String pattern) {
        ArrayList<String> t = new ArrayList<String>();
        for (String s : str.split(pattern)) {
            if (s.isEmpty()) continue;
            t.add(s);
        }
        return t;
    }

    public static void writeFile(String file, byte[] data, int size) {
        if (size < 1) {
            return;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)out).write(data, 0, size);
            ((OutputStream)out).flush();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static int[] unpack(int[] data) {
        int[] tmp = new int[4096];
        int pos = 0;
        for (int d : data) {
            if (d >> 8 > 0) {
                int m = d >> 8;
                for (int j = 0; j < m; ++j) {
                    tmp[pos++] = d & 0xFF;
                }
                continue;
            }
            tmp[pos++] = d;
        }
        return tmp;
    }

    public static int validateInt(String num, int radix, int low, int high) {
        String s = num.trim();
        try {
            int n = s.startsWith("$") ? Integer.parseInt(s.substring(1), 16) : Integer.parseInt(s, radix);
            if (n >= low && n < high) {
                return n;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return -1;
    }
}

