/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import org.free.j64.app.C64;
import org.free.j64.app.Desktop;
import org.free.j64.etc.Config;
import org.free.j64.etc.Utils;
import org.free.j64.net.Net;
import org.free.j64.net.type.Key;

public final class Admin
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(Admin.class);
    private final Callback cb;
    private final Map<String, Object> config = Config.CONFIG.getConfig();
    private final Map<String, Net.User> users = (Map)this.config.get("users");
    private int fontSize = 14;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextPane jTextPane1;

    public Admin(Callback cb) {
        this.cb = cb;
        this.initComponents();
        Utils.initWindow(this, this.getRootPane(), this.jButton1);
        this.initForm();
    }

    private void initForm() {
        this.jTextField1.setText("");
        this.jTextField1.requestFocusInWindow();
        this.fontSize = prefs.node("User").getInt("FontSize", 14);
        this.newTextFont();
        this.update(this.showHelp(), Utils.getAttributes(Color.blue, this.fontSize));
        this.update(this.showStatus(), Utils.getAttributes(Color.gray, this.fontSize));
        this.listUsers();
        this.setVisible(true);
    }

    private void parseInput() {
        String msg = this.jTextField1.getText();
        if (msg.length() < 3) {
            return;
        }
        switch (msg.toLowerCase().substring(0, 3)) {
            case "add": {
                this.addUser(msg);
                break;
            }
            case "aud": {
                this.setAudioDelay(msg);
                break;
            }
            case "aut": {
                this.setAuto(msg);
                break;
            }
            case "bye": 
            case "qui": {
                this.quit();
                break;
            }
            case "del": {
                this.delUser(msg);
                break;
            }
            case "/fs": {
                this.setFontSize(msg);
                break;
            }
            case "hel": {
                this.update(this.showHelp(), Utils.getAttributes(Color.blue, this.fontSize));
                break;
            }
            case "ima": {
                this.setImageDelay(msg);
                break;
            }
            case "jam": {
                this.setJam(msg);
                break;
            }
            case "joy": {
                this.setJoystick(msg);
                break;
            }
            case "key": {
                this.setKeySender(msg);
                break;
            }
            case "max": {
                this.setMax(msg);
                break;
            }
            case "por": {
                this.setPort(msg);
                break;
            }
            case "sta": {
                this.update(this.showStatus(), Utils.getAttributes(Color.gray, this.fontSize));
                break;
            }
            case "use": {
                this.listUsers();
                break;
            }
            default: {
                this.update("command not recognized\n", Utils.getAttributes(Color.red, this.fontSize));
            }
        }
        this.jTextField1.setText("");
    }

    private void addUser(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: add <address> [name]\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        String user = cmd.get(1).trim();
        if (this.users.containsKey(user)) {
            this.update(String.format("user %s already in list%n", user), Utils.getAttributes(Color.red, this.fontSize));
            this.listUsers();
        } else {
            int n = cmd.size();
            if (n > 2) {
                StringBuilder s = new StringBuilder();
                for (int i = 2; i < n; ++i) {
                    s.append(cmd.get(i)).append(" ");
                }
                this.users.put(user, new Net.User(user, s.toString()));
            } else {
                this.users.put(user, new Net.User(user));
            }
            this.update(String.format("user %s added%n", user), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void delUser(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: del <address>\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        String user = cmd.get(1).trim();
        if (!this.users.containsKey(user)) {
            this.update(String.format("user %s not found%n", user), Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.users.remove(user);
            this.update(String.format("user %s deleted%n", user), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void listUsers() {
        for (Net.User u : this.users.values()) {
            this.update(String.format("%s %s%n", u.getAddress(), u.getName()), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void newTextFont() {
        Font f = this.jTextField1.getFont();
        this.jTextField1.setFont(new Font(f.getFontName(), f.getStyle(), this.fontSize));
    }

    public void quit() {
        this.setVisible(false);
        this.cb.enableMenus();
        try {
            Config.CONFIG.write("c64-config.xml");
        }
        catch (Exception ex) {
            Logger.getLogger(Admin.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.dispose();
    }

    private void setAuto(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: auto <0 or 1> (0 is off, 1 is on)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int auto = Integer.parseInt(cmd.get(1).trim());
        if (auto < 0 || auto > 1) {
            this.update("format: auto <0 or 1> (0 is off, 1 is on)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.config.put("serverAuto", auto == 1);
            this.update(String.format("auto set to %d%n", auto), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setAudioDelay(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: audio <interval> (1 to 10 ms)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int interval = Utils.validateInt(cmd.get(1), 10, 1, 11);
        if (interval == -1) {
            this.update("format: audio <interval> (1 to 10 ms)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            Desktop.appPrefs.node("VNC").putInt("AudioDelay", interval);
            C64.C64.setAudioDelay(interval);
            this.update(String.format("audio interval set to %d%n", interval), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setFontSize(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: /fs <number> (where 8 <= number <= 24)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int size = Utils.validateInt(cmd.get(1), 10, 8, 25);
        if (size == -1) {
            this.update("format: /fs <number> (where 8 <= number <= 24)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.fontSize = size;
            this.newTextFont();
            prefs.node("User").putInt("FontSize", this.fontSize);
            this.update(String.format("font size set to %d%n", size), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setImageDelay(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: image <interval> (20 to 50 ms)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int interval = Utils.validateInt(cmd.get(1), 10, 20, 51);
        if (interval == -1) {
            this.update("format: image <interval> (20 to 50 ms)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            Desktop.appPrefs.node("VNC").putInt("ImageDelay", interval);
            C64.C64.setImageDelay(interval);
            this.update(String.format("image interval set to %d%n", interval), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setJam(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: jam <0 or 1> (0 is off, 1 is on)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int jam = Integer.parseInt(cmd.get(1).trim());
        if (jam < 0 || jam > 1) {
            this.update("format: jam <0 or 1> (0 is off, 1 is on)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            boolean jammer = jam == 1;
            Desktop.appPrefs.node("VNC").putBoolean("keyJam", jammer);
            C64.C64.setKeyJam(jammer);
            this.update(String.format("jam set to %d%n", jam), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setJoystick(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: joy <1 or 2> (port for key sender in 2 player game)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int port = Integer.parseInt(cmd.get(1).trim());
        if (port < 1 || port > 2) {
            this.update("format: joy <1 or 2> (port for key sender in 2 player game)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            Desktop.appPrefs.node("VNC").putInt("JoyPort", port);
            C64.C64.setJoyPort(port);
            this.update(String.format("joystick set to %d%n", port), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setKeySender(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: key <address>\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        String user = cmd.get(1).trim();
        if (!this.users.containsKey(user)) {
            this.update("format: key <address>\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.updateSender(user);
            this.update(String.format("key sender set to %s%n", user), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setMax(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: max <number> (where 0 <= number)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int max = Utils.validateInt(cmd.get(1), 10, 0, Integer.MAX_VALUE);
        if (max == -1) {
            this.update("format: max <number> (where 0 <= number)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.config.put("serverMax", max);
            Net.ServerSession.SS.setMaxCon(max);
            this.update(String.format("max set to %d%n", max), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setPort(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: port <number> (where 1824 <= number < 65536)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int port = Utils.validateInt(cmd.get(1), 10, 1024, 65536);
        if (port == -1) {
            this.update("format: port <number> (where 1824 <= number < 65536)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.config.put("serverPort", port);
            this.update(String.format("port set to %d%n", port), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private String showHelp() {
        return String.format("%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s", "\nSERVER ADMIN CONSOLE\n\n", "Commands: (only first 3 chars required)\n\n", "add <address> [name] - add user [name optional]\n", "audio <interval> - set transmission delay interval (0 is off or 1 to 10 ms)\n", "auto <0 or 1> - stop (0) or start (1) server on app startup\n", "bye or quit - close and commit changes\n", "del <address> - block user\n", "/fs <size> - set font size (8 to 24)\n", "help - this help message\n", "image <interval> - set transmission delay interval (0 is off or 1 to 50 ms)\n", "jam <0 or 1> - stop (0) or start (1) remote key jam detector\n", "joy <1 or 2> - port 1 or 2 for key sender in 2 player games\n", "key <address> - give user permission to send keys\n", "max <number> - max simultaneous connections (0 for unlimited)\n", "port <number> - change server port (requires server restart)\n", "status - current uncommitted settings\n", "users - list all permitted users\n\n");
    }

    private String showStatus() {
        return String.format("%s%s%s%s%s%s%s%s%s", "\nSERVER STATUS\n\n", String.format("audio delay is %dms\n", C64.C64.getAudioDelay()), String.format("autostart is %s\n", (Boolean)this.config.get("serverAuto") != false ? "on" : "off"), String.format("image delay is %dms\n", C64.C64.getImageDelay()), String.format("joystick port for key sender is %d\n", C64.C64.getJoyPort()), String.format("key jam detector is %s\n", C64.C64.isKeyJam() ? "on" : "off"), String.format("key sender is %s\n", !Net.ServerSession.SS.getKeySender().isEmpty() ? Net.ServerSession.SS.getKeySender() : "not set"), String.format("max connections is %d\n", (int)((Integer)this.config.get("serverMax"))), String.format("port number is %d\n%n", (int)((Integer)this.config.get("serverPort"))));
    }

    private void update(String msg, SimpleAttributeSet attr) {
        StyledDocument doc = this.jTextPane1.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), msg, attr);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Admin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateSender(String user) {
        if (!Net.ServerSession.SS.getKeySender().isEmpty()) {
            Net.ServerSession.SS.sendKey(Net.ServerSession.SS.getKeySender(), new Key(0));
        }
        Net.ServerSession.SS.setKeySender(user);
        Net.ServerSession.SS.sendKey(user, new Key(1));
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jTextField1 = new JTextField();
        this.setDefaultCloseOperation(0);
        this.setTitle("Server Admin");
        this.setMinimumSize(new Dimension(640, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Admin.this.windowClosing(evt);
            }
        });
        this.jButton1.setFont(new Font("Dialog", 1, 13));
        this.jButton1.setMnemonic('Q');
        this.jButton1.setText("Quit");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Admin.this.actionPerformed(evt);
            }
        });
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setFont(new Font("Dialog", 1, 13));
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jTextField1.setFont(new Font("Dialog", 1, 13));
        this.jTextField1.setText("jTextField2");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Admin.this.actionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jTextField1, -1, 412, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 315, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jTextField1, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.jButton1, this.jTextField1);
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd;
        if (evt.getSource().equals(this.jTextField1)) {
            this.parseInput();
        }
        if ((cmd = evt.getActionCommand()).startsWith("Quit")) {
            this.quit();
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.quit();
    }

    public static interface Callback {
        public void enableMenus();
    }
}

