/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import org.free.j64.app.Desktop;
import org.free.j64.cpu.Assembler;
import org.free.j64.etc.Utils;
import org.free.j64.gui.Dump;
import org.free.j64.io.Screen;

public final class Patch
extends JDialog {
    private static final String scriptFile = String.format("c64-script-%s.txt", Utils.localDate);
    private static final FileFilter openAssembly = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return Utils.isAcceptAssembly(f);
        }

        @Override
        public String getDescription() {
            return "Assembly files (a65|bin|txt)";
        }
    };
    private static final FileFilter saveBinary = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return Utils.isAcceptBinary(f);
        }

        @Override
        public String getDescription() {
            return "Binary files (bin)";
        }
    };
    private final Frame parent;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JCheckBox jCheckBox1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;

    public Patch(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.initComponents();
        Utils.initWindow(this, this.getRootPane(), this.jButton1);
        this.jButton1.requestFocusInWindow();
        this.setVisible(true);
    }

    private void dumpPatch(int from, int to, boolean isHex) {
        String strPatch = isHex ? "PATCH HEX %04x%n%s%n/PATCH%n" : "PATCH DEC %d%n%s%n/PATCH%n";
        this.dumpPatch(String.format(strPatch, from, Screen.SCREEN.dumpRawMemory(from, to - from, isHex)), from, to);
    }

    private void dumpPatch(String msg, int from, int to) {
        Utils.dumpMemory(from, to, Desktop.saveDump(), Desktop.debugFile);
        Utils.dumpMsg(msg, Desktop.saveDump(), scriptFile);
    }

    private void fillMemory() {
        int from = Utils.validateInt(this.jTextField1.getText(), 10, 0, 65536);
        int to = Utils.validateInt(this.jTextField2.getText(), 10, 0, 65536);
        int value = Utils.validateInt(this.jTextField3.getText(), 10, 0, 256);
        if (from != -1 && to != -1 && from <= to && value != -1) {
            Assembler.fillMemory(from, to, value);
            String strFill = this.jCheckBox1.isSelected() ? "FILL HEX %04x %02x %02x%n" : "FILL DEC %d %d %d%n";
            this.dumpPatch(String.format(strFill, from, to, value), from, to);
        } else {
            System.err.format("Fill memory locations: 0 <= from < to < 65536 and 0 <= value < 256%n", new Object[0]);
        }
    }

    private void openAssemblyDialog() {
        this.jFileChooser1.setDialogTitle("Open C64 Assembly File");
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setFileFilter(openAssembly);
        this.jFileChooser1.removeChoosableFileFilter(saveBinary);
        Utils.showChooser(this.jFileChooser1);
    }

    private void openAssembly() {
        final int from = Utils.validateInt(this.jTextField4.getText(), 10, 0, 65536);
        if (from != -1) {
            this.openAssemblyDialog();
            if (this.jFileChooser1.showOpenDialog(this) == 0) {
                final String path = this.jFileChooser1.getSelectedFile().toString();
                String name = this.jFileChooser1.getSelectedFile().getName();
                final String ext = Utils.getExtension(name);
                this.jButton6.setEnabled(false);
                final boolean isHex = this.jCheckBox1.isSelected();
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        if (ext.equalsIgnoreCase("a65")) {
                            Patch.this.dumpPatch(from, new Assembler().assemble(Utils.getText(path), from), isHex);
                        } else if (ext.equalsIgnoreCase("bin")) {
                            Patch.this.dumpPatch(from, Assembler.loadBinary(path, from), isHex);
                        } else if (ext.equalsIgnoreCase("txt")) {
                            Assembler.loadScript(path);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        Patch.this.jButton6.setEnabled(true);
                    }
                }.execute();
            }
            this.jFileChooser1.setVisible(false);
        } else {
            System.err.format("Patch memory location: 0 <= from < 65536%n", new Object[0]);
        }
    }

    private void saveBinaryDialog() {
        this.jFileChooser1.setDialogTitle("Save C64 Binary File");
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.setFileFilter(saveBinary);
        this.jFileChooser1.removeChoosableFileFilter(openAssembly);
        Utils.showChooser(this.jFileChooser1);
    }

    private void saveBinary() {
        final int from = Utils.validateInt(this.jTextField5.getText(), 10, 0, 65536);
        final int to = Utils.validateInt(this.jTextField6.getText(), 10, 0, 65536);
        if (from != -1 && to != -1 && from <= to) {
            this.saveBinaryDialog();
            if (this.jFileChooser1.showSaveDialog(this) == 0) {
                String path = this.jFileChooser1.getSelectedFile().toString();
                String name = this.jFileChooser1.getSelectedFile().getName();
                if (!Utils.getExtension(name).equalsIgnoreCase("bin")) {
                    path = String.format("%s.%s", path, "bin");
                }
                final String p = path;
                this.jButton5.setEnabled(false);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        Assembler.saveBinary(p, from, to);
                        return null;
                    }

                    @Override
                    protected void done() {
                        Patch.this.jButton5.setEnabled(true);
                    }
                }.execute();
            }
            this.jFileChooser1.setVisible(false);
        } else {
            System.err.format("Save memory locations: 0 <= from < to < 65536%n", new Object[0]);
        }
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jTextField6 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Patch Memory");
        this.setResizable(false);
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setText("From");
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setText("To");
        this.jTextField2.setFont(new Font("Dialog", 1, 16));
        this.jTextField2.setText("65535");
        this.jTextField2.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Patch.this.focusLost(evt);
            }
        });
        this.jTextField1.setFont(new Font("Dialog", 1, 16));
        this.jTextField1.setText("0");
        this.jTextField1.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Patch.this.focusLost(evt);
            }
        });
        this.jButton1.setMnemonic('C');
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Patch.this.actionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("Dialog", 1, 14));
        this.jButton2.setMnemonic('F');
        this.jButton2.setText("Fill");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Patch.this.actionPerformed(evt);
            }
        });
        this.jLabel5.setDisplayedMnemonic('V');
        this.jLabel5.setFont(new Font("Dialog", 1, 14));
        this.jLabel5.setText("Value");
        this.jTextField3.setFont(new Font("Dialog", 1, 16));
        this.jTextField3.setText("0");
        this.jTextField3.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField3.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Patch.this.focusLost(evt);
            }
        });
        this.jLabel7.setFont(new Font("Dialog", 1, 14));
        this.jLabel7.setText("From");
        this.jTextField4.setFont(new Font("Dialog", 1, 16));
        this.jTextField4.setText("0");
        this.jTextField4.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField4.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Patch.this.focusLost(evt);
            }
        });
        this.jButton4.setMnemonic('D');
        this.jButton4.setText("Dump");
        this.jButton4.setToolTipText("");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Patch.this.actionPerformed(evt);
            }
        });
        this.jButton5.setMnemonic('S');
        this.jButton5.setText("Save");
        this.jButton5.setToolTipText("");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Patch.this.actionPerformed(evt);
            }
        });
        this.jButton6.setFont(new Font("Dialog", 1, 14));
        this.jButton6.setMnemonic('P');
        this.jButton6.setText("Patch");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Patch.this.actionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Dialog", 1, 14));
        this.jLabel4.setText("From");
        this.jTextField5.setFont(new Font("Dialog", 1, 16));
        this.jTextField5.setText("0");
        this.jTextField5.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField5.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Patch.this.focusLost(evt);
            }
        });
        this.jTextField6.setFont(new Font("Dialog", 1, 16));
        this.jTextField6.setText("65535");
        this.jTextField6.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField6.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Patch.this.focusLost(evt);
            }
        });
        this.jLabel6.setFont(new Font("Dialog", 1, 14));
        this.jLabel6.setText("To");
        this.jCheckBox1.setFont(new Font("Dialog", 1, 13));
        this.jCheckBox1.setMnemonic('H');
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("Hex Dump");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jTextField5, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(layout.createSequentialGroup().addComponent(this.jTextField6, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton5)))).addComponent(this.jLabel7).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jTextField2, -2, 75, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jTextField4, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addComponent(this.jLabel5).addGroup(layout.createSequentialGroup().addComponent(this.jTextField3, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2)))))).addGroup(layout.createSequentialGroup().addGap(103, 103, 103).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButton1, this.jButton2, this.jButton4, this.jButton5, this.jButton6);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField3, -2, -1, -2)).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jButton6).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField6, -2, -1, -2).addComponent(this.jButton5)).addComponent(this.jTextField5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton4).addComponent(this.jButton1)).addContainerGap()));
        layout.linkSize(1, this.jButton1, this.jButton2, this.jButton4, this.jButton5, this.jButton6);
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("Close")) {
            this.setVisible(false);
        } else if (cmd.startsWith("Dump")) {
            new Dump(this.parent, false);
        } else if (cmd.startsWith("Fill")) {
            this.fillMemory();
        } else if (cmd.startsWith("Patch")) {
            this.openAssembly();
        } else if (cmd.startsWith("Save")) {
            this.saveBinary();
        }
    }

    private void focusLost(FocusEvent evt) {
        if (evt.getSource() instanceof JTextField) {
            JTextField o = (JTextField)evt.getSource();
            o.setText(o.getText().toUpperCase());
        }
        if (evt.getSource().equals(this.jTextField1)) {
            Utils.setText(this.jTextField1, this.jTextField2);
        } else if (evt.getSource().equals(this.jTextField5)) {
            Utils.setText(this.jTextField5, this.jTextField6);
        }
    }
}

