/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.io;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.free.j64.cpu.CPU;
import org.free.j64.io.C64File;

public enum Loader {
    LOADER;

    private final StringBuilder sb = new StringBuilder();
    private final Map<String, C64File> programs = new HashMap<String, C64File>();
    private final byte[][] sectors = new byte[800][256];
    private Media type;

    public void load(String program) {
        C64File entry = this.get(program);
        if (entry == null) {
            return;
        }
        if (this.type == Media.DISK) {
            this.loadDisk(entry);
        } else {
            this.loadTape(entry);
        }
    }

    public void buildList(String file, Media type) {
        this.programs.clear();
        this.type = type;
        if (type == Media.DISK) {
            this.readDisk(file);
        } else if (type == Media.TAPE) {
            this.readTape(file);
        }
    }

    public List<String> getList() {
        ArrayList<String> l = new ArrayList<String>();
        for (C64File f : this.programs.values()) {
            l.add(f.getName());
        }
        return l;
    }

    public void readPGM(String file, int address) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int n;
            byte[] start = new byte[2];
            ((InputStream)is).read(start);
            int sector = 0;
            while ((n = this.readSector(is, sector)) == 256) {
                ++sector;
            }
            if (address == -1) {
                address = start[0] + (start[1] << 8);
            }
            int m = (sector << 8) + n;
            for (int i = 0; i < m; ++i) {
                CPU.CPU.memory.set(address++, this.sectors[i >> 8][i & 0xFF] & 0xFF);
            }
            this.setAddress(address);
        }
        catch (Exception ex) {
            Logger.getLogger(Loader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void add(byte[] data, int track, int sector) {
        if (sector == 0) {
            return;
        }
        for (int start = 0; start < 255 && data[start + 2] != 0; start += 32) {
            this.sb.delete(0, this.sb.length());
            for (int i = 0; i < 16; ++i) {
                if (data[start + 5 + i] != -96) {
                    this.sb.append((char)data[start + 5 + i]);
                    continue;
                }
                this.sb.append(" ");
            }
            int size = data[start + 30] & 255 + data[start + 31] * 256;
            if (size <= 0) continue;
            this.programs.put(this.sb.toString(), new C64File(this.sb.toString(), data[start + 3], data[start + 4], size, data[start + 2] & 0xFF));
        }
    }

    private C64File get(String program) {
        C64File entry = null;
        if (program.contains("*")) {
            String match = program.substring(0, program.indexOf(42));
            for (Map.Entry<String, C64File> e : this.programs.entrySet()) {
                if (!e.getKey().startsWith(match)) continue;
                return e.getValue();
            }
        } else {
            entry = this.programs.get(program);
            if (entry == null) {
                this.sb.delete(0, this.sb.length());
                int n = 16;
                for (int i = program.length(); i < n; ++i) {
                    this.sb.append(' ');
                }
                entry = this.programs.get(this.sb.toString());
            }
        }
        return entry;
    }

    private void loadDisk(C64File entry) {
        boolean reading;
        byte[] sector = this.getSector(entry.getTrack(), entry.getSector());
        int address = (sector[2] & 0xFF) + (sector[3] & 0xFF) * 256;
        int nxtSector = sector[1] & 0xFF;
        int nxtTrack = sector[0] & 0xFF;
        for (int i = 0; i < 252; ++i) {
            CPU.CPU.memory.set(i + address, sector[i + 4] & 0xFF);
        }
        address += 252;
        boolean bl = reading = nxtTrack != 0;
        while (reading) {
            sector = this.getSector(nxtTrack, nxtSector);
            nxtSector = sector[1] & 0xFF;
            nxtTrack = sector[0] & 0xFF;
            reading = nxtTrack != 0;
            for (int i = 0; i < 254; ++i) {
                CPU.CPU.memory.set(i + address, sector[i + 2] & 0xFF);
            }
            address += 254;
        }
        this.setAddress(address -= 255 - nxtSector);
    }

    private void loadTape(C64File entry) {
        int address = entry.getSector();
        int offset = entry.getTrack();
        int n = entry.getSize();
        for (int i = 0; i < n; ++i) {
            CPU.CPU.memory.set(address++, this.sectors[i + offset >> 8][i + offset & 0xFF] & 0xFF);
        }
        this.setAddress(address);
    }

    private byte[] getSector(int track, int sectrack) {
        return this.sectors[this.getTrack(track) + sectrack];
    }

    private int getTrack(int track) {
        int sector = track < 18 ? (track - 1) * 21 : (track >= 18 && track < 25 ? (track - 1) * 19 + 34 : (track >= 25 && track < 31 ? (track - 1) * 18 + 58 : (track - 1) * 17 + 88));
        return sector;
    }

    private void readDisk(String file) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int n;
            int sector = 0;
            int sectrack = 0;
            int track = 1;
            while ((n = ((InputStream)is).read(this.sectors[sector])) > 0) {
                if (n < 256) {
                    ((InputStream)is).read(this.sectors[sector], n, 256 - n);
                }
                if (track == 18) {
                    this.add(this.sectors[sector], track, sectrack);
                }
                ++sector;
                if (!(track < 18 && sectrack == 21 || track >= 18 && track < 25 && sectrack == 19 || track >= 25 && track < 31 && sectrack == 18) && (track < 31 || track >= 41 || ++sectrack != 17)) continue;
                sectrack = 0;
                ++track;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Loader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readTape(String file) {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            byte[] start = new byte[32];
            ((InputStream)is).read(start);
            if (start.toString().startsWith("C64")) {
                int i;
                ((InputStream)is).read(start);
                int max = start[3] * 256 + start[2];
                int used = start[5] * 256 + start[4];
                if (used == 0) {
                    used = 1;
                }
                for (i = 0; i < used; ++i) {
                    ((InputStream)is).read(start);
                    int startAddr = (start[2] & 0xFF) + (start[3] & 0xFF) * 256;
                    int endAddr = (start[4] & 0xFF) + (start[5] & 0xFF) * 256;
                    int offset = (start[8] & 0xFF) + (start[9] & 0xFF) * 256;
                    this.sb.delete(0, this.sb.length());
                    for (int j = 16; j < 32; ++j) {
                        this.sb.append((char)start[j]);
                    }
                    this.programs.put(this.sb.toString(), new C64File(this.sb.toString(), offset - 32 * (max + 2), startAddr, endAddr - startAddr, start[1]));
                }
                for (i = used; i < max; ++i) {
                    ((InputStream)is).read(start);
                }
                int sector = 0;
                while (this.readSector(is, sector++) == 256) {
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Loader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int readSector(InputStream is, int sector) {
        try {
            int read;
            int n;
            for (read = is.read(this.sectors[sector]); read < 256 && (n = is.read(this.sectors[sector], read, 256 - read)) != -1; read += n) {
            }
            return read;
        }
        catch (IOException ex) {
            Logger.getLogger(Loader.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    private void setAddress(int address) {
        if (address > 40704) {
            address = 40704;
        }
        int v = address & 0xFF;
        CPU.CPU.memory.set(45, v);
        CPU.CPU.memory.set(47, v);
        CPU.CPU.memory.set(49, v);
        v = (address & 0xFF00) >> 8;
        CPU.CPU.memory.set(46, v);
        CPU.CPU.memory.set(48, v);
        CPU.CPU.memory.set(50, v);
    }

    public static enum Media {
        TAPE,
        DISK;

    }
}

