/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.net;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.free.j64.net.Net;
import org.free.j64.net.type.Chat;
import org.free.j64.net.type.Key;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

final class ServerHandler
extends SimpleChannelHandler {
    private static final Logger logger = Logger.getLogger(ServerHandler.class.getName());

    ServerHandler() {
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        String address = e.getChannel().getRemoteAddress().toString().substring(1).split(":")[0];
        Net.ServerSession.SS.connections.incrementAndGet();
        if (this.untrustedAddress(address) || this.duplicate(e, address) || this.overLimit(e)) {
            System.out.format("Connection refused rom %s%n", address);
            Net.ServerSession.SS.sendKey(address, new Key(2));
            e.getChannel().close();
            return;
        }
        Net.ServerSession.SS.connected.put(address, new Net.User(address));
        Net.ServerSession.SS.channels.add(e.getChannel());
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        String address = e.getChannel().getRemoteAddress().toString().substring(1).split(":")[0];
        Net.ServerSession.SS.connections.decrementAndGet();
        Net.ServerSession.SS.connected.remove(address);
        Net.ServerSession.SS.channels.remove(e.getChannel());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (e.getMessage() instanceof Chat) {
            Net.ServerSession.SS.chatBuffer.offer((Chat)e.getMessage());
        } else if (e.getMessage() instanceof Key) {
            this.receiveKey(e);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        e.getChannel().close();
    }

    private boolean duplicate(ChannelStateEvent e, String address) {
        if (Net.ServerSession.SS.connected.containsKey(address)) {
            String msg = String.format("Already connected from %s%n", address);
            logger.log(Level.SEVERE, msg);
            e.getChannel().write(msg);
            return true;
        }
        return false;
    }

    private boolean overLimit(ChannelStateEvent e) {
        if (Net.ServerSession.SS.maxConnections > 0 && Net.ServerSession.SS.connections.get() > Net.ServerSession.SS.maxConnections) {
            String msg = String.format("Server limit reached: connection rejected from %s%n", e.getChannel().getRemoteAddress().toString());
            logger.log(Level.SEVERE, msg);
            e.getChannel().write(msg);
            return true;
        }
        return false;
    }

    private boolean untrustedAddress(String address) {
        return !Net.ServerSession.SS.getUsers().containsKey(address);
    }

    private void receiveKey(MessageEvent e) {
        String address = e.getChannel().getRemoteAddress().toString().substring(1).split(":")[0];
        if (address.equalsIgnoreCase(Net.ServerSession.SS.keySender)) {
            Net.ServerSession.SS.keyBuffer.offer((Key)e.getMessage());
        }
    }
}

