/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.sound;

final class EnvelopeGenerator {
    private boolean hold_zero;
    private int rate_counter;
    private int rate_period;
    private int exponential_counter;
    private int exponential_counter_period;
    private int envelope_counter;
    private int gate;
    private int attack;
    private int decay;
    private int sustain;
    private int release;
    private State state;
    private static final int[] rate_counter_period = new int[]{9, 32, 63, 95, 149, 220, 267, 313, 392, 977, 1954, 3126, 3907, 11720, 19532, 31251};
    private static final int[] sustain_level = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};

    void clock() {
        if ((++this.rate_counter & 0x8000) != 0) {
            ++this.rate_counter;
            this.rate_counter &= Short.MAX_VALUE;
        }
        if (this.rate_counter != this.rate_period) {
            return;
        }
        this.rate_counter = 0;
        if (this.state == State.ATTACK || ++this.exponential_counter == this.exponential_counter_period) {
            this.exponential_counter = 0;
            if (this.hold_zero) {
                return;
            }
            this.processState();
            this.setCounterPeriod();
        }
    }

    int output() {
        return this.envelope_counter;
    }

    EnvelopeGenerator() {
        this.reset();
    }

    void reset() {
        this.exponential_counter = 0;
        this.rate_counter = 0;
        this.gate = 0;
        this.release = 0;
        this.sustain = 0;
        this.decay = 0;
        this.attack = 0;
        this.envelope_counter = 0;
        this.exponential_counter_period = 1;
        this.state = State.RELEASE;
        this.rate_period = rate_counter_period[this.release];
        this.hold_zero = true;
    }

    void writeCONTROL_REG(int control) {
        int gate_next = control & 1;
        if (this.gate == 0 && gate_next != 0) {
            this.state = State.ATTACK;
            this.rate_period = rate_counter_period[this.attack];
            this.hold_zero = false;
        } else if (this.gate != 0 && gate_next == 0) {
            this.state = State.RELEASE;
            this.rate_period = rate_counter_period[this.release];
        }
        this.gate = gate_next;
    }

    void writeATTACK_DECAY(int attack_decay) {
        this.attack = attack_decay >> 4 & 0xF;
        this.decay = attack_decay & 0xF;
        if (this.state == State.ATTACK) {
            this.rate_period = rate_counter_period[this.attack];
        } else if (this.state == State.DECAY_SUSTAIN) {
            this.rate_period = rate_counter_period[this.decay];
        }
    }

    void writeSUSTAIN_RELEASE(int sustain_release) {
        this.sustain = sustain_release >> 4 & 0xF;
        this.release = sustain_release & 0xF;
        if (this.state == State.RELEASE) {
            this.rate_period = rate_counter_period[this.release];
        }
    }

    int readENV() {
        return this.output();
    }

    private void setCounterPeriod() {
        switch (this.envelope_counter) {
            case 255: {
                this.exponential_counter_period = 1;
                break;
            }
            case 93: {
                this.exponential_counter_period = 2;
                break;
            }
            case 54: {
                this.exponential_counter_period = 4;
                break;
            }
            case 26: {
                this.exponential_counter_period = 8;
                break;
            }
            case 14: {
                this.exponential_counter_period = 16;
                break;
            }
            case 6: {
                this.exponential_counter_period = 30;
                break;
            }
            case 0: {
                this.exponential_counter_period = 1;
                this.hold_zero = true;
                break;
            }
        }
    }

    private void processState() {
        switch (this.state) {
            case ATTACK: {
                ++this.envelope_counter;
                this.envelope_counter &= 0xFF;
                if (this.envelope_counter != 255) break;
                this.state = State.DECAY_SUSTAIN;
                this.rate_period = rate_counter_period[this.decay];
                break;
            }
            case DECAY_SUSTAIN: {
                if (this.envelope_counter == sustain_level[this.sustain]) break;
                --this.envelope_counter;
                break;
            }
            case RELEASE: {
                --this.envelope_counter;
                this.envelope_counter &= 0xFF;
                break;
            }
        }
    }

    private static enum State {
        ATTACK,
        DECAY_SUSTAIN,
        RELEASE;

    }
}

