/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.sound;

import org.free.j64.sound.EnvelopeGenerator;
import org.free.j64.sound.WaveformGenerator;

final class Voice {
    final WaveformGenerator wave = new WaveformGenerator();
    final EnvelopeGenerator envelope = new EnvelopeGenerator();
    private final boolean muted;
    private int wave_zero;
    private int voice_DC;

    int output() {
        if (!this.muted) {
            return (this.wave.output() - this.wave_zero) * this.envelope.output() + this.voice_DC;
        }
        return 0;
    }

    Voice() {
        this.muted = false;
        this.init();
    }

    private void init() {
        this.wave_zero = 896;
        this.voice_DC = 522240;
    }

    void set_sync_source(Voice source) {
        this.wave.set_sync_source(source.wave);
    }

    void writeCONTROL_REG(int control) {
        this.wave.writeCONTROL_REG(control);
        this.envelope.writeCONTROL_REG(control);
    }

    void reset() {
        this.wave.reset();
        this.envelope.reset();
    }
}

