/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.app;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.free.j64.app.Desktop;
import org.free.j64.cpu.CPU;
import org.free.j64.etc.Config;
import org.free.j64.io.Audio;
import org.free.j64.io.Keyboard;
import org.free.j64.io.Loader;
import org.free.j64.io.Screen;
import org.free.j64.net.Net;
import org.free.j64.net.type.Key;

public enum C64 {
    C64;

    static final String ABOUT_MESSAGE = "JaC64 version: 1.3.0rc1\nJaC64 is a Java-based C64 emulator by Joakim Eriksson\nThe SID emulation uses the resid Java port by Ken Hindel\n\nFor more information see: http://www.jathis.com/";
    volatile boolean texting;
    volatile boolean twoPlayer;
    private final ExecutorService exec = Executors.newCachedThreadPool();
    private final Map<Integer, Future<?>> tasks = new ConcurrentHashMap();
    private final AtomicInteger taskId = new AtomicInteger(0);
    private final Object textLock = new Object();
    private final Object throttleLock = new Object();
    private volatile boolean turbo;
    private volatile boolean timing;
    private volatile boolean throttling;
    private volatile boolean keyJam = Desktop.appPrefs.node("VNC").getBoolean("keyJam", false);
    private volatile int audioDelay = Desktop.appPrefs.node("VNC").getInt("AudioDelay", 1);
    private volatile int imageDelay = Desktop.appPrefs.node("VNC").getInt("ImageDelay", 30);
    private volatile int joyStick = Desktop.appPrefs.node("VNC").getInt("JoyPort", 1);
    private Future<?> keysTask;

    public int getAudioDelay() {
        return org.free.j64.app.C64.C64.audioDelay;
    }

    public void setAudioDelay(int delay) {
        org.free.j64.app.C64.C64.audioDelay = delay;
    }

    public int getImageDelay() {
        return org.free.j64.app.C64.C64.imageDelay;
    }

    public void setImageDelay(int delay) {
        org.free.j64.app.C64.C64.imageDelay = delay;
    }

    public int getJoyPort() {
        return org.free.j64.app.C64.C64.joyStick;
    }

    public void setJoyPort(int joyStick) {
        org.free.j64.app.C64.C64.joyStick = joyStick;
    }

    public boolean isKeyJam() {
        return this.keyJam;
    }

    public void setKeyJam(boolean keyJam) {
        this.keyJam = keyJam;
    }

    public boolean isTurbo() {
        return this.turbo;
    }

    public Future<?> addTask(int id, Callable<?> c) {
        if (this.tasks.containsKey(id)) {
            return null;
        }
        Future<?> f = this.exec.submit(c);
        this.tasks.put(id, f);
        return f;
    }

    public int getTaskId() {
        return this.taskId.getAndIncrement();
    }

    public void removeTask(int id) {
        this.tasks.remove(id);
    }

    void shutdownTasks() {
        for (Future<?> t : this.tasks.values()) {
            if (t.isDone()) continue;
            t.cancel(true);
        }
        this.exec.shutdown();
    }

    void addKey(Key key, Keyboard.JoyStick joy) {
        Keyboard.KEYBOARD.addKey(new Keyboard.Key(key, !this.twoPlayer ? Keyboard.JoyStick.NONE : joy));
    }

    void buildProgramList(String name) {
        if (name.toLowerCase().endsWith(".d64")) {
            Loader.LOADER.buildList(name, Loader.Media.DISK);
        } else if (name.toLowerCase().endsWith(".t64")) {
            Loader.LOADER.buildList(name, Loader.Media.TAPE);
        } else if (name.toLowerCase().endsWith(".prg") || name.toLowerCase().endsWith(".p00")) {
            this.readPGM(name);
        }
    }

    Keyboard.JoyStick getJoyStick(boolean keySender) {
        if (this.joyStick == 1) {
            if (keySender) {
                return Keyboard.JoyStick.ONE;
            }
            return Keyboard.JoyStick.TWO;
        }
        if (keySender) {
            return Keyboard.JoyStick.TWO;
        }
        return Keyboard.JoyStick.ONE;
    }

    void init() {
        CPU.CPU.init();
        Screen.SCREEN.init();
        CPU.CPU.start();
        Config.CONFIG.read("c64-config.xml");
        if (((Boolean)Config.CONFIG.getConfig().get("serverAuto")).booleanValue()) {
            this.startServer();
        }
    }

    boolean isServer() {
        return this.keysTask != null;
    }

    void pause() {
        this.texting = false;
        CPU.CPU.pause();
    }

    void reset(boolean soft) {
        this.texting = false;
        if (soft) {
            CPU.CPU.reset();
        } else {
            CPU.CPU.hardReset();
        }
        this.throttleCPU(false);
    }

    void startServer() {
        Net.ServerSession.SS.start((Integer)Config.CONFIG.getConfig().get("serverPort"));
        Screen.SCREEN.startServer();
        Audio.AUDIO.startServer();
        this.startKeys();
        System.out.println("Server started");
    }

    void stopServer() {
        Net.ServerSession.SS.stop();
        Screen.SCREEN.stopServer();
        Audio.AUDIO.stopServer();
        this.stopKeys();
        System.out.println("Server stopped");
    }

    void simulateBreak(int period) {
        this.addKey(new Key(19), Keyboard.JoyStick.NONE);
        try {
            TimeUnit.MILLISECONDS.sleep(period);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addKey(new Key(-20), Keyboard.JoyStick.NONE);
    }

    void stop() throws InterruptedException {
        this.texting = false;
        if (this.isServer()) {
            this.stopServer();
        }
        Keyboard.KEYBOARD.stop();
        Screen.SCREEN.stop();
        CPU.CPU.stop();
        this.shutdownTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void text(String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        Object object = this.textLock;
        synchronized (object) {
            this.throttleCPU(true);
            CPU.CPU.text(msg);
            if (!this.timing && !this.throttling) {
                this.throttleCPU(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void text(List<String> msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        Object object = this.textLock;
        synchronized (object) {
            this.texting = true;
            this.throttleCPU(true);
            StringBuilder sb = new StringBuilder();
            for (String s : msg) {
                if (!this.texting) break;
                if (s.isEmpty()) continue;
                sb.delete(0, sb.length());
                sb.append(s).append("~");
                CPU.CPU.text(sb.toString());
            }
            if (!this.timing && !this.throttling) {
                this.throttleCPU(false);
            }
            this.texting = false;
        }
    }

    void throttleCPU(int value, int scale) {
        int v = 200 - (int)((float)value / (float)scale * 200.0f);
        Screen.Canvas.CANVAS.setOldrate(v);
        Screen.Canvas.CANVAS.setRate(v);
    }

    void throttleCPUTime(final int ms) {
        final int id = this.getTaskId();
        this.addTask(id, new Callable<Void>(){

            @Override
            public Void call() {
                C64.this.timing = true;
                C64.this.throttleCPU(true);
                try {
                    TimeUnit.MILLISECONDS.sleep(ms);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!C64.this.throttling) {
                    C64.this.throttleCPU(false);
                }
                C64.this.timing = false;
                C64.this.removeTask(id);
                return null;
            }
        });
    }

    void throttleCPU() {
        this.throttling = !this.throttling;
        this.throttleCPU(this.throttling);
    }

    private void startKeys() {
        final int id = C64.getTaskId();
        this.keysTask = this.addTask(id, new Callable<Void>(){

            @Override
            public Void call() {
                while (!Thread.currentThread().isInterrupted()) {
                    Key key = Net.ServerSession.SS.getKey();
                    if (key != null) {
                        C64.this.addKey(key, C64.this.getJoyStick(true));
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(C64.this.audioDelay);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                C64.this.removeTask(id);
                C64.this.keysTask = null;
                return null;
            }
        });
    }

    private void stopKeys() {
        this.keysTask.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throttleCPU(boolean throttle) {
        Object object = this.throttleLock;
        synchronized (object) {
            if (Audio.AUDIO.hasSound()) {
                this.turbo = throttle;
            } else if (throttle) {
                Screen.Canvas.CANVAS.setRate(0);
            } else {
                Screen.Canvas.CANVAS.setRate(Screen.Canvas.CANVAS.getOldrate());
            }
        }
    }

    private void readPGM(String name) {
        CPU.CPU.reset();
        while (!Keyboard.KEYBOARD.isReady()) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Loader.LOADER.readPGM(name, -1);
        CPU.CPU.runBasic();
    }
}

