/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.cpu;

import org.free.j64.cpu.CPU;
import org.free.j64.cpu.Ops;

enum Debugger {
    DEBUGGER;

    private final StringBuilder line = new StringBuilder();
    private final StringBuilder bytes = new StringBuilder();
    private long lastCycles = 0L;

    String disAssemble(int pc, int acc, int x, int y, byte status, int interruptInExec, int lastInterrupt) {
        try {
            return this.buildLine(pc, x, y, interruptInExec, lastInterrupt, acc, status);
        }
        catch (Exception e) {
            System.err.println(e.getCause());
            return "";
        }
    }

    private String buildLine(int pc, int x, int y, int interruptInExec, int lastInterrupt, int acc, byte status) {
        int i;
        this.line.delete(0, this.line.length());
        this.line.append(String.format("%05x", pc)).append(" ");
        int startPC = pc;
        int data = Ops.INSTRUCTION_SET[CPU.CPU.memory.get(pc++)];
        int op = data & Ops.Op.OP_MASK.getCode();
        int addrMode = data & Ops.Op.ADDRESSING_MASK.getCode();
        int adMode = addrMode >> 8;
        boolean read = (data & Ops.Op.READ.getCode()) != 0;
        boolean write = (data & Ops.Op.WRITE.getCode()) != 0;
        int p1 = CPU.CPU.memory.get(pc++);
        this.line.append(Ops.INS_STR[op]).append(Ops.ADR_STR_PRE[adMode]);
        switch (Ops.getOp(addrMode)) {
            case IMMEDIATE: {
                data = p1;
                this.line.append("$").append(String.format("%02x", data));
                break;
            }
            case ABSOLUTE: {
                int address = (CPU.CPU.memory.get(pc++) << 8) + p1;
                this.line.append("$").append(String.format("%02x", address));
                if (!read) break;
                data = CPU.CPU.memory.get(address);
                this.line.append("=").append(String.format("%02x", data));
                break;
            }
            case ZERO: {
                int address = p1;
                this.line.append("$").append(String.format("%02x", address));
                if (!read) break;
                data = CPU.CPU.memory.get(address);
                this.line.append("=").append(String.format("%02x", data));
                break;
            }
            case ZERO_X: 
            case ZERO_Y: {
                CPU.CPU.memory.get(p1);
                int address = addrMode == Ops.Op.ZERO_X.getCode() ? p1 + x & 0xFF : p1 + y & 0xFF;
                this.line.append("$").append(String.format("%02x", address));
                if (!read) break;
                data = CPU.CPU.memory.get(address);
                this.line.append("=").append(String.format("%02x", data));
                break;
            }
            case ABSOLUTE_X: 
            case ABSOLUTE_Y: {
                int address = CPU.CPU.memory.get(pc++) << 8;
                p1 = addrMode == Ops.Op.ABSOLUTE_X.getCode() ? (p1 += x) : (p1 += y);
                this.line.append("$").append(String.format("%02x", address += p1));
                if (!read || p1 <= 255 && !write) break;
                data = CPU.CPU.memory.get(address);
                this.line.append("=").append(String.format("%02x", data));
                break;
            }
            case RELATIVE: {
                int address = pc + (byte)p1;
                this.line.append("$").append(String.format("%02x", address));
                break;
            }
            case ACCUMULATOR: {
                --pc;
                break;
            }
            case INDIRECT_X: {
                int tmp = p1 + x & 0xFF;
                int address = CPU.CPU.memory.get(tmp + 1) << 8;
                this.line.append("$").append(String.format("%02x", address |= CPU.CPU.memory.get(tmp)));
                if (!read) break;
                data = CPU.CPU.memory.get(address);
                this.line.append("=").append(String.format("%02x", data));
                break;
            }
            case INDIRECT_Y: {
                int address = CPU.CPU.memory.get(p1 + 1) << 8;
                p1 = CPU.CPU.memory.get(p1);
                this.line.append("$").append(String.format("%02x", address += (p1 += y)));
                if (!read || p1 <= 255 && !write) break;
                data = CPU.CPU.memory.get(address);
                this.line.append("=").append(String.format("%02x", data));
                break;
            }
            case INDIRECT: {
                int address = (CPU.CPU.memory.get(pc) << 8) + p1;
                int tmp = address & 0xFFF00 | address + 1 & 0xFF;
                address = (CPU.CPU.memory.get(tmp) << 8) + CPU.CPU.memory.get(address);
                this.line.append("$").append(String.format("%02x", address));
                break;
            }
            default: {
                --pc;
            }
        }
        this.line.append(Ops.ADR_STR_POST[adMode]);
        this.bytes.delete(0, this.bytes.length());
        for (i = startPC; i < pc; ++i) {
            this.bytes.append(String.format("%02x", CPU.CPU.memory.get(i))).append(" ");
        }
        for (i = 9 - this.bytes.length(); i > 0; --i) {
            this.bytes.append(" ");
        }
        if (interruptInExec > 0) {
            if (lastInterrupt == 1) {
                this.bytes.append("[NMI] ").append(interruptInExec).append(" ");
            } else {
                this.bytes.append("[IRQ] ").append(interruptInExec).append(" ");
            }
        } else {
            this.bytes.append("        ");
        }
        if (this.line.length() > 6) {
            this.line.insert(6, this.bytes.toString());
        }
        for (i = 45 - this.line.length(); i > 0; --i) {
            this.line.append(" ");
        }
        this.line.append("A:").append(String.format("%02x", acc));
        this.line.append(" X:").append(String.format("%02x", x));
        this.line.append(" Y:").append(String.format("%02x", y)).append(" ");
        this.line.append((status & 1) != 0 ? "C" : "-");
        this.line.append((status & 2) != 0 ? "Z" : "-");
        this.line.append((status & 4) != 0 ? "I" : "-");
        this.line.append((status & 8) != 0 ? "D" : "-");
        this.line.append((status & 0x10) != 0 ? "B" : "-");
        this.line.append((status & 0x40) != 0 ? "O" : "-");
        this.line.append((status & 0x80) != 0 ? "S" : "-").append(" ");
        this.line.append(CPU.CPU.isNMILow() ? "N" : "-");
        this.line.append(CPU.CPU.isIRQLow() ? "I" : "-");
        this.line.append(" S:").append(String.format("%02x", CPU.CPU.getSP()));
        this.line.append(" ").append(String.format("%02x", (int)(CPU.CPU.getCycles() - this.lastCycles)));
        this.getFunction(startPC);
        this.lastCycles = CPU.CPU.getCycles();
        return this.line.toString();
    }

    private void getFunction(int startPC) {
        if ((CPU.CPU.memory.get(1) & 3) != 3) {
            return;
        }
        switch (startPC) {
            case 40960: {
                this.line.append("  % -\tRestart Vectors\t\t\t\tWORD");
                break;
            }
            case 40972: {
                this.line.append("  % stmdsp\tBASIC Command Vectors\t\t\tWORD");
                break;
            }
            case 41042: {
                this.line.append("  % fundsp\tBASIC Function Vectors\t\t\tWORD");
                break;
            }
            case 41088: {
                this.line.append("  % optab\tBASIC Operator Vectors\t\t\tWORD");
                break;
            }
            case 41118: {
                this.line.append("  % reslst\tBASIC Command Keyword Table\t\tDATA");
                break;
            }
            case 41257: {
                this.line.append("  % msclst\tBASIC Misc. Keyword Table\t\tDATA");
                break;
            }
            case 41280: {
                this.line.append("  % oplist\tBASIC Operator Keyword Table\t\tDATA");
                break;
            }
            case 41293: {
                this.line.append("  % funlst\tBASIC Function Keyword Table\t\tDATA");
                break;
            }
            case 41374: {
                this.line.append("  % errtab\tError Message Table\t\t\tDATA");
                break;
            }
            case 41768: {
                this.line.append("  % errptr\tError Message Pointers\t\t\tWORD");
                break;
            }
            case 41828: {
                this.line.append("  % okk\tMisc. Messages\t\t\t\tTEXT");
                break;
            }
            case 41866: {
                this.line.append("  % fndfor\tFind FOR/GOSUB Entry on Stack");
                break;
            }
            case 41912: {
                this.line.append("  % bltu\tOpen Space in Memory");
                break;
            }
            case 41979: {
                this.line.append("  % getstk\tCheck Stack Depth");
                break;
            }
            case 41992: {
                this.line.append("  % reason\tCheck Memory Overlap / Array area overflow check");
                break;
            }
            case 42037: {
                this.line.append("  % omerr\tOutput ?OUT OF MEMORY Error");
                break;
            }
            case 42039: {
                this.line.append("  % error\tError Routine");
                break;
            }
            case 42089: {
                this.line.append("  % errfin\tBreak Entry");
                break;
            }
            case 42100: {
                this.line.append("  % ready\tRestart BASIC");
                break;
            }
            case 42112: {
                this.line.append("  % main\tInput & Identify BASIC Line");
                break;
            }
            case 42140: {
                this.line.append("  % main1\tGet Line Number & Tokenise Text");
                break;
            }
            case 42146: {
                this.line.append("  % inslin\tInsert BASIC Text");
                break;
            }
            case 42291: {
                this.line.append("  % linkprg\tRechain Lines");
                break;
            }
            case 42336: {
                this.line.append("  % inlin\tInput Line Into Buffer");
                break;
            }
            case 42361: {
                this.line.append("  % crunch\tTokenise Input Buffer");
                break;
            }
            case 42515: {
                this.line.append("  % fndlin\tSearch for Line Number");
                break;
            }
            case 42562: {
                this.line.append("  % scrtch\tPerform [new]");
                break;
            }
            case 42590: {
                this.line.append("  % clear\tPerform [clr]");
                break;
            }
            case 42638: {
                this.line.append("  % stxpt\tReset TXTPTR");
                break;
            }
            case 42652: {
                this.line.append("  % list\tPerform [list]");
                break;
            }
            case 42775: {
                this.line.append("  % qplop\tHandle LIST Character");
                break;
            }
            case 42818: {
                this.line.append("  % for\tPerform [for]");
                break;
            }
            case 42926: {
                this.line.append("  % newstt\tBASIC Warm Start");
                break;
            }
            case 42948: {
                this.line.append("  % ckeol\tCheck End of Program");
                break;
            }
            case 42977: {
                this.line.append("  % gone\tPrepare to execute statement");
                break;
            }
            case 42989: {
                this.line.append("  % gone3\tPerform BASIC Keyword,Execute command in A");
                break;
            }
            case 43037: {
                this.line.append("  % restor\tPerform [restore]");
                break;
            }
            case 43052: {
                this.line.append("  % stop\tPerform [stop], [end], break");
                break;
            }
            case 43095: {
                this.line.append("  % cont\tPerform [cont]");
                break;
            }
            case 43121: {
                this.line.append("  % run\tPerform [run]");
                break;
            }
            case 43139: {
                this.line.append("  % gosub\tPerform [gosub]");
                break;
            }
            case 43168: {
                this.line.append("  % goto\tPerform [goto]");
                break;
            }
            case 43218: {
                this.line.append("  % return\tPerform [return]");
                break;
            }
            case 43256: {
                this.line.append("  % data\tPerform [data]");
                break;
            }
            case 43270: {
                this.line.append("  % datan\tSearch for Next Statement / Line");
                break;
            }
            case 43304: {
                this.line.append("  % if\tPerform [if]");
                break;
            }
            case 43323: {
                this.line.append("  % rem\tPerform [rem]");
                break;
            }
            case 43339: {
                this.line.append("  % ongoto\tPerform [on]");
                break;
            }
            case 43371: {
                this.line.append("  % linget\tFetch linnum From BASIC");
                break;
            }
            case 43429: {
                this.line.append("  % let\tPerform [let]");
                break;
            }
            case 43460: {
                this.line.append("  % putint\tAssign Integer");
                break;
            }
            case 43478: {
                this.line.append("  % ptflpt\tAssign Floating Point");
                break;
            }
            case 43481: {
                this.line.append("  % putstr\tAssign String");
                break;
            }
            case 43491: {
                this.line.append("  % puttim\tAssign TI$");
                break;
            }
            case 43564: {
                this.line.append("  % getspt\tAdd Digit to FAC#1");
                break;
            }
            case 43648: {
                this.line.append("  % printn\tPerform [print]#");
                break;
            }
            case 43654: {
                this.line.append("  % cmd\tPerform [cmd]");
                break;
            }
            case 43674: {
                this.line.append("  % strdon\tPrint String From Memory");
                break;
            }
            case 43680: {
                this.line.append("  % print\tPerform [print]");
                break;
            }
            case 43704: {
                this.line.append("  % varop\tOutput Variable");
                break;
            }
            case 43735: {
                this.line.append("  % crdo\tOutput CR/LF");
                break;
            }
            case 43752: {
                this.line.append("  % comprt\tHandle comma, TAB(, SPC(");
                break;
            }
            case 43806: {
                this.line.append("  % strout\tOutput String");
                break;
            }
            case 43835: {
                this.line.append("  % outspc\tOutput Format Character");
                break;
            }
            case 43853: {
                this.line.append("  % doagin\tHandle Bad Data");
                break;
            }
            case 43899: {
                this.line.append("  % get\tPerform [get]");
                break;
            }
            case 43941: {
                this.line.append("  % inputn\tPerform [input#]");
                break;
            }
            case 43967: {
                this.line.append("  % input\tPerform [input]");
                break;
            }
            case 44010: {
                this.line.append("  % bufful\tRead Input Buffer");
                break;
            }
            case 44025: {
                this.line.append("  % qinlin\tDo Input Prompt");
                break;
            }
            case 44038: {
                this.line.append("  % read\tPerform [read]");
                break;
            }
            case 44085: {
                this.line.append("  % rdget\tGeneral Purpose Read Routine");
                break;
            }
            case 44284: {
                this.line.append("  % exint\tInput Error Messages\t\t\tTEXT");
                break;
            }
            case 44318: {
                this.line.append("  % next\tPerform [next]");
                break;
            }
            case 44385: {
                this.line.append("  % donext\tCheck Valid Loop");
                break;
            }
            case 44426: {
                this.line.append("  % frmnum\tConfirm Result");
                break;
            }
            case 44446: {
                this.line.append("  % frmevl\tEvaluate Expression in Text");
                break;
            }
            case 44675: {
                this.line.append("  % eval\tEvaluate Single Term");
                break;
            }
            case 44712: {
                this.line.append("  % pival\tConstant - pi\t\t\t\tDATA");
                break;
            }
            case 44717: {
                this.line.append("  % qdot\tContinue Expression");
                break;
            }
            case 44785: {
                this.line.append("  % parchk\tExpression in Brackets");
                break;
            }
            case 44791: {
                this.line.append("  % chkcls\tConfirm Character");
                break;
            }
            case 44794: {
                this.line.append("  % -\t-test '('-");
                break;
            }
            case 44797: {
                this.line.append("  % -\t-test comma-");
                break;
            }
            case 44808: {
                this.line.append("  % synerr\tOutput ?SYNTAX Error");
                break;
            }
            case 44813: {
                this.line.append("  % domin\tSet up NOT Function");
                break;
            }
            case 44820: {
                this.line.append("  % rsvvar\tIdentify Reserved Variable");
                break;
            }
            case 44840: {
                this.line.append("  % isvar\tSearch for Variable");
                break;
            }
            case 44872: {
                this.line.append("  % tisasc\tConvert TI to ASCII String");
                break;
            }
            case 44967: {
                this.line.append("  % isfun\tIdentify Function Type");
                break;
            }
            case 44977: {
                this.line.append("  % strfun\tEvaluate String Function");
                break;
            }
            case 45009: {
                this.line.append("  % numfun\tEvaluate Numeric Function");
                break;
            }
            case 45030: {
                this.line.append("  % orop\tPerform [or], [and]");
                break;
            }
            case 45078: {
                this.line.append("  % dorel\tPerform <, =, >");
                break;
            }
            case 45083: {
                this.line.append("  % numrel\tNumeric Comparison");
                break;
            }
            case 45102: {
                this.line.append("  % strrel\tString Comparison");
                break;
            }
            case 45182: {
                this.line.append("  % dim\tPerform [dim]");
                break;
            }
            case 45195: {
                this.line.append("  % ptrget\tIdentify Variable");
                break;
            }
            case 45287: {
                this.line.append("  % ordvar\tLocate Ordinary Variable");
                break;
            }
            case 45341: {
                this.line.append("  % notfns\tCreate New Variable");
                break;
            }
            case 45352: {
                this.line.append("  % notevl\tCreate Variable");
                break;
            }
            case 45460: {
                this.line.append("  % aryget\tAllocate Array Pointer Space");
                break;
            }
            case 45477: {
                this.line.append("  % n32768\tConstant 32768 in Flpt\t\t\tDATA");
                break;
            }
            case 45482: {
                this.line.append("  % facinx\tFAC#1 to Integer in (AC/YR)");
                break;
            }
            case 45490: {
                this.line.append("  % intidx\tEvaluate Text for Integer (convert)");
                break;
            }
            case 45503: {
                this.line.append("  % ayint\tFloat (FAC#1) to Positive Integer (convert)");
                break;
            }
            case 45521: {
                this.line.append("  % isary\tGet Array Parameters");
                break;
            }
            case 45592: {
                this.line.append("  % fndary\tFind Array");
                break;
            }
            case 45637: {
                this.line.append("  % bserr\t?BAD SUBSCRIPT/?ILLEGAL QUANTITY");
                break;
            }
            case 45665: {
                this.line.append("  % notfdd\tCreate Array");
                break;
            }
            case 45838: {
                this.line.append("  % inlpn2\tLocate Element in Array");
                break;
            }
            case 45900: {
                this.line.append("  % umult\tNumber of Bytes in Subscript");
                break;
            }
            case 45949: {
                this.line.append("  % fre\tPerform [fre]");
                break;
            }
            case 45969: {
                this.line.append("  % givayf\tConvert Integer in (AC/YR) to Flpt");
                break;
            }
            case 45982: {
                this.line.append("  % pos\tPerform [pos]");
                break;
            }
            case 45990: {
                this.line.append("  % errdir\tConfirm Program Mode");
                break;
            }
            case 46049: {
                this.line.append("  % getfnm\tCheck Syntax of FN");
                break;
            }
            case 46068: {
                this.line.append("  % fndoer\tPerform [fn]");
                break;
            }
            case 46181: {
                this.line.append("  % strd\tPerform [str$]");
                break;
            }
            case 46215: {
                this.line.append("  % strlit\tSet Up String");
                break;
            }
            case 46293: {
                this.line.append("  % putnw1\tSave String Descriptor");
                break;
            }
            case 46324: {
                this.line.append("  % getspa\tAllocate Space for String");
                break;
            }
            case 46374: {
                this.line.append("  % garbag\tGarbage Collection");
                break;
            }
            case 46525: {
                this.line.append("  % dvars\tSearch for Next String");
                break;
            }
            case 46598: {
                this.line.append("  % grbpas\tCollect a String");
                break;
            }
            case 46653: {
                this.line.append("  % cat\tConcatenate Two Strings");
                break;
            }
            case 46714: {
                this.line.append("  % movins\tStore String in High RAM");
                break;
            }
            case 46755: {
                this.line.append("  % frestr\tPerform String Housekeeping");
                break;
            }
            case 46811: {
                this.line.append("  % frefac\tClean Descriptor Stack");
                break;
            }
            case 46828: {
                this.line.append("  % chrd\tPerform [chr$]");
                break;
            }
            case 46848: {
                this.line.append("  % leftd\tPerform [left$]");
                break;
            }
            case 46892: {
                this.line.append("  % rightd\tPerform [right$]");
                break;
            }
            case 46903: {
                this.line.append("  % midd\tPerform [mid$]");
                break;
            }
            case 46945: {
                this.line.append("  % pream\tPull sTring Parameters");
                break;
            }
            case 46972: {
                this.line.append("  % len\tPerform [len]");
                break;
            }
            case 46978: {
                this.line.append("  % len1\tExit String Mode");
                break;
            }
            case 46987: {
                this.line.append("  % asc\tPerform [asc]");
                break;
            }
            case 47003: {
                this.line.append("  % gtbytc\tEvaluate Text to 1 Byte in XR");
                break;
            }
            case 47021: {
                this.line.append("  % val\tPerform [val]");
                break;
            }
            case 47029: {
                this.line.append("  % strval\tConvert ASCII String to Flpt");
                break;
            }
            case 47083: {
                this.line.append("  % getnum\tGet parameters for POKE/WAIT");
                break;
            }
            case 47095: {
                this.line.append("  % getadr\tConvert FAC#1 to Integer in LINNUM");
                break;
            }
            case 47117: {
                this.line.append("  % peek\tPerform [peek]");
                break;
            }
            case 47140: {
                this.line.append("  % poke\tPerform [poke]");
                break;
            }
            case 47149: {
                this.line.append("  % wait\tPerform [wait]");
                break;
            }
            case 47177: {
                this.line.append("  % faddh\tAdd 0.5 to FAC#1");
                break;
            }
            case 47184: {
                this.line.append("  % fsub\tPerform Subtraction");
                break;
            }
            case 47202: {
                this.line.append("  % fadd5\tNormalise Addition");
                break;
            }
            case 47207: {
                this.line.append("  % fadd\tPerform Addition");
                break;
            }
            case 47431: {
                this.line.append("  % negfac\t2's Complement FAC#1");
                break;
            }
            case 47486: {
                this.line.append("  % overr\tOutput ?OVERFLOW Error");
                break;
            }
            case 47491: {
                this.line.append("  % mulshf\tMultiply by Zero Byte");
                break;
            }
            case 47548: {
                this.line.append("  % fone\tTable of Flpt Constants\t\t\tDATA");
                break;
            }
            case 47594: {
                this.line.append("  % log\tPerform [log]");
                break;
            }
            case 47656: {
                this.line.append("  % fmult\tPerform Multiply");
                break;
            }
            case 47705: {
                this.line.append("  % mulply\tMultiply by a Byte");
                break;
            }
            case 47756: {
                this.line.append("  % conupk\tLoad FAC#2 From Memory");
                break;
            }
            case 47799: {
                this.line.append("  % muldiv\tTest Both Accumulators");
                break;
            }
            case 47828: {
                this.line.append("  % mldvex\tOverflow / Underflow");
                break;
            }
            case 47842: {
                this.line.append("  % mul10\tMultiply FAC#1 by 10");
                break;
            }
            case 47865: {
                this.line.append("  % tenc\tConstant 10 in Flpt\t\t\tDATA");
                break;
            }
            case 47870: {
                this.line.append("  % div10\tDivide FAC#1 by 10");
                break;
            }
            case 47879: {
                this.line.append("  % fdiv\tDivide FAC#2 by Flpt at (AC/YR)");
                break;
            }
            case 47887: {
                this.line.append("  % fdivt\tDivide FAC#2 by FAC#1");
                break;
            }
            case 48034: {
                this.line.append("  % movfm\tLoad FAC#1 From Memory");
                break;
            }
            case 48071: {
                this.line.append("  % mov2f\tStore FAC#1 in Memory");
                break;
            }
            case 48124: {
                this.line.append("  % movfa\tCopy FAC#2 into FAC#1");
                break;
            }
            case 48140: {
                this.line.append("  % movaf\tCopy FAC#1 into FAC#2");
                break;
            }
            case 48155: {
                this.line.append("  % round\tRound FAC#1");
                break;
            }
            case 48171: {
                this.line.append("  % sign\tCheck Sign of FAC#1");
                break;
            }
            case 48185: {
                this.line.append("  % sgn\tPerform [sgn]");
                break;
            }
            case 48216: {
                this.line.append("  % abs\tPerform [abs]");
                break;
            }
            case 48219: {
                this.line.append("  % fcomp\tCompare FAC#1 With Memory");
                break;
            }
            case 48283: {
                this.line.append("  % qint\tConvert FAC#1 to Integer");
                break;
            }
            case 48332: {
                this.line.append("  % int\tPerform [int]");
                break;
            }
            case 48371: {
                this.line.append("  % fin\tConvert ASCII String to a Float in FAC#1");
                break;
            }
            case 48563: {
                this.line.append("  % n0999\tString Conversion Constants\t\tDATA");
                break;
            }
            case 48578: {
                this.line.append("  % inprt\tOutput 'IN' and Line Number");
                break;
            }
            case 48605: {
                this.line.append("  % fout\tConvert FAC#1 to ASCII String");
                break;
            }
            case 48744: {
                this.line.append("  % foutim\tConvert TI to String");
                break;
            }
            case 48913: {
                this.line.append("  % fhalf\tTable of Constants\t\t\tDATA");
                break;
            }
            case 49009: {
                this.line.append("  % sqr\tPerform [sqr]");
                break;
            }
            case 49019: {
                this.line.append("  % fpwrt\tPerform power ($)");
                break;
            }
            case 49076: {
                this.line.append("  % negop\tNegate FAC#1");
                break;
            }
            case 49087: {
                this.line.append("  % logeb2\tTable of Constants\t\t\tDATA");
                break;
            }
            case 49133: {
                this.line.append("  % exp\tPerform [exp]");
                break;
            }
            case 57344: {
                this.line.append("  % (exp continues)\tEXP continued From BASIC ROM");
                break;
            }
            case 57411: {
                this.line.append("  % polyx\tSeries Evaluation");
                break;
            }
            case 57485: {
                this.line.append("  % rmulc\tConstants for RND\t\t\tDATA");
                break;
            }
            case 57495: {
                this.line.append("  % rnd\tPerform [rnd]");
                break;
            }
            case 57593: {
                this.line.append("  % bioerr\tHandle I/O Error in BASIC");
                break;
            }
            case 57612: {
                this.line.append("  % bchout\tOutput Character");
                break;
            }
            case 57618: {
                this.line.append("  % bchin\tInput Character");
                break;
            }
            case 57624: {
                this.line.append("  % bckout\tSet Up For Output");
                break;
            }
            case 57630: {
                this.line.append("  % bckin\tSet Up For Input");
                break;
            }
            case 57636: {
                this.line.append("  % bgetin\tGet One Character");
                break;
            }
            case 57642: {
                this.line.append("  % sys\tPerform [sys]");
                break;
            }
            case 57686: {
                this.line.append("  % savet\tPerform [save]");
                break;
            }
            case 57701: {
                this.line.append("  % verfyt\tPerform [verify / load]");
                break;
            }
            case 57790: {
                this.line.append("  % opent\tPerform [open]");
                break;
            }
            case 57799: {
                this.line.append("  % closet\tPerform [close]");
                break;
            }
            case 57812: {
                this.line.append("  % slpara\tGet Parameters For LOAD/SAVE");
                break;
            }
            case 57856: {
                this.line.append("  % combyt\tGet Next One Byte Parameter");
                break;
            }
            case 57862: {
                this.line.append("  % deflt\tCheck Default Parameters");
                break;
            }
            case 57870: {
                this.line.append("  % cmmerr\tCheck For Comma");
                break;
            }
            case 57881: {
                this.line.append("  % ocpara\tGet Parameters For OPEN/CLOSE");
                break;
            }
            case 57956: {
                this.line.append("  % cos\tPerform [cos]");
                break;
            }
            case 57963: {
                this.line.append("  % sin\tPerform [sin]");
                break;
            }
            case 58036: {
                this.line.append("  % tan\tPerform [tan]");
                break;
            }
            case 58080: {
                this.line.append("  % pi2\tTable of Trig Constants\t\t\tDATA");
                break;
            }
            case 58126: {
                this.line.append("  % atn\tPerform [atn]");
                break;
            }
            case 58174: {
                this.line.append("  % atncon\tTable of ATN Constants\t\t\tDATA");
                break;
            }
            case 58235: {
                this.line.append("  % bassft\tBASIC Warm Start [RUNSTOP-RESTORE]");
                break;
            }
            case 58260: {
                this.line.append("  % init\tBASIC Cold Start");
                break;
            }
            case 58274: {
                this.line.append("  % initat\tCHRGET For Zero-page");
                break;
            }
            case 58298: {
                this.line.append("  % rndsed\tRND Seed For zero-page\t\t\tDATA");
                break;
            }
            case 58303: {
                this.line.append("  % initcz\tInitialize BASIC RAM");
                break;
            }
            case 58402: {
                this.line.append("  % initms\tOutput Power-Up Message");
                break;
            }
            case 58439: {
                this.line.append("  % bvtrs\tTable of BASIC Vectors (for 0300)\tWORD");
                break;
            }
            case 58451: {
                this.line.append("  % initv\tInitialize Vectors");
                break;
            }
            case 58463: {
                this.line.append("  % words\tPower-Up Message\t\t\tDATA");
                break;
            }
            case 58541: {
                this.line.append("  % -\tPatch for BASIC Call to CHKOUT");
                break;
            }
            case 58551: {
                this.line.append("  % -\tUnused Bytes For Future Patches\t\tEMPTY");
                break;
            }
            case 58586: {
                this.line.append("  % -\tReset Character Colour");
                break;
            }
            case 58592: {
                this.line.append("  % -\tPause After Finding Tape File");
                break;
            }
            case 58604: {
                this.line.append("  % -\tRS-232 Timing Table -- PAL\t\tDATA");
                break;
            }
            case 58624: {
                this.line.append("  % iobase\tGet I/O Address");
                break;
            }
            case 58629: {
                this.line.append("  % screen\tGet Screen Size");
                break;
            }
            case 58634: {
                this.line.append("  % plot\tPut / Get Row And Column");
                break;
            }
            case 58648: {
                this.line.append("  % cint1\tInitialize I/O");
                break;
            }
            case 58692: {
                this.line.append("  % -\tClear Screen");
                break;
            }
            case 58726: {
                this.line.append("  % -\tHome Cursor");
                break;
            }
            case 58732: {
                this.line.append("  % -\tSet Screen Pointers");
                break;
            }
            case 58778: {
                this.line.append("  % -\tSet I/O Defaults (Unused Entry)");
                break;
            }
            case 58784: {
                this.line.append("  % -\tSet I/O Defaults");
                break;
            }
            case 58804: {
                this.line.append("  % lp2\tGet Character From Keyboard Buffer");
                break;
            }
            case 58826: {
                this.line.append("  % -\tInput From Keyboard");
                break;
            }
            case 58930: {
                this.line.append("  % -\tInput From Screen or Keyboard");
                break;
            }
            case 59012: {
                this.line.append("  % -\tQuotes Test");
                break;
            }
            case 59025: {
                this.line.append("  % -\tSet Up Screen Print");
                break;
            }
            case 59062: {
                this.line.append("  % -\tAdvance Cursor");
                break;
            }
            case 59117: {
                this.line.append("  % -\tRetreat Cursor");
                break;
            }
            case 59137: {
                this.line.append("  % -\tBack on to Previous Line");
                break;
            }
            case 59158: {
                this.line.append("  % -\tOutput to Screen");
                break;
            }
            case 59178: {
                this.line.append("  % -\t-unshifted characters-");
                break;
            }
            case 59348: {
                this.line.append("  % -\t-shifted characters-");
                break;
            }
            case 59516: {
                this.line.append("  % -\tGo to Next Line");
                break;
            }
            case 59537: {
                this.line.append("  % -\tOutput ");
                break;
            }
            case 59553: {
                this.line.append("  % -\tCheck Line Decrement");
                break;
            }
            case 59571: {
                this.line.append("  % -\tCheck Line Increment");
                break;
            }
            case 59595: {
                this.line.append("  % -\tSet Colour Code");
                break;
            }
            case 59610: {
                this.line.append("  % -\tColour Code Table");
                break;
            }
            case 59626: {
                this.line.append("  % -\tScroll Screen");
                break;
            }
            case 59749: {
                this.line.append("  % -\tOpen A Space On The Screen");
                break;
            }
            case 59848: {
                this.line.append("  % -\tMove A Screen Line");
                break;
            }
            case 59872: {
                this.line.append("  % -\tSyncronise Colour Transfer");
                break;
            }
            case 59888: {
                this.line.append("  % -\tSet Start of Line");
                break;
            }
            case 59903: {
                this.line.append("  % -\tClear Screen Line");
                break;
            }
            case 59923: {
                this.line.append("  % -\tPrint To Screen");
                break;
            }
            case 59940: {
                this.line.append("  % -\tSyncronise Colour Pointer");
                break;
            }
            case 59953: {
                this.line.append("  % -\tMain IRQ Entry Point");
                break;
            }
            case 60039: {
                this.line.append("  % scnkey\tScan Keyboard");
                break;
            }
            case 60125: {
                this.line.append("  % -\tProcess Key Image");
                break;
            }
            case 60281: {
                this.line.append("  % -\tPointers to Keyboard decoding tables\tWORD");
                break;
            }
            case 60289: {
                this.line.append("  % -\tKeyboard 1 -- unshifted\t\t\tDATA");
                break;
            }
            case 60354: {
                this.line.append("  % -\tKeyboard 2 -- Shifted\t\t\tDATA");
                break;
            }
            case 60419: {
                this.line.append("  % -\tKeyboard 3 -- Commodore\t\t\tDATA");
                break;
            }
            case 60484: {
                this.line.append("  % -\tGraphics/Text Control");
                break;
            }
            case 60536: {
                this.line.append("  % -\tKeyboard 4 -- Control\t\t\tDATA");
                break;
            }
            case 60601: {
                this.line.append("  % -\tVideo Chip Setup Table\t\t\tDATA");
                break;
            }
            case 60647: {
                this.line.append("  % -\tShift-Run Equivalent");
                break;
            }
            case 60656: {
                this.line.append("  % -\tLow Byte Screen Line Addresses\t\tDATA");
                break;
            }
            case 60681: {
                this.line.append("  % talk\tSend TALK Command on Serial Bus");
                break;
            }
            case 60684: {
                this.line.append("  % listn\tSend LISTEN Command on Serial Bus");
                break;
            }
            case 60736: {
                this.line.append("  % -\tSend Data On Serial Bus");
                break;
            }
            case 60845: {
                this.line.append("  % -\tFlag Errors");
                break;
            }
            case 63239: {
                this.line.append("  % -\tStatus #80 - device not present");
                break;
            }
            case 60848: {
                this.line.append("  % -\tStatus #03 - write timeout");
                break;
            }
            case 60857: {
                this.line.append("  % second\tSend LISTEN Secondary Address");
                break;
            }
            case 60862: {
                this.line.append("  % -\tClear ATN");
                break;
            }
            case 60871: {
                this.line.append("  % tksa\tSend TALK Secondary Address");
                break;
            }
            case 60876: {
                this.line.append("  % -\tWait For Clock");
                break;
            }
            case 60893: {
                this.line.append("  % ciout\tSend Serial Deferred");
                break;
            }
            case 60911: {
                this.line.append("  % untlk\tSend UNTALK / UNLISTEN");
                break;
            }
            case 60947: {
                this.line.append("  % acptr\tReceive From Serial Bus");
                break;
            }
            case 61061: {
                this.line.append("  % -\tSerial Clock On");
                break;
            }
            case 61070: {
                this.line.append("  % -\tSerial Clock Off");
                break;
            }
            case 61079: {
                this.line.append("  % -\tSerial Output 1");
                break;
            }
            case 61088: {
                this.line.append("  % -\tSerial Output 0");
                break;
            }
            case 61097: {
                this.line.append("  % -\tGet Serial Data And Clock In");
                break;
            }
            case 61107: {
                this.line.append("  % -\tDelay 1 ms");
                break;
            }
            case 61115: {
                this.line.append("  % -\tRS-232 Send");
                break;
            }
            case 61190: {
                this.line.append("  % -\tSend New RS-232 Byte");
                break;
            }
            case 61230: {
                this.line.append("  % -\t'No DSR' / 'No CTS' Error");
                break;
            }
            case 61241: {
                this.line.append("  % -\tDisable Timer");
                break;
            }
            case 61258: {
                this.line.append("  % -\tCompute Bit Count");
                break;
            }
            case 61273: {
                this.line.append("  % -\tRS-232 Receive");
                break;
            }
            case 61310: {
                this.line.append("  % -\tSet Up To Receive");
                break;
            }
            case 61328: {
                this.line.append("  % -\tProcess RS-232 Byte");
                break;
            }
            case 61409: {
                this.line.append("  % -\tSubmit to RS-232");
                break;
            }
            case 61453: {
                this.line.append("  % -\tNo DSR (Data Set Ready) Error");
                break;
            }
            case 61463: {
                this.line.append("  % -\tSend to RS-232 Buffer");
                break;
            }
            case 61517: {
                this.line.append("  % -\tInput From RS-232");
                break;
            }
            case 61574: {
                this.line.append("  % -\tGet From RS-232");
                break;
            }
            case 61604: {
                this.line.append("  % -\tSerial Bus Idle");
                break;
            }
            case 61629: {
                this.line.append("  % -\tTable of Kernal I/O Messages\t\tDATA");
                break;
            }
            case 61739: {
                this.line.append("  % -\tPrint Message if Direct");
                break;
            }
            case 61743: {
                this.line.append("  % -\tPrint Message");
                break;
            }
            case 61758: {
                this.line.append("  % getin\tGet a byte");
                break;
            }
            case 61783: {
                this.line.append("  % chrin\tInput a byte");
                break;
            }
            case 61849: {
                this.line.append("  % -\tGet From Tape / Serial / RS-232");
                break;
            }
            case 61898: {
                this.line.append("  % chrout\tOutput One Character");
                break;
            }
            case 61966: {
                this.line.append("  % chkin\tSet Input Device");
                break;
            }
            case 62032: {
                this.line.append("  % chkout\tSet Output Device");
                break;
            }
            case 62097: {
                this.line.append("  % close\tClose File");
                break;
            }
            case 62223: {
                this.line.append("  % -\tFind File");
                break;
            }
            case 62239: {
                this.line.append("  % -\tSet File values");
                break;
            }
            case 62255: {
                this.line.append("  % clall\tAbort All Files");
                break;
            }
            case 62259: {
                this.line.append("  % clrchn\tRestore Default I/O");
                break;
            }
            case 62282: {
                this.line.append("  % open\tOpen File");
                break;
            }
            case 62421: {
                this.line.append("  % -\tSend Secondary Address");
                break;
            }
            case 62473: {
                this.line.append("  % -\tOpen RS-232");
                break;
            }
            case 62622: {
                this.line.append("  % load\tLoad RAM");
                break;
            }
            case 62648: {
                this.line.append("  % -\tLoad File From Serial Bus");
                break;
            }
            case 62771: {
                this.line.append("  % -\tLoad File From Tape");
                break;
            }
            case 62895: {
                this.line.append("  % -\tPrint 'SEARCHING'");
                break;
            }
            case 62913: {
                this.line.append("  % -\tPrint Filename");
                break;
            }
            case 62930: {
                this.line.append("  % -\tPrint 'LOADING / VERIFYING'");
                break;
            }
            case 62941: {
                this.line.append("  % save\tSave RAM");
                break;
            }
            case 62970: {
                this.line.append("  % -\tSave to Serial Bus");
                break;
            }
            case 63065: {
                this.line.append("  % -\tSave to Tape");
                break;
            }
            case 63119: {
                this.line.append("  % -\tPrint 'SAVING'");
                break;
            }
            case 63131: {
                this.line.append("  % udtim\tBump Clock");
                break;
            }
            case 63197: {
                this.line.append("  % rdtim\tGet Time");
                break;
            }
            case 63204: {
                this.line.append("  % settim\tSet Time");
                break;
            }
            case 63213: {
                this.line.append("  % stop\tCheck STOP Key");
                break;
            }
            case 63227: {
                this.line.append("  % -\t'too many files'");
                break;
            }
            case 63230: {
                this.line.append("  % -\t'file open'");
                break;
            }
            case 63233: {
                this.line.append("  % -\t'file not open'");
                break;
            }
            case 63236: {
                this.line.append("  % -\t'file not found'");
                break;
            }
            case 63242: {
                this.line.append("  % -\t'not input file'");
                break;
            }
            case 63245: {
                this.line.append("  % -\t'not output file'");
                break;
            }
            case 63248: {
                this.line.append("  % -\t'missing filename'");
                break;
            }
            case 63251: {
                this.line.append("  % -\t'illegal device number'");
                break;
            }
            case 63277: {
                this.line.append("  % -\tFind Any Tape Header");
                break;
            }
            case 63338: {
                this.line.append("  % -\tWrite Tape Header");
                break;
            }
            case 63440: {
                this.line.append("  % -\tGet Buffer Address");
                break;
            }
            case 63447: {
                this.line.append("  % -\tSet Buffer Stat / End Pointers");
                break;
            }
            case 63466: {
                this.line.append("  % -\tFind Specific Tape Header");
                break;
            }
            case 63501: {
                this.line.append("  % -\tBump Tape Pointer");
                break;
            }
            case 63511: {
                this.line.append("  % -\tPrint 'PRESS PLAY ON TAPE'");
                break;
            }
            case 63534: {
                this.line.append("  % -\tCheck Tape Status");
                break;
            }
            case 63544: {
                this.line.append("  % -\tPrint 'PRESS RECORD...'");
                break;
            }
            case 63553: {
                this.line.append("  % -\tInitiate Tape Read");
                break;
            }
            case 63588: {
                this.line.append("  % -\tInitiate Tape Write");
                break;
            }
            case 63605: {
                this.line.append("  % -\tCommon Tape Code");
                break;
            }
            case 63696: {
                this.line.append("  % -\tCheck Tape Stop");
                break;
            }
            case 63714: {
                this.line.append("  % -\tSet Read Timing");
                break;
            }
            case 63788: {
                this.line.append("  % -\tRead Tape Bits");
                break;
            }
            case 64096: {
                this.line.append("  % -\tStore Tape Characters");
                break;
            }
            case 64398: {
                this.line.append("  % -\tReset Tape Pointer");
                break;
            }
            case 64407: {
                this.line.append("  % -\tNew Character Setup");
                break;
            }
            case 64422: {
                this.line.append("  % -\tSend Tone to Tape");
                break;
            }
            case 64456: {
                this.line.append("  % -\tWrite Data to Tape");
                break;
            }
            case 64461: {
                this.line.append("  % -\tIRQ Entry Point");
                break;
            }
            case 64599: {
                this.line.append("  % -\tWrite Tape Leader");
                break;
            }
            case 64659: {
                this.line.append("  % -\tRestore Normal IRQ");
                break;
            }
            case 64696: {
                this.line.append("  % -\tSet IRQ Vector");
                break;
            }
            case 64714: {
                this.line.append("  % -\tKill Tape Motor");
                break;
            }
            case 64721: {
                this.line.append("  % -\tCheck Read / Write Pointer");
                break;
            }
            case 64731: {
                this.line.append("  % -\tBump Read / Write Pointer");
                break;
            }
            case 64738: {
                this.line.append("  % -\tPower-Up RESET Entry");
                break;
            }
            case 64770: {
                this.line.append("  % -\tCheck For 8-ROM");
                break;
            }
            case 64786: {
                this.line.append("  % -\t8-ROM Mask '80CBM'\t\t\tDATA");
                break;
            }
            case 64789: {
                this.line.append("  % restor\tRestore Kernal Vectors (at 0314)");
                break;
            }
            case 64794: {
                this.line.append("  % vector\tChange Vectors For User");
                break;
            }
            case 64816: {
                this.line.append("  % -\tKernal Reset Vectors\t\t\tWORD");
                break;
            }
            case 64848: {
                this.line.append("  % ramtas\tInitialise System Constants");
                break;
            }
            case 64923: {
                this.line.append("  % -\tIRQ Vectors For Tape I/O\t\tWORD");
                break;
            }
            case 64931: {
                this.line.append("  % ioinit\tInitialise I/O");
                break;
            }
            case 64989: {
                this.line.append("  % -\tEnable Timer");
                break;
            }
            case 65017: {
                this.line.append("  % setnam\tSet Filename");
                break;
            }
            case 65024: {
                this.line.append("  % setlfs\tSet Logical File Parameters");
                break;
            }
            case 65031: {
                this.line.append("  % readst\tGet I/O Status Word");
                break;
            }
            case 65048: {
                this.line.append("  % setmsg\tControl OS Messages");
                break;
            }
            case 65057: {
                this.line.append("  % settmo\tSet IEEE Timeout");
                break;
            }
            case 65061: {
                this.line.append("  % memtop\tRead / Set Top of Memory");
                break;
            }
            case 65076: {
                this.line.append("  % membot\tRead / Set Bottom of Memory");
                break;
            }
            case 65091: {
                this.line.append("  % -\tNMI Transfer Entry");
                break;
            }
            case 65126: {
                this.line.append("  % -\tWarm Start Basic [BRK]");
                break;
            }
            case 65212: {
                this.line.append("  % -\tExit Interrupt");
                break;
            }
            case 65218: {
                this.line.append("  % -\tRS-232 Timing Table - NTSC\tDATA");
                break;
            }
            case 65238: {
                this.line.append("  % -\tNMI RS-232 In");
                break;
            }
            case 65287: {
                this.line.append("  % -\tNMI RS-232 Out");
                break;
            }
            case 65347: {
                this.line.append("  % -\tFake IRQ Entry");
                break;
            }
            case 65352: {
                this.line.append("  % -\tIRQ Entry");
                break;
            }
            case 65371: {
                this.line.append("  % cint\tInitialize screen editor");
                break;
            }
            case 65408: {
                this.line.append("  % -\tKernal Version Number [03]\tDATA");
                break;
            }
            case 65409: {
                this.line.append("  % cint\t\tInit Editor & Video Chips");
                break;
            }
            case 65412: {
                this.line.append("  % ioinit\t\tInit I/O Devices, Ports & Timers");
                break;
            }
            case 65415: {
                this.line.append("  % ramtas\t\tInit Ram & Buffers");
                break;
            }
            case 65418: {
                this.line.append("  % restor\t\tRestore Vectors");
                break;
            }
            case 65421: {
                this.line.append("  % vector\t\tChange Vectors For User");
                break;
            }
            case 65424: {
                this.line.append("  % setmsg\t\tControl OS Messages");
                break;
            }
            case 65427: {
                this.line.append("  % secnd\t\tSend SA After Listen");
                break;
            }
            case 65430: {
                this.line.append("  % tksa\t\tSend SA After Talk");
                break;
            }
            case 65433: {
                this.line.append("  % memtop\t\tSet/Read System RAM Top");
                break;
            }
            case 65436: {
                this.line.append("  % membot\t\tSet/Read System RAM Bottom");
                break;
            }
            case 65439: {
                this.line.append("  % scnkey\t\tScan Keyboard");
                break;
            }
            case 65442: {
                this.line.append("  % settmo\t\tSet Timeout In IEEE");
                break;
            }
            case 65445: {
                this.line.append("  % acptr\t\tHandshake Serial Byte In");
                break;
            }
            case 65448: {
                this.line.append("  % ciout\t\tHandshake Serial Byte Out");
                break;
            }
            case 65451: {
                this.line.append("  % untalk\t\tCommand Serial Bus UNTALK");
                break;
            }
            case 65454: {
                this.line.append("  % unlsn\t\tCommand Serial Bus UNLISTEN");
                break;
            }
            case 65457: {
                this.line.append("  % listn\t\tCommand Serial Bus LISTEN");
                break;
            }
            case 65460: {
                this.line.append("  % talk\t\tCommand Serial Bus TALK");
                break;
            }
            case 65463: {
                this.line.append("  % readss\t\tRead I/O Status Word");
                break;
            }
            case 65466: {
                this.line.append("  % setlfs\t\tSet Logical File Parameters");
                break;
            }
            case 65469: {
                this.line.append("  % setnam\t\tSet Filename");
                break;
            }
            case 65472: {
                this.line.append("  % (iopen)\t\tOpen Vector [f34a]");
                break;
            }
            case 65475: {
                this.line.append("  % (iclose)   \tClose Vector [f291]");
                break;
            }
            case 65478: {
                this.line.append("  % (ichkin)   \tSet Input [f20e]");
                break;
            }
            case 65481: {
                this.line.append("  % (ichkout)\tSet Output [f250]");
                break;
            }
            case 65484: {
                this.line.append("  % (iclrch)\tRestore I/O Vector [f333]");
                break;
            }
            case 65487: {
                this.line.append("  % (ichrin)\tInput Vector, chrin [f157]");
                break;
            }
            case 65490: {
                this.line.append("  % (ichrout)\tOutput Vector, chrout [f1ca]");
                break;
            }
            case 65493: {
                this.line.append("  % load\t\tLoad RAM From Device");
                break;
            }
            case 65496: {
                this.line.append("  % save\t\tSave RAM To Device");
                break;
            }
            case 65499: {
                this.line.append("  % settim\t\tSet Real-Time Clock");
                break;
            }
            case 65502: {
                this.line.append("  % rdtim\t\tRead Real-Time Clock");
                break;
            }
            case 65505: {
                this.line.append("  % (istop)\t\tTest-Stop Vector [f6ed]");
                break;
            }
            case 65508: {
                this.line.append("  % (igetin)\tGet From Keyboad [f13e]");
                break;
            }
            case 65511: {
                this.line.append("  % (iclall)\tClose All Channels And Files [f32f]");
                break;
            }
            case 65514: {
                this.line.append("  % udtim\t\tIncrement Real-Time Clock");
                break;
            }
            case 65517: {
                this.line.append("  % screen\t\tReturn Screen Organization");
                break;
            }
            case 65520: {
                this.line.append("  % plot\t\tRead / Set Cursor X/Y Position");
                break;
            }
            case 65523: {
                this.line.append("  % iobase\t\tReturn I/O Base Address");
                break;
            }
            case 65526: {
                this.line.append("  % - [5252]");
                break;
            }
            case 65528: {
                this.line.append("  % SYSTEM [5942]");
                break;
            }
            case 65530: {
                this.line.append("  % NMI [fe43]");
                break;
            }
            case 65532: {
                this.line.append("  % RESET [fce2]");
                break;
            }
            case 65534: {
                this.line.append("  % IRQ [ff48]");
                break;
            }
            case 48589: {
                this.line.append("  % Print number from AX");
                break;
            }
        }
    }
}

