/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.free.j64.app.Desktop;
import org.free.j64.etc.Utils;

public final class Dump
extends JDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public Dump(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Utils.initWindow(this, this.getRootPane(), this.jButton1);
        this.setVisible(true);
    }

    private void dumpMemory() {
        this.jButton1.setEnabled(false);
        final int from = Utils.validateInt(this.jTextField1.getText(), 10, 0, 65536);
        final int to = Utils.validateInt(this.jTextField2.getText(), 10, 0, 65536);
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                if (from != -1 && to != -1 && from < to) {
                    Utils.dumpMemory(from, to, Desktop.saveDump(), Desktop.debugFile);
                } else {
                    System.err.format("Dump memory locations: 0 <= from < to < 65536%n", new Object[0]);
                }
                return null;
            }

            @Override
            protected void done() {
                Dump.this.jButton1.setEnabled(true);
            }
        }.execute();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Dump Memory");
        this.setResizable(false);
        this.jLabel2.setDisplayedMnemonic('F');
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        this.jLabel2.setText("From");
        this.jLabel3.setDisplayedMnemonic('T');
        this.jLabel3.setFont(new Font("Dialog", 1, 14));
        this.jLabel3.setText("To");
        this.jTextField2.setFont(new Font("Dialog", 1, 16));
        this.jTextField2.setText("65535");
        this.jTextField2.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Dump.this.focusLost(evt);
            }
        });
        this.jTextField1.setFont(new Font("Dialog", 1, 16));
        this.jTextField1.setText("0");
        this.jTextField1.setToolTipText("Prefix Hex Numbers with $");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Dump.this.focusLost(evt);
            }
        });
        this.jButton1.setMnemonic('D');
        this.jButton1.setText("Dump");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dump.this.actionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("Dialog", 1, 14));
        this.jButton2.setMnemonic('C');
        this.jButton2.setText("Close");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dump.this.actionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addGap(15, 15, 15)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jTextField2, -2, 75, -2)))).addContainerGap(37, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2).addComponent(this.jButton1)).addContainerGap()));
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("Dump")) {
            this.dumpMemory();
        } else if (cmd.startsWith("Close")) {
            this.setVisible(false);
        }
    }

    private void focusLost(FocusEvent evt) {
        if (evt.getSource() instanceof JTextField) {
            JTextField o = (JTextField)evt.getSource();
            o.setText(o.getText().toUpperCase());
        }
        if (evt.getSource().equals(this.jTextField1)) {
            Utils.setText(this.jTextField1, this.jTextField2);
        }
    }
}

