/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.io;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.free.j64.app.C64;
import org.free.j64.net.Net;

public enum Audio {
    AUDIO;

    private static final int bufferSize = 22000;
    private static final int sampleRate = 44000;
    private final Queue<org.free.j64.net.type.Audio> audioBuffer = new LinkedBlockingQueue<org.free.j64.net.type.Audio>();
    private volatile SourceDataLine dataLine = null;
    private volatile boolean sound = true;
    private Future<?> audioTask;

    private Audio() {
        try {
            AudioFormat af = new AudioFormat(44000.0f, 16, 1, true, false);
            this.dataLine = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, af, 22000));
            this.dataLine.open(this.dataLine.getFormat(), 22000);
            this.dataLine.start();
        }
        catch (LineUnavailableException ex) {
            System.err.format("Sound device busy or unavailable, continuing..%n", new Object[0]);
            System.err.format("Try closing other programs using sound and restart%n", new Object[0]);
        }
    }

    public void startServer() {
        final int id = C64.C64.getTaskId();
        this.audioTask = C64.C64.addTask(id, new Callable<Void>(){

            @Override
            public Void call() {
                while (!Thread.currentThread().isInterrupted()) {
                    if (Audio.this.audioBuffer.isEmpty()) continue;
                    Net.ServerSession.SS.sendAudio((org.free.j64.net.type.Audio)Audio.this.audioBuffer.poll());
                    try {
                        TimeUnit.MICROSECONDS.sleep(C64.C64.getAudioDelay() * 100);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                C64.C64.removeTask(id);
                return null;
            }
        });
    }

    public void stopServer() {
        this.audioTask.cancel(true);
    }

    public void play(byte[] buffer) {
        if (this.dataLine == null || C64.C64.isTurbo()) {
            return;
        }
        int bsize = buffer.length;
        while (this.dataLine.available() < bsize) {
            try {
                TimeUnit.MILLISECONDS.sleep(C64.C64.getAudioDelay());
            }
            catch (InterruptedException e) {}
        }
        if (this.audioTask != null) {
            this.audioBuffer.offer(new org.free.j64.net.type.Audio(buffer));
        }
        if (this.sound) {
            this.dataLine.write(buffer, 0, bsize);
        } else {
            try {
                TimeUnit.MILLISECONDS.sleep(C64.C64.getAudioDelay());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean hasSound() {
        return this.dataLine != null;
    }

    public boolean isSound() {
        return this.sound;
    }

    public void setSound(boolean sound) {
        this.sound = sound;
    }

    void stop() {
        if (this.dataLine != null) {
            this.dataLine.stop();
            this.dataLine.flush();
            this.dataLine.close();
        }
        this.audioBuffer.clear();
    }
}

