/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.io;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import org.free.j64.app.C64;
import org.free.j64.cpu.CPU;
import org.free.j64.etc.Utils;
import org.free.j64.io.Audio;
import org.free.j64.io.CIA;
import org.free.j64.io.ExtChip;
import org.free.j64.io.Keyboard;
import org.free.j64.io.VIC;
import org.free.j64.net.Net;
import org.free.j64.sound.RESID;

public enum Screen {
    SCREEN;

    public static final String VERSION = "1.3.0rc1";
    public static final int RATE_NORMAL = 100;
    public static final int RATE_MAX = 0;
    public static final int RATE_MIN = 200;
    public static final int KEYBOARD_NMI = 1;
    public static final int FILE_WIDTH = 80;
    private Future<?> screenTask;

    public String dumpMemory(int address, int size) {
        int i;
        StringBuilder[] s = new StringBuilder[3];
        for (i = 0; i < 3; ++i) {
            s[i] = new StringBuilder();
        }
        s[0].append(String.format("%nDumping 0x%04x bytes from CPU.memory location 0x%04x%n%n", size, address));
        int last = 0;
        for (i = 0; i < size; ++i) {
            int val = CPU.CPU.memory.get(address + i);
            s[1].append(String.format("%02x", val)).append(" ");
            if ((i & 3) == 3) {
                s[1].append(" ");
            }
            if (val > 32 && val < 127) {
                s[2].append((char)val);
            } else {
                s[2].append(".");
            }
            if ((i & 0xF) != 15) continue;
            last = address + i - 15;
            s[0].append(String.format("%04x", last)).append("  ").append(s[1].toString()).append(s[2].toString()).append("\n");
            s[1].delete(0, s[1].length());
            s[2].delete(0, s[2].length());
        }
        if ((i & 0xF) != 0) {
            String l = s[1].toString();
            if (l.length() < 52) {
                l = String.format("%1$-52s", l);
            }
            s[0].append(String.format("%04x", last + 16)).append("  ").append(l).append(s[2].toString()).append("\n");
        }
        return s[0].toString();
    }

    public String dumpRawMemory(int address, int size, boolean hex) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            int val = CPU.CPU.memory.get(address + i);
            if (hex) {
                s.append(String.format("%02x", val));
            } else {
                s.append(val);
            }
            if (s.length() % 80 <= 80) {
                s.append(" ");
                continue;
            }
            s.append("\n");
        }
        return s.toString();
    }

    public void init() {
        Keyboard.KEYBOARD.init(Renderer.RENDERER.cia[0]);
        Renderer.RENDERER.init();
    }

    public void restoreKey(boolean down) {
        if (down) {
            Renderer.RENDERER.Vic.setNMI(1);
        } else {
            Renderer.RENDERER.Vic.clearNMI(1);
        }
    }

    public void setColorSet(int c) {
        Renderer.RENDERER.setColorSet(c);
    }

    public void startServer() {
        final int id = C64.C64.getTaskId();
        this.screenTask = C64.C64.addTask(id, new Callable<Void>(){

            @Override
            public Void call() {
                while (!Thread.currentThread().isInterrupted()) {
                    Net.ServerSession.SS.sendImage(Utils.createImage((Image)Renderer.RENDERER.screen.get()));
                    try {
                        TimeUnit.MILLISECONDS.sleep(C64.C64.getImageDelay());
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                C64.C64.removeTask(id);
                return null;
            }
        });
    }

    public void stopServer() {
        this.screenTask.cancel(true);
    }

    public void stop() {
        Renderer.RENDERER.Vic.stop();
    }

    private static final class Sprite {
        private final int[] color = new int[4];
        private boolean painting = false;
        private boolean dma = false;
        private boolean enabled;
        private boolean expFlipFlop;
        private boolean multicolor = false;
        private boolean expandX = false;
        private boolean expandY = false;
        private boolean priority = false;
        private boolean lineFinished = false;
        private int nextByte;
        private int pointer;
        private int x;
        private int y;
        private int spriteNo;
        private int spriteReg;
        private int pixelsLeft = 0;
        private int currentPixel = 0;
        private int col;

        private Sprite() {
        }

        private int getPixel() {
            if (this.lineFinished) {
                return 0;
            }
            if (--this.pixelsLeft > 0) {
                return this.currentPixel;
            }
            if (this.pixelsLeft <= 0 && this.spriteReg == 0) {
                this.currentPixel = 0;
                this.lineFinished = true;
                return 0;
            }
            if (this.multicolor) {
                this.currentPixel = (this.spriteReg & 0xC00000) >> 22;
                this.spriteReg = this.spriteReg << 2 & 0xFFFFFF;
                this.pixelsLeft = 2;
            } else {
                this.currentPixel = (this.spriteReg & 0x800000) >> 22;
                this.spriteReg = this.spriteReg << 1 & 0xFFFFFF;
                this.pixelsLeft = 1;
            }
            if (this.expandX) {
                this.pixelsLeft <<= 1;
            }
            return this.currentPixel;
        }

        private void reset() {
            this.lineFinished = false;
        }

        private void readSpriteData() {
            this.pointer = Renderer.RENDERER.vicBank + CPU.CPU.memory.get(Renderer.RENDERER.spr0BlockSel + this.spriteNo) * 64;
            this.spriteReg = (CPU.CPU.memory.get(this.pointer + this.nextByte++) & 0xFF) << 16 | (CPU.CPU.memory.get(this.pointer + this.nextByte++) & 0xFF) << 8 | CPU.CPU.memory.get(this.pointer + this.nextByte++);
            if (!this.expandY) {
                this.expFlipFlop = false;
            }
            if (this.expFlipFlop) {
                this.nextByte -= 3;
            }
            this.expFlipFlop = !this.expFlipFlop;
            this.pixelsLeft = 0;
        }
    }

    public static enum Renderer {
        RENDERER;

        private int[] cbmcolor = VIC.COLOR_SETS[0];
        private int[] bgCol = new int[4];
        private volatile int vicBank;
        private volatile int spr0BlockSel;
        private volatile int control1;
        private volatile int charMemoryIndex;
        private volatile int charSet;
        private volatile int vbeam;
        private volatile int raster;
        private volatile int videoMatrix;
        private volatile int videoMode;
        private volatile int borderColor = this.cbmcolor[0];
        private volatile int bgColor = this.cbmcolor[1];
        private volatile int bCol;
        private volatile int sprMC0;
        private volatile int sprMC1;
        private volatile boolean multiCol;
        private final AtomicReference<Image> screen = new AtomicReference<Object>(null);
        private final CIA[] cia = new CIA[2];
        private final Sprite[] sprites = new Sprite[8];
        private final ExtChip Vic = new ExtChip(){
            private final MemoryImageSource mis;
            private final int[] vicCharCache = new int[40];
            private final int[] vicColCache = new int[40];
            private final int[] mem = new int[112896];
            private final int[] multiColor = new int[4];
            private final int[] collisionMask = new int[432];
            private int cia2PRA;
            private int cia2DDRA;
            private int borderState;
            private int xPos;
            private int colIndex;
            private int irqMask;
            private int irqFlags;
            private int control2;
            private int sprXMSB;
            private int sprEN;
            private int sprYEX;
            private int sprXEX;
            private int sprPri;
            private int sprMul;
            private int sprCol;
            private int sprBgCol;
            private int vicMem;
            private int vicBase;
            private int vc;
            private int vcBase;
            private int rc;
            private int vmli;
            private int vPos;
            private int mpos;
            private int horizScroll;
            private int vScroll;
            private boolean gfxVisible;
            private boolean extended;
            private boolean blankRow;
            private boolean hideColumn;
            private boolean badLine;
            private boolean updating;
            private boolean displayEnabled = true;
            private boolean notVisible;
            private long lastLine;
            {
                Renderer.this.makeColors(VIC.darks, VIC.DARKER_0, VIC.DARKER_N);
                Renderer.this.makeColors(VIC.lites, VIC.LIGHTER_0, VIC.LIGHTER_N);
                Renderer.this.charMemoryIndex = 118784;
                ((Renderer)Renderer.this).cia[0] = new CIA(VIC.IO_OFFSET + 56320, this);
                ((Renderer)Renderer.this).cia[1] = new CIA(VIC.IO_OFFSET + 56576, this);
                int n = 109056;
                for (int i = 0; i < n; ++i) {
                    this.mem[i] = Renderer.this.cbmcolor[6];
                }
                this.mis = new MemoryImageSource(384, 284, this.mem, 0, 384);
                this.mis.setAnimated(true);
                this.mis.setFullBufferUpdates(true);
                Renderer.this.screen.set(Canvas.CANVAS.panel.createImage(this.mis));
            }

            @Override
            public void clock(long cycles) {
                int vicCycle = (int)(cycles - this.lastLine);
                if (this.notVisible && vicCycle < 62) {
                    return;
                }
                if (this.badLine) {
                    this.gfxVisible = true;
                }
                switch (vicCycle) {
                    case 0: {
                        this.processCycle0();
                        break;
                    }
                    case 1: {
                        if (Renderer.this.sprites[3].dma) {
                            Renderer.this.sprites[3].readSpriteData();
                        }
                        if (!Renderer.this.sprites[5].dma) break;
                        CPU.CPU.setBaLowUntil(this.lastLine + 6L);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (Renderer.this.sprites[4].dma) {
                            Renderer.this.sprites[4].readSpriteData();
                        }
                        if (!Renderer.this.sprites[6].dma) break;
                        CPU.CPU.setBaLowUntil(this.lastLine + 8L);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        if (Renderer.this.sprites[5].dma) {
                            Renderer.this.sprites[5].readSpriteData();
                        }
                        if (!Renderer.this.sprites[7].dma) break;
                        CPU.CPU.setBaLowUntil(this.lastLine + 10L);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        if (!Renderer.this.sprites[6].dma) break;
                        Renderer.this.sprites[6].readSpriteData();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        this.processCycle9();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        if (!this.badLine) break;
                        CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                        break;
                    }
                    case 12: {
                        this.mpos = this.vPos * 384;
                        this.drawBackground();
                        this.xPos = 16;
                        this.mpos += 8;
                        break;
                    }
                    case 13: {
                        this.processCycle13();
                        break;
                    }
                    case 14: {
                        this.processCycle14();
                        break;
                    }
                    case 15: {
                        this.processCycle14();
                        for (Sprite s : Renderer.this.sprites) {
                            if (s.nextByte != 63) continue;
                            s.dma = false;
                        }
                        break;
                    }
                    case 16: {
                        this.processCycle16();
                        break;
                    }
                    case 17: {
                        this.processCycle17();
                        break;
                    }
                    case 54: {
                        this.processCycle54();
                        break;
                    }
                    case 55: {
                        this.processCycle55();
                        break;
                    }
                    case 56: {
                        this.processCycle56();
                        break;
                    }
                    case 57: {
                        this.processCycle57(vicCycle);
                        break;
                    }
                    case 58: {
                        this.drawBackground();
                        this.drawSprites();
                        this.mpos += 8;
                        break;
                    }
                    case 59: {
                        this.drawBackground();
                        this.drawSprites();
                        this.mpos += 8;
                        if (!Renderer.this.sprites[1].painting) break;
                        Renderer.this.sprites[1].readSpriteData();
                        break;
                    }
                    case 60: {
                        this.drawSprites();
                        break;
                    }
                    case 61: {
                        if (Renderer.this.sprites[2].painting) {
                            Renderer.this.sprites[2].readSpriteData();
                        }
                        if (!Renderer.this.sprites[3].dma) break;
                        CPU.CPU.setBaLowUntil(this.lastLine + 65L);
                        break;
                    }
                    case 62: {
                        this.processCycle62();
                        break;
                    }
                    default: {
                        this.processDefaultCycle();
                    }
                }
            }

            @Override
            public int performRead(int address, long cycles) {
                int pos = address >> 8 & 0xF;
                switch (address &= VIC.IO_ADDRAND[pos]) {
                    case 53248: 
                    case 53250: 
                    case 53252: 
                    case 53254: 
                    case 53256: 
                    case 53258: 
                    case 53260: 
                    case 53262: {
                        return Renderer.this.sprites[address - 53248 >> 1].x & 0xFF;
                    }
                    case 53249: 
                    case 53251: 
                    case 53253: 
                    case 53255: 
                    case 53257: 
                    case 53259: 
                    case 53261: 
                    case 53263: {
                        return Renderer.this.sprites[address - 53248 >> 1].y;
                    }
                    case 53264: {
                        return this.sprXMSB;
                    }
                    case 53265: {
                        return Renderer.this.control1 & 0x7F | (Renderer.this.vbeam & 0x100) >> 1;
                    }
                    case 53266: {
                        return Renderer.this.vbeam & 0xFF;
                    }
                    case 53267: 
                    case 53268: {
                        return 0;
                    }
                    case 53269: {
                        return this.sprEN;
                    }
                    case 53270: {
                        return this.control2;
                    }
                    case 53271: {
                        return this.sprYEX;
                    }
                    case 53272: {
                        return this.vicMem;
                    }
                    case 53273: {
                        return this.irqFlags;
                    }
                    case 53274: {
                        return this.irqMask;
                    }
                    case 53275: {
                        return this.sprPri;
                    }
                    case 53276: {
                        return this.sprMul;
                    }
                    case 53277: {
                        return this.sprXEX;
                    }
                    case 53278: {
                        int val = this.sprCol;
                        this.sprCol = 0;
                        return val;
                    }
                    case 53279: {
                        int val = this.sprBgCol;
                        this.sprBgCol = 0;
                        return val;
                    }
                    case 53280: {
                        return Renderer.this.bCol | 0xF0;
                    }
                    case 53281: 
                    case 53282: 
                    case 53283: 
                    case 53284: {
                        return Renderer.this.bgCol[address - 53281] | 0xF0;
                    }
                    case 53285: {
                        return Renderer.this.sprMC0 | 0xF0;
                    }
                    case 53286: {
                        return Renderer.this.sprMC1 | 0xF0;
                    }
                    case 53287: 
                    case 53288: 
                    case 53289: 
                    case 53290: 
                    case 53291: 
                    case 53292: 
                    case 53293: 
                    case 53294: {
                        return Renderer.this.sprites[address - 53287].col | 0xF0;
                    }
                    case 54299: 
                    case 54300: {
                        return RESID.RESID.getSid().performRead(VIC.IO_OFFSET + address, cycles);
                    }
                    case 54297: {
                        return Canvas.CANVAS.x;
                    }
                    case 54298: {
                        return Canvas.CANVAS.y;
                    }
                    case 56320: {
                        return Keyboard.KEYBOARD.readDC00(CPU.CPU.getLastReadOP());
                    }
                    case 56321: {
                        return Keyboard.KEYBOARD.readDC01(CPU.CPU.getLastReadOP());
                    }
                }
                if (pos == 4) {
                    return RESID.RESID.getSid().performRead(address + VIC.IO_OFFSET, cycles);
                }
                if (pos == 13) {
                    return Renderer.this.cia[1].performRead(address + VIC.IO_OFFSET, cycles);
                }
                if (pos == 12) {
                    return Renderer.this.cia[0].performRead(address + VIC.IO_OFFSET, cycles);
                }
                if (pos >= 8) {
                    return CPU.CPU.memory.get(VIC.IO_OFFSET + address) | 0xF0;
                }
                return 255;
            }

            @Override
            public void performWrite(int address, int data, long cycles) {
                int pos = address >> 8 & 0xF;
                CPU.CPU.memory.set((address &= VIC.IO_ADDRAND[pos]) + VIC.IO_OFFSET, data);
                switch (address) {
                    case 53248: 
                    case 53250: 
                    case 53252: 
                    case 53254: 
                    case 53256: 
                    case 53258: 
                    case 53260: 
                    case 53262: {
                        int sprite = address - 53248 >> 1;
                        Renderer.this.sprites[sprite].x &= 256;
                        Renderer.this.sprites[sprite].x += data;
                        break;
                    }
                    case 53249: 
                    case 53251: 
                    case 53253: 
                    case 53255: 
                    case 53257: 
                    case 53259: 
                    case 53261: 
                    case 53263: {
                        Renderer.this.sprites[address - 53248 >> 1].y = data;
                        break;
                    }
                    case 53264: {
                        this.sprXMSB = data;
                        int i = 0;
                        int m = 1;
                        while (i < 8) {
                            Renderer.this.sprites[i].x &= 255;
                            Renderer.this.sprites[i].x |= (data & m) != 0 ? 256 : 0;
                            ++i;
                            m <<= 1;
                        }
                        break;
                    }
                    case 53265: {
                        Renderer.this.raster = Renderer.this.raster & 0xFF | data << 1 & 0x100;
                        Renderer.this.control1 = data;
                        if (this.vScroll != (data & 7)) {
                            this.vScroll = data & 7;
                            this.badLine = this.displayEnabled && Renderer.this.vbeam >= 48 && Renderer.this.vbeam <= 247 && (Renderer.this.vbeam & 7) == this.vScroll;
                        }
                        this.extended = (data & 0x40) != 0;
                        this.blankRow = (data & 8) == 0;
                        Renderer.this.videoMode = (this.extended ? 2 : 0) | (Renderer.this.multiCol ? 1 : 0) | ((data & 0x20) != 0 ? 4 : 0);
                        break;
                    }
                    case 53266: {
                        Renderer.this.raster = Renderer.this.raster & 0x100 | data;
                        break;
                    }
                    case 53267: 
                    case 53268: {
                        break;
                    }
                    case 53269: {
                        this.sprEN = data;
                        int i = 0;
                        int m = 1;
                        while (i < 8) {
                            Renderer.this.sprites[i].enabled = (data & m) != 0;
                            ++i;
                            m <<= 1;
                        }
                        break;
                    }
                    case 53270: {
                        this.control2 = data;
                        this.horizScroll = data & 7;
                        Renderer.this.multiCol = (data & 0x10) != 0;
                        this.hideColumn = (data & 8) == 0;
                        break;
                    }
                    case 53271: {
                        this.sprYEX = data;
                        int i = 0;
                        int m = 1;
                        while (i < 8) {
                            Renderer.this.sprites[i].expandY = (data & m) != 0;
                            ++i;
                            m <<= 1;
                        }
                        break;
                    }
                    case 53272: {
                        this.vicMem = data;
                        this.setVideoMem();
                        break;
                    }
                    case 53273: {
                        if ((data & 0x80) != 0) {
                            data = 255;
                        }
                        int latchval = 0xFF ^ data;
                        this.irqFlags &= latchval;
                        if ((this.irqMask & 0xF & this.irqFlags) != 0) break;
                        this.clearIRQ(1);
                        break;
                    }
                    case 53274: {
                        this.irqMask = data;
                        if ((this.irqMask & 0xF & this.irqFlags) != 0) {
                            this.irqFlags |= 0x80;
                            this.setIRQ(1);
                            break;
                        }
                        this.clearIRQ(1);
                        break;
                    }
                    case 53275: {
                        this.sprPri = data;
                        int i = 0;
                        int m = 1;
                        while (i < 8) {
                            Renderer.this.sprites[i].priority = (data & m) != 0;
                            ++i;
                            m <<= 1;
                        }
                        break;
                    }
                    case 53276: {
                        this.sprMul = data;
                        int i = 0;
                        int m = 1;
                        while (i < 8) {
                            Renderer.this.sprites[i].multicolor = (data & m) != 0;
                            ++i;
                            m <<= 1;
                        }
                        break;
                    }
                    case 53277: {
                        this.sprXEX = data;
                        int i = 0;
                        int m = 1;
                        while (i < 8) {
                            Renderer.this.sprites[i].expandX = (data & m) != 0;
                            ++i;
                            m <<= 1;
                        }
                        break;
                    }
                    case 53280: {
                        Renderer.this.borderColor = Renderer.this.cbmcolor[Renderer.this.bCol = data & 0xF];
                        break;
                    }
                    case 53281: {
                        int n = data & 0xF;
                        ((Renderer)Renderer.this).bgCol[0] = n;
                        Renderer.this.bgColor = Renderer.this.cbmcolor[n];
                        for (Sprite s : Renderer.this.sprites) {
                            ((Sprite)s).color[0] = Renderer.this.bgColor;
                        }
                        break;
                    }
                    case 53282: 
                    case 53283: 
                    case 53284: {
                        ((Renderer)Renderer.this).bgCol[address - 53281] = data & 0xF;
                        break;
                    }
                    case 53285: {
                        Renderer.this.sprMC0 = data & 0xF;
                        for (Sprite s : Renderer.this.sprites) {
                            ((Sprite)s).color[1] = Renderer.this.cbmcolor[Renderer.this.sprMC0];
                        }
                        break;
                    }
                    case 53286: {
                        Renderer.this.sprMC1 = data & 0xF;
                        for (Sprite s : Renderer.this.sprites) {
                            ((Sprite)s).color[3] = Renderer.this.cbmcolor[Renderer.this.sprMC1];
                        }
                        break;
                    }
                    case 53287: 
                    case 53288: 
                    case 53289: 
                    case 53290: 
                    case 53291: 
                    case 53292: 
                    case 53293: 
                    case 53294: {
                        ((Sprite)((Renderer)Renderer.this).sprites[address - 53287]).color[2] = Renderer.this.cbmcolor[data & 0xF];
                        Renderer.this.sprites[address - 53287].col = data & 0xF;
                        break;
                    }
                    case 56320: 
                    case 56321: 
                    case 56322: 
                    case 56323: {
                        Renderer.this.cia[0].performWrite(address + VIC.IO_OFFSET, data, CPU.CPU.getCycles());
                        break;
                    }
                    case 56576: {
                        Renderer.this.cia[1].performWrite(address + VIC.IO_OFFSET, data, CPU.CPU.getCycles());
                        this.cia2PRA = data;
                        data = ~this.cia2PRA & this.cia2DDRA;
                        this.setVideoMem();
                        break;
                    }
                    case 56578: {
                        this.cia2DDRA = data;
                        Renderer.this.cia[1].performWrite(address + VIC.IO_OFFSET, data, CPU.CPU.getCycles());
                        this.setVideoMem();
                        break;
                    }
                    default: {
                        if (pos == 4) {
                            RESID.RESID.getSid().performWrite(address + VIC.IO_OFFSET, data, cycles);
                            break;
                        }
                        if (pos == 13) {
                            Renderer.this.cia[1].performWrite(address + VIC.IO_OFFSET, data, cycles);
                            break;
                        }
                        if (pos != 12) break;
                        Renderer.this.cia[0].performWrite(address + VIC.IO_OFFSET, data, cycles);
                    }
                }
            }

            @Override
            public void reset() {
                this.initUpdate();
                RESID.RESID.getSid().reset();
                this.lastLine = CPU.CPU.getCycles();
                int n = this.mem.length;
                for (int i = 0; i < n; ++i) {
                    this.mem[i] = 0;
                }
                this.sprBgCol = 0;
                this.sprCol = 0;
                Renderer.this.cia[0].reset();
                Renderer.this.cia[1].reset();
                Keyboard.KEYBOARD.reset();
                this.resetInterrupts();
            }

            @Override
            public void stop() {
                RESID.RESID.getSid().stop();
                Audio.AUDIO.stop();
            }

            private void drawGraphics(int mpos) {
                if (!this.gfxVisible || (this.borderState & 1) == 1) {
                    int color = this.borderState > 0 ? Renderer.this.borderColor : Renderer.this.bgColor;
                    int n = mpos + 8;
                    for (int i = mpos -= this.horizScroll; i < n; ++i) {
                        this.mem[i] = color;
                    }
                    ++this.vmli;
                    return;
                }
                int collX = (this.vmli << 3) + this.horizScroll + 32;
                if (this.vmli == 0) {
                    int i;
                    int n = i + 8;
                    for (i = mpos - this.horizScroll; i < n; ++i) {
                        this.mem[i] = Renderer.this.bgColor;
                    }
                }
                if ((Renderer.this.control1 & 0x20) == 0) {
                    this.drawNormalMode(mpos, collX, Renderer.this.bgColor);
                } else {
                    this.drawBitmapMode(mpos, collX);
                }
                ++this.vc;
                ++this.vmli;
            }

            private void drawNormalMode(int mpos, int collX, int bgcol) {
                int pix;
                int position;
                int data;
                if (Renderer.this.multiCol) {
                    this.multiColor[0] = Renderer.this.bgColor;
                    this.multiColor[1] = Renderer.this.cbmcolor[Renderer.this.bgCol[1]];
                    this.multiColor[2] = Renderer.this.cbmcolor[Renderer.this.bgCol[2]];
                }
                int pcol = this.vicColCache[this.vmli] & 0xF;
                int penColor = Renderer.this.cbmcolor[pcol];
                if (this.extended) {
                    data = this.vicCharCache[this.vmli];
                    position = Renderer.this.charMemoryIndex + ((data & 0x3F) << 3);
                    bgcol = Renderer.this.cbmcolor[Renderer.this.bgCol[data >> 6]];
                } else {
                    position = Renderer.this.charMemoryIndex + (this.vicCharCache[this.vmli] << 3);
                }
                data = CPU.CPU.memory.get(position + this.rc);
                if (Renderer.this.multiCol && pcol > 7) {
                    this.multiColor[3] = Renderer.this.cbmcolor[pcol & 7];
                    for (pix = 0; pix < 8; pix += 2) {
                        int tmp = data >> pix & 3;
                        int n = this.multiColor[tmp];
                        this.mem[mpos + 7 - pix] = n;
                        this.mem[mpos + 6 - pix] = n;
                        tmp = tmp > 1 ? 256 : 0;
                        int n2 = tmp;
                        this.collisionMask[collX + 6 - pix] = n2;
                        this.collisionMask[collX + 7 - pix] = n2;
                    }
                } else {
                    for (pix = 0; pix < 8; ++pix) {
                        if ((data & 1 << pix) > 0) {
                            this.mem[mpos + 7 - pix] = penColor;
                            this.collisionMask[collX + 7 - pix] = 256;
                            continue;
                        }
                        this.mem[mpos + 7 - pix] = bgcol;
                        this.collisionMask[collX + 7 - pix] = 0;
                    }
                }
                if (Renderer.this.multiCol && this.extended) {
                    for (pix = 0; pix < 8; ++pix) {
                        this.mem[mpos + 7 - pix] = -16777216;
                    }
                }
            }

            private void drawBitmapMode(int mpos, int collX) {
                int pix;
                if (Renderer.this.multiCol) {
                    this.multiColor[0] = Renderer.this.bgColor;
                }
                int position = this.vicBase + (this.vc & 0x3FF) * 8 + this.rc;
                int vmliData = this.vicCharCache[this.vmli];
                int penColor = Renderer.this.cbmcolor[(vmliData & 0xF0) >> 4];
                int bgcol = Renderer.this.cbmcolor[vmliData & 0xF];
                int data = CPU.CPU.memory.get(position);
                if (Renderer.this.multiCol) {
                    this.multiColor[1] = Renderer.this.cbmcolor[vmliData >> 4 & 0xF];
                    this.multiColor[2] = Renderer.this.cbmcolor[vmliData & 0xF];
                    this.multiColor[3] = Renderer.this.cbmcolor[this.vicColCache[this.vmli] & 0xF];
                    for (int pix2 = 0; pix2 < 8; pix2 += 2) {
                        int tmp = data >> pix2 & 3;
                        int n = this.multiColor[tmp];
                        this.mem[mpos + 7 - pix2] = n;
                        this.mem[mpos + 6 - pix2] = n;
                        tmp = tmp > 1 ? 256 : 0;
                        int n2 = tmp;
                        this.collisionMask[collX + 6 - pix2] = n2;
                        this.collisionMask[collX + 7 - pix2] = n2;
                    }
                } else {
                    for (pix = 0; pix < 8; ++pix) {
                        if ((data & 1 << pix) > 0) {
                            this.mem[7 - pix + mpos] = penColor;
                            this.collisionMask[collX + 7 - pix] = 256;
                            continue;
                        }
                        this.mem[7 - pix + mpos] = bgcol;
                        this.collisionMask[collX + 7 - pix] = 0;
                    }
                }
                if (this.extended) {
                    for (pix = 0; pix < 8; ++pix) {
                        this.mem[mpos + 7 - pix] = -16777216;
                    }
                }
            }

            private void drawSprites() {
                int smult = 256;
                int lastX = this.xPos - 8;
                for (int i = 7; i >= 0; --i) {
                    int minX;
                    Sprite sprite = Renderer.this.sprites[i];
                    smult >>= 1;
                    if (sprite.lineFinished || !sprite.painting) continue;
                    int x = sprite.x + 8;
                    int mpos1 = this.vPos * 384;
                    if (x >= this.xPos) continue;
                    int m = this.xPos;
                    for (int j = minX = lastX > x ? lastX : x; j < m; ++j) {
                        int c = sprite.getPixel();
                        if (c == 0 || this.borderState != 0) continue;
                        int n = j;
                        int n2 = this.collisionMask[n] | smult;
                        this.collisionMask[n] = n2;
                        int tmp = n2;
                        if (!sprite.priority || (tmp & 0x100) == 0) {
                            this.mem[mpos1 + j] = sprite.color[c];
                        }
                        if (tmp == smult) continue;
                        if ((tmp & 0x100) != 0) {
                            this.sprBgCol |= smult;
                        }
                        if ((tmp & 0xFF) == smult) continue;
                        this.sprCol |= tmp & 0xFF;
                    }
                }
                this.xPos += 8;
            }

            private void drawBackground() {
                int bpos = this.mpos;
                int currentBg = this.borderState > 0 ? Renderer.this.borderColor : Renderer.this.bgColor;
                for (int i = 0; i < 8; ++i) {
                    this.mem[bpos++] = currentBg;
                }
            }

            private void initUpdate() {
                this.vmli = 0;
                this.vcBase = 0;
                this.vc = 0;
                this.updating = true;
            }

            private void processCycle62() {
                for (Sprite s : Renderer.this.sprites) {
                    s.reset();
                }
                this.lastLine += 63L;
                if (this.updating && this.vPos == 285) {
                    this.mis.newPixels();
                    Canvas.CANVAS.panel.repaint();
                    this.updating = false;
                }
                this.notVisible = false;
            }

            private void processCycle57(int vicCycle) {
                for (Sprite s : Renderer.this.sprites) {
                    if (!s.dma) continue;
                    s.painting = true;
                }
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                if (this.rc == 7) {
                    this.vcBase = this.vc;
                    this.gfxVisible = false;
                }
                if (this.badLine || this.gfxVisible) {
                    this.rc = this.rc + 1 & 7;
                    this.gfxVisible = true;
                }
                if (Renderer.this.sprites[0].painting) {
                    Renderer.this.sprites[0].readSpriteData();
                }
                if (Renderer.this.sprites[2].dma) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 63L);
                }
            }

            private void processCycle56() {
                if (!this.hideColumn) {
                    this.borderState |= 2;
                }
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                for (Sprite s : Renderer.this.sprites) {
                    if (s.dma) continue;
                    s.painting = false;
                }
                if (Renderer.this.sprites[1].dma) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 61L);
                }
            }

            private void processCycle55() {
                if (this.hideColumn) {
                    this.borderState |= 2;
                }
                if (this.badLine) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                    this.vicCharCache[this.vmli] = CPU.CPU.memory.get(Renderer.this.videoMatrix + (this.vcBase + this.vmli & 0x3FF));
                    this.vicColCache[this.vmli] = CPU.CPU.memory.get(VIC.IO_OFFSET + 55296 + (this.vcBase + this.vmli & 0x3FF));
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                if (this.borderState != 0) {
                    this.drawBackground();
                }
                this.mpos += 8;
            }

            private void processCycle54() {
                if (this.badLine) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                    this.vicCharCache[this.vmli] = CPU.CPU.memory.get(Renderer.this.videoMatrix + (this.vcBase + this.vmli & 0x3FF));
                    this.vicColCache[this.vmli] = CPU.CPU.memory.get(VIC.IO_OFFSET + 55296 + (this.vcBase + this.vmli & 0x3FF));
                }
                int ypos = this.vPos + 16;
                for (Sprite s : Renderer.this.sprites) {
                    if (!s.enabled || s.y != (ypos & 0xFF) || ypos >= 270) continue;
                    s.nextByte = 0;
                    s.dma = (s.expFlipFlop = true);
                }
                if (Renderer.this.sprites[0].dma) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 59L);
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                this.mpos += 8;
            }

            private void processCycle17() {
                if (this.hideColumn) {
                    this.borderState &= 0xFD;
                }
                this.processDefaultCycle();
            }

            private void processCycle16() {
                if (!this.hideColumn) {
                    this.borderState &= 0xFD;
                }
                if (this.badLine) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                    this.vicCharCache[this.vmli] = CPU.CPU.memory.get(Renderer.this.videoMatrix + (this.vcBase & 0x3FF));
                    this.vicColCache[this.vmli] = CPU.CPU.memory.get(VIC.IO_OFFSET + 55296 + (this.vcBase & 0x3FF));
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                if (this.borderState != 0) {
                    this.drawBackground();
                }
                this.mpos += 8;
            }

            private void processCycle13() {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                this.vc = this.vcBase;
                this.vmli = 0;
                if (this.badLine) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                    this.rc = 0;
                }
            }

            private void processCycle14() {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                if (this.badLine) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                }
            }

            private void processCycle9() {
                int i;
                if (Renderer.this.sprites[7].dma) {
                    Renderer.this.sprites[7].readSpriteData();
                }
                if (this.blankRow) {
                    if (Renderer.this.vbeam == 247) {
                        this.borderState |= 1;
                    }
                } else {
                    if (Renderer.this.vbeam == 251) {
                        this.borderState |= 1;
                    }
                    if (Renderer.this.vbeam == 51) {
                        this.borderState &= 0xFE;
                        for (i = 0; i < 7; ++i) {
                            if (Renderer.this.sprites[i].painting) continue;
                            Renderer.this.sprites[i].lineFinished = true;
                        }
                    }
                }
                if (Renderer.this.vbeam == 55) {
                    this.borderState &= 0xFE;
                    for (i = 0; i < 7; ++i) {
                        if (Renderer.this.sprites[i].painting) continue;
                        Renderer.this.sprites[i].lineFinished = true;
                    }
                }
            }

            private void processCycle0() {
                int irqComp;
                Renderer.this.vbeam = (Renderer.this.vbeam + 1) % 312;
                this.vPos = Renderer.this.vbeam - 16;
                if (Renderer.this.vbeam == 15) {
                    if (++this.colIndex >= 32) {
                        this.colIndex = 0;
                    }
                    this.initUpdate();
                }
                if ((this.irqMask & 2) != 0 && this.sprBgCol != 0 && (this.irqFlags & 2) == 0) {
                    this.irqFlags |= 0x52;
                    this.setIRQ(1);
                }
                if ((this.irqMask & 4) != 0 && this.sprCol != 0 && (this.irqFlags & 4) == 0) {
                    this.irqFlags |= 0x54;
                    this.setIRQ(1);
                }
                if ((irqComp = Renderer.this.raster) > 312) {
                    irqComp &= 0xFF;
                }
                if ((this.irqFlags & 1) == 0 && irqComp == Renderer.this.vbeam) {
                    this.irqFlags |= 1;
                    if ((this.irqMask & 1) != 0) {
                        this.irqFlags |= 0x80;
                        this.setIRQ(1);
                    }
                }
                this.notVisible = false;
                if (this.vPos < 0 || this.vPos >= 284) {
                    CPU.CPU.setBaLowUntil(0L);
                    this.notVisible = true;
                    return;
                }
                if (Renderer.this.vbeam == 48) {
                    boolean bl = this.displayEnabled = (Renderer.this.control1 & 0x10) != 0;
                    this.borderState = this.displayEnabled ? (this.borderState &= 0xFFFFFFFB) : (this.borderState |= 4);
                }
                this.badLine = this.displayEnabled && Renderer.this.vbeam >= 48 && Renderer.this.vbeam <= 247 && (Renderer.this.vbeam & 7) == this.vScroll;
                for (int i = 0; i < 384; ++i) {
                    this.collisionMask[i] = 0;
                }
            }

            private void processDefaultCycle() {
                if (this.badLine) {
                    CPU.CPU.setBaLowUntil(this.lastLine + 54L);
                    this.vicCharCache[this.vmli] = CPU.CPU.memory.get(Renderer.this.videoMatrix + (this.vcBase + this.vmli & 0x3FF));
                    this.vicColCache[this.vmli] = CPU.CPU.memory.get(VIC.IO_OFFSET + 55296 + (this.vcBase + this.vmli & 0x3FF));
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                this.mpos += 8;
            }

            private void setVideoMem() {
                Renderer.this.vicBank = (~(~this.cia2DDRA | this.cia2PRA) & 3) << 14;
                Renderer.this.charSet = Renderer.this.vicBank | (this.vicMem & 0xE) << 10;
                Renderer.this.videoMatrix = Renderer.this.vicBank | (this.vicMem & 0xF0) << 6;
                this.vicBase = Renderer.this.vicBank | (this.vicMem & 8) << 10;
                Renderer.this.spr0BlockSel = 1016 + Renderer.this.videoMatrix;
                if ((this.vicMem & 0xC) != 4 || (Renderer.this.vicBank & 0x4000) == 16384) {
                    Renderer.this.charMemoryIndex = Renderer.this.charSet;
                } else {
                    Renderer.this.charMemoryIndex = ((this.vicMem & 2) == 0 ? 0 : 2048) + 118784;
                }
            }
        };

        public ExtChip getRenderer() {
            return this.Vic;
        }

        public String dump() {
            StringBuilder s = new StringBuilder();
            s.append("\n$d011 = ").append(this.control1);
            s.append("\n24 Rows on? ").append((this.control1 & 8) == 0 ? "yes" : "no");
            s.append("\nChar Memory Index: 0x").append(Integer.toString(this.charMemoryIndex, 16));
            s.append("\nCharSet: 0x").append(Integer.toString(this.charSet, 16));
            s.append("\nIRQ RPos : ").append(this.raster);
            s.append("\nRaster Pos: ").append(this.vbeam).append(" irq: ").append(this.raster);
            s.append("\nmulticol = ").append(this.multiCol);
            s.append("\nVic Bank: 0x").append(Integer.toString(this.vicBank, 16));
            s.append("\nVideo Matrix: 0x").append(Integer.toString(this.videoMatrix, 16));
            s.append("\nVideo Mode: 0x").append(Integer.toString(this.videoMode, 16));
            s.append("\nYScroll = ").append(this.control1 & 7);
            s.append("\nBasic ON: ").append(CPU.CPU.isBasicROM());
            s.append("\nchar ON: ").append(CPU.CPU.isCharROM());
            s.append("\nio ON: ").append(CPU.CPU.isIoON());
            s.append("\nKernal ON: ").append(CPU.CPU.isKernalROM()).append("\n");
            for (int i = 0; i < 8; ++i) {
                s.append("\nSprite ").append(i + 1).append(" pos = ").append(this.sprites[i].x).append(", ").append(this.sprites[i].y);
            }
            s.append(this.cia[0].printStatus());
            s.append(this.cia[1].printStatus());
            return s.toString();
        }

        private void init() {
            int n = this.sprites.length;
            for (int i = 0; i < n; ++i) {
                this.sprites[i] = new Sprite();
                this.sprites[i].spriteNo = i;
            }
            for (Sprite s : this.sprites) {
                s.nextByte = (s.spriteReg = 0);
                s.painting = false;
            }
            Color[] colors = new Color[16];
            for (int i = 0; i < 16; ++i) {
                colors[i] = new Color(this.cbmcolor[i]);
            }
            Canvas.CANVAS.panel.setBackground(colors[CPU.CPU.memory.get(VIC.IO_OFFSET + 53280) & 0xF]);
        }

        private void makeColors(Color[] colors, Color c1, Color c2) {
            int a0 = c1.getAlpha();
            int r0 = c1.getRed();
            int g0 = c1.getGreen();
            int b0 = c1.getBlue();
            int an = c2.getAlpha();
            int rn = c2.getRed();
            int gn = c2.getGreen();
            int bn = c2.getBlue();
            int lc = 16;
            int n = lc;
            for (int i = 0; i < n; ++i) {
                Color color = new Color(((lc - i) * r0 + i * rn) / lc, ((lc - i) * g0 + i * gn) / lc, ((lc - i) * b0 + i * bn) / lc, ((lc - i) * a0 + i * an) / lc);
                colors[32 - i - 1] = color;
                colors[i] = color;
            }
        }

        private void paint(Graphics g) {
            int off2Y = Canvas.CANVAS.offsetY << 1;
            int off2X = Canvas.CANVAS.offsetX << 1;
            g.fillRect(0, 0, Canvas.CANVAS.offsetX, Canvas.CANVAS.displayHeight + off2Y);
            g.fillRect(Canvas.CANVAS.offsetX + Canvas.CANVAS.displayWidth, 0, Canvas.CANVAS.offsetX, Canvas.CANVAS.displayHeight + off2Y);
            g.fillRect(0, 0, Canvas.CANVAS.displayWidth + off2X, Canvas.CANVAS.offsetY);
            g.fillRect(0, Canvas.CANVAS.displayHeight + Canvas.CANVAS.offsetY, Canvas.CANVAS.displayWidth + off2X, Canvas.CANVAS.offsetY);
            g.drawImage(this.screen.get(), Canvas.CANVAS.offsetX, Canvas.CANVAS.offsetY, Canvas.CANVAS.displayWidth, Canvas.CANVAS.displayHeight, null);
        }

        private void setColorSet(int c) {
            if (c >= 0 && c < VIC.COLOR_SETS.length) {
                this.cbmcolor = VIC.COLOR_SETS[c];
                this.borderColor = this.cbmcolor[this.bCol];
                this.bgColor = this.cbmcolor[this.bgCol[0]];
                for (Sprite s : this.sprites) {
                    ((Sprite)s).color[0] = this.bgColor;
                    ((Sprite)s).color[1] = this.cbmcolor[this.sprMC0];
                    ((Sprite)s).color[3] = this.cbmcolor[this.sprMC1];
                }
            }
        }
    }

    public static enum Canvas {
        CANVAS;

        private int w;
        private int h;
        private int x = 0;
        private int y = 0;
        private int displayWidth = 384;
        private int displayHeight = 284;
        private int offsetX = 0;
        private int offsetY = 0;
        private volatile int rate = 100;
        private volatile int oldRate = 100;
        private final JPanel panel = new JPanel(){
            {
                this.setDoubleBuffered(true);
                MouseAdapter ma = new MouseAdapter(){
                    private boolean button1 = false;
                    private boolean button2 = false;

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        this.updateLocation(e);
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        this.updateLocation(e);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.updateButtons(e, true);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.updateButtons(e, false);
                    }

                    private void updateLocation(MouseEvent e) {
                        Canvas.this.x = e.getX() & 0xFF;
                        Canvas.this.y = 255 - (e.getY() & 0xFF);
                    }

                    private void updateButtons(MouseEvent e, boolean pressed) {
                        if (e.getButton() == 1) {
                            this.button1 = pressed;
                        } else {
                            this.button2 = pressed;
                        }
                        Keyboard.KEYBOARD.setButtonval(255 - (this.button1 | this.button2 ? 16 : 0));
                    }
                };
                this.addMouseMotionListener(ma);
                this.addMouseListener(ma);
            }

            @Override
            public void paint(Graphics g) {
                if (!Audio.AUDIO.hasSound()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(Canvas.this.rate);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Canvas.this.doAutoScale();
                Renderer.RENDERER.paint(g);
            }
        };

        public JPanel getPanel() {
            return this.panel;
        }

        public void setOldrate(int o) {
            this.oldRate = o;
        }

        public int getOldrate() {
            return this.oldRate;
        }

        public int getRate() {
            return this.rate;
        }

        public void setRate(int r) {
            this.rate = r;
        }

        private void doAutoScale() {
            if (this.w == this.panel.getWidth() && this.h == this.panel.getHeight()) {
                return;
            }
            this.w = this.panel.getWidth();
            this.h = this.panel.getHeight();
            double fw = 1.0 * (double)this.w / 384.0;
            double fh = 1.0 * (double)this.h / 284.0;
            if (fw > fh) {
                fw = fh;
            }
            if (fw > 1.0) {
                fw = (int)fw;
            }
            this.setDisplayFactor(fw);
            this.setDisplayOffset((int)((double)this.w - fw * 384.0) / 2, (int)((double)this.h - fh * 284.0) / 2);
        }

        private void setDisplayFactor(double f) {
            this.displayWidth = (int)(384.0 * f);
            this.displayHeight = (int)(284.0 * f);
        }

        private void setDisplayOffset(int x, int y) {
            this.offsetX = x;
            this.offsetY = y;
        }
    }
}

