/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.sound;

import org.free.j64.sound.Voice;

enum SID {
    SID;

    private final Voice[] voice = new Voice[]{new Voice(), new Voice(), new Voice()};
    private final Filter filter = new Filter();
    private final ExternalFilter extfilter = new ExternalFilter();
    private int bus_value;
    private int bus_value_ttl;
    private int ext_in;
    private final int FIR_N = 125;
    private final int FIR_RES_INTERPOLATE = 285;
    private final int FIR_RES_FAST = 51473;
    private final int FIR_SHIFT = 15;
    private final int RINGSIZE = 16384;
    private int fir_N;
    private int fir_RES;
    private short[] sample = null;
    private short[] fir = null;

    private SID() {
        this.voice[0].set_sync_source(this.voice[2]);
        this.voice[1].set_sync_source(this.voice[0]);
        this.voice[2].set_sync_source(this.voice[1]);
        this.set_sampling_parameters(985248.0, sampling_method.SAMPLE_FAST, 44100.0, -1.0, 0.97);
        this.ext_in = 0;
        this.bus_value_ttl = 0;
        this.bus_value = 0;
    }

    void clock() {
        if (--this.bus_value_ttl <= 0) {
            this.bus_value_ttl = 0;
            this.bus_value = 0;
        }
        for (Voice v : this.voice) {
            v.envelope.clock();
        }
        for (Voice v : this.voice) {
            v.wave.clock();
        }
        for (Voice v : this.voice) {
            v.wave.synchronize();
        }
        this.filter.clock(this.voice[0].output(), this.voice[1].output(), this.voice[2].output(), this.ext_in);
        this.extfilter.clock(this.filter.output());
    }

    boolean set_sampling_parameters(double clock_freq, sampling_method method, double sample_freq, double pass_freq, double filter_scale) {
        if ((method == sampling_method.SAMPLE_RESAMPLE_INTERPOLATE || method == sampling_method.SAMPLE_RESAMPLE_FAST) && 125.0 * clock_freq / sample_freq >= 16384.0) {
            return false;
        }
        if (pass_freq < 0.0) {
            pass_freq = 20000.0;
            if (2.0 * pass_freq / sample_freq >= 0.9) {
                pass_freq = 0.9 * sample_freq / 2.0;
            }
        } else if (pass_freq > 0.9 * sample_freq / 2.0) {
            return false;
        }
        if (filter_scale < 0.9 || filter_scale > 1.0) {
            return false;
        }
        this.extfilter.set_sampling_parameter(pass_freq);
        if (method != sampling_method.SAMPLE_RESAMPLE_INTERPOLATE && method != sampling_method.SAMPLE_RESAMPLE_FAST) {
            this.fir = null;
            this.sample = null;
            return true;
        }
        double A = -20.0 * Math.log10(1.52587890625E-5);
        double dw = (1.0 - 2.0 * pass_freq / sample_freq) * Math.PI;
        double wc = (2.0 * pass_freq / sample_freq + 1.0) * Math.PI / 2.0;
        double beta = 0.1102 * (A - 8.7);
        double I0beta = this.I0(beta);
        int N = (int)((A - 7.95) / (2.285 * dw) + 0.5);
        N += N & 1;
        double f_samples_per_cycle = sample_freq / clock_freq;
        double f_cycles_per_sample = clock_freq / sample_freq;
        this.fir_N = (int)((double)N * f_cycles_per_sample) + 1;
        this.fir_N |= 1;
        int res = method == sampling_method.SAMPLE_RESAMPLE_INTERPOLATE ? 285 : 51473;
        int n = (int)Math.ceil(Math.log((double)res / f_cycles_per_sample) / Math.log(2.0));
        this.fir_RES = 1 << n;
        this.fir = new short[this.fir_N * this.fir_RES];
        for (int i = 0; i < this.fir_RES; ++i) {
            int fir_offset = i * this.fir_N + this.fir_N / 2;
            double j_offset = (double)i / (double)this.fir_RES;
            for (int j = -this.fir_N / 2; j <= this.fir_N / 2; ++j) {
                double jx = (double)j - j_offset;
                double wt = wc * jx / f_cycles_per_sample;
                double temp = jx / (double)(this.fir_N / 2);
                double Kaiser = Math.abs(temp) <= 1.0 ? this.I0(beta * Math.sqrt(1.0 - temp * temp)) / I0beta : 0.0;
                double sincwt = Math.abs(wt) >= 1.0E-6 ? Math.sin(wt) / wt : 1.0;
                double val = 32768.0 * filter_scale * f_samples_per_cycle * wc / Math.PI * sincwt * Kaiser;
                this.fir[fir_offset + j] = (short)(val + 0.5);
            }
        }
        if (this.sample == null) {
            this.sample = new short[32768];
        }
        for (int j = 0; j < 32768; ++j) {
            this.sample[j] = 0;
        }
        return true;
    }

    void reset() {
        for (Voice v : this.voice) {
            v.reset();
        }
        this.filter.reset();
        this.extfilter.reset();
        this.bus_value_ttl = 0;
        this.bus_value = 0;
    }

    int output() {
        int range = 65536;
        int half = 32768;
        int sample1 = this.extfilter.output() / 11;
        if (sample1 >= 32768) {
            return Short.MAX_VALUE;
        }
        if (sample1 < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return sample1;
    }

    int read(int offset) {
        switch (offset) {
            case 25: {
                return 255;
            }
            case 26: {
                return 255;
            }
            case 27: {
                return this.voice[2].wave.readOSC();
            }
            case 28: {
                return this.voice[2].envelope.readENV();
            }
        }
        return this.bus_value;
    }

    void write(int offset, int value) {
        this.bus_value = value;
        this.bus_value_ttl = 8192;
        switch (offset) {
            case 0: {
                this.voice[0].wave.writeFREQ_LO(value);
                break;
            }
            case 1: {
                this.voice[0].wave.writeFREQ_HI(value);
                break;
            }
            case 2: {
                this.voice[0].wave.writePW_LO(value);
                break;
            }
            case 3: {
                this.voice[0].wave.writePW_HI(value);
                break;
            }
            case 4: {
                this.voice[0].writeCONTROL_REG(value);
                break;
            }
            case 5: {
                this.voice[0].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 6: {
                this.voice[0].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 7: {
                this.voice[1].wave.writeFREQ_LO(value);
                break;
            }
            case 8: {
                this.voice[1].wave.writeFREQ_HI(value);
                break;
            }
            case 9: {
                this.voice[1].wave.writePW_LO(value);
                break;
            }
            case 10: {
                this.voice[1].wave.writePW_HI(value);
                break;
            }
            case 11: {
                this.voice[1].writeCONTROL_REG(value);
                break;
            }
            case 12: {
                this.voice[1].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 13: {
                this.voice[1].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 14: {
                this.voice[2].wave.writeFREQ_LO(value);
                break;
            }
            case 15: {
                this.voice[2].wave.writeFREQ_HI(value);
                break;
            }
            case 16: {
                this.voice[2].wave.writePW_LO(value);
                break;
            }
            case 17: {
                this.voice[2].wave.writePW_HI(value);
                break;
            }
            case 18: {
                this.voice[2].writeCONTROL_REG(value);
                break;
            }
            case 19: {
                this.voice[2].envelope.writeATTACK_DECAY(value);
                break;
            }
            case 20: {
                this.voice[2].envelope.writeSUSTAIN_RELEASE(value);
                break;
            }
            case 21: {
                this.filter.writeFC_LO(value);
                break;
            }
            case 22: {
                this.filter.writeFC_HI(value);
                break;
            }
            case 23: {
                this.filter.writeRES_FILT(value);
                break;
            }
            case 24: {
                this.filter.writeMODE_VOL(value);
                break;
            }
        }
    }

    private double I0(double x) {
        double u;
        double I0e = 1.0E-6;
        int n = 1;
        double sum = u = (double)1;
        double temp = x / 2.0 / (double)n++;
        while ((u *= temp * temp) >= 1.0E-6 * (sum += u)) {
        }
        return sum;
    }

    private static final class Filter {
        private int fc = 0;
        private int res = 0;
        private int filt = 0;
        private int voice3off = 0;
        private int hp_bp_lp = 0;
        private int vol = 0;
        private boolean enabled;
        private int mixer_DC;
        private int Vhp = 0;
        private int Vbp = 0;
        private int Vlp = 0;
        private int Vnf = 0;
        private int DLthreshold;
        private int DLsteepness;
        private int DHthreshold;
        private int DHsteepness;
        private int DLlp;
        private int DLbp;
        private int DLhp;
        private int DHlp;
        private int DHbp;
        private int DHhp;
        private int w0;
        private int w0_ceil_1;
        private int _1024_div_Q;
        private final int[] f0_6581 = new int[2048];
        private int[] f0;
        private static final int[][] f0_points_6581 = new int[][]{{0, 220}, {0, 220}, {128, 230}, {256, 250}, {384, 300}, {512, 420}, {640, 780}, {768, 1600}, {832, 2300}, {896, 3200}, {960, 4300}, {992, 5000}, {1008, 5400}, {1016, 5700}, {1023, 6000}, {1023, 6000}, {1024, 4600}, {1024, 4600}, {1032, 4800}, {1056, 5300}, {1088, 6000}, {1120, 6600}, {1152, 7200}, {1280, 9500}, {1408, 12000}, {1536, 14500}, {1664, 16000}, {1792, 17100}, {1920, 17700}, {2047, 18000}, {2047, 18000}};

        void clock(int voice1, int voice2, int voice3, int ext_in) {
            int Vi_peak_lp;
            voice1 >>= 7;
            voice2 >>= 7;
            voice3 = this.voice3off != 0 && (this.filt & 4) == 0 ? 0 : (voice3 >>= 7);
            ext_in >>= 7;
            if (!this.enabled) {
                this.Vnf = voice1 + voice2 + voice3 + ext_in;
                this.Vlp = 0;
                this.Vbp = 0;
                this.Vhp = 0;
                return;
            }
            this.Vnf = 0;
            int Vi = 0;
            if ((this.filt & 1) != 0) {
                Vi += voice1;
            } else {
                this.Vnf += voice1;
            }
            if ((this.filt & 2) != 0) {
                Vi += voice2;
            } else {
                this.Vnf += voice2;
            }
            if ((this.filt & 4) != 0) {
                Vi += voice3;
            } else {
                this.Vnf += voice3;
            }
            if ((this.filt & 8) != 0) {
                Vi += ext_in;
            } else {
                this.Vnf += ext_in;
            }
            int Vi_peak_bp = (this.Vlp * this.DHlp + this.Vbp * this.DHbp + this.Vhp * this.DHhp >> 8) + Vi;
            if (Vi_peak_bp < this.DHthreshold) {
                Vi_peak_bp = this.DHthreshold;
            }
            if ((Vi_peak_lp = (this.Vlp * this.DLlp + this.Vbp * this.DLbp + this.Vhp * this.DLhp >> 8) + Vi) < this.DLthreshold) {
                Vi_peak_lp = this.DLthreshold;
            }
            int w0_eff_bp = this.w0 + this.w0 * (Vi_peak_bp - this.DHthreshold >> 4) / this.DHsteepness;
            int w0_eff_lp = this.w0 + this.w0 * (Vi_peak_lp - this.DLthreshold >> 4) / this.DLsteepness;
            if (w0_eff_bp > this.w0_ceil_1) {
                w0_eff_bp = this.w0_ceil_1;
            }
            if (w0_eff_lp > this.w0_ceil_1) {
                w0_eff_lp = this.w0_ceil_1;
            }
            this.Vhp = (this.Vbp * this._1024_div_Q >> 10) - this.Vlp - Vi;
            this.Vlp -= w0_eff_lp * this.Vbp >> 20;
            this.Vbp -= w0_eff_bp * this.Vhp >> 20;
        }

        int output() {
            int Vf;
            if (!this.enabled) {
                return (this.Vnf + this.mixer_DC) * this.vol;
            }
            switch (this.hp_bp_lp) {
                default: {
                    Vf = 0;
                    break;
                }
                case 1: {
                    Vf = this.Vlp;
                    break;
                }
                case 2: {
                    Vf = this.Vbp;
                    break;
                }
                case 3: {
                    Vf = this.Vlp + this.Vbp;
                    break;
                }
                case 4: {
                    Vf = this.Vhp;
                    break;
                }
                case 5: {
                    Vf = this.Vlp + this.Vhp;
                    break;
                }
                case 6: {
                    Vf = this.Vbp + this.Vhp;
                    break;
                }
                case 7: {
                    Vf = this.Vlp + this.Vbp + this.Vhp;
                }
            }
            return (this.Vnf + Vf + this.mixer_DC) * this.vol;
        }

        Filter() {
            this.enable_filter(true);
            this.interpolate(f0_points_6581, 0, f0_points_6581.length - 1, this.f0_6581, 1.0);
            this.init();
            this.set_distortion_properties(999999, 999999, 0, 0, 0, 999999, 999999, 0, 0, 0);
        }

        private void enable_filter(boolean enable) {
            this.enabled = enable;
        }

        void init() {
            this.mixer_DC = -454;
            this.f0 = this.f0_6581;
            this.set_w0();
            this.set_Q();
        }

        private void set_distortion_properties(int Lthreshold, int Lsteepness, int Llp, int Lbp, int Lhp, int Hthreshold, int Hsteepness, int Hlp, int Hbp, int Hhp) {
            this.DLthreshold = Lthreshold;
            if (Lsteepness < 16) {
                Lsteepness = 16;
            }
            this.DLsteepness = Lsteepness >> 4;
            this.DLlp = Llp;
            this.DLbp = Lbp;
            this.DLhp = Lhp;
            this.DHthreshold = Hthreshold;
            if (Hsteepness < 16) {
                Hsteepness = 16;
            }
            this.DHsteepness = Hsteepness >> 4;
            this.DHlp = Hlp;
            this.DHbp = Hbp;
            this.DHhp = Hhp;
        }

        void reset() {
            this.Vnf = 0;
            this.Vlp = 0;
            this.Vbp = 0;
            this.Vhp = 0;
            this.vol = 0;
            this.hp_bp_lp = 0;
            this.voice3off = 0;
            this.filt = 0;
            this.res = 0;
            this.fc = 0;
            this.set_w0();
            this.set_Q();
        }

        void writeFC_LO(int fc_lo) {
            this.fc = this.fc & 0x7F8 | fc_lo & 7;
            this.set_w0();
        }

        void writeFC_HI(int fc_hi) {
            this.fc = fc_hi << 3 & 0x7F8 | this.fc & 7;
            this.set_w0();
        }

        void writeRES_FILT(int res_filt) {
            this.res = res_filt >> 4 & 0xF;
            this.set_Q();
            this.filt = res_filt & 0xF;
        }

        void writeMODE_VOL(int mode_vol) {
            this.voice3off = mode_vol & 0x80;
            this.hp_bp_lp = mode_vol >> 4 & 7;
            this.vol = mode_vol & 0xF;
        }

        private void set_w0() {
            this.w0 = (int)(Math.PI * 2 * (double)this.f0[this.fc] * 1.048576);
            this.w0_ceil_1 = 118591;
        }

        private void set_Q() {
            this._1024_div_Q = (int)(1024.0 / (0.707 + 1.0 * (double)this.res / 15.0));
        }

        private void cubic_coefficients(double x1, double y1, double x2, double y2, double k1, double k2, Coefficients coeff) {
            double dx = x2 - x1;
            double dy = y2 - y1;
            coeff.a = (k1 + k2 - 2.0 * dy / dx) / (dx * dx);
            coeff.b = ((k2 - k1) / dx - 3.0 * (x1 + x2) * coeff.a) / 2.0;
            coeff.c = k1 - (3.0 * x1 * coeff.a + 2.0 * coeff.b) * x1;
            coeff.d = y1 - ((x1 * coeff.a + coeff.b) * x1 + coeff.c) * x1;
        }

        private void interpolate_forward_difference(double x1, double y1, double x2, double y2, double k1, double k2, int[] plotter, double res) {
            Coefficients coeff = new Coefficients();
            this.cubic_coefficients(x1, y1, x2, y2, k1, k2, coeff);
            double y = ((coeff.a * x1 + coeff.b) * x1 + coeff.c) * x1 + coeff.d;
            double dy = (3.0 * coeff.a * (x1 + res) + 2.0 * coeff.b) * x1 * res + ((coeff.a * res + coeff.b) * res + coeff.c) * res;
            double d2y = (6.0 * coeff.a * (x1 + res) + 2.0 * coeff.b) * res * res;
            double d3y = 6.0 * coeff.a * res * res * res;
            for (double x = x1; x <= x2; x += res) {
                plotter[(int)x] = y < 0.0 ? 0 : (int)y;
                y += dy;
                dy += d2y;
                d2y += d3y;
            }
        }

        private double x(int[][] f0_base, int p) {
            return f0_base[p][0];
        }

        private double y(int[][] f0_base, int p) {
            return f0_base[p][1];
        }

        private void interpolate(int[][] f0_base, int p0, int pn, int[] plotter, double res) {
            int p1 = p0;
            int p2 = ++p1;
            int p3 = ++p2;
            ++p3;
            while (p2 != pn) {
                if (Double.compare(this.x(f0_base, p1), this.x(f0_base, p2)) != 0) {
                    double k1;
                    double k2;
                    if (this.x(f0_base, p0) == this.x(f0_base, p1) && this.x(f0_base, p2) == this.x(f0_base, p3)) {
                        k1 = k2 = (this.y(f0_base, p2) - this.y(f0_base, p1)) / (this.x(f0_base, p2) - this.x(f0_base, p1));
                    } else if (this.x(f0_base, p0) == this.x(f0_base, p1)) {
                        k2 = (this.y(f0_base, p3) - this.y(f0_base, p1)) / (this.x(f0_base, p3) - this.x(f0_base, p1));
                        k1 = (3.0 * (this.y(f0_base, p2) - this.y(f0_base, p1)) / (this.x(f0_base, p2) - this.x(f0_base, p1)) - k2) / 2.0;
                    } else if (this.x(f0_base, p2) == this.x(f0_base, p3)) {
                        k1 = (this.y(f0_base, p2) - this.y(f0_base, p0)) / (this.x(f0_base, p2) - this.x(f0_base, p0));
                        k2 = (3.0 * (this.y(f0_base, p2) - this.y(f0_base, p1)) / (this.x(f0_base, p2) - this.x(f0_base, p1)) - k1) / 2.0;
                    } else {
                        k1 = (this.y(f0_base, p2) - this.y(f0_base, p0)) / (this.x(f0_base, p2) - this.x(f0_base, p0));
                        k2 = (this.y(f0_base, p3) - this.y(f0_base, p1)) / (this.x(f0_base, p3) - this.x(f0_base, p1));
                    }
                    this.interpolate_forward_difference(this.x(f0_base, p1), this.y(f0_base, p1), this.x(f0_base, p2), this.y(f0_base, p2), k1, k2, plotter, res);
                }
                ++p0;
                ++p1;
                ++p2;
                ++p3;
            }
        }

        private static final class Coefficients {
            double a;
            double b;
            double c;
            double d;

            private Coefficients() {
            }
        }
    }

    private static final class ExternalFilter {
        private boolean enabled;
        private int mixer_DC;
        private int Vlp;
        private int Vhp;
        private int Vo;
        private int w0lp;
        private int w0hp;

        void clock(int Vi) {
            if (!this.enabled) {
                this.Vhp = 0;
                this.Vlp = 0;
                this.Vo = Vi - this.mixer_DC;
                return;
            }
            int dVlp = (this.w0lp >> 8) * (Vi - this.Vlp) >> 12;
            int dVhp = this.w0hp * (this.Vlp - this.Vhp) >> 20;
            this.Vo = this.Vlp - this.Vhp;
            this.Vlp += dVlp;
            this.Vhp += dVhp;
        }

        int output() {
            return this.Vo;
        }

        ExternalFilter() {
            this.reset();
            this.enable_filter(true);
            this.set_sampling_parameter(15915.6);
            this.init();
        }

        private void enable_filter(boolean enable) {
            this.enabled = enable;
        }

        void set_sampling_parameter(double pass_freq) {
            this.w0hp = 105;
            this.w0lp = (int)(pass_freq * 6.588397316661141);
            if (this.w0lp > 104858) {
                this.w0lp = 104858;
            }
        }

        void init() {
            this.mixer_DC = 280065;
        }

        void reset() {
            this.Vo = 0;
            this.Vhp = 0;
            this.Vlp = 0;
        }
    }

    static enum sampling_method {
        SAMPLE_FAST,
        SAMPLE_RESAMPLE_INTERPOLATE,
        SAMPLE_RESAMPLE_FAST;

    }
}

