/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.net;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.free.j64.net.ClientHandler;
import org.free.j64.net.ClientPipelineFactory;
import org.free.j64.net.ServerPipelineFactory;
import org.free.j64.net.type.Audio;
import org.free.j64.net.type.Chat;
import org.free.j64.net.type.Key;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public final class Net {
    public static final int SEND_KEYS_OFF = 0;
    public static final int SEND_KEYS_ON = 1;
    public static final int DISCONNECT_CLIENT = 2;

    private Net() {
    }

    public static final class User {
        private String address = "";
        private String name = "";

        public User() {
        }

        public User(String address) {
            this.address = address;
        }

        public User(String address, String name) {
            this.address = address;
            this.name = name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getName() {
            return this.name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.address);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            User other = (User)obj;
            return Objects.equals(this.address, other.address);
        }
    }

    public static final class ClientSession {
        private final ClientBootstrap cb;
        private final Channel ch;
        private final ClientHandler handler;
        private final ChatSession cs = new ChatSession(){

            @Override
            public Chat getChat() {
                return ((ClientSession)ClientSession.this).handler.chatBuffer.poll();
            }

            @Override
            public void sendChat(Chat o) {
                if (o == null || ClientSession.this.sendingChat) {
                    return;
                }
                ChannelFuture f = ClientSession.this.ch.write(o);
                ClientSession.this.sendingChat = true;
                f.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        ClientSession.this.sendingChat = false;
                    }
                });
            }

            @Override
            public String getDefaultName() {
                return ClientSession.this.ch.getLocalAddress().toString();
            }
        };
        private volatile boolean sendingChat;
        private volatile boolean sendingKey;

        public static ClientSession connect(String host, int port) throws IOException {
            ClientBootstrap cb = new ClientBootstrap(new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
            cb.setPipelineFactory(new ClientPipelineFactory());
            ChannelFuture f = cb.connect(new InetSocketAddress(host, port));
            Channel ch = f.awaitUninterruptibly().getChannel();
            if (!f.isSuccess()) {
                f.getCause().printStackTrace();
                cb.releaseExternalResources();
                return null;
            }
            return new ClientSession(cb, ch);
        }

        public ClientSession(ClientBootstrap cb, Channel ch) {
            this.cb = cb;
            this.ch = ch;
            this.handler = (ClientHandler)ch.getPipeline().get("handler");
        }

        public void disconnect() {
            ChannelFuture f = this.ch.close().awaitUninterruptibly();
            if (!f.isSuccess()) {
                f.getCause().printStackTrace();
            }
            this.cb.releaseExternalResources();
            this.handler.audioBuffer.clear();
            this.handler.chatBuffer.clear();
            this.handler.keyBuffer.clear();
            this.handler.imageBuffer.clear();
            this.handler.stringBuffer.clear();
        }

        public Audio flushAudios() {
            Audio au = this.handler.audioBuffer.peekLast();
            this.handler.audioBuffer.clear();
            return au;
        }

        public BufferedImage flushImages() {
            BufferedImage img = this.handler.imageBuffer.peekLast();
            this.handler.imageBuffer.clear();
            return img;
        }

        public Audio getAudio() {
            return this.handler.audioBuffer.poll();
        }

        public int getAudioSize() {
            return this.handler.audioBuffer.size();
        }

        public ChatSession getChatSession() {
            return this.cs;
        }

        public Key getKey() {
            return this.handler.keyBuffer.poll();
        }

        public BufferedImage getImage() {
            return this.handler.imageBuffer.poll();
        }

        public int getImageSize() {
            return this.handler.imageBuffer.size();
        }

        public String getLocalAddress() {
            return this.ch.getLocalAddress().toString();
        }

        public String getRemoteAddress() {
            return this.ch.getRemoteAddress().toString();
        }

        public String getString() {
            return this.handler.stringBuffer.poll();
        }

        public boolean isConnected() {
            return this.ch.isConnected();
        }

        public void sendKey(Key o) {
            if (o == null || this.sendingKey) {
                return;
            }
            ChannelFuture f = this.ch.write(o);
            this.sendingKey = true;
            f.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    ClientSession.this.sendingKey = false;
                }
            });
        }
    }

    public static enum ServerSession {
        SS;

        final ChannelGroup channels = new DefaultChannelGroup();
        final Queue<Chat> chatBuffer = new LinkedBlockingQueue<Chat>();
        final Queue<Key> keyBuffer = new LinkedBlockingQueue<Key>();
        final Map<String, User> connected = new HashMap<String, User>();
        String keySender = "";
        int maxConnections = 0;
        final AtomicInteger connections = new AtomicInteger(0);
        private final ChatSession cs = new ChatSession(){

            @Override
            public Chat getChat() {
                return ServerSession.this.chatBuffer.poll();
            }

            @Override
            public void sendChat(Chat o) {
                if (o == null || ServerSession.this.sendingChat) {
                    return;
                }
                ChannelGroupFuture gf = ServerSession.this.channels.write(o);
                ServerSession.this.sendingChat = true;
                gf.addListener(new ChannelGroupFutureListener(){

                    @Override
                    public void operationComplete(ChannelGroupFuture future) {
                        ServerSession.this.sendingChat = false;
                    }
                });
            }

            @Override
            public String getDefaultName() {
                return ServerSession.this.ch.getLocalAddress().toString();
            }
        };
        private Map<String, User> users;
        private ServerBootstrap sb;
        private Channel ch;
        private volatile boolean isRunning;
        private volatile boolean sendingAudio;
        private volatile boolean sendingChat;
        private volatile boolean sendingKey;
        private volatile boolean sendingImage;

        public ChatSession getChatSession() {
            return this.cs;
        }

        public Key getKey() {
            return this.keyBuffer.poll();
        }

        public String getKeySender() {
            return this.keySender;
        }

        public String getLocalAddress() {
            return this.ch.getLocalAddress().toString();
        }

        public String getRemoteAddress() {
            return this.ch.getRemoteAddress().toString();
        }

        public Map<String, User> getUsers() {
            return Collections.unmodifiableMap(this.users);
        }

        public void sendAudio(Audio o) {
            if (o == null || this.sendingAudio || this.channels.size() == 0) {
                return;
            }
            ChannelGroupFuture gf = this.channels.write(o);
            this.sendingAudio = true;
            gf.addListener(new ChannelGroupFutureListener(){

                @Override
                public void operationComplete(ChannelGroupFuture future) {
                    ServerSession.this.sendingAudio = false;
                }
            });
        }

        public void sendKey(String address, Key o) {
            if (o == null || this.sendingKey) {
                return;
            }
            ChannelFuture f = null;
            for (Channel c : this.channels) {
                if (!c.getRemoteAddress().toString().substring(1).startsWith(address)) continue;
                f = c.write(o);
                this.sendingKey = true;
                break;
            }
            if (f != null) {
                f.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        ServerSession.this.sendingKey = false;
                    }
                });
            }
        }

        public void sendImage(BufferedImage o) {
            if (o == null || this.sendingImage || this.channels.size() == 0) {
                return;
            }
            ChannelGroupFuture gf = this.channels.write(o);
            this.sendingImage = true;
            gf.addListener(new ChannelGroupFutureListener(){

                @Override
                public void operationComplete(ChannelGroupFuture future) {
                    ServerSession.this.sendingImage = false;
                }
            });
        }

        public void setKeySender(String keySender) {
            this.keySender = keySender;
        }

        public void setMaxCon(int maxCon) {
            this.maxConnections = maxCon;
        }

        public void setUsers(Map<String, User> users) {
            this.users = users;
        }

        public void start(int port) {
            if (this.isRunning) {
                throw new IllegalStateException("Server already running.");
            }
            this.sb = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
            this.sb.setPipelineFactory(new ServerPipelineFactory());
            this.ch = this.sb.bind(new InetSocketAddress(port));
            this.isRunning = true;
        }

        public void stop() {
            if (!this.isRunning) {
                throw new IllegalStateException("Server not running.");
            }
            ChannelGroupFuture gf = this.channels.close();
            gf.awaitUninterruptibly();
            if (gf.isPartialFailure() || gf.isCompleteFailure()) {
                System.err.println("Some connections not closed properly. Check logs for errors");
            }
            ChannelFuture f = this.ch.close();
            f.awaitUninterruptibly();
            if (!f.isSuccess()) {
                f.getCause().printStackTrace();
            }
            this.sb.releaseExternalResources();
            this.chatBuffer.clear();
            this.keyBuffer.clear();
            this.connected.clear();
            this.users.clear();
            this.isRunning = false;
        }
    }

    public static interface ChatSession {
        public Chat getChat();

        public void sendChat(Chat var1);

        public String getDefaultName();
    }
}

