/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.net.chat;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import org.free.j64.net.Net;
import org.free.j64.net.etc.Utils;
import org.free.j64.net.type.Chat;

public final class Client
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(Client.class);
    private final Net.ChatSession cs;
    private final Callback cb;
    private String name;
    private String logFile;
    private final List<String> history = new ArrayList<String>();
    private volatile boolean connected = true;
    private int fontSize;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextPane jTextPane1;

    public Client(Net.ChatSession cs, Callback cb) {
        this.cs = cs;
        this.cb = cb;
        this.initComponents();
        Utils.initWindow(this, this.getRootPane(), this.jButton1);
        this.initForm();
        this.pollChat();
    }

    private void initForm() {
        this.fontSize = prefs.node("User").getInt("FontSize", 14);
        this.name = prefs.node("User").get("Name", this.cs.getDefaultName());
        this.logFile = String.format("c64-chat-%s.log", Utils.localDate);
        this.jTextField1.setText(this.name);
        this.jTextField2.setText("");
        this.jTextField2.requestFocusInWindow();
        this.newTextFont();
        this.update(this.showHelp(), Utils.getAttributes(Color.red, this.fontSize));
        String msg = String.format("%s has entered the chat room%n", this.name);
        this.cs.sendChat(new Chat(msg));
        this.update(msg, Utils.getAttributes(Color.darkGray, this.fontSize));
        this.setVisible(true);
    }

    private void newTextFont() {
        Font f = this.jTextField2.getFont();
        this.jTextField2.setFont(new Font(f.getFontName(), f.getStyle(), this.fontSize));
    }

    private void parseInput() {
        String msg = this.jTextField2.getText();
        if (msg.length() < 3) {
            this.sendMsg(msg);
        } else {
            this.parseCommand(msg);
        }
        this.jTextField2.setText("");
    }

    private void parseCommand(String msg) {
        switch (msg.toLowerCase().substring(0, 3)) {
            case "/by": 
            case "/qu": {
                this.quit();
                break;
            }
            case "/fs": {
                this.setFontSize(msg);
                break;
            }
            default: {
                this.sendMsg(msg);
            }
        }
    }

    private void pollChat() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (Client.this.connected) {
                    final Chat c = Client.this.cs.getChat();
                    if (c == null) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Client.this.update(c.getData(), Utils.getAttributes(Color.blue, Client.this.fontSize));
                        }
                    });
                }
            }
        }).start();
    }

    public void quit() {
        this.connected = false;
        this.setVisible(false);
        this.cb.enableMenus();
        this.cs.sendChat(new Chat(String.format("%s has left the chat room%n", this.name)));
        Utils.appendTextFile(this.logFile, this.jTextPane1.getText());
        System.out.println(this.logFile + " updated");
        this.dispose();
    }

    private void sendMsg(String msg) {
        String msg1 = String.format("%s> %s%n", this.name, msg);
        this.cs.sendChat(new Chat(msg1));
        this.update(msg1, Utils.getAttributes(Color.black, this.fontSize));
    }

    private void setFontSize(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() != 2) {
            this.update("format: /fs <number> (where 8 <= number <= 24)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int size = Utils.validateInt(cmd.get(1), 10, 8, 25);
        if (size == -1) {
            this.update("format: /fs <number> (where 8 <= number <= 24)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.fontSize = size;
            this.newTextFont();
            prefs.node("User").putInt("FontSize", this.fontSize);
            this.update(String.format("font size set to %d%n", size), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private String showHelp() {
        return String.format("%s%s%s%s%s%s", "\n** DISCLAIMER: THIS IS AN UNSECURE CHANNEL. DO NOT DISCLOSE ", "PERSONAL OR FINANCIAL INFORMATION UNLESS YOU ARE ABSOLUTELY SURE ", "THAT YOU KNOW WHAT YOU'RE DOING **\n\n", "Commands: \n\n", "/bye or /quit - close chat\n", "/fs <size> - set font size (8 to 24)\n\n");
    }

    private void update(String msg, SimpleAttributeSet attr) {
        StyledDocument doc = this.jTextPane1.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), msg, attr);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Client.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateName() {
        String s = this.jTextField1.getText();
        if (s.equalsIgnoreCase(this.name)) {
            this.update("name unchanged%n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        if (!s.isEmpty() && s.length() > 2 && Character.isLetter(s.charAt(0))) {
            String msg = String.format("%s has changed name to %s%n", this.name, s);
            this.name = s;
            prefs.node("User").put("Name", this.name);
            this.cs.sendChat(new Chat(msg));
            this.update(msg, Utils.getAttributes(Color.magenta, this.fontSize));
            this.jTextField1.setEditable(false);
            this.jButton2.setEnabled(true);
        } else {
            this.update("name should be >= 3 chars and start with a letter\n", Utils.getAttributes(Color.red, this.fontSize));
            this.jTextField1.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Chatting with everyone");
        this.setMinimumSize(new Dimension(640, 480));
        this.jLabel1.setText("Name");
        this.jButton1.setFont(new Font("Dialog", 1, 13));
        this.jButton1.setMnemonic('Q');
        this.jButton1.setText("Quit");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.actionPerformed(evt);
            }
        });
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setFont(new Font("Dialog", 1, 13));
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jTextField1.setEditable(false);
        this.jTextField1.setFont(new Font("Dialog", 1, 13));
        this.jTextField1.setText("jTextField1");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.actionPerformed(evt);
            }
        });
        this.jTextField2.setFont(new Font("Dialog", 1, 13));
        this.jTextField2.setText("jTextField2");
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.actionPerformed(evt);
            }
        });
        this.jButton2.setFont(new Font("Dialog", 1, 13));
        this.jButton2.setMnemonic('S');
        this.jButton2.setText("Set");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Client.this.actionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addGap(113, 113, 113).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 137, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addGap(0, 150, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jTextField2).addGap(18, 18, 18).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -2, 19, -2).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 288, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jTextField2, -2, -1, -2)).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jLabel1).addGap(325, 325, 325)));
        layout.linkSize(1, this.jButton1, this.jTextField2);
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.jTextField1)) {
            this.updateName();
        } else if (evt.getSource().equals(this.jTextField2)) {
            this.parseInput();
        }
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("Quit")) {
            this.quit();
        } else if (cmd.startsWith("Set")) {
            this.jTextField1.setEditable(true);
            this.jButton2.setEnabled(false);
        }
    }

    public static interface Callback {
        public void enableMenus();
    }
}

