/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.net.codec;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.free.j64.net.codec.Codecs;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.CorruptedFrameException;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

final class Decoder
extends FrameDecoder {
    Decoder() {
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < 5) {
            return null;
        }
        buffer.markReaderIndex();
        short magicNumber = buffer.readUnsignedByte();
        switch (magicNumber) {
            case 65: {
                return Codecs.ac.decode(buffer);
            }
            case 67: {
                return Codecs.cc.decode(buffer);
            }
            case 73: {
                return this.decodeImage(buffer);
            }
            case 75: {
                return Codecs.kc.decode(buffer);
            }
            case 83: {
                return Codecs.sc.decode(buffer);
            }
        }
        buffer.resetReaderIndex();
        throw new CorruptedFrameException("Invalid magic number: " + magicNumber);
    }

    private BufferedImage decodeImage(ChannelBuffer buffer) throws IOException {
        int dataLength = buffer.readInt();
        if (buffer.readableBytes() < dataLength) {
            buffer.resetReaderIndex();
            return null;
        }
        byte[] decoded = new byte[dataLength];
        buffer.readBytes(decoded);
        return ImageIO.read(new ByteArrayInputStream(decoded));
    }
}

