/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.vnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import org.free.j64.vnc.Utils;
import org.free.j64.vnc.Viewer;

public final class Admin
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(Admin.class);
    private final Callback cb;
    private int fontSize = 14;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextPane jTextPane1;

    public Admin(Callback cb) {
        this.cb = cb;
        this.initComponents();
        Utils.initWindow(this, this.getRootPane(), this.jButton1);
        this.initForm();
    }

    private void initForm() {
        this.jTextField1.setText("");
        this.jTextField1.requestFocusInWindow();
        this.fontSize = prefs.node("User").getInt("FontSize", 14);
        this.newTextFont();
        this.update(this.showHelp(), Utils.getAttributes(Color.blue, this.fontSize));
        this.update(this.showStatus(), Utils.getAttributes(Color.gray, this.fontSize));
        this.setVisible(true);
    }

    private void parseInput() {
        String msg = this.jTextField1.getText();
        if (msg.length() < 3) {
            return;
        }
        switch (msg.toLowerCase().substring(0, 3)) {
            case "aud": {
                this.setAudio(msg);
                break;
            }
            case "bye": 
            case "qui": {
                this.quit();
                break;
            }
            case "/fs": {
                this.setFontSize(msg);
                break;
            }
            case "hel": {
                this.update(this.showHelp(), Utils.getAttributes(Color.blue, this.fontSize));
                break;
            }
            case "ima": {
                this.setImage(msg);
                break;
            }
            case "sta": {
                this.update(this.showStatus(), Utils.getAttributes(Color.gray, this.fontSize));
                break;
            }
            default: {
                this.update("command not recognized\n", Utils.getAttributes(Color.red, this.fontSize));
            }
        }
        this.jTextField1.setText("");
    }

    private void newTextFont() {
        Font f = this.jTextField1.getFont();
        this.jTextField1.setFont(new Font(f.getFontName(), f.getStyle(), this.fontSize));
    }

    public void quit() {
        this.setVisible(false);
        this.cb.enableMenus();
        this.dispose();
    }

    private void setAudio(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: audio <interval> (where 0 is off or 1 to 30 secs)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int interval = Utils.validateInt(cmd.get(1), 10, 0, 31);
        if (interval == -1) {
            this.update("format: audio <interval> (where 0 is off or 1 to 30 secs)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            Viewer.vwPrefs.node("User").putInt("Audio", interval);
            Viewer.audioInterval = interval;
            this.update(String.format("audio interval set to %d%n", interval), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setFontSize(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: /fs <number> (where 8 <= number <= 24)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int size = Utils.validateInt(cmd.get(1), 10, 8, 25);
        if (size == -1) {
            this.update("format: /fs <number> (where 8 <= number <= 24)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            this.fontSize = size;
            this.newTextFont();
            prefs.node("User").putInt("FontSize", this.fontSize);
            this.update(String.format("font size set to %d%n", size), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private void setImage(String msg) {
        List<String> cmd = Utils.split(msg, " ");
        if (cmd.size() < 2) {
            this.update("format: image <interval> (where 0 is off or 1 to 30 secs)\n", Utils.getAttributes(Color.red, this.fontSize));
            return;
        }
        int interval = Utils.validateInt(cmd.get(1), 10, 0, 31);
        if (interval == -1) {
            this.update("format: image <interval> (where 0 is off or 1 to 30 secs)\n", Utils.getAttributes(Color.red, this.fontSize));
        } else {
            Viewer.vwPrefs.node("User").putInt("Image", interval);
            Viewer.imageInterval = interval;
            this.update(String.format("image interval set to %d%n", interval), Utils.getAttributes(Color.black, this.fontSize));
        }
    }

    private String showHelp() {
        return String.format("%s%s%s%s%s%s%s%s", "\nVNC ADMIN CONSOLE\n\n", "Commands: (only first 3 chars required)\n\n", "audio <interval> - set resync interval (0 is off or 1 to 30 secs)\n", "bye or quit - close and commit changes\n", "/fs <size> - set font size (8 to 24)\n", "help - this help message\n", "image <interval> - set resync interval (0 is off or 1 to 30 secs)\n", "status - current uncommitted settings\n");
    }

    private String showStatus() {
        return String.format("%s%s%s", "\nVNC STATUS\n\n", String.format("audio resync is %s\n", Viewer.audioInterval > 0 ? String.valueOf(Viewer.audioInterval) : "off"), String.format("image resync is %s\n", Viewer.imageInterval > 0 ? String.valueOf(Viewer.imageInterval) : "off"));
    }

    private void update(String msg, SimpleAttributeSet attr) {
        StyledDocument doc = this.jTextPane1.getStyledDocument();
        try {
            doc.insertString(doc.getLength(), msg, attr);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Admin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jTextField1 = new JTextField();
        this.setDefaultCloseOperation(0);
        this.setTitle("Server Admin");
        this.setMinimumSize(new Dimension(640, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Admin.this.windowClosing(evt);
            }
        });
        this.jButton1.setFont(new Font("Dialog", 1, 13));
        this.jButton1.setMnemonic('Q');
        this.jButton1.setText("Quit");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Admin.this.actionPerformed(evt);
            }
        });
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setFont(new Font("Dialog", 1, 13));
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jTextField1.setFont(new Font("Dialog", 1, 13));
        this.jTextField1.setText("jTextField2");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Admin.this.actionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1)).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jTextField1, -1, 412, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 315, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jTextField1, -2, -1, -2)).addContainerGap()));
        layout.linkSize(1, this.jButton1, this.jTextField1);
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd;
        if (evt.getSource().equals(this.jTextField1)) {
            this.parseInput();
        }
        if ((cmd = evt.getActionCommand()).startsWith("Quit")) {
            this.quit();
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.quit();
    }

    public static interface Callback {
        public void enableMenus();
    }
}

