/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.vnc;

import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.free.j64.net.type.Audio;
import org.free.j64.vnc.Viewer;

final class AudioDriver {
    boolean sound = true;
    private final AudioFormat af;
    private final int bufferSize;
    private SourceDataLine dataLine;

    AudioDriver(int sampleRate, int bufferSize) {
        this.af = new AudioFormat(sampleRate, 16, 1, true, false);
        this.bufferSize = bufferSize;
    }

    void open() {
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, this.af, this.bufferSize));
            this.dataLine.open(this.dataLine.getFormat(), this.bufferSize);
            this.dataLine.start();
        }
        catch (LineUnavailableException ex) {
            System.err.format("Sound device busy or unavailable, continuing..%n", new Object[0]);
            System.err.format("Try closing other programs using sound and restart%n", new Object[0]);
        }
    }

    void play(Audio au) throws InterruptedException {
        byte[] buffer = au.getData();
        int bsize = buffer.length;
        while (this.dataLine.available() < bsize) {
            TimeUnit.MICROSECONDS.sleep(Viewer.audioInterval * 32);
        }
        if (this.sound) {
            this.dataLine.write(buffer, 0, buffer.length);
        } else {
            TimeUnit.MICROSECONDS.sleep(Viewer.audioInterval * 1024);
        }
    }

    void stop() {
        if (this.dataLine != null) {
            this.dataLine.stop();
            this.dataLine.flush();
            this.dataLine.close();
        }
    }
}

