/*
 * Decompiled with CFR 0.152.
 */
package org.free.j64.vnc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.free.j64.net.Net;
import org.free.j64.net.chat.Client;
import org.free.j64.net.type.Audio;
import org.free.j64.net.type.Key;
import org.free.j64.vnc.Admin;
import org.free.j64.vnc.AudioDriver;
import org.free.j64.vnc.ConnectHost;

public final class Viewer
extends JFrame {
    static final Preferences vwPrefs = Preferences.userNodeForPackage(Viewer.class);
    static volatile int audioInterval = vwPrefs.node("User").getInt("Audio", 30);
    static volatile int imageInterval = vwPrefs.node("User").getInt("Image", 3);
    private static final String VERSION = "1.3.0rc1";
    private static final String ABOUT_MESSAGE = "JaC64 version: 1.3.0rc1\nJaC64 is a Java-based C64 emulator by Joakim Eriksson\nVNC emulation by Osman Pub (2012-13)\n";
    private static final Font fpsFont = new Font("Dialog", 1, 13);
    private final ExecutorService exec = Executors.newCachedThreadPool();
    private final Map<Integer, Future<?>> tasks = new ConcurrentHashMap();
    private final AtomicInteger taskId = new AtomicInteger(0);
    private Net.ClientSession cs;
    private volatile boolean debug = false;
    private volatile boolean sendKeys = false;
    private volatile boolean sound = true;
    private Admin adminForm;
    private Client chatForm;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JPanel jPanel1;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Viewer();
            }
        });
    }

    Viewer() {
        this.initComponents();
        this.loadPrefs();
        this.setVisible(true);
    }

    private Future<?> addTask(int id, Callable<?> c) {
        if (this.tasks.containsKey(id)) {
            return null;
        }
        Future<?> f = this.exec.submit(c);
        this.tasks.put(id, f);
        return f;
    }

    private int getTaskId() {
        return this.taskId.getAndIncrement();
    }

    private void removeTask(int id) {
        this.tasks.remove(id);
    }

    private void shutdownTasks() {
        for (Future<?> t : this.tasks.values()) {
            if (t.isDone()) continue;
            t.cancel(true);
        }
    }

    private void connect(String host, int port) {
        try {
            this.cs = Net.ClientSession.connect(host, port);
            if (this.cs != null && this.cs.isConnected()) {
                this.toggleConnected(true);
                this.getAudio();
                this.getImage();
                this.getOther();
                this.setTitle("Connected to " + this.cs.getRemoteAddress());
                System.out.println("Client session connected to host " + this.cs.getRemoteAddress() + " from " + this.cs.getLocalAddress());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void disconnect() {
        if (this.cs != null) {
            this.shutdownTasks();
            this.cs.disconnect();
            this.disconnected();
        }
    }

    private void disconnected() {
        this.toggleConnected(false);
        this.setTitle("J64 VNC");
        System.out.println("Client session disconnected");
    }

    private void getAudio() {
        final int id = this.getTaskId();
        this.addTask(id, new Callable<Void>(){
            private final AudioDriver ad = new AudioDriver(44000, 22000);
            private long lastTime = System.nanoTime();

            @Override
            public Void call() {
                this.ad.open();
                while (!Thread.currentThread().isInterrupted()) {
                    this.ad.sound = Viewer.this.sound;
                    Audio au = Viewer.this.cs.getAudio();
                    int elapsed = (int)TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTime, TimeUnit.NANOSECONDS);
                    if (audioInterval > 0 && elapsed > audioInterval) {
                        au = Viewer.this.cs.flushAudios();
                        this.lastTime = System.nanoTime();
                    }
                    if (au != null) {
                        try {
                            this.ad.play(au);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    try {
                        TimeUnit.MICROSECONDS.sleep(audioInterval * 30);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.ad.stop();
                Viewer.this.removeTask(id);
                return null;
            }
        });
    }

    private void getImage() {
        final int id = this.getTaskId();
        this.addTask(id, new Callable<Void>(){
            private long lastTime = System.nanoTime();
            private int fps = 0;
            private int drawFps = 0;

            @Override
            public Void call() {
                while (!Thread.currentThread().isInterrupted()) {
                    BufferedImage image = Viewer.this.cs.getImage();
                    int elapsed = (int)TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTime, TimeUnit.NANOSECONDS);
                    image = this.resyncImage(elapsed, imageInterval > 0 ? imageInterval : 8, image);
                    if (image != null) {
                        Viewer.this.jLabel1.setIcon(new ImageIcon(this.scaleImage(image, Viewer.this.getWidth(), Viewer.this.getHeight())));
                        Viewer.this.jLabel1.setLocation(0, 0);
                        ++this.fps;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(imageInterval);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                Viewer.this.removeTask(id);
                return null;
            }

            private BufferedImage resyncImage(int elapsed, int interval, BufferedImage image) {
                if (elapsed > interval) {
                    image = Viewer.this.cs.flushImages();
                    this.drawFps = this.fps / interval;
                    this.fps = 0;
                    this.lastTime = System.nanoTime();
                }
                return image;
            }

            private BufferedImage scaleImage(BufferedImage image, int width, int height) {
                float aspect = (float)image.getWidth() / (float)image.getHeight();
                int w = width;
                int h = (int)((float)w / aspect);
                int x = 0;
                int y = 0;
                if (h > height) {
                    w = (int)((float)w * ((float)height / (float)h));
                    h = height;
                } else {
                    y = height - h >> 1;
                }
                if (w < width) {
                    x = width - w >> 1;
                }
                BufferedImage bimg = new BufferedImage(width, height, 1);
                Graphics2D g = bimg.createGraphics();
                g.setColor(Color.black);
                g.fillRect(0, 0, width, height);
                g.drawImage(image, x, y, w, h, null);
                if (Viewer.this.debug) {
                    g.setColor(Color.white);
                    g.setFont(fpsFont);
                    g.drawString(String.format("FPS: %d", this.drawFps), 16, 16);
                }
                g.dispose();
                return bimg;
            }
        });
    }

    private void getOther() {
        final int id = this.getTaskId();
        this.addTask(id, new Callable<Void>(){

            @Override
            public Void call() {
                while (!Thread.currentThread().isInterrupted()) {
                    this.getKeys();
                    this.getMessages();
                    try {
                        TimeUnit.MILLISECONDS.sleep(audioInterval);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                Viewer.this.removeTask(id);
                return null;
            }

            private void getKeys() {
                Key key = Viewer.this.cs.getKey();
                if (key == null) {
                    return;
                }
                switch (key.getData()) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        Viewer.this.sendKeys = true;
                        break;
                    }
                    case 0: {
                        Viewer.this.sendKeys = false;
                        break;
                    }
                }
            }

            private void getMessages() {
                String s = Viewer.this.cs.getString();
                if (s != null) {
                    System.out.println(s);
                }
            }
        });
    }

    private void loadPrefs() {
        Preferences p = vwPrefs.node("Window");
        int w = p.getInt("Width", -1);
        int h = p.getInt("Height", -1);
        if (w != -1 && h != -1) {
            this.setSize(w, h);
        } else {
            this.setSize(800, 600);
        }
        int x = p.getInt("X", -1);
        int y = p.getInt("Y", -1);
        if (x != -1 && y != -1) {
            this.setLocation(x, y);
        } else {
            Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((sz.width - this.getWidth()) / 2, (sz.height - this.getHeight()) / 2);
        }
        int s = p.getInt("ExtendedState", -1);
        if (s != -1) {
            this.setExtendedState(s);
        } else {
            this.setExtendedState(6);
        }
    }

    private void savePrefs() {
        Preferences p = vwPrefs.node("Window");
        p.putInt("Width", this.getWidth());
        p.putInt("Height", this.getHeight());
        p.putInt("X", this.getX());
        p.putInt("Y", this.getY());
        p.putInt("ExtendedState", this.getExtendedState());
    }

    private void quitDesktop() {
        this.setVisible(false);
        if (this.adminForm != null) {
            this.adminForm.quit();
        }
        if (this.chatForm != null) {
            this.chatForm.quit();
        }
        this.savePrefs();
        this.disconnect();
        this.shutdownTasks();
        this.exec.shutdown();
        System.exit(0);
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this, ABOUT_MESSAGE, "JaC64 VNC- The Java C64 Emulator Virtual Network Console", 1);
    }

    private void startAdmin() {
        this.adminForm = new Admin(new Admin.Callback(){

            @Override
            public void enableMenus() {
                Viewer.this.jMenuItem8.setEnabled(true);
                Viewer.this.adminForm = null;
            }
        });
        this.jMenuItem8.setEnabled(false);
    }

    private void startChat() {
        this.chatForm = new Client(this.cs.getChatSession(), new Client.Callback(){

            @Override
            public void enableMenus() {
                Viewer.this.jMenuItem5.setEnabled(true);
                Viewer.this.chatForm = null;
            }
        });
        this.jMenuItem5.setEnabled(false);
    }

    private void showConnect() {
        ConnectHost ch = new ConnectHost((Frame)this, true);
        if (ch.getPort() != -1 && !ch.getHost().isEmpty()) {
            this.connect(ch.getHost(), ch.getPort());
        }
    }

    private void toggleConnected(boolean enabled) {
        this.jMenuItem1.setEnabled(!enabled);
        this.jMenuItem2.setEnabled(enabled);
        this.jMenuItem5.setEnabled(enabled);
        this.jMenuItem6.setEnabled(enabled);
        this.jMenuItem7.setEnabled(enabled);
    }

    private void toggleDebug() {
        boolean bl = this.debug = !this.debug;
        if (this.debug) {
            this.jMenuItem7.setText("Debug off");
        } else {
            this.jMenuItem7.setText("Debug on");
        }
    }

    private void toggleSound() {
        boolean bl = this.sound = !this.sound;
        if (this.sound) {
            this.jMenuItem6.setText("Sound Off");
        } else {
            this.jMenuItem6.setText("Sound On");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItem8 = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItem3 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("J64 VNC");
        this.setBackground(Color.black);
        this.setBounds(new Rectangle(400, 300, 800, 600));
        this.setForeground(Color.black);
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(640, 480));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Viewer.this.windowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Viewer.this.keyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                Viewer.this.keyReleased(evt);
            }
        });
        this.jLabel1.setDoubleBuffered(true);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 529, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.jLabel1).addContainerGap(455, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 330, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.jLabel1).addContainerGap(256, Short.MAX_VALUE))));
        this.jMenu1.setMnemonic('V');
        this.jMenu1.setText("View");
        this.jMenu1.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem1.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem1.setMnemonic('C');
        this.jMenuItem1.setText("Connect");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.jMenuItem2.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem2.setMnemonic('D');
        this.jMenuItem2.setText("Disconnect");
        this.jMenuItem2.setEnabled(false);
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu1.add(this.jSeparator4);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.jMenuItem5.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem5.setMnemonic('h');
        this.jMenuItem5.setText("Chat");
        this.jMenuItem5.setEnabled(false);
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem6.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem6.setMnemonic('S');
        this.jMenuItem6.setText("Sound off");
        this.jMenuItem6.setEnabled(false);
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenu1.add(this.jSeparator5);
        this.jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMenuItem8.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem8.setMnemonic('A');
        this.jMenuItem8.setText("Admin");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem8);
        this.jMenu1.add(this.jSeparator6);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem3.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem3.setMnemonic('Q');
        this.jMenuItem3.setText("Quit");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu3.setMnemonic('H');
        this.jMenu3.setText("Help");
        this.jMenu3.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItem7.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem7.setMnemonic('D');
        this.jMenuItem7.setText("Debug on");
        this.jMenuItem7.setEnabled(false);
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem7);
        this.jMenuItem4.setFont(new Font("Dialog", 1, 13));
        this.jMenuItem4.setMnemonic('A');
        this.jMenuItem4.setText("About");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Viewer.this.actionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("Connect")) {
            this.showConnect();
        } else if (cmd.startsWith("Disconnect")) {
            this.disconnect();
        } else if (cmd.startsWith("Admin")) {
            this.startAdmin();
        } else if (cmd.startsWith("Chat")) {
            this.startChat();
        } else if (cmd.startsWith("Sound")) {
            this.toggleSound();
        } else if (cmd.startsWith("Quit")) {
            this.quitDesktop();
        } else if (cmd.startsWith("Debug")) {
            this.toggleDebug();
        } else if (cmd.startsWith("About")) {
            this.showAbout();
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.quitDesktop();
    }

    private void keyPressed(KeyEvent evt) {
        if (this.cs == null || !this.sendKeys) {
            return;
        }
        this.cs.sendKey(new Key(evt.getKeyCode()));
    }

    private void keyReleased(KeyEvent evt) {
        if (this.cs == null || !this.sendKeys) {
            return;
        }
        this.cs.sendKey(new Key(~evt.getKeyCode()));
    }
}

